/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.client.HttpInputStream;
import org.fcrepo.server.security.servletfilters.xmluserfile.FedoraUsers;
import org.fcrepo.test.DemoObjectTestSetup;
import org.fcrepo.test.FedoraServerTestCase;

public class TestHTTPStatusCodes
extends FedoraServerTestCase {
    public static final String TEST_OBJ = "demo:SmileyBucket";
    public static final String BOGUS_DS = "NonExistingDS";
    public static final String BOGUS_METHOD = "nonExistingMethod";
    public static final String BOGUS_OBJ = "demo:NonExistingObject";
    public static final String BOGUS_SDEF = "demo:NonExistingSDef";
    public static final String GET_NEXT_PID_PATH = "/management/getNextPID?xml=true";
    public static final String DESCRIBE_REPOSITORY_PATH = "/describe?xml=true";
    public static final String GET_DS_DISSEM_PATH = "/get/demo:SmileyBucket/DC";
    public static final String GET_DS_DISSEM_BOGUS_DS_PATH = "/get/demo:SmileyBucket/NonExistingDS";
    public static final String GET_DS_DISSEM_BOGUS_OBJ_PATH = "/get/demo:NonExistingObject/DC";
    public static final String GET_DEFAULT_DISSEM_PATH = "/get/demo:SmileyBucket/fedora-system:3/viewDublinCore";
    public static final String GET_DEFAULT_DISSEM_BOGUS_METHOD_PATH = "/get/demo:SmileyBucket/fedora-system:3/nonExistingMethod";
    public static final String GET_DEFAULT_DISSEM_BOGUS_OBJ_PATH = "/get/demo:NonExistingObject/fedora-system:3/viewDublinCore";
    public static final String GET_CUSTOM_DISSEM_PATH = "/get/demo:SmileyBucket/demo:DualResolution/mediumSize";
    public static final String GET_CUSTOM_DISSEM_BOGUS_METHOD_PATH = "/get/demo:SmileyBucket/demo:DualResolution/nonExistingMethod";
    public static final String GET_CUSTOM_DISSEM_BOGUS_SDEF_PATH = "/get/demo:SmileyBucket/demo:NonExistingSDef/nonExistingMethod";
    public static final String GET_CUSTOM_DISSEM_BOGUS_OBJ_PATH = "/get/demo:NonExistingObject/demo:DualResolution/mediumSize";
    public static final String GET_OBJ_HISTORY_PATH = "/getObjectHistory/demo:SmileyBucket?xml=true";
    public static final String GET_OBJ_HISTORY_BOGUS_OBJ_PATH = "/getObjectHistory/demo:NonExistingObject?xml=true";
    public static final String GET_OBJ_PROFILE_PATH = "/get/demo:SmileyBucket?xml=true";
    public static final String GET_OBJ_PROFILE_BOGUS_OBJ_PATH = "/get/demo:NonExistingObject?xml=true";
    public static final String LIST_DATASTREAMS_PATH = "/listDatastreams/demo:SmileyBucket?xml=true";
    public static final String LIST_DATASTREAMS_BOGUS_OBJ_PATH = "/listDatastreams/demo:NonExistingObject?xml=true";
    public static final String LIST_METHODS_PATH = "/listMethods/demo:SmileyBucket?xml=true";
    public static final String LIST_METHODS_BOGUS_OBJ_PATH = "/listMethods/demo:NonExistingObject?xml=true";
    public static final String FIND_OBJECTS_PATH = "/search?pid=true&terms=&query=&maxResults=120&xml=true";
    public static final String FIND_OBJECTS_BADREQ_PATH = "/search?pid=true&terms=&query=&maxResults=unparsable&xml=true";
    public static final String RI_SEARCH_PATH = "/risearch?type=triples&lang=spo&format=N-Triples&limit=&dt=on&stream=on&query=%3Cinfo%3Afedora%2Fdemo%3ASmileyStuff%3E+*+*";
    private static FedoraClient CLIENT_VALID_USER_VALID_PASS;
    private static FedoraClient CLIENT_VALID_USER_VALID_PASS_UNAUTHORIZED;
    private static FedoraClient CLIENT_VALID_USER_BOGUS_PASS;
    private static FedoraClient CLIENT_BOGUS_USER;

    public static Test suite() {
        TestSuite suite = new TestSuite("TestHTTPStatusCodes TestSuite");
        suite.addTestSuite(TestHTTPStatusCodes.class);
        return new DemoObjectTestSetup((Test)suite);
    }

    public static void checkOK(String requestPath) throws Exception {
        TestHTTPStatusCodes.checkGetCode(TestHTTPStatusCodes.getClient(true, true, true), requestPath, "Expected HTTP 200 (OK) response for authenticated, authorized request", 200);
    }

    public static void checkError(String requestPath) throws Exception {
        TestHTTPStatusCodes.checkGetCode(TestHTTPStatusCodes.getClient(true, true, true), requestPath, "Expected HTTP 500 (Internal Server Error) response for authenticated, authorized request", 500);
    }

    public static void checkBadAuthN(String requestPath) throws Exception {
        TestHTTPStatusCodes.checkGetCode(TestHTTPStatusCodes.getClient(true, false, true), requestPath, "Expected HTTP 401 (Unauthorized) response for bad authentication (valid user, bad pass) request", 401);
        TestHTTPStatusCodes.checkGetCode(TestHTTPStatusCodes.getClient(false, false, true), requestPath, "Expected HTTP 401 (Unauthorized) response for bad authentication (invalid user) request", 401);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkBadAuthZ(String requestPath) throws Exception {
        try {
            TestHTTPStatusCodes.activateUnauthorizedUserAndPolicy();
            TestHTTPStatusCodes.checkGetCode(TestHTTPStatusCodes.getClient(true, true, false), requestPath, "Expected HTTP 403 (Forbidden) response for authenticated, unauthorized request", 403);
        }
        finally {
            TestHTTPStatusCodes.deactivateUnauthorizedUserAndPolicy();
        }
    }

    public static void checkNotFound(String requestPath) throws Exception {
        TestHTTPStatusCodes.checkGetCode(TestHTTPStatusCodes.getClient(true, true, true), requestPath, "Expected HTTP 404 (Not Found) response for authenticated, authorized request", 404);
    }

    public static void checkBadRequest(String requestPath) throws Exception {
        TestHTTPStatusCodes.checkGetCode(TestHTTPStatusCodes.getClient(true, true, true), requestPath, "Expected HTTP 400 (Bad Request) response for authenticated, authorized request", 400);
    }

    public void testGetNextPID_OK() throws Exception {
        TestHTTPStatusCodes.checkOK(GET_NEXT_PID_PATH);
    }

    public void testGetNextPID_BadAuthN() throws Exception {
        TestHTTPStatusCodes.checkBadAuthN(GET_NEXT_PID_PATH);
    }

    public void testGetNextPID_BadAuthZ() throws Exception {
        TestHTTPStatusCodes.checkBadAuthZ(GET_NEXT_PID_PATH);
    }

    public void testUpload_Created() throws Exception {
        TestHTTPStatusCodes.checkUploadCode(TestHTTPStatusCodes.getClient(true, true, true), "file", "Expected HTTP 201 (Created) response for authenticated, authorized request", 201);
    }

    public void testUpload_BadAuthN() throws Exception {
        TestHTTPStatusCodes.checkUploadCode(TestHTTPStatusCodes.getClient(true, false, true), "file", "Expected HTTP 401 (Unauthorized) response for bad authentication (valid user, bad pass) request", 401);
        TestHTTPStatusCodes.checkUploadCode(TestHTTPStatusCodes.getClient(false, false, true), "file", "Expected HTTP 401 (Unauthorized) response for bad authentication (invalid user) request", 401);
    }

    public void testUpload_BadRequest() throws Exception {
        TestHTTPStatusCodes.checkUploadCode(TestHTTPStatusCodes.getClient(true, true, true), "badparam", "Expected HTTP 400 (Bad Request) response for authenticated, authorized request", 400);
    }

    public void testDescribeRepository_OK() throws Exception {
        TestHTTPStatusCodes.checkOK(DESCRIBE_REPOSITORY_PATH);
    }

    public void testGetDatastreamDissemination_OK() throws Exception {
        TestHTTPStatusCodes.checkOK(GET_DS_DISSEM_PATH);
    }

    public void testGetDatastreamDissemination_Datastream_NotFound() throws Exception {
        TestHTTPStatusCodes.checkNotFound(GET_DS_DISSEM_BOGUS_DS_PATH);
    }

    public void testGetDatastreamDissemination_Object_NotFound() throws Exception {
        TestHTTPStatusCodes.checkNotFound(GET_DS_DISSEM_BOGUS_OBJ_PATH);
    }

    public void testGetDissemination_Default_OK() throws Exception {
        TestHTTPStatusCodes.checkOK(GET_DEFAULT_DISSEM_PATH);
    }

    public void testGetDissemination_Default_Method_NotFound() throws Exception {
        TestHTTPStatusCodes.checkNotFound(GET_DEFAULT_DISSEM_BOGUS_METHOD_PATH);
    }

    public void testGetDissemination_Default_Object_NotFound() throws Exception {
        TestHTTPStatusCodes.checkNotFound(GET_DEFAULT_DISSEM_BOGUS_OBJ_PATH);
    }

    public void testGetDissemination_Custom_OK() throws Exception {
        TestHTTPStatusCodes.checkOK(GET_CUSTOM_DISSEM_PATH);
    }

    public void testGetDissemination_Custom_Method_NotFound() throws Exception {
        TestHTTPStatusCodes.checkNotFound(GET_CUSTOM_DISSEM_BOGUS_METHOD_PATH);
    }

    public void testGetDissemination_Custom_Object_NotFound() throws Exception {
        TestHTTPStatusCodes.checkNotFound(GET_CUSTOM_DISSEM_BOGUS_OBJ_PATH);
    }

    public void testGetObjectHistory_OK() throws Exception {
        TestHTTPStatusCodes.checkOK(GET_OBJ_HISTORY_PATH);
    }

    public void testGetObjectHistory_Object_NotFound() throws Exception {
        TestHTTPStatusCodes.checkNotFound(GET_OBJ_HISTORY_BOGUS_OBJ_PATH);
    }

    public void testGetObjectProfile_OK() throws Exception {
        TestHTTPStatusCodes.checkOK(GET_OBJ_PROFILE_PATH);
    }

    public void testGetObjectProfile_Object_NotFound() throws Exception {
        TestHTTPStatusCodes.checkNotFound(GET_OBJ_PROFILE_BOGUS_OBJ_PATH);
    }

    public void testListDatastreams_OK() throws Exception {
        TestHTTPStatusCodes.checkOK(LIST_DATASTREAMS_PATH);
    }

    public void testListDatastreams_Object_NotFound() throws Exception {
        TestHTTPStatusCodes.checkNotFound(LIST_DATASTREAMS_BOGUS_OBJ_PATH);
    }

    public void testListMethods_OK() throws Exception {
        TestHTTPStatusCodes.checkOK(LIST_METHODS_PATH);
    }

    public void testListMethods_Object_NotFound() throws Exception {
        TestHTTPStatusCodes.checkNotFound(LIST_METHODS_BOGUS_OBJ_PATH);
    }

    public void testFindObjects_OK() throws Exception {
        TestHTTPStatusCodes.checkOK(FIND_OBJECTS_PATH);
    }

    public void testFindObjects_BadRequest() throws Exception {
        TestHTTPStatusCodes.checkBadRequest(FIND_OBJECTS_BADREQ_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getStatus(FedoraClient client, String requestPath) throws Exception {
        HttpInputStream in = client.get(requestPath, false);
        try {
            int n = in.getStatusCode();
            return n;
        }
        finally {
            in.close();
        }
    }

    private static FedoraClient getClient(boolean validUser, boolean validPass, boolean authorized) throws Exception {
        if (validUser) {
            if (validPass) {
                System.out.println("Using Fedora Client with valid user, valid pass");
                if (authorized) {
                    if (CLIENT_VALID_USER_VALID_PASS == null) {
                        CLIENT_VALID_USER_VALID_PASS = TestHTTPStatusCodes.getFedoraClient();
                    }
                    return CLIENT_VALID_USER_VALID_PASS;
                }
                if (CLIENT_VALID_USER_VALID_PASS_UNAUTHORIZED == null) {
                    CLIENT_VALID_USER_VALID_PASS_UNAUTHORIZED = TestHTTPStatusCodes.getFedoraClient(TestHTTPStatusCodes.getBaseURL(), "untrustedUser", "password");
                }
                return CLIENT_VALID_USER_VALID_PASS_UNAUTHORIZED;
            }
            System.out.println("Using Fedora Client with valid user, bogus pass");
            if (CLIENT_VALID_USER_BOGUS_PASS == null) {
                CLIENT_VALID_USER_BOGUS_PASS = TestHTTPStatusCodes.getFedoraClient(TestHTTPStatusCodes.getBaseURL(), TestHTTPStatusCodes.getUsername(), "bogus");
            }
            return CLIENT_VALID_USER_BOGUS_PASS;
        }
        System.out.println("Using Fedora Client with bogus user");
        if (CLIENT_BOGUS_USER == null) {
            CLIENT_BOGUS_USER = TestHTTPStatusCodes.getFedoraClient(TestHTTPStatusCodes.getBaseURL(), "bogus", "bogus");
        }
        return CLIENT_BOGUS_USER;
    }

    private static void activateUnauthorizedUserAndPolicy() throws Exception {
        TestHTTPStatusCodes.backupFedoraUsersFile();
        TestHTTPStatusCodes.writeFedoraUsersFile("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<fedora-users>\n  <user name=\"" + TestHTTPStatusCodes.getUsername() + "\" password=\"" + TestHTTPStatusCodes.getPassword() + "\">\n" + "    <attribute name=\"fedoraRole\">\n" + "      <value>administrator</value>\n" + "    </attribute>\n" + "  </user>\n" + "  <user name=\"fedoraIntCallUser\" password=\"changeme\">\n" + "    <attribute name=\"fedoraRole\">\n" + "      <value>fedoraInternalCall-1</value>\n" + "      <value>fedoraInternalCall-2</value>\n" + "    </attribute>\n" + "  </user>\n" + "  <user name=\"untrustedUser\" password=\"password\">\n" + "    <attribute name=\"fedoraRole\">\n" + "      <value>unauthorized</value>\n" + "    </attribute>\n" + "  </user>\n" + "</fedora-users>");
        TestHTTPStatusCodes.addSystemWidePolicyFile("deny-all-if-unauthorized.xml", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Policy xmlns=\"urn:oasis:names:tc:xacml:1.0:policy\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    PolicyId=\"deny-all-if-unauthorized\"    RuleCombiningAlgId=\"urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:first-applicable\">\n  <Description>deny all api-a and api-m access if subject has fedoraRole unauthorized</Description>\n  <Target>\n    <Subjects>\n      <AnySubject/>\n    </Subjects>\n    <Resources>\n      <AnyResource/>\n    </Resources>\n    <Actions>\n      <AnyAction/>\n    </Actions>\n  </Target>\n  <Rule RuleId=\"1\" Effect=\"Deny\">\n    <Condition FunctionId=\"urn:oasis:names:tc:xacml:1.0:function:string-is-in\">\n      <AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">unauthorized</AttributeValue>\n      <SubjectAttributeDesignator AttributeId=\"fedoraRole\" DataType=\"http://www.w3.org/2001/XMLSchema#string\"/>\n    </Condition>\n  </Rule>\n</Policy>");
        TestHTTPStatusCodes.reloadPolicies();
    }

    private static void deactivateUnauthorizedUserAndPolicy() throws Exception {
        TestHTTPStatusCodes.restoreFedoraUsersFile();
        TestHTTPStatusCodes.removeSystemWidePolicyFile("deny-all-if-unauthorized.xml");
        TestHTTPStatusCodes.reloadPolicies();
    }

    private static void backupFedoraUsersFile() throws Exception {
        File sourceFile = FedoraUsers.fedoraUsersXML;
        File destFile = new File(FedoraUsers.fedoraUsersXML.getPath() + ".backup");
        TestHTTPStatusCodes.copyFile(sourceFile, destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File sourceFile, File destFile) throws Exception {
        FileInputStream in = new FileInputStream(sourceFile);
        FileOutputStream out = new FileOutputStream(destFile);
        byte[] buf = new byte[4096];
        try {
            int len;
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    private static void writeFedoraUsersFile(String xml) throws Exception {
        TestHTTPStatusCodes.writeStringToFile(xml, FedoraUsers.fedoraUsersXML);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeStringToFile(String string, File file) throws Exception {
        FileOutputStream out = new FileOutputStream(file);
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out));
        try {
            writer.print(string);
        }
        finally {
            writer.close();
        }
    }

    private static void restoreFedoraUsersFile() throws Exception {
        File sourceFile = new File(FedoraUsers.fedoraUsersXML.getPath() + ".backup");
        File destFile = FedoraUsers.fedoraUsersXML;
        TestHTTPStatusCodes.copyFile(sourceFile, destFile);
    }

    private static void addSystemWidePolicyFile(String filename, String xml) throws Exception {
        String policyDir = "data/fedora-xacml-policies/repository-policies/junit";
        File dir = new File(FEDORA_HOME, "data/fedora-xacml-policies/repository-policies/junit");
        dir.mkdir();
        File policyFile = new File(dir, filename);
        TestHTTPStatusCodes.writeStringToFile(xml, policyFile);
    }

    private static void removeSystemWidePolicyFile(String filename) throws Exception {
        String policyDir = "data/fedora-xacml-policies/repository-policies/junit";
        File dir = new File(FEDORA_HOME, "data/fedora-xacml-policies/repository-policies/junit");
        File policyFile = new File(dir, filename);
        policyFile.delete();
        dir.delete();
    }

    private static void reloadPolicies() throws Exception {
        TestHTTPStatusCodes.getClient(true, true, true).reloadPolicies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkGetCode(FedoraClient client, String requestPath, String errorMessage, int expectedCode) throws Exception {
        HttpInputStream in = client.get(requestPath, false);
        try {
            int gotCode = in.getStatusCode();
            TestHTTPStatusCodes.assertEquals((String)(errorMessage + " (" + requestPath + ")"), (int)expectedCode, (int)gotCode);
            if (expectedCode != 200) {
                String expectedString = "Fedora: " + expectedCode + " ";
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in));
                boolean foundExpectedString = false;
                String line = reader.readLine();
                while (line != null) {
                    if (line.indexOf(expectedString) != -1) {
                        foundExpectedString = true;
                    }
                    line = reader.readLine();
                }
                TestHTTPStatusCodes.assertTrue((String)("HTTP status code was correct (" + expectedCode + "), but body did not contain " + "the string \"" + expectedString + "\""), (boolean)foundExpectedString);
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkUploadCode(FedoraClient client, String partName, String errorMessage, int expectedCode) throws Exception {
        File file = File.createTempFile("fedora-junit", ".txt");
        try {
            TestHTTPStatusCodes.writeStringToFile("test", file);
            int gotCode = TestHTTPStatusCodes.getUploadCode(client, TestHTTPStatusCodes.getBaseURL() + "/management/upload", file, partName);
            TestHTTPStatusCodes.assertEquals((String)(errorMessage + " (/management/upload, partName=" + partName + ")"), (int)expectedCode, (int)gotCode);
        }
        finally {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getUploadCode(FedoraClient client, String url, File file, String partName) throws Exception {
        PostMethod post = null;
        try {
            post = new PostMethod(url);
            post.setDoAuthentication(true);
            post.getParams().setParameter("Connection", (Object)"Keep-Alive");
            post.setContentChunked(true);
            Part[] parts = new Part[]{new FilePart(partName, file)};
            post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, post.getParams()));
            int responseCode = client.getHttpClient().executeMethod((HttpMethod)post);
            if (responseCode > 299 && responseCode < 400) {
                String location = post.getResponseHeader("location").getValue();
                System.out.println("Redirected to " + location);
                int n = TestHTTPStatusCodes.getUploadCode(client, location, file, partName);
                return n;
            }
            int n = responseCode;
            return n;
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }
}

