/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.api.TestRESTAPI;

public class TestRESTAPIURLDecoding
extends FedoraServerTestCase {
    private static final String pid = "test:SomeObject";
    private static final String pidWithEscapedColon1 = "test%3ASomeObject";
    private static final String pidWithEscapedColon2 = "test%3aSomeObject";
    private static TestRESTAPI rest = new TestRESTAPI();

    private static String getFOXML(String pid) {
        StringBuilder sb = new StringBuilder();
        sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<foxml:digitalObject VERSION=\"1.1\" PID=\"" + pid + "\" ");
        sb.append("  xmlns:foxml=\"info:fedora/fedora-system:def/foxml#\" ");
        sb.append("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
        sb.append("  xsi:schemaLocation=\"info:fedora/fedora-system:def/foxml# ");
        sb.append("  http://www.fedora.info/definitions/1/0/foxml1-1.xsd\">");
        sb.append("  <foxml:objectProperties>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#state\" VALUE=\"A\"/>");
        sb.append("  </foxml:objectProperties>");
        sb.append("</foxml:digitalObject>");
        return sb.toString();
    }

    public void setUp() throws Exception {
        TestRESTAPIURLDecoding.rest.url = String.format("/objects/%s", pid);
        rest.post(TestRESTAPIURLDecoding.getFOXML(pid), true);
    }

    public void tearDown() throws Exception {
        TestRESTAPIURLDecoding.rest.url = String.format("/objects/%s", pid);
        rest.delete(true);
    }

    public void testGetObjectProfile() throws Exception {
        this.getAndExpect("/objects/test:SomeObject", 200);
        this.getAndExpect("/objects/test%3ASomeObject", 200);
        this.getAndExpect("/objects/test%3aSomeObject", 200);
    }

    private void getAndExpect(String url, int statusCode) throws Exception {
        TestRESTAPIURLDecoding.rest.url = url;
        TestRESTAPIURLDecoding.assertEquals((int)200, (int)rest.get(true).getStatusCode());
    }
}

