/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.fesl.policyindex;

import java.io.IOException;
import org.apache.http.client.ClientProtocolException;
import org.fcrepo.test.fesl.policyindex.PolicyIndexUtils;
import org.fcrepo.test.fesl.util.AuthorizationDeniedException;
import org.fcrepo.test.fesl.util.HttpUtils;

public class PolicyIndexExerciser
extends Thread {
    private static int updaterRunningCount = 0;
    private static int readerRunningCount = 0;
    private Throwable failure;
    private boolean failed = false;
    private static int updaterPassedCount = 0;
    private static int readerPassedCount = 0;
    private HttpUtils utils = null;
    private HttpUtils adminUtils = null;
    private byte[][] objects = null;
    private String[] pids = null;
    private static String urlA = "/fedora/objects/test:1000002?format=xml";
    private static String urlB = "/fedora/objects/test:1000007?format=xml";
    private String url = "";
    private boolean isReader = false;
    private boolean stopped = false;

    public PolicyIndexExerciser(String testurl, String testuser, String testpassword, String adminUrl, String adminUser, String adminPassword, String[] testPids) throws Exception {
        this.utils = new HttpUtils(testurl, testuser, testpassword);
        this.adminUtils = new HttpUtils(adminUrl, adminUser, adminPassword);
        this.pids = testPids;
        this.objects = new byte[this.pids.length][];
        for (int i = 0; i < this.pids.length; ++i) {
            String policy = i % 2 == 0 ? "A" : "B";
            this.objects[i] = PolicyIndexUtils.getPolicyObject(policy, "A", "A", this.pids[i]);
        }
    }

    public PolicyIndexExerciser(String testurl, String testuser, String testpassword) throws Exception {
        this.utils = new HttpUtils(testurl, testuser, testpassword);
        this.isReader = true;
    }

    @Override
    public void run() {
        if (this.isReader) {
            this.runReader();
        } else {
            this.runUpdater();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runReader() {
        PolicyIndexExerciser.readerStarted();
        try {
            while (!this.stopped()) {
                this.read("A");
                this.read("B");
            }
            PolicyIndexExerciser.readerPass();
        }
        catch (Throwable th) {
            this.failed = true;
            this.failure = th;
        }
        finally {
            PolicyIndexExerciser.readerFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stopped() {
        PolicyIndexExerciser policyIndexExerciser = this;
        synchronized (policyIndexExerciser) {
            return this.stopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopit() {
        PolicyIndexExerciser policyIndexExerciser = this;
        synchronized (policyIndexExerciser) {
            this.stopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUpdater() {
        PolicyIndexExerciser.updaterStarted();
        try {
            for (int i = 0; i < this.pids.length; ++i) {
                this.read("A");
                this.read("B");
                this.add(this.objects[i]);
                this.read("A");
                this.read("B");
                this.delete(this.pids[i]);
                this.read("A");
                this.read("B");
            }
            PolicyIndexExerciser.updaterPass();
        }
        catch (Throwable th) {
            this.failed = true;
            this.failure = th;
        }
        finally {
            PolicyIndexExerciser.updaterFinished();
        }
    }

    private void read(String policy) throws ClientProtocolException, IOException {
        long startTime = System.nanoTime();
        if (policy.equals("A")) {
            this.url = urlA;
        } else if (policy.equals("B")) {
            this.url = urlB;
        }
        try {
            this.utils.get(this.url);
            PolicyIndexExerciser.doSleep(startTime, System.nanoTime());
        }
        catch (AuthorizationDeniedException e) {
            // empty catch block
        }
    }

    private void add(byte[] object) throws ClientProtocolException, IOException, AuthorizationDeniedException {
        long startTime = System.nanoTime();
        this.url = "/fedora/objects/new";
        this.adminUtils.post(this.url, null, object);
        PolicyIndexExerciser.doSleep(startTime, System.nanoTime());
    }

    private void delete(String pid) throws ClientProtocolException, IOException, AuthorizationDeniedException {
        long startTime = System.nanoTime();
        this.url = "/fedora/objects/" + pid;
        this.adminUtils.delete(this.url, null);
        PolicyIndexExerciser.doSleep(startTime, System.nanoTime());
    }

    private static void doSleep(long startTime, long endTime) {
        try {
            PolicyIndexExerciser.sleep((endTime - startTime) / 2000000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Sleep failed - " + e.getMessage(), e);
        }
    }

    public static synchronized int updaterRunningCount() {
        return updaterRunningCount;
    }

    private static synchronized void updaterFinished() {
        --updaterRunningCount;
    }

    private static synchronized void updaterStarted() {
        ++updaterRunningCount;
    }

    private static synchronized void updaterPass() {
        ++updaterPassedCount;
    }

    public static synchronized int updaterPassedCount() {
        return updaterPassedCount;
    }

    public static synchronized int readerRunningCount() {
        return readerRunningCount;
    }

    private static synchronized void readerFinished() {
        --readerRunningCount;
    }

    private static synchronized void readerStarted() {
        ++readerRunningCount;
    }

    private static synchronized void readerPass() {
        ++readerPassedCount;
    }

    public static synchronized int readerPassedCount() {
        return readerPassedCount;
    }

    public Throwable failure() {
        return this.failure;
    }

    public boolean failed() {
        return this.failed;
    }

    public String lastUrl() {
        return this.url;
    }
}

