/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.integration;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.server.utilities.StreamUtility;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.test.FedoraServerTestCase;
import org.w3c.dom.Document;

public class TestOAIService
extends FedoraServerTestCase {
    private DocumentBuilderFactory factory;
    private DocumentBuilder builder;
    private FedoraClient client;

    public static Test suite() {
        TestSuite suite = new TestSuite("Test OAI Service");
        suite.addTestSuite(TestOAIService.class);
        return suite;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.client = new FedoraClient(TestOAIService.getBaseURL(), TestOAIService.getUsername(), TestOAIService.getPassword());
        this.factory = DocumentBuilderFactory.newInstance();
        this.builder = this.factory.newDocumentBuilder();
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("fedora-types", "http://www.fedora.info/definitions/1/0/types/");
        nsMap.put("oai", "http://www.openarchives.org/OAI/2.0/");
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
    }

    public void tearDown() throws Exception {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
        super.tearDown();
    }

    public void testListMetadataFormats() throws Exception {
        String request = "/oai?verb=ListMetadataFormats";
        Document result = this.getXMLQueryResult(request);
        this.assertXpathEvaluatesTo("oai_dc", "/oai:OAI-PMH/oai:ListMetadataFormats/oai:metadataFormat/oai:metadataPrefix", result);
    }

    public void testListRecords() throws Exception {
        FedoraAPIMMTOM apim = this.client.getAPIMMTOM();
        FileInputStream in = new FileInputStream(FEDORA_HOME + "/client/demo/foxml/local-server-demos/simple-document-demo/obj_demo_31.xml");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamUtility.pipeStream((InputStream)in, (OutputStream)out, (int)4096);
        apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])out.toByteArray()), TestOAIService.FOXML1_1.uri, "for testing");
        String request = "/oai?verb=ListRecords&metadataPrefix=oai_dc";
        Document result = this.getXMLQueryResult(request);
        this.assertXpathExists("/oai:OAI-PMH/oai:ListRecords/oai:record", result);
        request = "/oai?verb=ListRecords&metadataPrefix=oai_dc&from=2000-01-01";
        result = this.getXMLQueryResult(request);
        this.assertXpathExists("/oai:OAI-PMH/oai:ListRecords/oai:record", result);
        apim.purgeObject("demo:31", "for testing", false);
    }

    public static void main(String[] args) {
        TestRunner.run(TestOAIService.class);
    }
}

