/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.integration.cma;

import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.integration.cma.Util;
import org.junit.After;
import org.junit.Before;

public class ConflictingDeploymentTests {
    private static final String DEMO_OBJECT_BASE = "cma-examples/conflicting-deployments";
    private static final String PUBLIC_OBJECT_BASE = "cma-examples/conflicting-deployments/public-objects";
    private static final String DEPLOYMENT_1_BASE = "cma-examples/conflicting-deployments/sdeps/1";
    private static final String DEPLOYMENT_2_BASE = "cma-examples/conflicting-deployments/sdeps/2";
    private final String SDEF_PID = "demo:conflicting-deployment.sdef";
    private final String OBJECT_PID = "demo:conflicting-deployment.object";
    private final String SDEP_1_PID = "demo:conflicting-deployment.sdep1";
    private final String SDEP_2_PID = "demo:conflicting-deployment.sdep2";
    private final String METHOD_NAME = "content";
    private FedoraClient m_client;

    public static Test suite() {
        return new JUnit4TestAdapter(ConflictingDeploymentTests.class);
    }

    @Before
    public void setUp() throws Exception {
        this.m_client = new FedoraClient(FedoraServerTestCase.getBaseURL(), FedoraServerTestCase.getUsername(), FedoraServerTestCase.getPassword());
        Util.ingestTestObjects(PUBLIC_OBJECT_BASE);
    }

    @After
    public void tearDown() throws Exception {
        FedoraServerTestCase.purgeDemoObjects();
    }

    @org.junit.Test
    public void testDeployFirstIngested12() throws Exception {
        Util.ingestTestObjects(DEPLOYMENT_1_BASE);
        Util.ingestTestObjects(DEPLOYMENT_2_BASE);
        String content = this.getDisseminatedContent();
        Assert.assertFalse((String)("Wrong deployment used!" + content), (boolean)content.contains("CONTENT_2"));
        Assert.assertTrue((String)"Did not disseminate expected content", (boolean)content.contains("CONTENT_1"));
    }

    @org.junit.Test
    public void testDeployFirstIngested21() throws Exception {
        Util.ingestTestObjects(DEPLOYMENT_2_BASE);
        Util.ingestTestObjects(DEPLOYMENT_1_BASE);
        String content = this.getDisseminatedContent();
        Assert.assertFalse((String)"Wrong deployment used!", (boolean)content.contains("CONTENT_1"));
        Assert.assertTrue((String)"Did not disseminate expected content", (boolean)content.contains("CONTENT_2"));
    }

    @org.junit.Test
    public void testModifyOldestSdep() throws Exception {
        Util.ingestTestObjects(DEPLOYMENT_1_BASE);
        Util.ingestTestObjects(DEPLOYMENT_2_BASE);
        this.modify("demo:conflicting-deployment.sdep1");
        String content = this.getDisseminatedContent();
        Assert.assertFalse((String)"Wrong deployment used!", (boolean)content.contains("CONTENT_1"));
        Assert.assertTrue((String)"Did not disseminate expected content", (boolean)content.contains("CONTENT_2"));
    }

    @org.junit.Test
    public void testModifyNewestSdep() throws Exception {
        Util.ingestTestObjects(DEPLOYMENT_1_BASE);
        Util.ingestTestObjects(DEPLOYMENT_2_BASE);
        this.modify("demo:conflicting-deployment.sdep2");
        String content = this.getDisseminatedContent();
        Assert.assertFalse((String)"Wrong deployment used!", (boolean)content.contains("CONTENT_2"));
        Assert.assertTrue((String)"Did not disseminate expected content", (boolean)content.contains("CONTENT_1"));
    }

    @org.junit.Test
    public void testPurgeReplace() throws Exception {
        Util.ingestTestObjects(DEPLOYMENT_1_BASE);
        Util.ingestTestObjects(DEPLOYMENT_2_BASE);
        this.m_client.getAPIMMTOM().purgeObject("demo:conflicting-deployment.sdep1", "removing first sDep", false);
        Assert.assertTrue((String)"Did not disseminate expected content: ", (boolean)this.getDisseminatedContent().contains("CONTENT_2"));
    }

    private void modify(String pid) throws Exception {
        this.m_client.getAPIMMTOM().addRelationship(pid, "http://example.org/isModified", "true", true, null);
    }

    private String getDisseminatedContent() throws Exception {
        return Util.getDissemination(this.m_client, "demo:conflicting-deployment.object", "demo:conflicting-deployment.sdef", "content");
    }
}

