/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.integration.cma;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.activation.DataHandler;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.client.utility.ingest.Ingest;
import org.fcrepo.client.utility.ingest.IngestCounter;
import org.fcrepo.common.Constants;
import org.fcrepo.server.access.FedoraAPIAMTOM;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.server.types.gen.ObjectMethodsDef;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.test.FedoraTestCase;

public abstract class Util {
    public static ObjectMethodsDef[] filterMethods(ObjectMethodsDef[] initial) {
        ArrayList<ObjectMethodsDef> desiredDefs = new ArrayList<ObjectMethodsDef>();
        for (ObjectMethodsDef def : initial) {
            if (def.getServiceDefinitionPID().startsWith("fedora-system:") || def == null) continue;
            desiredDefs.add(def);
        }
        return desiredDefs.toArray(new ObjectMethodsDef[0]);
    }

    public static String getDissemination(FedoraClient client, String pid, String sDef, String method) throws Exception {
        return new String(TypeUtility.convertDataHandlerToBytes((DataHandler)client.getAPIAMTOM().getDissemination(pid, sDef, method, null, null).getStream()), "UTF-8");
    }

    public static void ingestTestObjects(String path) throws Exception {
        File dir = null;
        String specificPath = File.separator + path;
        System.out.println("Ingesting test objects in FOXML format from " + specificPath);
        String base = "src/test/resources/";
        if (System.getProperty("fcrepo-integrationtest-core.classes") != null) {
            base = System.getProperty("fcrepo-integrationtest-core.classes");
        }
        dir = new File(base + "test-objects/foxml" + specificPath);
        FedoraClient client = FedoraTestCase.getFedoraClient();
        Ingest.multiFromDirectory((File)dir, (String)Constants.FOXML1_1.uri, (FedoraAPIAMTOM)client.getAPIAMTOM(), (FedoraAPIMMTOM)client.getAPIMMTOM(), null, (PrintStream)new PrintStream(File.createTempFile("demo", null)), (IngestCounter)new IngestCounter());
    }
}

