/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.io.IOException;
import java.net.URLEncoder;
import junit.framework.Assert;
import org.fcrepo.client.FedoraClient;

public class RISearchUtil {
    private static final String RISEARCH_COUNT = "/risearch?type=triples&lang=spo&format=count&stream=on&flush=true&query=";

    public static void checkSPOCount(FedoraClient client, String query, int expectedCount) {
        int actualCount = RISearchUtil.getSPOCount(client, query);
        Assert.assertEquals((String)("Expected " + expectedCount + " results from SPO query" + " " + query + ", but got " + actualCount), (int)expectedCount, (int)actualCount);
    }

    public static int getSPOCount(FedoraClient client, String query) {
        String response = null;
        try {
            response = client.getResponseAsString(RISEARCH_COUNT + URLEncoder.encode(query, "UTF-8"), true, true).trim();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"Error while querying resource index (is it enabled?).  See stack trace");
        }
        int count = 0;
        try {
            count = Integer.parseInt(response);
        }
        catch (NumberFormatException e) {
            Assert.fail((String)("Expected numeric plaintext response body from RI query, but got the following: " + response));
        }
        return count;
    }
}

