/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import javax.activation.DataHandler;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.common.Models;
import org.fcrepo.server.access.FedoraAPIAMTOM;
import org.fcrepo.server.types.gen.ComparisonOperator;
import org.fcrepo.server.types.gen.Condition;
import org.fcrepo.server.types.gen.FieldSearchQuery;
import org.fcrepo.server.types.gen.FieldSearchResult;
import org.fcrepo.server.types.gen.ObjectFactory;
import org.fcrepo.server.types.gen.ObjectFields;
import org.fcrepo.server.types.gen.ObjectProfile;
import org.fcrepo.server.types.gen.Property;
import org.fcrepo.server.types.gen.RepositoryInfo;
import org.fcrepo.server.types.mtom.gen.GetDissemination;
import org.fcrepo.server.types.mtom.gen.MIMETypedStream;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.test.DemoObjectTestSetup;
import org.fcrepo.test.FedoraServerTestCase;
import org.junit.After;

public class TestAPIA
extends FedoraServerTestCase {
    private FedoraAPIAMTOM apia;

    public static Test suite() {
        TestSuite suite = new TestSuite("APIA TestSuite");
        suite.addTestSuite(TestAPIA.class);
        return new DemoObjectTestSetup((Test)suite);
    }

    public void testDescribeRepository() throws Exception {
        RepositoryInfo describe = this.apia.describeRepository();
        TestAPIA.assertTrue((!describe.getRepositoryName().equals("") ? 1 : 0) != 0);
    }

    public void testFindObjects() throws Exception {
        String[] resultFields = new String[]{"pid"};
        BigInteger maxResults = new BigInteger("100");
        FieldSearchQuery query = new FieldSearchQuery();
        FieldSearchQuery.Conditions conds = new FieldSearchQuery.Conditions();
        Condition cond = new Condition();
        cond.setOperator(ComparisonOperator.EQ);
        cond.setProperty("pid");
        cond.setValue("demo:5");
        conds.getCondition().add(cond);
        ObjectFactory factory = new ObjectFactory();
        query.setConditions(factory.createFieldSearchQueryConditions(conds));
        FieldSearchResult result = this.apia.findObjects(TypeUtility.convertStringtoAOS((String[])resultFields), maxResults, query);
        FieldSearchResult.ResultList resultList = result.getResultList();
        List fields = resultList.getObjectFields();
        TestAPIA.assertEquals((int)1, (int)fields.size());
        TestAPIA.assertEquals((String)"demo:5", (String)((String)((ObjectFields)fields.get(0)).getPid().getValue()));
    }

    public void testGetDatastreamDissemination() throws Exception {
        MIMETypedStream ds = null;
        ds = this.apia.getDatastreamDissemination("demo:5", "DC", null);
        byte[] bytes = TypeUtility.convertDataHandlerToBytes((DataHandler)ds.getStream());
        String xml = new String(bytes, "UTF-8");
        this.assertXpathExists("/oai_dc:dc", xml);
        this.assertXpathEvaluatesTo("demo:5", "/oai_dc:dc/dc:identifier/text( )", xml);
        TestAPIA.assertEquals((String)ds.getMIMEType(), (String)"text/xml");
        ds = this.apia.getDatastreamDissemination("demo:SmileyBeerGlass", "MEDIUM_SIZE", null);
        bytes = TypeUtility.convertDataHandlerToBytes((DataHandler)ds.getStream());
        TestAPIA.assertEquals((String)ds.getMIMEType(), (String)"image/jpeg");
        TestAPIA.assertTrue((bytes.length > 0 ? 1 : 0) != 0);
        ds = this.apia.getDatastreamDissemination("demo:31", "DS3", null);
        TestAPIA.assertEquals((String)ds.getMIMEType(), (String)"application/fedora-redirect");
        ds = this.apia.getDatastreamDissemination("demo:5", "THUMBRES_IMG", null);
        bytes = TypeUtility.convertDataHandlerToBytes((DataHandler)ds.getStream());
        TestAPIA.assertEquals((String)ds.getMIMEType(), (String)"image/jpeg");
        TestAPIA.assertTrue((bytes.length > 0 ? 1 : 0) != 0);
    }

    public void testGetDisseminationDefault() throws Exception {
        MIMETypedStream diss = null;
        GetDissemination.Parameters params = new GetDissemination.Parameters();
        diss = this.apia.getDissemination("demo:5", "fedora-system:3", "viewDublinCore", params, null);
        TestAPIA.assertEquals((String)diss.getMIMEType(), (String)"text/html");
        TestAPIA.assertTrue((TypeUtility.convertDataHandlerToBytes((DataHandler)diss.getStream()).length > 0 ? 1 : 0) != 0);
    }

    public void testGetDisseminationUserInput() throws Exception {
        MIMETypedStream diss = null;
        GetDissemination.Parameters params = new GetDissemination.Parameters();
        Property prop = new Property();
        prop.setName("convertTo");
        prop.setValue("gif");
        params.getParameter().add(prop);
        diss = this.apia.getDissemination("demo:29", "demo:27", "convertImage", params, null);
        TestAPIA.assertEquals((String)diss.getMIMEType(), (String)"image/gif");
        TestAPIA.assertTrue((TypeUtility.convertDataHandlerToBytes((DataHandler)diss.getStream()).length > 0 ? 1 : 0) != 0);
    }

    public void testObjectHistory() throws Exception {
        List timestamps = this.apia.getObjectHistory("demo:5");
        TestAPIA.assertTrue((timestamps.size() > 0 ? 1 : 0) != 0);
    }

    public void testGetObjectProfile() throws Exception {
        ObjectProfile profile = this.apia.getObjectProfile("demo:5", null);
        TestAPIA.assertEquals((String)"demo:5", (String)profile.getPid());
        TestAPIA.assertTrue((!profile.getObjDissIndexViewURL().equals("") ? 1 : 0) != 0);
        TestAPIA.assertTrue((!profile.getObjItemIndexViewURL().equals("") ? 1 : 0) != 0);
    }

    public void testGetObjectProfileBasicCModel() throws Exception {
        for (String pid : new String[]{"demo:SmileyPens", "demo:SmileyGreetingCard"}) {
            ObjectProfile profile = this.apia.getObjectProfile(pid, null);
            boolean found = false;
            ObjectProfile.ObjModels objModels = profile.getObjModels();
            if (objModels != null && objModels.getModel() != null) {
                for (String objModel : objModels.getModel()) {
                    if (!objModel.equals(Models.FEDORA_OBJECT_CURRENT.uri)) continue;
                    found = true;
                }
            }
            TestAPIA.assertTrue((String)(pid + " did not assert cmodel " + Models.FEDORA_OBJECT_CURRENT.uri), (boolean)found);
        }
    }

    public void testListDatastreams() throws Exception {
        List dsDefs = this.apia.listDatastreams("demo:5", null);
        TestAPIA.assertEquals((int)6, (int)dsDefs.size());
    }

    public void testListMethods() throws Exception {
        List methodDefs = this.apia.listMethods("demo:5", null);
        TestAPIA.assertEquals((int)8, (int)methodDefs.size());
    }

    public void setUp() throws Exception {
        FedoraClient client = TestAPIA.getFedoraClient();
        this.apia = client.getAPIAMTOM();
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put(TestAPIA.OAI_DC.prefix, TestAPIA.OAI_DC.uri);
        nsMap.put(TestAPIA.DC.prefix, TestAPIA.DC.uri);
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
    }

    @After
    public void tearDown() {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
    }

    public static void main(String[] args) {
        TestRunner.run(TestAPIA.class);
    }
}

