/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.client.HttpInputStream;
import org.fcrepo.common.Models;
import org.fcrepo.test.DemoObjectTestSetup;
import org.fcrepo.test.FedoraServerTestCase;
import org.junit.After;
import org.junit.Before;
import org.w3c.dom.Document;

public class TestAPIALite
extends FedoraServerTestCase {
    private static FedoraClient client;

    public static Test suite() {
        TestSuite suite = new TestSuite("APIALite TestSuite");
        suite.addTestSuite(TestAPIALite.class);
        return new DemoObjectTestSetup((Test)suite);
    }

    @Before
    public void setUp() throws Exception {
        client = TestAPIALite.getFedoraClient();
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("fedora-types", "http://www.fedora.info/definitions/1/0/types/");
        nsMap.put(TestAPIALite.OAI_DC.prefix, TestAPIALite.OAI_DC.uri);
        nsMap.put(TestAPIALite.DC.prefix, TestAPIALite.DC.uri);
        nsMap.put(TestAPIALite.ACCESS.prefix, TestAPIALite.ACCESS.uri);
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
    }

    @After
    public void tearDown() {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
    }

    public void testDescribeRepository() throws Exception {
        Document result = this.getXMLQueryResult("/describe?xml=true");
        this.assertXpathExists(String.format("/%s:fedoraRepository/%s:repositoryName", TestAPIALite.ACCESS.prefix, TestAPIALite.ACCESS.prefix), result);
    }

    public void testGetDatastreamDissemination() throws Exception {
        Document result = this.getXMLQueryResult("/get/demo:5/DC");
        this.assertXpathExists("/oai_dc:dc", result);
        this.assertXpathEvaluatesTo("demo:5", "/oai_dc:dc/dc:identifier/text()", result);
        HttpInputStream in = client.get("/get/demo:SmileyBeerGlass/MEDIUM_SIZE", true);
        TestAPIALite.assertEquals((String)in.getContentType(), (String)"image/jpeg");
        TestAPIALite.assertTrue((in.getContentLength() > 0 ? 1 : 0) != 0);
        in.close();
        in = client.get("/get/demo:31/DS3", false, false);
        TestAPIALite.assertEquals((int)in.getStatusCode(), (int)302);
        in.close();
        in = client.get("/get/demo:5/THUMBRES_IMG", true);
        TestAPIALite.assertEquals((String)in.getContentType(), (String)"image/jpeg");
        in.close();
    }

    public void testGetDisseminationDefault() throws Exception {
        HttpInputStream his = client.get("/get/demo:5/fedora-system:3/viewDublinCore", true);
        TestAPIALite.assertEquals((String)his.getContentType(), (String)"text/html");
        his.close();
    }

    public void testGetDisseminationUserInput() throws Exception {
        HttpInputStream his = client.get("/get/demo:29/demo:27/convertImage?convertTo=gif", true);
        TestAPIALite.assertEquals((String)his.getContentType(), (String)"image/gif");
        his.close();
    }

    public void testObjectHistory() throws Exception {
        Document result = this.getXMLQueryResult("/getObjectHistory/demo:5?xml=true");
        this.assertXpathExists(String.format("/%s:fedoraObjectHistory/%s:objectChangeDate", TestAPIALite.ACCESS.prefix, TestAPIALite.ACCESS.prefix), result);
    }

    public void testGetObjectProfile() throws Exception {
        Document result = this.getXMLQueryResult("/get/demo:5?xml=true");
        this.assertXpathEvaluatesTo("demo:5", String.format("/%s:objectProfile/attribute::pid", TestAPIALite.ACCESS.prefix), result);
    }

    public void testGetObjectProfileBasicCModel() throws Exception {
        String testExpression = String.format("count(/%s:objectProfile/%s:objModels/%s:model[normalize-space()='" + Models.FEDORA_OBJECT_CURRENT.uri + "'])", TestAPIALite.ACCESS.prefix, TestAPIALite.ACCESS.prefix, TestAPIALite.ACCESS.prefix);
        for (String pid : new String[]{"demo:SmileyPens", "demo:SmileyGreetingCard"}) {
            Document result = this.getXMLQueryResult("/get/" + pid + "?xml=true");
            this.assertXpathEvaluatesTo("1", testExpression, result);
        }
    }

    public void testListDatastreams() throws Exception {
        Document result = this.getXMLQueryResult("/listDatastreams/demo:5?xml=true");
        this.assertXpathEvaluatesTo("6", String.format("count(/%s:objectDatastreams/%s:datastream)", TestAPIALite.ACCESS.prefix, TestAPIALite.ACCESS.prefix), result);
    }

    public void testListMethods() throws Exception {
        Document result = this.getXMLQueryResult("/listMethods/demo:5?xml=true");
        this.assertXpathEvaluatesTo("8", String.format("count(/%s:objectMethods/%s:sDef/%s:method)", TestAPIALite.ACCESS.prefix, TestAPIALite.ACCESS.prefix, TestAPIALite.ACCESS.prefix), result);
    }

    public static void main(String[] args) {
        TestRunner.run(TestAPIALite.class);
    }
}

