/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.xml.ws.soap.SOAPFaultException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.common.Constants;
import org.fcrepo.server.access.FedoraAPIAMTOM;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.server.types.gen.Datastream;
import org.fcrepo.server.types.gen.DatastreamProblem;
import org.fcrepo.server.types.gen.FieldSearchQuery;
import org.fcrepo.server.types.gen.FieldSearchResult;
import org.fcrepo.server.types.gen.ObjectFactory;
import org.fcrepo.server.types.gen.ObjectFields;
import org.fcrepo.server.types.gen.Validation;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.test.DemoObjectTestSetup;
import org.fcrepo.test.FedoraServerTestCase;
import org.junit.After;
import org.w3c.dom.Document;

public class TestAPIM
extends FedoraServerTestCase
implements Constants {
    private FedoraAPIMMTOM apim;
    private FedoraAPIAMTOM apia;
    public static byte[] dsXML;
    public static byte[] demo997FOXML10ObjectXML;
    public static byte[] demo998FOXMLObjectXML;
    public static byte[] demo999METSObjectXML;
    public static byte[] demo999bMETS10ObjectXML;
    public static byte[] demo1000ATOMObjectXML;
    public static byte[] demo1001ATOMZip;
    public static byte[] demo1001_relsext;
    public static byte[] changeme1FOXMLObjectXML;
    public static byte[] changeme2METSObjectXML;

    public static Test suite() {
        TestSuite suite = new TestSuite("APIM TestSuite");
        suite.addTestSuite(TestAPIM.class);
        return new DemoObjectTestSetup((Test)suite);
    }

    public void setUp() throws Exception {
        this.apim = TestAPIM.getFedoraClient().getAPIMMTOM();
        this.apia = TestAPIM.getFedoraClient().getAPIAMTOM();
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("oai_dc", "http://www.openarchives.org/OAI/2.0/oai_dc/");
        nsMap.put("dc", "http://purl.org/dc/elements/1.1/");
        nsMap.put("foxml", "info:fedora/fedora-system:def/foxml#");
        nsMap.put("audit", "info:fedora/fedora-system:def/audit#");
        nsMap.put("METS", "http://www.loc.gov/METS/");
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
    }

    @After
    public void tearDown() {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
    }

    public void testGetObjectXML() throws Exception {
        System.out.println("Running TestAPIM.testGetObjectXML...");
        byte[] objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML("demo:5"));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        String xmlIn = new String(objectXML, "UTF-8");
        this.assertXpathExists("foxml:digitalObject[@PID='demo:5']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
        this.assertXpathEvaluatesTo("6", "count(//foxml:datastream[@ID!='AUDIT'])", xmlIn);
    }

    public void testObjectMethods() throws Exception {
        HashSet<String> serverAssignedPIDs = new HashSet<String>();
        System.out.println("Running TestAPIM.testIngest...");
        String pid2 = this.apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])demo998FOXMLObjectXML), TestAPIM.FOXML1_1.uri, "ingesting new foxml object");
        TestAPIM.assertNotNull((Object)pid2);
        serverAssignedPIDs.add(pid2);
        byte[] objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML(pid2));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        String xmlIn = new String(objectXML, "UTF-8");
        this.assertXpathExists("foxml:digitalObject[@PID='" + pid2 + "']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
        this.assertXpathExists("//foxml:datastream[@ID='AUDIT']", xmlIn);
        this.assertXpathEvaluatesTo("5", "count(//foxml:datastream[@ID!='AUDIT'])", xmlIn);
        pid2 = this.apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])changeme1FOXMLObjectXML), TestAPIM.FOXML1_1.uri, null);
        TestAPIM.assertNotNull((Object)pid2);
        serverAssignedPIDs.add(pid2);
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML(pid2));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        xmlIn = new String(objectXML, "UTF-8");
        this.assertXpathExists("foxml:digitalObject[@PID='" + pid2 + "']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
        this.assertXpathNotExists("//foxml:datastream[@ID='AUDIT']", xmlIn);
        this.assertXpathEvaluatesTo("5", "count(//foxml:datastream[@ID!='AUDIT'])", xmlIn);
        pid2 = this.apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])demo999METSObjectXML), TestAPIM.METS_EXT1_1.uri, "ingesting new mets object");
        TestAPIM.assertNotNull((Object)pid2);
        serverAssignedPIDs.add(pid2);
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML(pid2));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        xmlIn = new String(objectXML, "UTF-8");
        this.assertXpathExists("foxml:digitalObject[@PID='" + pid2 + "']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
        this.assertXpathEvaluatesTo("5", "count(//foxml:datastream[@ID!='AUDIT'])", xmlIn);
        pid2 = this.apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])changeme2METSObjectXML), TestAPIM.METS_EXT1_1.uri, "ingesting new mets object");
        TestAPIM.assertNotNull((Object)pid2);
        serverAssignedPIDs.add(pid2);
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML(pid2));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        xmlIn = new String(objectXML, "UTF-8");
        this.assertXpathExists("foxml:digitalObject[@PID='" + pid2 + "']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
        this.assertXpathEvaluatesTo("5", "count(//foxml:datastream[@ID!='AUDIT'])", xmlIn);
        pid2 = this.apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])demo1000ATOMObjectXML), TestAPIM.ATOM1_1.uri, "ingesting new atom object");
        TestAPIM.assertNotNull((Object)pid2);
        serverAssignedPIDs.add(pid2);
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML(pid2));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        xmlIn = new String(objectXML, "UTF-8");
        this.assertXpathExists("foxml:digitalObject[@PID='" + pid2 + "']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
        this.assertXpathEvaluatesTo("6", "count(//foxml:datastream[@ID!='AUDIT'])", xmlIn);
        System.out.println("Running TestAPIM.testModifyObject...");
        String result = this.apim.modifyObject("demo:5", "I", null, null, "changed state to Inactive");
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML("demo:5"));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        xmlIn = new String(objectXML, "UTF-8");
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state'and @VALUE='Inactive']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label'and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
        this.assertXpathExists("//audit:auditTrail/audit:record[last()]/audit:action['modifyObject']", xmlIn);
        this.assertXpathExists("//audit:auditTrail/audit:record[last()]/audit:justification['changed state to Inactive']", xmlIn);
        result = this.apim.modifyObject("demo:5", null, "changed label", null, "changed label");
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML("demo:5"));
        xmlIn = new String(objectXML, "UTF-8");
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Inactive']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='changed label']", xmlIn);
        result = this.apim.modifyObject("demo:5", "D", "label of object to be deleted", null, "changed label and state");
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML("demo:5"));
        xmlIn = new String(objectXML, "UTF-8");
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Deleted']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='label of object to be deleted']", xmlIn);
        result = this.apim.modifyObject("demo:5", "A", "Data Object (Coliseum) for Local Simple Image Demo", null, "reset label and state");
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML("demo:5"));
        xmlIn = new String(objectXML, "UTF-8");
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
        System.out.println("Running TestAPIM.testExport...");
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.export("demo:998", TestAPIM.FOXML1_1.uri, "default"));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        xmlIn = new String(objectXML, "UTF-8");
        this.assertXpathExists("foxml:digitalObject[@PID='demo:998']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
        this.assertXpathEvaluatesTo("5", "count(//foxml:datastream[@ID!='AUDIT'])", xmlIn);
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.export("demo:998", TestAPIM.FOXML1_1.uri, "public"));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        xmlIn = new String(objectXML, "UTF-8");
        this.assertXpathExists("foxml:digitalObject[@PID='demo:998']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
        this.assertXpathEvaluatesTo("5", "count(//foxml:datastream[@ID!='AUDIT'])", xmlIn);
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.export("demo:998", TestAPIM.FOXML1_1.uri, "migrate"));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        xmlIn = new String(objectXML, "UTF-8");
        this.assertXpathExists("foxml:digitalObject[@PID='demo:998']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
        this.assertXpathEvaluatesTo("5", "count(//foxml:datastream[@ID!='AUDIT'])", xmlIn);
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.export("demo:999", TestAPIM.METS_EXT1_1.uri, "default"));
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML("demo:999"));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        xmlIn = new String(objectXML, "UTF-8");
        this.assertXpathExists("foxml:digitalObject[@PID='demo:999']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
        this.assertXpathEvaluatesTo("5", "count(//foxml:datastream[@ID!='AUDIT'])", xmlIn);
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.export("demo:999", TestAPIM.METS_EXT1_1.uri, "public"));
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML("demo:999"));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        xmlIn = new String(objectXML, "UTF-8");
        this.assertXpathExists("foxml:digitalObject[@PID='demo:999']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
        this.assertXpathEvaluatesTo("5", "count(//foxml:datastream[@ID!='AUDIT'])", xmlIn);
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.export("demo:999", TestAPIM.METS_EXT1_1.uri, "migrate"));
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML("demo:999"));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        xmlIn = new String(objectXML, "UTF-8");
        this.assertXpathExists("foxml:digitalObject[@PID='demo:999']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
        this.assertXpathEvaluatesTo("5", "count(//foxml:datastream[@ID!='AUDIT'])", xmlIn);
        System.out.println("Running TestAPIM.testPurgeObject...");
        for (String pid2 : serverAssignedPIDs) {
            result = this.apim.purgeObject(pid2, "purging object " + pid2, false);
            TestAPIM.assertNotNull((Object)result);
        }
    }

    public void testAddDatastream() throws Exception {
        System.out.println("Running TestAPIM.testAddDatastream...");
        try {
            this.apim.addDatastream("demo:14", "NEWDS1", null, "A New M-type Datastream", true, "text/xml", "info:myFormatURI/Mtype/stuff#junk", TestAPIM.getBaseURL() + "/get/fedora-system:ContentModel-3.0/DC", "M", "A", "MD6", null, "adding new datastream");
            Assert.fail();
        }
        catch (SOAPFaultException af) {
            System.out.println(af.getMessage());
            TestAPIM.assertTrue((boolean)af.getMessage().contains("Unknown checksum algorithm specified:"));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        try {
            this.apim.addDatastream("demo:14", "NEWDS1", null, "A New M-type Datastream", true, "text/xml", "info:myFormatURI/Mtype/stuff#junk", TestAPIM.getBaseURL() + "/get/fedora-system:ContentModel-3.0/DC", "M", "A", "TIGER", null, "adding new datastream");
            Assert.fail();
        }
        catch (SOAPFaultException af) {
            TestAPIM.assertTrue((boolean)af.getMessage().contains("Checksum algorithm not yet implemented:"));
        }
        String[] altIds = new String[]{"Datastream 1 Alternate ID"};
        String datastreamId = this.apim.addDatastream("demo:14", "NEWDS1", TypeUtility.convertStringtoAOS((String[])altIds), "A New M-type Datastream", true, "text/xml", "info:myFormatURI/Mtype/stuff#junk", TestAPIM.getBaseURL() + "/get/fedora-system:ContentModel-3.0/DC", "M", "A", null, null, "adding new datastream");
        TestAPIM.assertEquals((String)datastreamId, (String)"NEWDS1");
        byte[] objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML("demo:14"));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        String xmlIn = new String(objectXML, "UTF-8");
        Document doc = XMLUnit.buildControlDocument((String)xmlIn);
        this.assertXpathExists("foxml:digitalObject[@PID='demo:14']", doc);
        this.assertXpathExists("//foxml:datastream[@ID='NEWDS1' and @CONTROL_GROUP='M' and @STATE='A']", doc);
        this.assertXpathExists("//foxml:datastreamVersion[@ID='NEWDS1.0' and @MIMETYPE='text/xml' and @LABEL='A New M-type Datastream' and @ALT_IDS='Datastream 1 Alternate ID' and @FORMAT_URI='info:myFormatURI/Mtype/stuff#junk']", doc);
        this.assertXpathExists("//audit:auditTrail/audit:record[last()]/audit:action['addDatastream']", doc);
        this.assertXpathEvaluatesTo("6", "count(//foxml:datastream[@ID!='AUDIT'])", doc);
        Datastream origManagedContent = this.apim.getDatastream("fedora-system:ContentModel-3.0", "DC", null);
        long managedContentSize = origManagedContent.getSize();
        this.assertXpathExists("//foxml:datastreamVersion[@ID='NEWDS1.0' and @SIZE='" + managedContentSize + "']", xmlIn);
        altIds[0] = "Datastream 2 Alternate ID";
        datastreamId = this.apim.addDatastream("demo:14", "NEWDS2", TypeUtility.convertStringtoAOS((String[])altIds), "A New X-type Datastream", true, "text/xml", "info:myFormatURI/Xtype/stuff#junk", TestAPIM.getBaseURL() + "/get/fedora-system:ContentModel-3.0/DC", "X", "A", null, null, "adding new datastream");
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML("demo:14"));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        xmlIn = new String(objectXML, "UTF-8");
        doc = XMLUnit.buildControlDocument((String)xmlIn);
        this.assertXpathExists("foxml:digitalObject[@PID='demo:14']", doc);
        this.assertXpathExists("//foxml:datastream[@ID='NEWDS2' and @CONTROL_GROUP='X' and @STATE='A']", doc);
        this.assertXpathExists("//foxml:datastreamVersion[@ID='NEWDS2.0' and @MIMETYPE='text/xml' and @LABEL='A New X-type Datastream' and @ALT_IDS='Datastream 2 Alternate ID' and @FORMAT_URI='info:myFormatURI/Xtype/stuff#junk']", doc);
        this.assertXpathExists("//audit:auditTrail/audit:record[last()]/audit:action['addDatastream']", doc);
        this.assertXpathEvaluatesTo("7", "count(//foxml:datastream[@ID!='AUDIT'])", doc);
        altIds[0] = "Datastream 3 Alternate ID";
        datastreamId = this.apim.addDatastream("demo:14", "NEWDS3", TypeUtility.convertStringtoAOS((String[])altIds), "A New E-type Datastream", true, "text/xml", "info:myFormatURI/Etype/stuff#junk", TestAPIM.getBaseURL() + "/get/fedora-system:ContentModel-3.0/DC", "E", "A", null, null, "adding new datastream");
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML("demo:14"));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        xmlIn = new String(objectXML, "UTF-8");
        doc = XMLUnit.buildControlDocument((String)xmlIn);
        this.assertXpathExists("foxml:digitalObject[@PID='demo:14']", doc);
        this.assertXpathExists("//foxml:datastream[@ID='NEWDS3' and @CONTROL_GROUP='E' and @STATE='A']", doc);
        this.assertXpathExists("//foxml:datastreamVersion[@ID='NEWDS3.0' and @MIMETYPE='text/xml' and @LABEL='A New E-type Datastream' and @ALT_IDS='Datastream 3 Alternate ID' and @FORMAT_URI='info:myFormatURI/Etype/stuff#junk']", doc);
        this.assertXpathExists("//audit:auditTrail/audit:record[last()]/audit:action['addDatastream']", doc);
        this.assertXpathEvaluatesTo("8", "count(//foxml:datastream[@ID!='AUDIT'])", doc);
        for (String reservedDSID : new String[]{"RELS-EXT", "RELS-INT", "DC"}) {
            altIds[0] = "Datastream 2 Alternate ID";
            try {
                datastreamId = this.apim.addDatastream("demo:18", reservedDSID, TypeUtility.convertStringtoAOS((String[])altIds), "A New RELS Datastream", true, "application/rdf+xml", "info:fedora/fedora-system:FedoraRELSExt-1.0", TestAPIM.getBaseURL() + "/get/fedora-system:ContentModel-3.0/RELS-EXT", "X", "A", null, null, "adding new invalid datastream");
                TestAPIM.fail((String)(reservedDSID + " was not validated on addDatastream"));
            }
            catch (SOAPFaultException se) {
                // empty catch block
            }
        }
        String mcPID = "demo:SmileyBeerGlass_M";
        String[] purgedDatastreams = this.apim.purgeDatastream(mcPID, "RELS-EXT", null, null, "Purge managed content datastream RELS-EXT" + mcPID, false).toArray(new String[0]);
        TestAPIM.assertTrue((String)"Check purged managed datastream RELS-EXT", (purgedDatastreams.length == 1 ? 1 : 0) != 0);
        for (String reservedDSID : new String[]{"RELS-EXT", "RELS-INT"}) {
            altIds[0] = "Datastream 2 Alternate ID";
            try {
                datastreamId = this.apim.addDatastream(mcPID, reservedDSID, TypeUtility.convertStringtoAOS((String[])altIds), "A New RELS Datastream", true, "application/rdf+xml", "info:fedora/fedora-system:FedoraRELSExt-1.0", TestAPIM.getBaseURL() + "/get/fedora-system:ContentModel-3.0/RELS-EXT", "M", "A", null, null, "adding new invalid datastream");
                TestAPIM.fail((String)(reservedDSID + " was not validated on addDatastream (managed)"));
            }
            catch (SOAPFaultException se) {
                TestAPIM.assertTrue((String)se.getMessage(), (boolean)se.getMessage().contains(reservedDSID + " validation failed"));
            }
        }
        mcPID = "demo:SmileyPens_M";
        purgedDatastreams = this.apim.purgeDatastream(mcPID, "RELS-EXT", null, null, "Purge managed content datastream RELS-EXT" + mcPID, false).toArray(new String[0]);
        TestAPIM.assertTrue((String)"Check purged managed datastream RELS-EXT", (purgedDatastreams.length == 1 ? 1 : 0) != 0);
        purgedDatastreams = this.apim.purgeDatastream(mcPID, "RELS-INT", null, null, "Purge managed content datastream RELS-INT" + mcPID, false).toArray(new String[0]);
        TestAPIM.assertTrue((String)"Check purged managed datastream RELS-INT", (purgedDatastreams.length == 1 ? 1 : 0) != 0);
        for (String reservedDSID : new String[]{"RELS-EXT", "RELS-INT"}) {
            altIds[0] = "Datastream 2 Alternate ID";
            datastreamId = this.apim.addDatastream(mcPID, reservedDSID, TypeUtility.convertStringtoAOS((String[])altIds), "A New RELS Datastream", true, "application/rdf+xml", "info:fedora/fedora-system:FedoraRELSExt-1.0", TestAPIM.getDemoBaseURL() + "/image-collection-demo/SmileyPens_M-" + reservedDSID + ".xml", "M", "A", null, null, "adding new invalid datastream");
            objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML(mcPID));
            TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
            xmlIn = new String(objectXML, "UTF-8");
            doc = XMLUnit.buildControlDocument((String)xmlIn);
            this.assertXpathExists("foxml:digitalObject[@PID='" + mcPID + "']", doc);
            this.assertXpathExists("//foxml:datastream[@ID='" + reservedDSID + "' and @CONTROL_GROUP='M' and @STATE='A']", doc);
            this.assertXpathExists("//foxml:datastream[@ID='" + reservedDSID + "']/foxml:datastreamVersion[@ID='" + reservedDSID + ".0' and @MIMETYPE='application/rdf+xml' and @LABEL='A New RELS Datastream' and @ALT_IDS='Datastream 2 Alternate ID' and @FORMAT_URI='info:fedora/fedora-system:FedoraRELSExt-1.0']", doc);
            this.assertXpathExists("//audit:auditTrail/audit:record[last()]/audit:action['addDatastream']", doc);
        }
    }

    public void testModifyDatastreamByReference() throws Exception {
        System.out.println("Running TestAPIM.testModifyDatastreamByReference...");
        List<String> testDsIds = this.setUpDatastreamModificationTest("demo:14", "MODREF", "M", 1);
        int numNonAudits = this.getNumberNonAuditDatastreams("demo:14");
        String testDsId = testDsIds.get(0);
        TestAPIM.assertEquals((String)"MODREFDSM1", (String)testDsId);
        Datastream origManagedContent = this.apim.getDatastream("fedora-system:ContentModel-3.0", "DC", null);
        long managedContentSize = origManagedContent.getSize();
        String[] altIds = new String[]{"Datastream 1 Modified Alternate ID"};
        String datastreamId = this.apim.modifyDatastreamByReference("demo:14", testDsId, TypeUtility.convertStringtoAOS((String[])altIds), "Modified M-type Datastream", "text/xml", "info:newMyFormatURI/Mtype/stuff#junk", TestAPIM.getBaseURL() + "/get/fedora-system:ContentModel-3.0/DC", null, null, "modified datastream", false);
        byte[] objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML("demo:14"));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        String xmlIn = new String(objectXML, "UTF-8");
        Document doc = XMLUnit.buildControlDocument((String)xmlIn);
        this.assertXpathExists("foxml:digitalObject[@PID='demo:14']", doc);
        this.assertXpathExists("//foxml:datastream[@ID='MODREFDSM1' and @CONTROL_GROUP='M' and @STATE='A']", doc);
        this.assertXpathExists("//foxml:datastreamVersion[@ID='MODREFDSM1.1' and @MIMETYPE='text/xml' and @LABEL='Modified M-type Datastream' and @ALT_IDS='Datastream 1 Modified Alternate ID' and @FORMAT_URI='info:newMyFormatURI/Mtype/stuff#junk']", doc);
        this.assertXpathExists("//audit:auditTrail/audit:record[last()]/audit:action['modifyDatastreamByReference']", doc);
        this.assertXpathEvaluatesTo(Integer.toString(numNonAudits), "count(//foxml:datastream[@ID!='AUDIT'])", doc);
        this.assertXpathExists("//foxml:datastreamVersion[@ID='MODREFDSM1.0' and @SIZE='" + managedContentSize + "']", doc);
        Datastream ds1 = this.apim.getDatastream("demo:14", "MODREFDSM1", null);
        TestAPIM.assertEquals((long)managedContentSize, (long)ds1.getSize());
        String mcPID = "demo:SmileyPens_M";
        for (String reservedDSID : new String[]{"RELS-EXT", "RELS-INT"}) {
            altIds[0] = "Datastream 2 Alternate ID";
            try {
                datastreamId = this.apim.modifyDatastreamByReference(mcPID, reservedDSID, TypeUtility.convertStringtoAOS((String[])altIds), "A New RELS Datastream", "application/rdf+xml", "info:fedora/fedora-system:FedoraRELSExt-1.0", TestAPIM.getBaseURL() + "/get/fedora-system:ContentModel-3.0/RELS-EXT", null, null, "modifying by reference invalid datastream", false);
                TestAPIM.fail((String)(reservedDSID + " was not validated on modifyDatastreamByReference"));
            }
            catch (SOAPFaultException se) {
                TestAPIM.assertTrue((String)se.getMessage(), (boolean)se.getMessage().contains(reservedDSID + " validation failed"));
            }
        }
        mcPID = "demo:SmileyPens_M";
        for (String reservedDSID : new String[]{"RELS-EXT", "RELS-INT"}) {
            altIds[0] = "Datastream 2 Alternate ID";
            String uri = null;
            if (reservedDSID.equals("RELS-EXT")) {
                uri = "info:fedora/fedora-system:FedoraRELSExt-1.0";
            } else if (reservedDSID.equals("RELS-INT")) {
                uri = "info:fedora/fedora-system:FedoraRELSInt-1.0";
            }
            datastreamId = this.apim.modifyDatastreamByReference(mcPID, reservedDSID, TypeUtility.convertStringtoAOS((String[])altIds), "A New RELS Datastream", "application/rdf+xml", uri, TestAPIM.getDemoBaseURL() + "/image-collection-demo/SmileyPens_M-" + reservedDSID + ".xml", null, null, "modify reserved datastream by reference with valid content", false);
            objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML(mcPID));
            TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
            xmlIn = new String(objectXML, "UTF-8");
            doc = XMLUnit.buildControlDocument((String)xmlIn);
            this.assertXpathExists("foxml:digitalObject[@PID='" + mcPID + "']", doc);
            this.assertXpathExists("//foxml:datastream[@ID='" + reservedDSID + "' and @CONTROL_GROUP='M' and @STATE='A']", doc);
            this.assertXpathExists("//foxml:datastream[@ID='" + reservedDSID + "']/foxml:datastreamVersion[@ID='" + reservedDSID + ".1' and @MIMETYPE='application/rdf+xml' and @LABEL='A New RELS Datastream' and @ALT_IDS='Datastream 2 Alternate ID' and @FORMAT_URI='" + uri + "']", doc);
            this.assertXpathExists("//audit:auditTrail/audit:record[last()]/audit:action['addDatastream']", doc);
        }
        this.tearDownDatastreamModificationTest("demo:14", testDsIds);
    }

    public void testModifyDatastreamByValue() throws Exception {
        String uri;
        System.out.println("Running TestAPIM.testModifyDatastreamByValue...");
        List<String> testDsIds = this.setUpDatastreamModificationTest("demo:14", "MODVALUE", "M", 1);
        testDsIds.addAll(this.setUpDatastreamModificationTest("demo:14", "MODVALUE", "X", 1));
        int numNonAudits = this.getNumberNonAuditDatastreams("demo:14");
        String testXDsId = testDsIds.get(1);
        String testMDsId = testDsIds.get(0);
        TestAPIM.assertEquals((String)"MODVALUEDSX1", (String)testXDsId);
        TestAPIM.assertEquals((String)"MODVALUEDSM1", (String)testMDsId);
        String[] altIds = new String[]{"Datastream 1 Modified Alternate ID"};
        String datastreamId = this.apim.modifyDatastreamByValue("demo:14", testXDsId, TypeUtility.convertStringtoAOS((String[])altIds), "Modified X-type Datastream", "text/xml", "info:newMyFormatURI/Xtype/stuff#junk", TypeUtility.convertBytesToDataHandler((byte[])dsXML), null, null, "modified datastream", false);
        byte[] objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML("demo:14"));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        String xmlIn = new String(objectXML, "UTF-8");
        Document doc = XMLUnit.buildControlDocument((String)xmlIn);
        this.assertXpathExists("foxml:digitalObject[@PID='demo:14']", doc);
        this.assertXpathExists("//foxml:datastream[@ID='" + testXDsId + "' and @CONTROL_GROUP='X' and @STATE='A']", doc);
        this.assertXpathExists("//foxml:datastreamVersion[@ID='" + testXDsId + ".1' and @MIMETYPE='text/xml' and @LABEL='Modified X-type Datastream' and @ALT_IDS='Datastream 1 Modified Alternate ID' and @FORMAT_URI='info:newMyFormatURI/Xtype/stuff#junk']", doc);
        this.assertXpathExists("foxml:digitalObject/foxml:datastream[@ID='" + testXDsId + "'][//dc:identifier='Identifier 5']", doc);
        this.assertXpathExists("foxml:digitalObject/foxml:datastream[@ID='" + testXDsId + "'][//dc:identifier='demo:14']", doc);
        this.assertXpathExists("//audit:auditTrail/audit:record[last()]/audit:action['modifyDatastreamByValue']", doc);
        this.assertXpathEvaluatesTo(Integer.toString(numNonAudits), "count(//foxml:datastream[@ID!='AUDIT'])", doc);
        System.out.println("Running TestAPIM.testModifyDatastreamByValue...");
        altIds = new String[]{"Datastream 1 Modified Alternate ID"};
        datastreamId = this.apim.modifyDatastreamByValue("demo:14", testMDsId, TypeUtility.convertStringtoAOS((String[])altIds), "Modified M-type Datastream", "text/xml", "info:newMyFormatURI/Xtype/stuff#junk", TypeUtility.convertBytesToDataHandler((byte[])dsXML), null, null, "modified datastream by value (M)", false);
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML("demo:14"));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        xmlIn = new String(objectXML, "UTF-8");
        doc = XMLUnit.buildControlDocument((String)xmlIn);
        this.assertXpathExists("foxml:digitalObject[@PID='demo:14']", doc);
        this.assertXpathExists("//foxml:datastream[@ID='MODVALUEDSM1' and @CONTROL_GROUP='M' and @STATE='A']", doc);
        this.assertXpathExists("//foxml:datastreamVersion[@ID='MODVALUEDSM1.1' and @MIMETYPE='text/xml' and @LABEL='Modified M-type Datastream' and @ALT_IDS='Datastream 1 Modified Alternate ID' and @FORMAT_URI='info:newMyFormatURI/Xtype/stuff#junk']", doc);
        this.assertXpathExists("foxml:digitalObject/foxml:datastream[@ID='MODVALUEDSM1'][//dc:identifier='Identifier 5']", doc);
        this.assertXpathExists("//audit:auditTrail/audit:record[last()]/audit:action['modifyDatastreamByValue']", doc);
        this.assertXpathEvaluatesTo(Integer.toString(numNonAudits), "count(//foxml:datastream[@ID!='AUDIT'])", doc);
        for (String reservedDSID : new String[]{"RELS-EXT", "RELS-INT"}) {
            altIds[0] = "Datastream 2 Alternate ID";
            String uri2 = null;
            if (reservedDSID.equals("RELS-EXT")) {
                uri2 = "info:fedora/fedora-system:FedoraRELSExt-1.0";
            } else if (reservedDSID.equals("RELS-INT")) {
                uri2 = "info:fedora/fedora-system:FedoraRELSInt-1.0";
            }
            try {
                datastreamId = this.apim.modifyDatastreamByValue("demo:SmileyGreetingCard", reservedDSID, TypeUtility.convertStringtoAOS((String[])altIds), "Modified RELS Datastream", "application/rdf+xml", uri2, TypeUtility.convertBytesToDataHandler((byte[])demo1001_relsext), null, null, "modifying datastream", false);
                TestAPIM.fail((String)(reservedDSID + " was not validated on modifyDatastreamByValue"));
            }
            catch (SOAPFaultException se) {
                TestAPIM.assertTrue((String)se.getMessage(), (boolean)se.getMessage().contains(reservedDSID + " validation failed"));
            }
        }
        String mcPID = "demo:SmileyPens_M";
        for (String reservedDSID : new String[]{"RELS-EXT", "RELS-INT"}) {
            altIds[0] = "Datastream 2 Alternate ID";
            uri = null;
            if (reservedDSID.equals("RELS-EXT")) {
                uri = "info:fedora/fedora-system:FedoraRELSExt-1.0";
            } else if (reservedDSID.equals("RELS-INT")) {
                uri = "info:fedora/fedora-system:FedoraRELSInt-1.0";
            }
            try {
                datastreamId = this.apim.modifyDatastreamByValue(mcPID, reservedDSID, TypeUtility.convertStringtoAOS((String[])altIds), "A New RELS Datastream", "application/rdf+xml", uri, TypeUtility.convertBytesToDataHandler((byte[])"<node>with valid xml but not valid content for RELS-* or DC</node>".getBytes()), null, null, "modifying by value M type reserved datastream", false);
                TestAPIM.fail((String)(reservedDSID + " was not validated on modifyDatastreamByReference"));
            }
            catch (SOAPFaultException se) {
                TestAPIM.assertTrue((String)se.getMessage(), (boolean)se.getMessage().contains(reservedDSID + " validation failed"));
            }
        }
        mcPID = "demo:SmileyPens_M";
        String[] relsContent = new String[]{"<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:rel=\"http://www.example.org/test#\"><rdf:Description rdf:about=\"info:fedora/demo:SmileyPens_M\"><rel:dummy>stuff</rel:dummy></rdf:Description></rdf:RDF>", "<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:rel=\"http://www.example.org/test#\"><rdf:Description rdf:about=\"info:fedora/demo:SmileyPens_M/DC\"><rel:dummy>stuff</rel:dummy></rdf:Description></rdf:RDF>"};
        String[] relsIDs = new String[]{"RELS-EXT", "RELS-INT"};
        for (int i = 0; i < relsIDs.length; ++i) {
            String reservedDSID;
            reservedDSID = relsIDs[i];
            altIds[0] = "Datastream 2 Alternate ID";
            uri = null;
            if (reservedDSID.equals("RELS-EXT")) {
                uri = "info:fedora/fedora-system:FedoraRELSExt-1.0";
            } else if (reservedDSID.equals("RELS-INT")) {
                uri = "info:fedora/fedora-system:FedoraRELSInt-1.0";
            }
            datastreamId = this.apim.modifyDatastreamByValue(mcPID, reservedDSID, TypeUtility.convertStringtoAOS((String[])altIds), "A New RELS Datastream", "application/rdf+xml", uri, TypeUtility.convertBytesToDataHandler((byte[])relsContent[i].getBytes()), null, null, "modify reserved M datastream by value with valid content", false);
            objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML(mcPID));
            TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
            xmlIn = new String(objectXML, "UTF-8");
            doc = XMLUnit.buildControlDocument((String)xmlIn);
            this.assertXpathExists("foxml:digitalObject[@PID='" + mcPID + "']", doc);
            this.assertXpathExists("//foxml:datastream[@ID='" + reservedDSID + "' and @CONTROL_GROUP='M' and @STATE='A']", doc);
            this.assertXpathExists("//foxml:datastream[@ID='" + reservedDSID + "']/foxml:datastreamVersion[@ID='" + reservedDSID + ".2' and @MIMETYPE='application/rdf+xml' and @LABEL='A New RELS Datastream' and @ALT_IDS='Datastream 2 Alternate ID' and @FORMAT_URI='" + uri + "']", doc);
            this.assertXpathExists("//audit:auditTrail/audit:record[last()]/audit:action['addDatastream']", doc);
        }
        System.out.println("Running TestAPIM.testModifyDatastreamByValue for METHODMAP...");
        datastreamId = this.apim.modifyDatastreamByValue("demo:2", "METHODMAP", null, "Mapping of WSDL to Fedora Notion of Method Definitions", "text/xml", null, null, null, null, "modified datastream", false);
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML("demo:2"));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        xmlIn = new String(objectXML, "UTF-8");
        doc = XMLUnit.buildControlDocument((String)xmlIn);
        this.assertXpathExists("foxml:digitalObject[@PID='demo:2']", doc);
        this.assertXpathExists("//foxml:datastream[@ID='METHODMAP' and @CONTROL_GROUP='X' and @STATE='A']", doc);
        this.assertXpathExists("//foxml:datastreamVersion[@ID='METHODMAP.1' and @MIMETYPE='text/xml' and @LABEL='Mapping of WSDL to Fedora Notion of Method Definitions']", doc);
        this.tearDownDatastreamModificationTest("demo:14", testDsIds);
    }

    public void compareDatastreamChecksum() throws Exception {
        System.out.println("Running TestAPIM.compareDatastreamChecksum...");
        List<String> testDsIds = this.setUpDatastreamModificationTest("demo:14", "CHECKSUMS", "M", 1);
        String testDsId = testDsIds.get(0);
        String datastreamId = null;
        try {
            datastreamId = this.apim.modifyDatastreamByValue("demo:14", testDsId, null, null, null, null, null, "MD6", null, "turned on checksumming", false);
            Assert.fail();
        }
        catch (SOAPFaultException af) {
            TestAPIM.assertTrue((boolean)af.getMessage().contains("Unknown checksum algorithm specified:"));
        }
        try {
            datastreamId = this.apim.modifyDatastreamByValue("demo:14", testDsId, null, null, null, null, null, "TIGER", null, "turned on checksumming", false);
            Assert.fail();
        }
        catch (SOAPFaultException af) {
            TestAPIM.assertTrue((boolean)af.getMessage().contains("Checksum algorithm not yet implemented:"));
        }
        datastreamId = this.apim.modifyDatastreamByValue("demo:14", testDsId, null, null, null, null, null, "MD5", null, "turned on checksumming", false);
        String checksum = this.apim.compareDatastreamChecksum("demo:14", testDsId, null);
        TestAPIM.assertTrue((checksum.length() > 0 ? 1 : 0) != 0);
        TestAPIM.assertTrue((!checksum.equals("none") ? 1 : 0) != 0);
        datastreamId = this.apim.modifyDatastreamByValue("demo:14", testDsId, null, null, null, null, null, "MD5", checksum, "turned off checksumming", false);
        String checksum2 = this.apim.compareDatastreamChecksum("demo:14", testDsId, null);
        TestAPIM.assertTrue((checksum2.length() > 0 ? 1 : 0) != 0);
        TestAPIM.assertTrue((boolean)checksum2.equals(checksum));
        datastreamId = this.apim.modifyDatastreamByValue("demo:14", testDsId, null, null, null, null, null, "DISABLED", null, "turned off checksumming", false);
        checksum = this.apim.compareDatastreamChecksum("demo:14", testDsId, null);
        TestAPIM.assertTrue((checksum.length() > 0 ? 1 : 0) != 0);
        TestAPIM.assertTrue((boolean)checksum.equals("none"));
        String checksum3 = "3aff11a78a8335a54b75e02d85a0caa3";
        datastreamId = this.apim.addDatastream("demo:14", "CHECKSUMDS", null, "datastream for testing checksums", true, null, null, TestAPIM.getBaseURL() + "/get/demo:14/" + testDsId, "M", "A", "MD5", checksum3, "creating datastream with checksum");
        String checksum4 = this.apim.compareDatastreamChecksum("demo:14", "CHECKSUMDS", null);
        TestAPIM.assertTrue((boolean)checksum3.equals(checksum4));
        try {
            datastreamId = this.apim.addDatastream("demo:14", "CHECKSUMDSFAIL", null, "datastream for testing checksums", true, null, null, TestAPIM.getBaseURL() + "/get/demo:14/" + testDsId, "M", "A", "MD5", "4aff31a28b8335a24b95e02d85a0caa4", "creating datastream with checksum");
            Assert.fail();
        }
        catch (SOAPFaultException af) {
            TestAPIM.assertTrue((boolean)af.getMessage().contains("Checksum Mismatch"));
        }
        try {
            datastreamId = this.apim.modifyDatastreamByReference("demo:14", "CHECKSUMDS", null, null, null, null, TestAPIM.getBaseURL() + "/get/demo:14/" + testDsId, "MD5", "4aff31a28b8335a24b95e02d85a0caa4", "modifying datastream with incorrect checksum", false);
            Assert.fail();
        }
        catch (SOAPFaultException af) {
            TestAPIM.assertTrue((boolean)af.getMessage().contains("Checksum Mismatch"));
        }
        datastreamId = this.apim.modifyDatastreamByReference("demo:14", "CHECKSUMDS", null, null, null, null, TestAPIM.getBaseURL() + "/get/demo:14/" + testDsId, "MD5", checksum3, "modifying datastream with correct checksum", false);
        checksum4 = this.apim.compareDatastreamChecksum("demo:14", "CHECKSUMDS", null);
        TestAPIM.assertTrue((boolean)checksum3.equals(checksum3));
        this.tearDownDatastreamModificationTest("demo:14", testDsIds);
    }

    public void testPurgeDatastream() throws Exception {
        String[] results;
        List<String> testDsIds = this.setUpDatastreamModificationTest("demo:14", "PURGE", "M", 3);
        System.out.println("Running TestAPIM.testPurgeDatastream...");
        for (String element : results = this.apim.purgeDatastream("demo:14", testDsIds.get(0), "1900-01-01T00:00:00.000Z", null, "purging datastream NEWDS1", false).toArray(new String[0])) {
            System.out.println("***** Testcase: TestAPIM.testPurgeDatastream specifying startDate=\"1900-01-01T00:00:00.000Z\" and endDate=null dsID: " + element);
        }
        TestAPIM.assertTrue((results.length > 0 ? 1 : 0) != 0);
        for (String element : results = this.apim.purgeDatastream("demo:14", testDsIds.get(1), null, null, "purging datastream NEWDS2", false).toArray(new String[0])) {
            System.out.println("***** Testcase: TestAPIM.testPurgeDatastream specifying startDate=null and endDate=null dsID: " + element);
        }
        TestAPIM.assertTrue((results.length > 0 ? 1 : 0) != 0);
        for (String element : results = this.apim.purgeDatastream("demo:14", testDsIds.get(2), "1900-01-01T00:00:00.000Z", "9999-01-01T00:00:00.000Z", "purging datastream NEWDS3", false).toArray(new String[0])) {
            System.out.println("***** Testcase: TestAPIM.testPurgeDatastream specifying startDate=\"1900-01-01T00:00:00.000Z\" endDate=\"9999-01-01T00:00:00.000Z\" dsID: " + element);
        }
        TestAPIM.assertTrue((results.length > 0 ? 1 : 0) != 0);
        byte[] objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML("demo:14"));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        String xmlIn = new String(objectXML, "UTF-8");
        Document doc = XMLUnit.buildControlDocument((String)xmlIn);
        this.assertXpathExists("foxml:digitalObject[@PID='demo:14']", doc);
        this.assertXpathExists("//audit:auditTrail/audit:record[last()]/audit:action['purgeDatastream']", doc);
    }

    public void testGetDatastream() throws Exception {
        System.out.println("Running TestAPIM.testGetDatastream...");
        Datastream ds = this.apim.getDatastream("demo:26", "XML_SOURCE", null);
        TestAPIM.assertNotNull((Object)ds);
        Datastream[] dsArray = new Datastream[]{ds};
        System.out.println("***** Testcase: TestAPIM.testGetDatastream getDatastream(\"demo:26\", \"XML_SOURCE\", null)");
        this.checkDatastream(dsArray, "XML_SOURCE", null, "FOP Dissemination as Datastream", "http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/" + TestAPIM.getFedoraAppServerContext() + "/get/demo:26/demo:22/getFO", "text/xml", "A", "XML_SOURCE1.0", true, "E", -1, new String[0]);
        dsArray[0] = ds = this.apim.getDatastream("demo:26", "XML_SOURCE", "9999-01-01T00:00:00.000Z");
        System.out.println("***** Testcase: TestAPIM.testGetDatastream getDatastream(\"demo:26\", ,\"XML_SOURCE\", \"9999-01-01T00:00:00.000Z\")");
        this.checkDatastream(dsArray, "XML_SOURCE", null, "FOP Dissemination as Datastream", "http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/" + TestAPIM.getFedoraAppServerContext() + "/get/demo:26/demo:22/getFO", "text/xml", "A", "XML_SOURCE1.0", true, "E", -1, new String[0]);
    }

    public void testGetDatastreams() throws Exception {
        System.out.println("Running TestAPIM.testGetDatastreams...");
        Datastream[] dsArray = this.apim.getDatastreams("demo:26", null, null).toArray(new Datastream[0]);
        TestAPIM.assertEquals((int)dsArray.length, (int)4);
        System.out.println("***** Testcase: TestAPIM.testGetDatastreams getDatastreams(\"demo:26\", null, null) number of Datastreams: " + dsArray.length);
        this.checkDatastream(dsArray, "DC", TestAPIM.OAI_DC2_0.uri, "Dublin Core Record for this object", null, "text/xml", "A", "DC1.0", true, "X", -1, new String[0]);
        this.checkDatastream(dsArray, "XML_SOURCE", null, "FOP Dissemination as Datastream", "http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/" + TestAPIM.getFedoraAppServerContext() + "/get/demo:26/demo:22/getFO", "text/xml", "A", "XML_SOURCE1.0", true, "E", -1, new String[0]);
        this.checkDatastream(dsArray, "TEI_SOURCE", null, "TEI Source", null, "text/xml", "A", "TEI_SOURCE1.0", true, "X", -1, new String[0]);
        this.checkDatastream(dsArray, "RELS-EXT", TestAPIM.RELS_EXT1_0.uri, "RDF Statements about this object", null, "application/rdf+xml", "A", "RELS-EXT1.0", true, "X", -1, new String[0]);
        dsArray = this.apim.getDatastreams("demo:26", "9999-01-01T00:00:00.000Z", null).toArray(new Datastream[0]);
        System.out.println("***** Testcase: TestAPIM.testGetDatastreams getDatastreams(\"demo:26\", \"9999-01-01T00:00:00.000Z\", null) number of Datastreams: " + dsArray.length);
        TestAPIM.assertEquals((int)dsArray.length, (int)4);
        this.checkDatastream(dsArray, "DC", TestAPIM.OAI_DC2_0.uri, "Dublin Core Record for this object", null, "text/xml", "A", "DC1.0", true, "X", -1, new String[0]);
        this.checkDatastream(dsArray, "XML_SOURCE", null, "FOP Dissemination as Datastream", "http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/" + TestAPIM.getFedoraAppServerContext() + "/get/demo:26/demo:22/getFO", "text/xml", "A", "XML_SOURCE1.0", true, "E", -1, new String[0]);
        this.checkDatastream(dsArray, "TEI_SOURCE", null, "TEI Source", null, "text/xml", "A", "TEI_SOURCE1.0", true, "X", -1, new String[0]);
        this.checkDatastream(dsArray, "RELS-EXT", TestAPIM.RELS_EXT1_0.uri, "RDF Statements about this object", null, "application/rdf+xml", "A", "RELS-EXT1.0", true, "X", -1, new String[0]);
    }

    public void testGetDatastreamHistory() throws Exception {
        System.out.println("Running TestAPIM.testGetDatastreamHistory...");
        Datastream[] dsArray = this.apim.getDatastreamHistory("demo:5", "DC").toArray(new Datastream[0]);
        TestAPIM.assertEquals((int)dsArray.length, (int)1);
    }

    private List<String> setUpDatastreamModificationTest(String pid, String stub, String type, int number) throws Exception {
        ArrayList<String> result = new ArrayList<String>(number);
        for (int i = 0; i < number; ++i) {
            String newDS = stub + "DS" + type + Integer.toString(i + 1);
            String[] altIds = new String[]{"Datastream " + Integer.toString(i + 1) + " Alternate ID"};
            String datastreamId = this.apim.addDatastream(pid, newDS, TypeUtility.convertStringtoAOS((String[])altIds), "A New M-type Datastream", true, "text/xml", "info:myFormatURI/Mtype/stuff#junk", TestAPIM.getBaseURL() + "/get/fedora-system:ContentModel-3.0/DC", type, "A", null, null, "adding new datastream");
            result.add(i, datastreamId);
        }
        return result;
    }

    private void tearDownDatastreamModificationTest(String pid, List<String> dsids) throws Exception {
        for (String dsid : dsids) {
            this.apim.purgeDatastream(pid, dsid, null, null, "purging datastream " + dsid, false).toArray(new String[0]);
        }
    }

    private void checkDatastream(Datastream[] dsArray, String id, String formatURI, String label, String location, String mimeType, String state, String versionID, boolean isVersionable, String controlGroup, int size, String[] altIDs) {
        Datastream ds = null;
        for (Datastream candidate : dsArray) {
            if (!candidate.getID().equals(id)) continue;
            ds = candidate;
        }
        if (ds != null) {
            if (TestAPIM.testingMETS() && formatURI == null && ds.getFormatURI() != null) {
                TestAPIM.assertTrue((boolean)ds.getFormatURI().endsWith("MD.OTHER.UNSPECIFIED"));
            } else {
                TestAPIM.assertEquals((String)formatURI, (String)ds.getFormatURI());
            }
            TestAPIM.assertEquals((String)label, (String)ds.getLabel());
            TestAPIM.assertEquals((String)location, (String)ds.getLocation());
            TestAPIM.assertEquals((String)mimeType, (String)ds.getMIMEType());
            TestAPIM.assertEquals((String)state, (String)ds.getState());
            TestAPIM.assertEquals((String)versionID, (String)ds.getVersionID());
            TestAPIM.assertEquals((boolean)isVersionable, (boolean)ds.isVersionable());
            TestAPIM.assertEquals((String)controlGroup, (String)ds.getControlGroup().value());
            if (size > -1) {
                TestAPIM.assertEquals((long)size, (long)ds.getSize());
            }
            if (altIDs == null) {
                TestAPIM.assertEquals(null, (Object)ds.getAltIDs());
            } else {
                TestAPIM.assertEquals((int)altIDs.length, (int)ds.getAltIDs().getItem().size());
                for (int i = 0; i < altIDs.length; ++i) {
                    TestAPIM.assertEquals((String)("AltID at position " + i + " did not match"), (String)altIDs[i], (String)((String)ds.getAltIDs().getItem().get(i)));
                }
            }
        } else {
            TestAPIM.assertEquals((String)("Datastream with id " + id + " not found in dsArray"), (boolean)true, (boolean)false);
        }
    }

    private int getNumberNonAuditDatastreams(String pid) throws Exception {
        byte[] objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML(pid));
        return this.getNumberNonAuditDatastreams(objectXML);
    }

    private int getNumberNonAuditDatastreams(byte[] objectXML) throws Exception {
        String xmlIn = new String(objectXML, "UTF-8");
        Document doc = XMLUnit.buildControlDocument((String)xmlIn);
        return this.getNumberNonAuditDatastreams(doc);
    }

    private int getNumberNonAuditDatastreams(Document doc) throws Exception {
        return Integer.parseInt(XMLUnit.newXpathEngine().evaluate("count(//foxml:datastream[@ID!='AUDIT'])", doc));
    }

    public void testSetDatastreamState() throws Exception {
        System.out.println("Running TestAPIM.testSetDatastreamState...");
        String result = this.apim.setDatastreamState("demo:5", "DC", "I", "changed state of datstream DC to Inactive");
        TestAPIM.assertNotNull((Object)result);
        Datastream ds = this.apim.getDatastream("demo:5", "DC", null);
        TestAPIM.assertEquals((String)"I", (String)ds.getState());
        byte[] objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML("demo:5"));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        String xmlIn = new String(objectXML, "UTF-8");
        this.assertXpathExists("foxml:digitalObject[@PID='demo:5']", xmlIn);
        this.assertXpathExists("//audit:auditTrail/audit:record[last()]/audit:action['setDatastreamState']", xmlIn);
        result = this.apim.setDatastreamState("demo:5", "DC", "A", "reset state of datastream DC to Active");
        TestAPIM.assertNotNull((Object)result);
        ds = this.apim.getDatastream("demo:5", "DC", null);
        TestAPIM.assertEquals((String)"A", (String)ds.getState());
    }

    public void testSetDatastreamVersionable() throws Exception {
        System.out.println("Running TestAPIM.testSetDatastreamVersionable...");
        String result = this.apim.setDatastreamVersionable("demo:5", "DC", false, "changed versionable on datastream DC to false");
        TestAPIM.assertNotNull((Object)result);
        Datastream ds = this.apim.getDatastream("demo:5", "DC", null);
        TestAPIM.assertEquals((boolean)false, (boolean)ds.isVersionable());
        byte[] objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML("demo:5"));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        String xmlIn = new String(objectXML, "UTF-8");
        this.assertXpathExists("foxml:digitalObject[@PID='demo:5']", xmlIn);
        this.assertXpathExists("//audit:auditTrail/audit:record[last()]/audit:action['setDatastreamVersionable']", xmlIn);
        result = this.apim.setDatastreamVersionable("demo:5", "DC", true, "reset versionable on datastream DC to true");
        TestAPIM.assertNotNull((Object)result);
        ds = this.apim.getDatastream("demo:5", "DC", null);
        TestAPIM.assertEquals((boolean)true, (boolean)ds.isVersionable());
    }

    public void testGetNextPID() throws Exception {
        System.out.println("Running TestAPIM.testGetNextPID...");
        String[] pids = this.apim.getNextPID(null, null).toArray(new String[0]);
        TestAPIM.assertTrue((pids.length > 0 ? 1 : 0) != 0);
        TestAPIM.assertEquals((int)pids.length, (int)1);
        TestAPIM.assertTrue((boolean)pids[0].startsWith("changeme"));
        pids = this.apim.getNextPID(null, "dummy").toArray(new String[0]);
        TestAPIM.assertTrue((pids.length > 0 ? 1 : 0) != 0);
        TestAPIM.assertEquals((int)pids.length, (int)1);
        TestAPIM.assertTrue((boolean)pids[0].startsWith("dummy:"));
        pids = this.apim.getNextPID(new BigInteger("1"), null).toArray(new String[0]);
        TestAPIM.assertTrue((pids.length > 0 ? 1 : 0) != 0);
        TestAPIM.assertEquals((int)pids.length, (int)1);
        TestAPIM.assertTrue((boolean)pids[0].startsWith("changeme"));
        pids = this.apim.getNextPID(new BigInteger("2"), "namespace").toArray(new String[0]);
        TestAPIM.assertTrue((pids.length > 0 ? 1 : 0) != 0);
        TestAPIM.assertEquals((int)pids.length, (int)2);
        TestAPIM.assertTrue((boolean)pids[0].startsWith("namespace:"));
        TestAPIM.assertTrue((boolean)pids[1].startsWith("namespace:"));
    }

    public void testLegacyDOFormats() throws Exception {
        System.out.println("Running TestAPIM.testDigitalObjectFormat...");
        String pid = this.apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])demo997FOXML10ObjectXML), TestAPIM.FOXML1_0.uri, "ingesting new foxml 1.0 object");
        TestAPIM.assertNotNull((Object)pid);
        byte[] objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML(pid));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        String xmlIn = new String(objectXML, "UTF-8");
        Document doc = XMLUnit.buildControlDocument((String)xmlIn);
        this.assertXpathExists("foxml:digitalObject[@PID='" + pid + "']", doc);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", doc);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", doc);
        this.assertXpathNotExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#contentModel']", doc);
        this.assertXpathNotExists("//foxml:disseminator", doc);
        this.assertXpathExists("//foxml:datastream[@ID='AUDIT']", doc);
        this.assertXpathEvaluatesTo("5", "count(//foxml:datastream[@ID!='AUDIT'])", doc);
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.export("demo:997", TestAPIM.FOXML1_0.uri, "migrate"));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        xmlIn = new String(objectXML, "UTF-8");
        doc = XMLUnit.buildControlDocument((String)xmlIn);
        this.assertXpathExists("foxml:digitalObject[@PID='demo:997']", doc);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", doc);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", doc);
        this.assertXpathNotExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#contentModel']", doc);
        this.assertXpathNotExists("//foxml:disseminator", doc);
        this.assertXpathExists("//foxml:datastream[@ID='AUDIT']", doc);
        this.assertXpathEvaluatesTo("5", "count(//foxml:datastream[@ID!='AUDIT'])", doc);
        this.apim.purgeObject(pid, "purging object demo:997", false);
        pid = this.apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])demo999bMETS10ObjectXML), TestAPIM.METS_EXT1_0.uri, "ingesting new mets 1.0 object");
        TestAPIM.assertNotNull((Object)pid);
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.getObjectXML(pid));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        xmlIn = new String(objectXML, "UTF-8");
        this.assertXpathExists("foxml:digitalObject[@PID='" + pid + "']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", xmlIn);
        this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
        this.assertXpathEvaluatesTo("5", "count(//foxml:datastream[@ID!='AUDIT'])", xmlIn);
        objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apim.export("demo:999b", TestAPIM.METS_EXT1_0.uri, "migrate"));
        TestAPIM.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
        xmlIn = new String(objectXML, "UTF-8");
        this.assertXpathExists("METS:mets[@OBJID='demo:999b']", xmlIn);
        this.assertXpathExists("METS:mets[@LABEL='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
        this.apim.purgeObject(pid, "purging object demo:999b", false);
    }

    public void testValidate() throws Exception {
        System.out.println("Running TestAPIM.testValidate...");
        String[] resultFields = new String[]{"pid"};
        BigInteger maxResults = new BigInteger("1000");
        FieldSearchQuery query = new FieldSearchQuery();
        ObjectFactory factory = new ObjectFactory();
        query.setTerms(factory.createFieldSearchQueryTerms("*"));
        FieldSearchResult result = this.apia.findObjects(TypeUtility.convertStringtoAOS((String[])resultFields), maxResults, query);
        List fields = result.getResultList().getObjectFields();
        for (ObjectFields objectFields : fields) {
            String pid = (String)objectFields.getPid().getValue();
            System.out.println("Validating object '" + pid + "'");
            Validation validation = this.apim.validate(pid, null);
            if (!validation.isValid()) {
                System.out.println("PID " + validation.getPid());
                System.out.println("Valid " + validation.isValid());
                System.out.println("Problems");
                for (String problem : validation.getObjProblems().getProblem()) {
                    System.out.println(problem);
                }
                System.out.println("Datastream Problems");
                for (DatastreamProblem datastreamProblem : validation.getDatastreamProblems().getDatastream()) {
                    System.out.println("DS ID " + datastreamProblem.getDatastreamID());
                    for (String problem : datastreamProblem.getProblem()) {
                        System.out.println(problem);
                    }
                }
            }
            TestAPIM.assertTrue((boolean)validation.isValid());
        }
    }

    public static void main(String[] args) {
        TestRunner.run(TestAPIM.class);
    }

    static {
        StringBuffer sb = new StringBuffer();
        sb.append("<oai_dc:dc xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\">");
        sb.append("<dc:title>Dublin Core Record 5</dc:title>");
        sb.append("<dc:creator>Author 5</dc:creator>");
        sb.append("<dc:subject>Subject 5</dc:subject>");
        sb.append("<dc:description>Description 5</dc:description>");
        sb.append("<dc:publisher>Publisher 5</dc:publisher>");
        sb.append("<dc:format>MIME type 5</dc:format>");
        sb.append("<dc:identifier>Identifier 5</dc:identifier>");
        sb.append("</oai_dc:dc>");
        try {
            dsXML = sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<foxml:digitalObject PID=\"demo:997\" xmlns:METS=\"http://www.loc.gov/METS/\" xmlns:audit=\"info:fedora/fedora-system:def/audit#\" xmlns:fedoraAudit=\"http://fedora.comm.nsdlib.org/audit\" xmlns:foxml=\"info:fedora/fedora-system:def/foxml#\" xmlns:uvalibadmin=\"http://dl.lib.virginia.edu/bin/dtd/admin/admin.dtd\" xmlns:uvalibdesc=\"http://dl.lib.virginia.edu/bin/dtd/descmeta/descmeta.dtd\" xmlns:xlink=\"http://www.w3.org/TR/xlink\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"info:fedora/fedora-system:def/foxml# http://www.fedora.info/definitions/1/0/foxml1-0.xsd\">");
        sb.append("<foxml:objectProperties>");
        sb.append("<foxml:property NAME=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#type\" VALUE=\"FedoraObject\"/>");
        sb.append("<foxml:property NAME=\"info:fedora/fedora-system:def/model#state\" VALUE=\"A\"/>");
        sb.append("<foxml:property NAME=\"info:fedora/fedora-system:def/model#label\" VALUE=\"Data Object (Coliseum) for Local Simple Image Demo\"/>");
        sb.append("<foxml:property NAME=\"info:fedora/fedora-system:def/model#contentModel\" VALUE=\"UVA_STD_IMAGE\"/>");
        sb.append("<foxml:property NAME=\"info:fedora/fedora-system:def/model#ownerId\" VALUE=\"fedoraAdmin\"/>");
        sb.append("</foxml:objectProperties>");
        sb.append("<foxml:datastream ID=\"DC\" CONTROL_GROUP=\"X\" STATE=\"A\">");
        sb.append("<foxml:datastreamVersion ID=\"DC1.0\" MIMETYPE=\"text/xml\" LABEL=\"Dublin Core Record for this object\">");
        sb.append("<foxml:xmlContent>");
        sb.append("<oai_dc:dc xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\">");
        sb.append("<dc:title>Coliseum in Rome</dc:title>");
        sb.append("<dc:creator>Thornton Staples</dc:creator>");
        sb.append("<dc:subject>Architecture, Roman</dc:subject>");
        sb.append("<dc:description>Image of Coliseum in Rome</dc:description>");
        sb.append("<dc:publisher>University of Virginia Library</dc:publisher>");
        sb.append("<dc:format>image/jpeg</dc:format>");
        sb.append("<dc:identifier>demo:5</dc:identifier>");
        sb.append("</oai_dc:dc>");
        sb.append("</foxml:xmlContent>");
        sb.append("</foxml:datastreamVersion>");
        sb.append("</foxml:datastream>");
        sb.append("<foxml:datastream ID=\"DS1\" CONTROL_GROUP=\"M\" STATE=\"A\">");
        sb.append("<foxml:datastreamVersion ID=\"DS1.0\" MIMETYPE=\"image/jpeg\" LABEL=\"Thorny's Coliseum thumbnail jpg image\">");
        sb.append("<foxml:contentLocation REF=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-thumb.jpg\" TYPE=\"URL\"/>");
        sb.append("</foxml:datastreamVersion>");
        sb.append("</foxml:datastream>");
        sb.append("<foxml:datastream ID=\"DS2\" CONTROL_GROUP=\"M\" STATE=\"A\">");
        sb.append("<foxml:datastreamVersion ID=\"DS2.0\" MIMETYPE=\"image/jpeg\" LABEL=\"Thorny's Coliseum medium jpg image\">");
        sb.append("<foxml:contentLocation REF=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-medium.jpg\" TYPE=\"URL\"/>");
        sb.append("</foxml:datastreamVersion>");
        sb.append("</foxml:datastream>");
        sb.append("<foxml:datastream ID=\"DS3\" CONTROL_GROUP=\"M\" STATE=\"A\">");
        sb.append("<foxml:datastreamVersion ID=\"DS3.0\" MIMETYPE=\"image/jpeg\" LABEL=\"Thorny's Coliseum high jpg image\">");
        sb.append("<foxml:contentLocation REF=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-high.jpg\" TYPE=\"URL\"/>");
        sb.append("</foxml:datastreamVersion>");
        sb.append("</foxml:datastream>");
        sb.append("<foxml:datastream ID=\"DS4\" CONTROL_GROUP=\"M\" STATE=\"A\">");
        sb.append("<foxml:datastreamVersion ID=\"DS4.0\" MIMETYPE=\"image/jpeg\" LABEL=\"Thorny's Coliseum veryhigh jpg image\">");
        sb.append("<foxml:contentLocation REF=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-veryhigh.jpg\" TYPE=\"URL\"/>");
        sb.append("</foxml:datastreamVersion>");
        sb.append("</foxml:datastream>");
        sb.append("<foxml:disseminator ID=\"DISS1\" BDEF_CONTRACT_PID=\"demo:1\" STATE=\"A\">");
        sb.append("<foxml:disseminatorVersion ID=\"DISS1.0\" BMECH_SERVICE_PID=\"demo:2\" LABEL=\"UVA Simple Image Behaviors\">");
        sb.append("<foxml:serviceInputMap>");
        sb.append("<foxml:datastreamBinding DATASTREAM_ID=\"DS1\" KEY=\"THUMBRES_IMG\" LABEL=\"Binding to thumbnail photo of Coliseum\"/>");
        sb.append("<foxml:datastreamBinding DATASTREAM_ID=\"DS2\" KEY=\"MEDRES_IMG\" LABEL=\"Binding to medium resolution photo of Coliseum\"/>");
        sb.append("<foxml:datastreamBinding DATASTREAM_ID=\"DS3\" KEY=\"HIGHRES_IMG\" LABEL=\"Binding to high resolution photo of Coliseum\"/>");
        sb.append("<foxml:datastreamBinding DATASTREAM_ID=\"DS4\" KEY=\"VERYHIGHRES_IMG\" LABEL=\"Binding to very high resolution photo of Coliseum\"/>");
        sb.append("</foxml:serviceInputMap>");
        sb.append("</foxml:disseminatorVersion>");
        sb.append("</foxml:disseminator>");
        sb.append("</foxml:digitalObject>");
        try {
            demo997FOXML10ObjectXML = sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<foxml:digitalObject VERSION=\"1.1\" PID=\"demo:998\" xmlns:foxml=\"info:fedora/fedora-system:def/foxml#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"info:fedora/fedora-system:def/foxml# http://www.fedora.info/definitions/1/0/foxml1-1.xsd\">");
        sb.append("  <foxml:objectProperties>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#state\" VALUE=\"A\"/>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#label\" VALUE=\"Data Object (Coliseum) for Local Simple Image Demo\"/>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#createdDate\" VALUE=\"2004-12-10T00:21:57Z\"/>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/view#lastModifiedDate\" VALUE=\"2004-12-10T00:21:57Z\"/>");
        sb.append("  </foxml:objectProperties>");
        sb.append("  <foxml:datastream ID=\"DC\" CONTROL_GROUP=\"X\" STATE=\"A\">");
        sb.append("    <foxml:datastreamVersion FORMAT_URI=\"http://www.openarchives.org/OAI/2.0/oai_dc/\" ID=\"DC1.0\" MIMETYPE=\"text/xml\" LABEL=\"Dublin Core Record for this object\">");
        sb.append("         <foxml:xmlContent>");
        sb.append("        <oai_dc:dc xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\">");
        sb.append("          <dc:title>Coliseum in Rome</dc:title>");
        sb.append("          <dc:creator>Thornton Staples</dc:creator>");
        sb.append("          <dc:subject>Architecture, Roman</dc:subject>");
        sb.append("          <dc:description>Image of Coliseum in Rome</dc:description>");
        sb.append("          <dc:publisher>University of Virginia Library</dc:publisher>");
        sb.append("          <dc:format>image/jpeg</dc:format>");
        sb.append("          <dc:identifier>demo:5</dc:identifier>");
        sb.append("        </oai_dc:dc>");
        sb.append("      </foxml:xmlContent>");
        sb.append("    </foxml:datastreamVersion>");
        sb.append("  </foxml:datastream>");
        sb.append("  <foxml:datastream ID=\"DS1\" CONTROL_GROUP=\"M\" STATE=\"A\">");
        sb.append("    <foxml:datastreamVersion ID=\"DS1.0\" MIMETYPE=\"image/jpeg\" LABEL=\"Thorny's Coliseum thumbnail jpg image\">");
        sb.append("      <foxml:contentLocation REF=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-thumb.jpg\" TYPE=\"URL\"/>");
        sb.append("    </foxml:datastreamVersion>");
        sb.append("  </foxml:datastream>");
        sb.append("  <foxml:datastream ID=\"DS2\" CONTROL_GROUP=\"M\" STATE=\"A\">");
        sb.append("    <foxml:datastreamVersion ID=\"DS2.0\" MIMETYPE=\"image/jpeg\" LABEL=\"Thorny's Coliseum medium jpg image\">");
        sb.append("      <foxml:contentLocation REF=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-medium.jpg\" TYPE=\"URL\"/>");
        sb.append("    </foxml:datastreamVersion>");
        sb.append("  </foxml:datastream>");
        sb.append("  <foxml:datastream ID=\"DS3\" CONTROL_GROUP=\"M\" STATE=\"A\">");
        sb.append("    <foxml:datastreamVersion ID=\"DS3.0\" MIMETYPE=\"image/jpeg\" LABEL=\"Thorny's Coliseum high jpg image\">");
        sb.append("      <foxml:contentLocation REF=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-high.jpg\" TYPE=\"URL\"/>");
        sb.append("    </foxml:datastreamVersion>");
        sb.append("  </foxml:datastream>");
        sb.append("  <foxml:datastream ID=\"DS4\" CONTROL_GROUP=\"M\" STATE=\"A\">");
        sb.append("    <foxml:datastreamVersion ID=\"DS4.0\" MIMETYPE=\"image/jpeg\" LABEL=\"Thorny's Coliseum veryhigh jpg image\">");
        sb.append("      <foxml:contentLocation REF=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-veryhigh.jpg\" TYPE=\"URL\"/>");
        sb.append("    </foxml:datastreamVersion>");
        sb.append("  </foxml:datastream>");
        sb.append("</foxml:digitalObject>");
        try {
            demo998FOXMLObjectXML = sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<foxml:digitalObject VERSION=\"1.1\" xmlns:foxml=\"info:fedora/fedora-system:def/foxml#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"info:fedora/fedora-system:def/foxml# http://www.fedora.info/definitions/1/0/foxml1-1.xsd\">");
        sb.append("  <foxml:objectProperties>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#state\" VALUE=\"A\"/>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#label\" VALUE=\"Data Object (Coliseum) for Local Simple Image Demo\"/>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#createdDate\" VALUE=\"2004-12-10T00:21:57Z\"/>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/view#lastModifiedDate\" VALUE=\"2004-12-10T00:21:57Z\"/>");
        sb.append("  </foxml:objectProperties>");
        sb.append("  <foxml:datastream ID=\"DC\" CONTROL_GROUP=\"X\" STATE=\"A\">");
        sb.append("    <foxml:datastreamVersion FORMAT_URI=\"http://www.openarchives.org/OAI/2.0/oai_dc/\" ID=\"DC1.0\" MIMETYPE=\"text/xml\" LABEL=\"Dublin Core Record for this object\">");
        sb.append("         <foxml:xmlContent>");
        sb.append("        <oai_dc:dc xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\">");
        sb.append("          <dc:title>Coliseum in Rome</dc:title>");
        sb.append("          <dc:creator>Thornton Staples</dc:creator>");
        sb.append("          <dc:subject>Architecture, Roman</dc:subject>");
        sb.append("          <dc:description>Image of Coliseum in Rome</dc:description>");
        sb.append("          <dc:publisher>University of Virginia Library</dc:publisher>");
        sb.append("          <dc:format>image/jpeg</dc:format>");
        sb.append("          <dc:identifier>demo:5</dc:identifier>");
        sb.append("        </oai_dc:dc>");
        sb.append("      </foxml:xmlContent>");
        sb.append("    </foxml:datastreamVersion>");
        sb.append("  </foxml:datastream>");
        sb.append("  <foxml:datastream ID=\"DS1\" CONTROL_GROUP=\"M\" STATE=\"A\">");
        sb.append("    <foxml:datastreamVersion ID=\"DS1.0\" MIMETYPE=\"image/jpeg\" LABEL=\"Thorny's Coliseum thumbnail jpg image\">");
        sb.append("      <foxml:contentLocation REF=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-thumb.jpg\" TYPE=\"URL\"/>");
        sb.append("    </foxml:datastreamVersion>");
        sb.append("  </foxml:datastream>");
        sb.append("  <foxml:datastream ID=\"DS2\" CONTROL_GROUP=\"M\" STATE=\"A\">");
        sb.append("    <foxml:datastreamVersion ID=\"DS2.0\" MIMETYPE=\"image/jpeg\" LABEL=\"Thorny's Coliseum medium jpg image\">");
        sb.append("      <foxml:contentLocation REF=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-medium.jpg\" TYPE=\"URL\"/>");
        sb.append("    </foxml:datastreamVersion>");
        sb.append("  </foxml:datastream>");
        sb.append("  <foxml:datastream ID=\"DS3\" CONTROL_GROUP=\"M\" STATE=\"A\">");
        sb.append("    <foxml:datastreamVersion ID=\"DS3.0\" MIMETYPE=\"image/jpeg\" LABEL=\"Thorny's Coliseum high jpg image\">");
        sb.append("      <foxml:contentLocation REF=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-high.jpg\" TYPE=\"URL\"/>");
        sb.append("    </foxml:datastreamVersion>");
        sb.append("  </foxml:datastream>");
        sb.append("  <foxml:datastream ID=\"DS4\" CONTROL_GROUP=\"M\" STATE=\"A\">");
        sb.append("    <foxml:datastreamVersion ID=\"DS4.0\" MIMETYPE=\"image/jpeg\" LABEL=\"Thorny's Coliseum veryhigh jpg image\">");
        sb.append("      <foxml:contentLocation REF=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-veryhigh.jpg\" TYPE=\"URL\"/>");
        sb.append("    </foxml:datastreamVersion>");
        sb.append("  </foxml:datastream>");
        sb.append("</foxml:digitalObject>");
        try {
            changeme1FOXMLObjectXML = sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<METS:mets EXT_VERSION=\"1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:METS=\"http://www.loc.gov/METS/\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.loc.gov/standards/METS/ http://www.fedora.info/definitions/1/0/mets-fedora-ext1-1.xsd\" OBJID=\"demo:999\" LABEL=\"Data Object (Coliseum) for Local Simple Image Demo\" >");
        sb.append("  <METS:dmdSecFedora ID=\"DC\" STATUS=\"A\">");
        sb.append("    <METS:descMD ID=\"DC1.0\">");
        sb.append("      <METS:mdWrap FORMAT_URI=\"http://www.openarchives.org/OAI/2.0/oai_dc/\" MIMETYPE=\"text/xml\" MDTYPE=\"OTHER\" LABEL=\"Dublin Core Record for this object\">");
        sb.append("        <METS:xmlData>");
        sb.append("          <oai_dc:dc xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\">");
        sb.append("            <dc:title>Coliseum in Rome</dc:title>");
        sb.append("            <dc:creator>Thornton Staples</dc:creator>");
        sb.append("            <dc:subject>Architecture, Roman</dc:subject>");
        sb.append("            <dc:description>Image of Coliseum in Rome</dc:description>");
        sb.append("            <dc:publisher>University of Virginia Library</dc:publisher>");
        sb.append("            <dc:format>image/jpeg</dc:format>");
        sb.append("            <dc:identifier>demo:5</dc:identifier>");
        sb.append("          </oai_dc:dc>");
        sb.append("        </METS:xmlData>");
        sb.append("      </METS:mdWrap>");
        sb.append("    </METS:descMD>");
        sb.append("  </METS:dmdSecFedora>");
        sb.append("  <METS:fileSec>");
        sb.append("    <METS:fileGrp ID=\"DATASTREAMS\">");
        sb.append("      <METS:fileGrp ID=\"DS1\" STATUS=\"A\">");
        sb.append("        <METS:file ID=\"DS1.0\" MIMETYPE=\"image/jpeg\" OWNERID=\"M\" STATUS=\"A\">");
        sb.append("          <METS:FLocat LOCTYPE=\"URL\" xlink:href=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-thumb.jpg\" xlink:title=\"Thorny's Coliseum thumbnail jpg image\"/>");
        sb.append("        </METS:file>");
        sb.append("      </METS:fileGrp>");
        sb.append("      <METS:fileGrp ID=\"DS2\" STATUS=\"A\">");
        sb.append("        <METS:file ID=\"DS2.0\" MIMETYPE=\"image/jpeg\" OWNERID=\"M\" STATUS=\"A\">");
        sb.append("          <METS:FLocat LOCTYPE=\"URL\" xlink:href=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-medium.jpg\" xlink:title=\"Thorny's Coliseum medium jpg image\"/>");
        sb.append("        </METS:file>");
        sb.append("      </METS:fileGrp>");
        sb.append("      <METS:fileGrp ID=\"DS3\">");
        sb.append("          <METS:file ID=\"DS3.0\" MIMETYPE=\"image/jpeg\" OWNERID=\"M\" STATUS=\"A\">");
        sb.append("            <METS:FLocat LOCTYPE=\"URL\" xlink:href=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-high.jpg\" xlink:title=\"Thorny's Coliseum high jpg image\"/>");
        sb.append("          </METS:file>");
        sb.append("      </METS:fileGrp>");
        sb.append("      <METS:fileGrp ID=\"DS4\">");
        sb.append("        <METS:file ID=\"DS4.0\" MIMETYPE=\"image/jpeg\" OWNERID=\"M\" STATUS=\"A\">");
        sb.append("          <METS:FLocat LOCTYPE=\"URL\" xlink:href=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-veryhigh.jpg\" xlink:title=\"Thorny's Coliseum veryhigh jpg image\"/>");
        sb.append("        </METS:file>");
        sb.append("      </METS:fileGrp>");
        sb.append("    </METS:fileGrp>");
        sb.append("  </METS:fileSec>");
        sb.append("</METS:mets>");
        try {
            demo999METSObjectXML = sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<METS:mets xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:METS=\"http://www.loc.gov/METS/\" xmlns:xlink=\"http://www.w3.org/TR/xlink\" xsi:schemaLocation=\"http://www.loc.gov/standards/METS/ http://www.fedora.info/definitions/1/0/mets-fedora-ext1-0.xsd\" OBJID=\"demo:999b\" TYPE=\"FedoraObject\" LABEL=\"Data Object (Coliseum) for Local Simple Image Demo\" >");
        sb.append("  <METS:dmdSecFedora ID=\"DC\" STATUS=\"A\">");
        sb.append("    <METS:descMD ID=\"DC1.0\">");
        sb.append("      <METS:mdWrap MIMETYPE=\"text/xml\" MDTYPE=\"OTHER\" LABEL=\"Dublin Core Record for this object\">");
        sb.append("        <METS:xmlData>");
        sb.append("          <oai_dc:dc xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\">");
        sb.append("            <dc:title>Coliseum in Rome</dc:title>");
        sb.append("            <dc:creator>Thornton Staples</dc:creator>");
        sb.append("            <dc:subject>Architecture, Roman</dc:subject>");
        sb.append("            <dc:description>Image of Coliseum in Rome</dc:description>");
        sb.append("            <dc:publisher>University of Virginia Library</dc:publisher>");
        sb.append("            <dc:format>image/jpeg</dc:format>");
        sb.append("            <dc:identifier>demo:5</dc:identifier>");
        sb.append("          </oai_dc:dc>");
        sb.append("        </METS:xmlData>");
        sb.append("      </METS:mdWrap>");
        sb.append("    </METS:descMD>");
        sb.append("  </METS:dmdSecFedora>");
        sb.append("  <METS:fileSec>");
        sb.append("    <METS:fileGrp ID=\"DATASTREAMS\">");
        sb.append("      <METS:fileGrp ID=\"DS1\" STATUS=\"A\">");
        sb.append("        <METS:file ID=\"DS1.0\" MIMETYPE=\"image/jpeg\" OWNERID=\"M\" STATUS=\"A\">");
        sb.append("          <METS:FLocat LOCTYPE=\"URL\" xlink:href=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-thumb.jpg\" xlink:title=\"Thorny's Coliseum thumbnail jpg image\"/>");
        sb.append("        </METS:file>");
        sb.append("      </METS:fileGrp>");
        sb.append("      <METS:fileGrp ID=\"DS2\" STATUS=\"A\">");
        sb.append("        <METS:file ID=\"DS2.0\" MIMETYPE=\"image/jpeg\" OWNERID=\"M\" STATUS=\"A\">");
        sb.append("          <METS:FLocat LOCTYPE=\"URL\" xlink:href=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-medium.jpg\" xlink:title=\"Thorny's Coliseum medium jpg image\"/>");
        sb.append("        </METS:file>");
        sb.append("      </METS:fileGrp>");
        sb.append("      <METS:fileGrp ID=\"DS3\">");
        sb.append("          <METS:file ID=\"DS3.0\" MIMETYPE=\"image/jpeg\" OWNERID=\"M\" STATUS=\"A\">");
        sb.append("            <METS:FLocat LOCTYPE=\"URL\" xlink:href=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-high.jpg\" xlink:title=\"Thorny's Coliseum high jpg image\"/>");
        sb.append("          </METS:file>");
        sb.append("      </METS:fileGrp>");
        sb.append("      <METS:fileGrp ID=\"DS4\">");
        sb.append("        <METS:file ID=\"DS4.0\" MIMETYPE=\"image/jpeg\" OWNERID=\"M\" STATUS=\"A\">");
        sb.append("          <METS:FLocat LOCTYPE=\"URL\" xlink:href=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-veryhigh.jpg\" xlink:title=\"Thorny's Coliseum veryhigh jpg image\"/>");
        sb.append("        </METS:file>");
        sb.append("      </METS:fileGrp>");
        sb.append("    </METS:fileGrp>");
        sb.append("  </METS:fileSec>");
        sb.append("</METS:mets>");
        try {
            demo999bMETS10ObjectXML = sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<METS:mets EXT_VERSION=\"1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:METS=\"http://www.loc.gov/METS/\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.loc.gov/standards/METS/ http://www.fedora.info/definitions/1/0/mets-fedora-ext1-1.xsd\" LABEL=\"Data Object (Coliseum) for Local Simple Image Demo\" >");
        sb.append("  <METS:dmdSecFedora ID=\"DC\" STATUS=\"A\">");
        sb.append("    <METS:descMD ID=\"DC1.0\">");
        sb.append("      <METS:mdWrap FORMAT_URI=\"http://www.openarchives.org/OAI/2.0/oai_dc/\" MIMETYPE=\"text/xml\" MDTYPE=\"OTHER\" LABEL=\"Dublin Core Record for this object\">");
        sb.append("        <METS:xmlData>");
        sb.append("          <oai_dc:dc xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\">");
        sb.append("            <dc:title>Coliseum in Rome</dc:title>");
        sb.append("            <dc:creator>Thornton Staples</dc:creator>");
        sb.append("            <dc:subject>Architecture, Roman</dc:subject>");
        sb.append("            <dc:description>Image of Coliseum in Rome</dc:description>");
        sb.append("            <dc:publisher>University of Virginia Library</dc:publisher>");
        sb.append("            <dc:format>image/jpeg</dc:format>");
        sb.append("            <dc:identifier>demo:5</dc:identifier>");
        sb.append("          </oai_dc:dc>");
        sb.append("        </METS:xmlData>");
        sb.append("      </METS:mdWrap>");
        sb.append("    </METS:descMD>");
        sb.append("  </METS:dmdSecFedora>");
        sb.append("  <METS:fileSec>");
        sb.append("    <METS:fileGrp ID=\"DATASTREAMS\">");
        sb.append("      <METS:fileGrp ID=\"DS1\" STATUS=\"A\">");
        sb.append("        <METS:file ID=\"DS1.0\" MIMETYPE=\"image/jpeg\" OWNERID=\"M\" STATUS=\"A\">");
        sb.append("          <METS:FLocat LOCTYPE=\"URL\" xlink:href=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-thumb.jpg\" xlink:title=\"Thorny's Coliseum thumbnail jpg image\"/>");
        sb.append("        </METS:file>");
        sb.append("      </METS:fileGrp>");
        sb.append("      <METS:fileGrp ID=\"DS2\" STATUS=\"A\">");
        sb.append("        <METS:file ID=\"DS2.0\" MIMETYPE=\"image/jpeg\" OWNERID=\"M\" STATUS=\"A\">");
        sb.append("          <METS:FLocat LOCTYPE=\"URL\" xlink:href=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-medium.jpg\" xlink:title=\"Thorny's Coliseum medium jpg image\"/>");
        sb.append("        </METS:file>");
        sb.append("      </METS:fileGrp>");
        sb.append("      <METS:fileGrp ID=\"DS3\">");
        sb.append("          <METS:file ID=\"DS3.0\" MIMETYPE=\"image/jpeg\" OWNERID=\"M\" STATUS=\"A\">");
        sb.append("            <METS:FLocat LOCTYPE=\"URL\" xlink:href=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-high.jpg\" xlink:title=\"Thorny's Coliseum high jpg image\"/>");
        sb.append("          </METS:file>");
        sb.append("      </METS:fileGrp>");
        sb.append("      <METS:fileGrp ID=\"DS4\">");
        sb.append("        <METS:file ID=\"DS4.0\" MIMETYPE=\"image/jpeg\" OWNERID=\"M\" STATUS=\"A\">");
        sb.append("          <METS:FLocat LOCTYPE=\"URL\" xlink:href=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-veryhigh.jpg\" xlink:title=\"Thorny's Coliseum veryhigh jpg image\"/>");
        sb.append("        </METS:file>");
        sb.append("      </METS:fileGrp>");
        sb.append("    </METS:fileGrp>");
        sb.append("  </METS:fileSec>");
        sb.append("</METS:mets>");
        try {
            changeme2METSObjectXML = sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<feed xmlns=\"http://www.w3.org/2005/Atom\">");
        sb.append("  <id>info:fedora/demo:1000</id>");
        sb.append("  <title type=\"text\">Data Object (Coliseum) for Local Simple Image Demo</title>");
        sb.append("  <updated>2008-04-30T03:54:31.525Z</updated>");
        sb.append("  <author>");
        sb.append("    <name>fedoraAdmin</name>");
        sb.append("  </author>");
        sb.append("  <category term=\"Active\" scheme=\"info:fedora/fedora-system:def/model#state\"></category>");
        sb.append("  <category term=\"2008-04-30T03:54:31.525Z\" scheme=\"info:fedora/fedora-system:def/model#createdDate\"></category>");
        sb.append("  <icon>http://www.fedora-commons.org/images/logo_vertical_transparent_200_251.png</icon>");
        sb.append("  <entry>");
        sb.append("    <id>info:fedora/demo:1000/DC</id>");
        sb.append("    <title type=\"text\">DC</title>");
        sb.append("    <updated>2008-04-30T03:54:31.459Z</updated>");
        sb.append("    <link href=\"info:fedora/demo:1000/DC/2008-04-30T03:54:31.459Z\" rel=\"alternate\"></link>");
        sb.append("    <category term=\"A\" scheme=\"info:fedora/fedora-system:def/model#state\"></category>");
        sb.append("    <category term=\"X\" scheme=\"info:fedora/fedora-system:def/model#controlGroup\"></category>");
        sb.append("    <category term=\"true\" scheme=\"info:fedora/fedora-system:def/model#versionable\"></category>");
        sb.append("  </entry>");
        sb.append("  <entry xmlns:thr=\"http://purl.org/syndication/thread/1.0\">");
        sb.append("    <id>info:fedora/demo:1000/DC/2008-04-30T03:54:31.459Z</id>");
        sb.append("    <title type=\"text\">DC1.0</title>");
        sb.append("    <updated>2008-04-30T03:54:31.459Z</updated>");
        sb.append("    <thr:in-reply-to ref=\"info:fedora/demo:1000/DC\"></thr:in-reply-to>");
        sb.append("    <category term=\"Dublin Core Record for this object\" scheme=\"info:fedora/fedora-system:def/model#label\"></category>");
        sb.append("    <category term=\"DISABLED\" scheme=\"info:fedora/fedora-system:def/model#digestType\"></category>");
        sb.append("    <category term=\"none\" scheme=\"info:fedora/fedora-system:def/model#digest\"></category>");
        sb.append("    <category term=\"491\" scheme=\"info:fedora/fedora-system:def/model#length\"></category>");
        sb.append("    <category term=\"http://www.openarchives.org/OAI/2.0/oai_dc/\" scheme=\"info:fedora/fedora-system:def/model#formatURI\"></category>");
        sb.append("    <content type=\"text/xml\">");
        sb.append("      <oai_dc:dc xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\">");
        sb.append("        <dc:title>Coliseum in Rome</dc:title>");
        sb.append("        <dc:creator>Thornton Staples</dc:creator>");
        sb.append("        <dc:subject>Architecture, Roman</dc:subject>");
        sb.append("        <dc:description>Image of Coliseum in Rome</dc:description>");
        sb.append("        <dc:publisher>University of Virginia Library</dc:publisher>");
        sb.append("        <dc:format>image/jpeg</dc:format>");
        sb.append("        <dc:identifier>demo:1000</dc:identifier>");
        sb.append("      </oai_dc:dc>");
        sb.append("    </content>");
        sb.append("  </entry>");
        sb.append("  <entry>");
        sb.append("    <id>info:fedora/demo:1000/RELS-EXT</id>");
        sb.append("    <title type=\"text\">RELS-EXT</title>");
        sb.append("    <updated>2008-04-30T03:54:31.459Z</updated>");
        sb.append("    <link href=\"info:fedora/demo:1000/RELS-EXT/2008-04-30T03:54:31.459Z\" rel=\"alternate\"></link>");
        sb.append("    <category term=\"A\" scheme=\"info:fedora/fedora-system:def/model#state\"></category>");
        sb.append("    <category term=\"X\" scheme=\"info:fedora/fedora-system:def/model#controlGroup\"></category>");
        sb.append("    <category term=\"false\" scheme=\"info:fedora/fedora-system:def/model#versionable\"></category>");
        sb.append("  </entry>");
        sb.append("  <entry xmlns:thr=\"http://purl.org/syndication/thread/1.0\">");
        sb.append("    <id>info:fedora/demo:1000/RELS-EXT/2008-04-30T03:54:31.459Z</id>");
        sb.append("    <title type=\"text\">RELS-EXT1.0</title>");
        sb.append("    <updated>2008-04-30T03:54:31.459Z</updated>");
        sb.append("    <thr:in-reply-to ref=\"info:fedora/demo:1000/RELS-EXT\"></thr:in-reply-to>");
        sb.append("    <category term=\"Relationships\" scheme=\"info:fedora/fedora-system:def/model#label\"></category>");
        sb.append("    <category term=\"DISABLED\" scheme=\"info:fedora/fedora-system:def/model#digestType\"></category>");
        sb.append("    <category term=\"none\" scheme=\"info:fedora/fedora-system:def/model#digest\"></category>");
        sb.append("    <category term=\"472\" scheme=\"info:fedora/fedora-system:def/model#length\"></category>");
        sb.append("    <category term=\"info:fedora/fedora-system:FedoraRELSExt-1.0\" scheme=\"info:fedora/fedora-system:def/model#formatURI\"></category>");
        sb.append("    <content type=\"application/rdf+xml\">");
        sb.append("      <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:fedora-model=\"info:fedora/fedora-system:def/model#\">");
        sb.append("        <rdf:Description rdf:about=\"info:fedora/demo:1000\">");
        sb.append("          <fedora-model:hasModel rdf:resource=\"info:fedora/demo:UVA_STD_IMAGE_1\"></fedora-model:hasModel>");
        sb.append("          </rdf:Description>");
        sb.append("        </rdf:RDF>");
        sb.append("    </content>");
        sb.append("  </entry>");
        sb.append("  <entry>");
        sb.append("    <id>info:fedora/demo:1000/THUMBRES_IMG</id>");
        sb.append("    <title type=\"text\">THUMBRES_IMG</title>");
        sb.append("    <updated>2008-04-30T03:54:31.459Z</updated>");
        sb.append("    <link href=\"info:fedora/demo:1000/THUMBRES_IMG/2008-04-30T03:54:31.459Z\" rel=\"alternate\"></link>");
        sb.append("    <category term=\"A\" scheme=\"info:fedora/fedora-system:def/model#state\"></category>");
        sb.append("    <category term=\"M\" scheme=\"info:fedora/fedora-system:def/model#controlGroup\"></category>");
        sb.append("    <category term=\"true\" scheme=\"info:fedora/fedora-system:def/model#versionable\"></category>");
        sb.append("  </entry>");
        sb.append("  <entry xmlns:thr=\"http://purl.org/syndication/thread/1.0\">");
        sb.append("    <id>info:fedora/demo:1000/THUMBRES_IMG/2008-04-30T03:54:31.459Z</id>");
        sb.append("    <title type=\"text\">THUMBRES_IMG1.0</title>");
        sb.append("    <updated>2008-04-30T03:54:31.459Z</updated>");
        sb.append("    <thr:in-reply-to ref=\"info:fedora/demo:1000/THUMBRES_IMG\"></thr:in-reply-to>");
        sb.append("    <category term=\"Thorny's Coliseum thumbnail jpg image\" scheme=\"info:fedora/fedora-system:def/model#label\"></category>");
        sb.append("    <category term=\"DISABLED\" scheme=\"info:fedora/fedora-system:def/model#digestType\"></category>");
        sb.append("    <category term=\"none\" scheme=\"info:fedora/fedora-system:def/model#digest\"></category>");
        sb.append("    <category term=\"0\" scheme=\"info:fedora/fedora-system:def/model#length\"></category>");
        sb.append("    <summary type=\"text\">THUMBRES_IMG1.0</summary>");
        sb.append("    <content type=\"image/jpeg\" src=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-thumb.jpg\"></content>");
        sb.append("  </entry>");
        sb.append("  <entry>");
        sb.append("    <id>info:fedora/demo:1000/MEDRES_IMG</id>");
        sb.append("    <title type=\"text\">MEDRES_IMG</title>");
        sb.append("    <updated>2008-04-30T03:54:31.459Z</updated>");
        sb.append("    <link href=\"info:fedora/demo:1000/MEDRES_IMG/2008-04-30T03:54:31.459Z\" rel=\"alternate\"></link>");
        sb.append("    <category term=\"A\" scheme=\"info:fedora/fedora-system:def/model#state\"></category>");
        sb.append("    <category term=\"M\" scheme=\"info:fedora/fedora-system:def/model#controlGroup\"></category>");
        sb.append("    <category term=\"true\" scheme=\"info:fedora/fedora-system:def/model#versionable\"></category>");
        sb.append("  </entry>");
        sb.append("  <entry xmlns:thr=\"http://purl.org/syndication/thread/1.0\">");
        sb.append("    <id>info:fedora/demo:1000/MEDRES_IMG/2008-04-30T03:54:31.459Z</id>");
        sb.append("    <title type=\"text\">MEDRES_IMG1.0</title>");
        sb.append("    <updated>2008-04-30T03:54:31.459Z</updated>");
        sb.append("    <thr:in-reply-to ref=\"info:fedora/demo:1000/MEDRES_IMG\"></thr:in-reply-to>");
        sb.append("    <category term=\"Thorny's Coliseum medium jpg image\" scheme=\"info:fedora/fedora-system:def/model#label\"></category>");
        sb.append("    <category term=\"DISABLED\" scheme=\"info:fedora/fedora-system:def/model#digestType\"></category>");
        sb.append("    <category term=\"none\" scheme=\"info:fedora/fedora-system:def/model#digest\"></category>");
        sb.append("    <category term=\"0\" scheme=\"info:fedora/fedora-system:def/model#length\"></category>");
        sb.append("    <summary type=\"text\">MEDRES_IMG1.0</summary>");
        sb.append("    <content type=\"image/jpeg\" src=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-medium.jpg\"></content>");
        sb.append("  </entry>");
        sb.append("  <entry>");
        sb.append("    <id>info:fedora/demo:1000/HIGHRES_IMG</id>");
        sb.append("    <title type=\"text\">HIGHRES_IMG</title>");
        sb.append("    <updated>2008-04-30T03:54:31.459Z</updated>");
        sb.append("    <link href=\"info:fedora/demo:1000/HIGHRES_IMG/2008-04-30T03:54:31.459Z\" rel=\"alternate\"></link>");
        sb.append("    <category term=\"A\" scheme=\"info:fedora/fedora-system:def/model#state\"></category>");
        sb.append("    <category term=\"M\" scheme=\"info:fedora/fedora-system:def/model#controlGroup\"></category>");
        sb.append("    <category term=\"true\" scheme=\"info:fedora/fedora-system:def/model#versionable\"></category>");
        sb.append("  </entry>");
        sb.append("  <entry xmlns:thr=\"http://purl.org/syndication/thread/1.0\">");
        sb.append("    <id>info:fedora/demo:1000/HIGHRES_IMG/2008-04-30T03:54:31.459Z</id>");
        sb.append("    <title type=\"text\">HIGHRES_IMG1.0</title>");
        sb.append("    <updated>2008-04-30T03:54:31.459Z</updated>");
        sb.append("    <thr:in-reply-to ref=\"info:fedora/demo:1000/HIGHRES_IMG\"></thr:in-reply-to>");
        sb.append("    <category term=\"Thorny's Coliseum high jpg image\" scheme=\"info:fedora/fedora-system:def/model#label\"></category>");
        sb.append("    <category term=\"DISABLED\" scheme=\"info:fedora/fedora-system:def/model#digestType\"></category>");
        sb.append("    <category term=\"none\" scheme=\"info:fedora/fedora-system:def/model#digest\"></category>");
        sb.append("    <category term=\"0\" scheme=\"info:fedora/fedora-system:def/model#length\"></category>");
        sb.append("    <summary type=\"text\">HIGHRES_IMG1.0</summary>");
        sb.append("    <content type=\"image/jpeg\" src=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-high.jpg\"></content>");
        sb.append("  </entry>");
        sb.append("  <entry>");
        sb.append("    <id>info:fedora/demo:1000/VERYHIGHRES_IMG</id>");
        sb.append("    <title type=\"text\">VERYHIGHRES_IMG</title>");
        sb.append("    <updated>2008-04-30T03:54:31.459Z</updated>");
        sb.append("    <link href=\"info:fedora/demo:1000/VERYHIGHRES_IMG/2008-04-30T03:54:31.459Z\" rel=\"alternate\"></link>");
        sb.append("    <category term=\"A\" scheme=\"info:fedora/fedora-system:def/model#state\"></category>");
        sb.append("    <category term=\"M\" scheme=\"info:fedora/fedora-system:def/model#controlGroup\"></category>");
        sb.append("    <category term=\"true\" scheme=\"info:fedora/fedora-system:def/model#versionable\"></category>");
        sb.append("  </entry>");
        sb.append("  <entry xmlns:thr=\"http://purl.org/syndication/thread/1.0\">");
        sb.append("    <id>info:fedora/demo:1000/VERYHIGHRES_IMG/2008-04-30T03:54:31.459Z</id>");
        sb.append("    <title type=\"text\">VERYHIGHRES_IMG1.0</title>");
        sb.append("    <updated>2008-04-30T03:54:31.459Z</updated>");
        sb.append("    <thr:in-reply-to ref=\"info:fedora/demo:1000/VERYHIGHRES_IMG\"></thr:in-reply-to>");
        sb.append("    <category term=\"Thorny's Coliseum veryhigh jpg image\" scheme=\"info:fedora/fedora-system:def/model#label\"></category>");
        sb.append("    <category term=\"DISABLED\" scheme=\"info:fedora/fedora-system:def/model#digestType\"></category>");
        sb.append("    <category term=\"none\" scheme=\"info:fedora/fedora-system:def/model#digest\"></category>");
        sb.append("    <category term=\"0\" scheme=\"info:fedora/fedora-system:def/model#length\"></category>");
        sb.append("    <summary type=\"text\">VERYHIGHRES_IMG1.0</summary>");
        sb.append("    <content type=\"image/jpeg\" src=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-veryhigh.jpg\"></content>");
        sb.append("  </entry>");
        sb.append("</feed>");
        try {
            demo1000ATOMObjectXML = sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<feed xmlns=\"http://www.w3.org/2005/Atom\">");
        sb.append("  <id>info:fedora/demo:1001</id>");
        sb.append("  <title type=\"text\">Data Object (Coliseum) for Local Simple Image Demo</title>");
        sb.append("  <updated>2008-04-30T03:54:31.525Z</updated>");
        sb.append("  <author>");
        sb.append("    <name>fedoraAdmin</name>");
        sb.append("  </author>");
        sb.append("  <category term=\"Active\" scheme=\"info:fedora/fedora-system:def/model#state\"></category>");
        sb.append("  <category term=\"2008-04-30T03:54:31.525Z\" scheme=\"info:fedora/fedora-system:def/model#createdDate\"></category>");
        sb.append("  <icon>http://www.fedora-commons.org/images/logo_vertical_transparent_200_251.png</icon>");
        sb.append("  <entry>");
        sb.append("    <id>info:fedora/demo:1001/DC</id>");
        sb.append("    <title type=\"text\">DC</title>");
        sb.append("    <updated>2008-04-30T03:54:31.459Z</updated>");
        sb.append("    <link href=\"info:fedora/demo:1001/DC/2008-04-30T03:54:31.459Z\" rel=\"alternate\"></link>");
        sb.append("    <category term=\"A\" scheme=\"info:fedora/fedora-system:def/model#state\"></category>");
        sb.append("    <category term=\"X\" scheme=\"info:fedora/fedora-system:def/model#controlGroup\"></category>");
        sb.append("    <category term=\"true\" scheme=\"info:fedora/fedora-system:def/model#versionable\"></category>");
        sb.append("  </entry>");
        sb.append("  <entry xmlns:thr=\"http://purl.org/syndication/thread/1.0\">");
        sb.append("    <id>info:fedora/demo:1001/DC/2008-04-30T03:54:31.459Z</id>");
        sb.append("    <title type=\"text\">DC1.0</title>");
        sb.append("    <updated>2008-04-30T03:54:31.459Z</updated>");
        sb.append("    <thr:in-reply-to ref=\"info:fedora/demo:1001/DC\"></thr:in-reply-to>");
        sb.append("    <category term=\"DC Record for Coliseum image object\" scheme=\"info:fedora/fedora-system:def/model#label\"></category>");
        sb.append("    <category term=\"DISABLED\" scheme=\"info:fedora/fedora-system:def/model#digestType\"></category>");
        sb.append("    <category term=\"none\" scheme=\"info:fedora/fedora-system:def/model#digest\"></category>");
        sb.append("    <category term=\"491\" scheme=\"info:fedora/fedora-system:def/model#length\"></category>");
        sb.append("    <category term=\"http://www.openarchives.org/OAI/2.0/oai_dc/\" scheme=\"info:fedora/fedora-system:def/model#formatURI\"></category>");
        sb.append("       <summary type=\"text\">DC1.0</summary>");
        sb.append("    <content type=\"text/xml\" src=\"DC1.0.xml\"/>");
        sb.append("  </entry>");
        sb.append("  <entry>");
        sb.append("    <id>info:fedora/demo:1001/RELS-EXT</id>");
        sb.append("    <title type=\"text\">RELS-EXT</title>");
        sb.append("    <updated>2008-04-30T03:54:31.459Z</updated>");
        sb.append("    <link href=\"info:fedora/demo:1001/RELS-EXT/2008-04-30T03:54:31.459Z\" rel=\"alternate\"></link>");
        sb.append("    <category term=\"A\" scheme=\"info:fedora/fedora-system:def/model#state\"></category>");
        sb.append("    <category term=\"X\" scheme=\"info:fedora/fedora-system:def/model#controlGroup\"></category>");
        sb.append("    <category term=\"false\" scheme=\"info:fedora/fedora-system:def/model#versionable\"></category>");
        sb.append("  </entry>");
        sb.append("  <entry xmlns:thr=\"http://purl.org/syndication/thread/1.0\">");
        sb.append("    <id>info:fedora/demo:1001/RELS-EXT/2008-04-30T03:54:31.459Z</id>");
        sb.append("    <title type=\"text\">RELS-EXT1.0</title>");
        sb.append("    <updated>2008-04-30T03:54:31.459Z</updated>");
        sb.append("    <thr:in-reply-to ref=\"info:fedora/demo:1001/RELS-EXT\"></thr:in-reply-to>");
        sb.append("    <category term=\"Relationships\" scheme=\"info:fedora/fedora-system:def/model#label\"></category>");
        sb.append("    <category term=\"DISABLED\" scheme=\"info:fedora/fedora-system:def/model#digestType\"></category>");
        sb.append("    <category term=\"none\" scheme=\"info:fedora/fedora-system:def/model#digest\"></category>");
        sb.append("    <category term=\"472\" scheme=\"info:fedora/fedora-system:def/model#length\"></category>");
        sb.append("    <category term=\"info:fedora/fedora-system:FedoraRELSExt-1.0\" scheme=\"info:fedora/fedora-system:def/model#formatURI\"></category>");
        sb.append("    <content type=\"application/rdf+xml\" src=\"RELS-EXT1.0.xml\"/>");
        sb.append("    <summary type=\"text\">RELS-EXT1.0</summary>");
        sb.append("  </entry>");
        sb.append("  <entry>");
        sb.append("    <id>info:fedora/demo:1001/VERYHIGHRES_IMG</id>");
        sb.append("    <title type=\"text\">VERYHIGHRES_IMG</title>");
        sb.append("    <updated>2008-04-30T03:54:31.459Z</updated>");
        sb.append("    <link href=\"info:fedora/demo:1001/VERYHIGHRES_IMG/2008-04-30T03:54:31.459Z\" rel=\"alternate\"></link>");
        sb.append("    <category term=\"A\" scheme=\"info:fedora/fedora-system:def/model#state\"></category>");
        sb.append("    <category term=\"M\" scheme=\"info:fedora/fedora-system:def/model#controlGroup\"></category>");
        sb.append("    <category term=\"true\" scheme=\"info:fedora/fedora-system:def/model#versionable\"></category>");
        sb.append("  </entry>");
        sb.append("  <entry xmlns:thr=\"http://purl.org/syndication/thread/1.0\">");
        sb.append("    <id>info:fedora/demo:1001/VERYHIGHRES_IMG/2008-04-30T03:54:31.459Z</id>");
        sb.append("    <title type=\"text\">VERYHIGHRES_IMG1.0</title>");
        sb.append("    <updated>2008-04-30T03:54:31.459Z</updated>");
        sb.append("    <thr:in-reply-to ref=\"info:fedora/demo:1001/VERYHIGHRES_IMG\"></thr:in-reply-to>");
        sb.append("    <category term=\"Thorny's Coliseum veryhigh jpg image\" scheme=\"info:fedora/fedora-system:def/model#label\"></category>");
        sb.append("    <category term=\"DISABLED\" scheme=\"info:fedora/fedora-system:def/model#digestType\"></category>");
        sb.append("    <category term=\"none\" scheme=\"info:fedora/fedora-system:def/model#digest\"></category>");
        sb.append("    <category term=\"0\" scheme=\"info:fedora/fedora-system:def/model#length\"></category>");
        sb.append("    <summary type=\"text\">VERYHIGHRES_IMG1.0</summary>");
        sb.append("    <content type=\"image/jpeg\" src=\"http://" + TestAPIM.getHost() + ":" + TestAPIM.getPort() + "/fedora-demo/simple-image-demo/coliseum-veryhigh.jpg\"></content>");
        sb.append("  </entry>");
        sb.append("</feed>");
        byte[] demo1001_manifest = null;
        try {
            demo1001_manifest = sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        sb = new StringBuffer();
        sb.append("      <oai_dc:dc xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\">");
        sb.append("        <dc:title>Coliseum in Rome</dc:title>");
        sb.append("        <dc:creator>Thornton Staples</dc:creator>");
        sb.append("        <dc:subject>Architecture, Roman</dc:subject>");
        sb.append("        <dc:description>Image of Coliseum in Rome</dc:description>");
        sb.append("        <dc:publisher>University of Virginia Library</dc:publisher>");
        sb.append("        <dc:format>image/jpeg</dc:format>");
        sb.append("        <dc:identifier>demo:1001</dc:identifier>");
        sb.append("      </oai_dc:dc>");
        byte[] demo1001_dc = null;
        try {
            demo1001_dc = sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        sb = new StringBuffer();
        sb.append("      <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:fedora-model=\"info:fedora/fedora-system:def/model#\">");
        sb.append("        <rdf:Description rdf:about=\"info:fedora/demo:1001\">");
        sb.append("          <fedora-model:hasModel rdf:resource=\"info:fedora/demo:UVA_STD_IMAGE_1\"></fedora-model:hasModel>");
        sb.append("        </rdf:Description>");
        sb.append("      </rdf:RDF>");
        try {
            demo1001_relsext = sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        ZipEntry manifest = new ZipEntry("atommanifest.xml");
        ZipEntry dc = new ZipEntry("DC1.0.xml");
        ZipEntry relsext = new ZipEntry("RELS-EXT1.0.xml");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(bout);
        try {
            zip.putNextEntry(manifest);
            zip.write(demo1001_manifest);
            zip.putNextEntry(dc);
            zip.write(demo1001_dc);
            zip.putNextEntry(relsext);
            zip.write(demo1001_relsext);
            zip.flush();
            zip.close();
            demo1001ATOMZip = bout.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

