/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import org.fcrepo.common.PID;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.api.TestRESTAPI;

public class TestRESTAPIConfigQ
extends FedoraServerTestCase {
    private FedoraAPIMMTOM apim;
    private static String DEMO_FOXML;
    private static final PID pid;
    private static TestRESTAPI rest;

    public void setUp() throws Exception {
        this.apim = TestRESTAPIConfigQ.getFedoraClient().getAPIMMTOM();
    }

    public void tearDown() throws Exception {
    }

    public void testFindObjects() throws Exception {
        TestRESTAPIConfigQ.rest.url = String.format("/objects?pid=true&terms=&query=&resultFormat=xml", new Object[0]);
        TestRESTAPIConfigQ.assertEquals((int)200, (int)rest.get(false).getStatusCode());
    }

    public void testIngest() throws Exception {
        String label = "Label";
        TestRESTAPIConfigQ.rest.url = String.format("/objects/%s?label=%s", pid, label);
        TestRESTAPIConfigQ.assertEquals((int)401, (int)rest.post(DEMO_FOXML, false).getStatusCode());
        TestRESTAPIConfigQ.rest.url = String.format("/objects/%s", pid);
        TestRESTAPIConfigQ.assertEquals((int)404, (int)rest.get(false).getStatusCode());
        TestRESTAPIConfigQ.rest.url = String.format("/objects/%s?label=%s", pid, label);
        TestRESTAPIConfigQ.assertEquals((int)201, (int)rest.post(DEMO_FOXML, true).getStatusCode());
        TestRESTAPIConfigQ.rest.url = String.format("/objects/%s", pid);
        TestRESTAPIConfigQ.assertEquals((int)200, (int)rest.get(false).getStatusCode());
        this.apim.purgeObject(pid.toString(), "", false);
    }

    static {
        pid = PID.getInstance((String)"demo:RESTQ");
        rest = new TestRESTAPI();
        StringBuilder sb = new StringBuilder();
        sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<foxml:digitalObject VERSION=\"1.1\" PID=\"" + pid.toString() + "\" ");
        sb.append("  xmlns:foxml=\"info:fedora/fedora-system:def/foxml#\" ");
        sb.append("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
        sb.append("  xsi:schemaLocation=\"info:fedora/fedora-system:def/foxml# ");
        sb.append("  http://www.fedora.info/definitions/1/0/foxml1-1.xsd\">");
        sb.append("  <foxml:objectProperties>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#state\" VALUE=\"A\"/>");
        sb.append("  </foxml:objectProperties>");
        sb.append("</foxml:digitalObject>");
        DEMO_FOXML = sb.toString();
    }
}

