/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.common.Constants;
import org.fcrepo.common.Models;
import org.fcrepo.common.PID;
import org.fcrepo.test.DemoObjectTestSetup;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.api.RISearchUtil;

public class TestRISearch
extends FedoraServerTestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite("TestRISearch TestSuite");
        suite.addTestSuite(TestRISearch.class);
        return new DemoObjectTestSetup((Test)suite);
    }

    public void testRISearchBasicCModel() throws Exception {
        FedoraClient client = TestRISearch.getFedoraClient();
        for (String pid : new String[]{"demo:SmileyPens", "demo:SmileyPens_M", "demo:SmileyGreetingCard"}) {
            String query = "<" + PID.toURI((String)pid) + ">" + " <" + Constants.MODEL.HAS_MODEL.uri + ">" + " <" + Models.FEDORA_OBJECT_CURRENT.uri + ">";
            RISearchUtil.checkSPOCount(client, query, 1);
        }
    }

    public void testRISearchRelsExtCollection() throws Exception {
        FedoraClient client = TestRISearch.getFedoraClient();
        String collectionPid = "demo:SmileyStuff";
        for (String pid : new String[]{"demo:SmileyPens", "demo:SmileyPens_M", "demo:SmileyGreetingCard"}) {
            String query = "<" + PID.toURI((String)pid) + ">" + " <" + Constants.RELS_EXT.IS_MEMBER_OF.uri + ">" + " <" + PID.toURI((String)collectionPid) + ">";
            RISearchUtil.checkSPOCount(client, query, 1);
        }
    }

    public void testRISearchRelsInt() throws Exception {
        FedoraClient client = TestRISearch.getFedoraClient();
        for (String pid : new String[]{"demo:SmileyPens", "demo:SmileyPens_M", "demo:SmileyGreetingCard"}) {
            String query = "<" + PID.toURI((String)pid) + "/MEDIUM_SIZE" + ">" + " <" + "http://ns.adobe.com/exif/1.0/PixelXDimension" + ">" + " \"320\"";
            RISearchUtil.checkSPOCount(client, query, 1);
        }
    }

    public void testSpringTripleGenerators() throws Exception {
        FedoraClient client = TestRISearch.getFedoraClient();
        String query = "<info:fedora/demo:5> <info:fedora/fedora-system:test/tests#tripleGenerator> \"true\"";
        RISearchUtil.checkSPOCount(client, query, 1);
    }
}

