/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.messaging;

import java.lang.reflect.Method;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Context;
import org.fcrepo.server.MockContext;
import org.fcrepo.server.Server;
import org.fcrepo.server.management.Management;
import org.fcrepo.server.messaging.AtomAPIMMessage;
import org.fcrepo.server.messaging.FedoraMethod;
import org.fcrepo.server.storage.types.DatastreamXMLMetadata;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.fcrepo.test.FedoraTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class AtomAPIMMessageTest
extends FedoraTestCase {
    static String entry;
    private static final String baseURL;
    private final String messageFormat;

    public AtomAPIMMessageTest() {
        this.messageFormat = Constants.ATOM_APIM1_0.uri;
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testStringConstructor() throws Exception {
        AtomAPIMMessage message = new AtomAPIMMessage(entry);
        Assert.assertEquals((String)"demo:atomTest", (String)message.getPID());
        Assert.assertEquals((String)"ingest", (String)message.getMethodName());
        Assert.assertEquals((String)baseURL, (String)message.getBaseUrl());
    }

    @Test
    public void testFedoraMethodConstructor() throws Exception {
        MockContext c = new MockContext();
        FedoraMethod fm = new FedoraMethod(Management.class.getDeclaredMethod("purgeObject", Context.class, String.class, String.class), new Object[]{c, "demo:foo", "a log message"}, (Object)"blah");
        AtomAPIMMessage message = new AtomAPIMMessage(fm, baseURL, Server.VERSION, this.messageFormat);
        Assert.assertNotNull((Object)message.getDate());
        Assert.assertEquals((String)"purgeObject", (String)message.getMethodName());
        Assert.assertEquals((String)"demo:foo", (String)message.getPID().toString());
        Assert.assertEquals((String)baseURL, (String)message.getBaseUrl());
        fm = new FedoraMethod(Management.class.getDeclaredMethod("addDatastream", Context.class, String.class, String.class, String[].class, String.class, Boolean.TYPE, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class), new Object[]{c, "demo:foo", "DS1", new String[]{"altid1, altid2"}, "a label", true, "text/xml", "some format uri", "dsLocation", "X", "A", "none", "n/a", "a log message"}, (Object)"asdf");
        message = new AtomAPIMMessage(fm, baseURL, Server.VERSION, this.messageFormat);
        Assert.assertNotNull((Object)message.getDate());
        Assert.assertEquals((String)"addDatastream", (String)message.getMethodName());
        Assert.assertEquals((String)"demo:foo", (String)message.getPID().toString());
        Assert.assertEquals((String)baseURL, (String)message.getBaseUrl());
        DatastreamXMLMetadata ds = new DatastreamXMLMetadata();
        ds.DatastreamID = "DS1";
        ds.DSVersionID = "DS1.0";
        ds.DSControlGrp = "X";
        ds.xmlContent = "<doc/>".getBytes();
        ds.DSCreateDT = new Date();
        fm = new FedoraMethod(Management.class.getDeclaredMethod("getDatastream", Context.class, String.class, String.class, Date.class), new Object[]{c, "demo:foo", "DS1", new Date()}, (Object)ds);
        message = new AtomAPIMMessage(fm, baseURL, Server.VERSION, this.messageFormat);
        Assert.assertNotNull((Object)message.getDate());
        Assert.assertEquals((String)"getDatastream", (String)message.getMethodName());
        Assert.assertEquals((String)"demo:foo", (String)message.getPID().toString());
        Assert.assertEquals((String)baseURL, (String)message.getBaseUrl());
        RelationshipTuple tuple = new RelationshipTuple("urn:subject", "urn:predicate", "object", true, null);
        fm = new FedoraMethod(Management.class.getDeclaredMethod("getRelationships", Context.class, String.class, String.class), new Object[]{c, "demo:foo", "urn:foo"}, (Object)new RelationshipTuple[]{tuple});
        message = new AtomAPIMMessage(fm, baseURL, Server.VERSION, this.messageFormat);
    }

    @Test
    public void testRoundTrip() throws Exception {
        MockContext context = new MockContext();
        Method method = Management.class.getDeclaredMethod("purgeObject", Context.class, String.class, String.class);
        String returnValue = "return";
        String logMessage = "a log message with \"quotes\" included";
        Object[] parameters = new Object[]{context, "demo:foo", logMessage};
        FedoraMethod fm = new FedoraMethod(method, parameters, (Object)returnValue);
        AtomAPIMMessage message = new AtomAPIMMessage(fm, baseURL, Server.VERSION, this.messageFormat);
        String messageText = message.toString();
        AtomAPIMMessage messageFromText = new AtomAPIMMessage(messageText);
        Assert.assertNotNull((Object)messageFromText.getDate());
        Assert.assertEquals((String)"purgeObject", (String)messageFromText.getMethodName());
        Assert.assertEquals((String)"demo:foo", (String)messageFromText.getPID().toString());
        Assert.assertEquals((String)baseURL, (String)messageFromText.getBaseUrl());
        Assert.assertEquals((String)this.normalize(messageText), (String)this.normalize(messageFromText.toString()));
        logMessage = "a log message with special characters (!@#$%^&*<>?`':;,.|[]{}) included";
        parameters = new Object[]{context, "demo:foo", logMessage};
        fm = new FedoraMethod(method, parameters, (Object)returnValue);
        message = new AtomAPIMMessage(fm, baseURL, Server.VERSION, this.messageFormat);
        messageText = message.toString();
        messageFromText = new AtomAPIMMessage(messageText);
        Assert.assertEquals((String)this.normalize(messageText), (String)this.normalize(messageFromText.toString()));
    }

    private String normalize(String xml) {
        String newline = System.getProperty("line.separator");
        return xml.replaceAll(newline, "").replaceAll("\n", "").replaceAll("\r", "").replaceAll(" ", "");
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(AtomAPIMMessageTest.class);
    }

    static {
        baseURL = AtomAPIMMessageTest.getBaseURL();
        StringBuilder sb = new StringBuilder();
        sb.append("<entry xmlns=\"http://www.w3.org/2005/Atom\">");
        sb.append("<id>ingestdemo:atomTest2008-03-15T11:12:00Z</id>");
        sb.append("<title type=\"text\">ingest</title>");
        sb.append("<updated>2008-03-15T11:12:00Z</updated>");
        sb.append("<author><name>fedoraAdmin</name><uri>").append(baseURL).append("</uri></author>");
        sb.append("<summary>demo:atomTest</summary>");
        sb.append("<content type=\"text\">demo:atomTest</content>");
        sb.append("</entry>");
        entry = sb.toString();
    }
}

