/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.server.storage.translation.DOTranslationUtility;
import org.fcrepo.server.storage.types.AuditRecord;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamXMLMetadata;
import org.fcrepo.test.FedoraTestCase;
import org.fcrepo.utilities.DateUtility;
import org.junit.After;

public class DOTranslationUtilityTest
extends FedoraTestCase {
    @After
    public void tearDown() throws Exception {
    }

    @org.junit.Test
    public void testNormalizeDSLocationURLs() {
        Datastream ds2;
        String baseURL = DOTranslationUtilityTest.getBaseURL();
        String pid = "demo:foo";
        ContextControlPair[] absoluteURLPairs = new ContextControlPair[]{new ContextControlPair(0, "E"), new ContextControlPair(0, "R"), new ContextControlPair(1, "E"), new ContextControlPair(1, "R")};
        ContextControlPair[] dissemURLPairs = new ContextControlPair[]{new ContextControlPair(1, "M"), new ContextControlPair(2, "M"), new ContextControlPair(4, "M")};
        ContextControlPair[] localURLPairs = new ContextControlPair[]{new ContextControlPair(2, "E"), new ContextControlPair(2, "R"), new ContextControlPair(3, "E"), new ContextControlPair(3, "R"), new ContextControlPair(4, "E"), new ContextControlPair(4, "R")};
        DatastreamXMLMetadata ds = new DatastreamXMLMetadata();
        for (ContextControlPair pair : absoluteURLPairs) {
            ds.DSControlGrp = pair.getControlGroup();
            ds.DSLocation = "http://localhost:8080/fedora-demo/simple-image-demo/coliseum-veryhigh.jpg";
            ds2 = DOTranslationUtility.normalizeDSLocationURLs((String)pid, (Datastream)ds, (int)pair.getContext());
            Assert.assertEquals((String)ds.DSLocation, (String)ds2.DSLocation);
            ds.DSLocation = baseURL + "/get/demo:foo/DS1";
            ds2 = DOTranslationUtility.normalizeDSLocationURLs((String)pid, (Datastream)ds, (int)pair.getContext());
            Assert.assertEquals((String)ds.DSLocation, (String)ds2.DSLocation);
        }
        ds = new DatastreamXMLMetadata();
        for (ContextControlPair pair : dissemURLPairs) {
            ds.DatastreamID = "DC";
            ds.DSControlGrp = pair.getControlGroup();
            ds.DSLocation = String.format("%s/get/%s/%s", baseURL, pid, ds.DatastreamID);
            System.setProperty("fedoraAppServerContext", DOTranslationUtilityTest.getFedoraAppServerContext());
            ds2 = DOTranslationUtility.normalizeDSLocationURLs((String)pid, (Datastream)ds, (int)pair.getContext());
            Assert.assertEquals((String)ds.DSLocation, (String)ds2.DSLocation);
        }
        ds = new DatastreamXMLMetadata();
        for (ContextControlPair pair : localURLPairs) {
            ds.DatastreamID = "DC";
            ds.DSControlGrp = pair.getControlGroup();
            String url = String.format("%s/get/%s/%s", baseURL, pid, ds.DatastreamID);
            String localURL = String.format("http://local.fedora.server/" + DOTranslationUtilityTest.getFedoraAppServerContext() + "/get/%s/%s", pid, ds.DatastreamID);
            ds.DSLocation = url;
            ds2 = DOTranslationUtility.normalizeDSLocationURLs((String)pid, (Datastream)ds, (int)pair.getContext());
            Assert.assertEquals((String)localURL, (String)ds2.DSLocation);
            ds.DSLocation = url;
            ds2 = DOTranslationUtility.normalizeDSLocationURLs((String)pid, (Datastream)ds, (int)pair.getContext());
            Assert.assertEquals((String)localURL, (String)ds2.DSLocation);
        }
    }

    @org.junit.Test
    public void testNormalizeInlineXML() {
        String xml = "<foo/>";
        String result = DOTranslationUtility.normalizeInlineXML((String)xml, (int)1);
        Assert.assertEquals((String)xml, (String)result);
    }

    @org.junit.Test
    public void testGetAuditRecords() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<audit:auditTrail xmlns:audit=\"info:fedora/fedora-system:def/audit#\">");
        sb.append("  <audit:record audit:ID=\"AUDREC1\">");
        sb.append("      <audit:process audit:type=\"Fedora API-M\"/>");
        sb.append("      <audit:action>modifyDatastreamByReference</audit:action>");
        sb.append("      <audit:componentID>DRAWING-ICON</audit:componentID>");
        sb.append("      <audit:responsibility>fedoraAdmin</audit:responsibility>");
        sb.append("      <audit:date>2005-01-20T22:46:07.428Z</audit:date>");
        sb.append("      <audit:justification>spite</audit:justification>");
        sb.append("  </audit:record>");
        sb.append("  <audit:record audit:ID=\"AUDREC2\">");
        sb.append("      <audit:process audit:type=\"Fedora API-M\"/>");
        sb.append("      <audit:action>modifyDatastreamByValue</audit:action>");
        sb.append("      <audit:componentID>DC</audit:componentID>");
        sb.append("      <audit:responsibility>fedoraAdmin</audit:responsibility>");
        sb.append("      <audit:date>2008-01-20T22:46:07.001Z</audit:date>");
        sb.append("      <audit:justification>malice</audit:justification>");
        sb.append("  </audit:record>");
        sb.append("</audit:auditTrail>");
        String auditXML = sb.toString();
        List records = DOTranslationUtility.getAuditRecords((InputStream)new ByteArrayInputStream(auditXML.getBytes("utf-8")));
        Assert.assertEquals((int)2, (int)records.size());
        Assert.assertEquals((String)"AUDREC1", (String)((AuditRecord)records.get((int)0)).id);
        Assert.assertEquals((String)"modifyDatastreamByReference", (String)((AuditRecord)records.get((int)0)).action);
        Assert.assertEquals((String)"DRAWING-ICON", (String)((AuditRecord)records.get((int)0)).componentID);
        Assert.assertEquals((Object)DateUtility.convertStringToDate((String)"2005-01-20T22:46:07.428Z"), (Object)((AuditRecord)records.get((int)0)).date);
        Assert.assertEquals((String)"spite", (String)((AuditRecord)records.get((int)0)).justification);
        Assert.assertEquals((String)"Fedora API-M", (String)((AuditRecord)records.get((int)0)).processType);
        Assert.assertEquals((String)"fedoraAdmin", (String)((AuditRecord)records.get((int)0)).responsibility);
        Assert.assertEquals((String)"AUDREC2", (String)((AuditRecord)records.get((int)1)).id);
        Assert.assertEquals((String)"modifyDatastreamByValue", (String)((AuditRecord)records.get((int)1)).action);
        Assert.assertEquals((String)"DC", (String)((AuditRecord)records.get((int)1)).componentID);
        Assert.assertEquals((Object)DateUtility.convertStringToDate((String)"2008-01-20T22:46:07.001Z"), (Object)((AuditRecord)records.get((int)1)).date);
        Assert.assertEquals((String)"malice", (String)((AuditRecord)records.get((int)1)).justification);
        Assert.assertEquals((String)"Fedora API-M", (String)((AuditRecord)records.get((int)1)).processType);
        Assert.assertEquals((String)"fedoraAdmin", (String)((AuditRecord)records.get((int)1)).responsibility);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(DOTranslationUtilityTest.class);
    }

    class ContextControlPair {
        private final int context;
        private final String controlGroup;

        public ContextControlPair(int context, String controlGroup) {
            this.context = context;
            this.controlGroup = controlGroup;
        }

        public int getContext() {
            return this.context;
        }

        public String getControlGroup() {
            return this.controlGroup;
        }
    }
}

