/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.io.File;
import java.math.BigInteger;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.common.Constants;
import org.fcrepo.server.access.FedoraAPIA;
import org.fcrepo.server.management.FedoraAPIM;
import org.fcrepo.server.types.gen.ComparisonOperator;
import org.fcrepo.server.types.gen.Condition;
import org.fcrepo.server.types.gen.FieldSearchQuery;
import org.fcrepo.server.types.gen.ObjectFactory;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.TemplatedResourceIterator;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class TestAPIM2
extends FedoraServerTestCase
implements Constants {
    private static FedoraClient s_client;
    private FedoraAPIM apim;
    private FedoraAPIA apia;

    @BeforeClass
    public static void bootStrap() throws Exception {
        s_client = TestAPIM2.getFedoraClient();
        TestAPIM2.ingestImageCollectionDemoObjects(s_client);
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        TestAPIM2.purgeDemoObjects(s_client);
        s_client.shutdown();
    }

    @Before
    public void setUp() throws Exception {
        this.apim = s_client.getAPIM();
        this.apia = s_client.getAPIA();
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("oai_dc", "http://www.openarchives.org/OAI/2.0/oai_dc/");
        nsMap.put("dc", "http://purl.org/dc/elements/1.1/");
        nsMap.put("foxml", "info:fedora/fedora-system:def/foxml#");
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
        TestAPIM2.purgeDemoObjects(s_client);
    }

    @After
    public void tearDown() throws Exception {
        TestAPIM2.purgeDemoObjects(s_client);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
    }

    @Test
    public void testIngest() throws Exception {
        byte[] foxml;
        TemplatedResourceIterator tri;
        String resource;
        File resourceFile;
        String resourceDirName = "src/test/resources/APIM2/foxml/";
        String[] resourceFilenames = new File(resourceDirName).list();
        int count = 0;
        for (String resourceFilename : resourceFilenames) {
            resourceFile = new File(resourceDirName + resourceFilename);
            if (!resourceFile.isFile()) continue;
            resource = FileUtils.readFileToString((File)resourceFile, (String)"UTF-8");
            tri = new TemplatedResourceIterator(resource, "src/test/resources/APIM2/values");
            while (tri.hasNext()) {
                foxml = tri.next().getBytes("UTF-8");
                this.apim.ingest(foxml, TestAPIM2.FOXML1_1.uri, "ingesting new foxml object");
                ++count;
            }
        }
        Assert.assertEquals((String)"Ingested object count", (int)count, (int)TestAPIM2.getDemoObjects(s_client).size());
        for (String resourceFilename : resourceFilenames) {
            resourceFile = new File(resourceDirName + resourceFilename);
            if (!resourceFile.isFile()) continue;
            resource = FileUtils.readFileToString((File)resourceFile, (String)"UTF-8");
            tri = new TemplatedResourceIterator(resource, "src/test/resources/APIM2/valuesplain");
            while (tri.hasNext()) {
                foxml = tri.next().getBytes("UTF-8");
                this.apim.ingest(foxml, TestAPIM2.FOXML1_1.uri, "ingesting new foxml object");
                ++count;
            }
        }
        Assert.assertEquals((String)"Ingested object count", (int)count, (int)TestAPIM2.getDemoObjects(s_client).size());
    }

    @Test
    public void testFieldSearch() throws Exception {
        String[] resourceFilenames;
        String resourceDirName = "src/test/resources/APIM2/foxml/";
        for (String resourceFilename : resourceFilenames = new File(resourceDirName).list()) {
            File resourceFile = new File(resourceDirName + resourceFilename);
            if (!resourceFile.isFile()) continue;
            String resource = FileUtils.readFileToString((File)resourceFile, (String)"UTF-8");
            TemplatedResourceIterator tri = new TemplatedResourceIterator(resource, "src/test/resources/APIM2/valuesplain");
            while (tri.hasNext()) {
                byte[] foxml = tri.next().getBytes("UTF-8");
                this.apim.ingest(foxml, TestAPIM2.FOXML1_1.uri, "ingesting new foxml object");
            }
        }
        String[] resultFields = new String[]{"pid", "title"};
        BigInteger maxResults = new BigInteger("100");
        String termsTemplate = "$value$";
        TemplatedResourceIterator tri = new TemplatedResourceIterator(termsTemplate, "src/test/resources/APIM2/searchvalues");
        while (tri.hasNext()) {
            FieldSearchQuery.Conditions conds = new FieldSearchQuery.Conditions();
            Condition c = new Condition();
            c.setProperty("pid");
            c.setOperator(ComparisonOperator.fromValue((String)"eq"));
            c.setValue(tri.getAttributeValue("value"));
            conds.getCondition().add(c);
            FieldSearchQuery query = new FieldSearchQuery();
            ObjectFactory factory = new ObjectFactory();
            query.setConditions(factory.createFieldSearchQueryConditions(conds));
            this.apia.findObjects(TypeUtility.convertStringtoAOS((String[])resultFields), maxResults, query);
            String terms = tri.next();
            query = new FieldSearchQuery();
            query.setTerms(factory.createFieldSearchQueryTerms(terms));
            this.apia.findObjects(TypeUtility.convertStringtoAOS((String[])resultFields), maxResults, query);
        }
        TestAPIM2.purgeDemoObjects(s_client);
        for (String resourceFilename : resourceFilenames) {
            File resourceFile = new File(resourceDirName + resourceFilename);
            if (!resourceFile.isFile()) continue;
            String resource = FileUtils.readFileToString((File)resourceFile, (String)"UTF-8");
            tri = new TemplatedResourceIterator(resource, "src/test/resources/APIM2/valuesplain");
            while (tri.hasNext()) {
                byte[] foxml = tri.next().getBytes("UTF-8");
                this.apim.ingest(foxml, TestAPIM2.FOXML1_1.uri, "ingesting new foxml object");
            }
        }
        TestAPIM2.purgeDemoObjects(s_client);
    }

    @Test
    public void testObjectMethods() throws Exception {
        String[] resourceFilenames;
        String resfile = "src/test/resources/APIM2/foxml/demo_SmileyBeerGlass.xml";
        File resourceFile = new File(resfile);
        String resource = FileUtils.readFileToString((File)resourceFile, (String)"UTF-8");
        TemplatedResourceIterator tri = new TemplatedResourceIterator(resource, "src/test/resources/APIM2/valuesplain");
        while (tri.hasNext()) {
            String label2 = tri.getAttributeValue("label2");
            byte[] foxml = tri.next().getBytes("UTF-8");
            String pid = this.apim.ingest(foxml, TestAPIM2.FOXML1_1.uri, "ingesting new foxml object");
            this.apim.modifyObject(pid, null, label2, null, "updating object label");
        }
        TestAPIM2.purgeDemoObjects(s_client);
        String resourceDirName = "src/test/resources/APIM2/foxml/";
        for (String resourceFilename : resourceFilenames = new File(resourceDirName).list()) {
            resourceFile = new File(resourceDirName + resourceFilename);
            if (!resourceFile.isFile()) continue;
            resource = FileUtils.readFileToString((File)resourceFile, (String)"UTF-8");
            tri = new TemplatedResourceIterator(resource, "src/test/resources/APIM2/valuesplain");
            while (tri.hasNext()) {
                byte[] foxml = tri.next().getBytes("UTF-8");
                this.apim.ingest(foxml, TestAPIM2.FOXML1_1.uri, "ingesting new foxml object");
            }
        }
        TestAPIM2.purgeDemoObjects(s_client);
    }

    @Test
    public void testDatastreamMethods() throws Exception {
        String[] resourceFilenames;
        String resfile = "src/test/resources/APIM2/foxml/demo_SmileyBeerGlass.xml";
        File resourceFile = new File(resfile);
        String resource = FileUtils.readFileToString((File)resourceFile, (String)"UTF-8");
        TemplatedResourceIterator tri = new TemplatedResourceIterator(resource, "src/test/resources/APIM2/valuesplain");
        while (tri.hasNext()) {
            String label2 = tri.getAttributeValue("label2");
            byte[] foxml = tri.next().getBytes("UTF-8");
            String pid = this.apim.ingest(foxml, TestAPIM2.FOXML1_1.uri, "ingesting new foxml object");
            this.apim.modifyDatastreamByValue(pid, "DC", null, label2, null, null, null, null, null, "modify datastream label", false);
        }
        TestAPIM2.purgeDemoObjects(s_client);
        String resourceDirName = "src/test/resources/APIM2/foxml/";
        for (String resourceFilename : resourceFilenames = new File(resourceDirName).list()) {
            resourceFile = new File(resourceDirName + resourceFilename);
            if (!resourceFile.isFile()) continue;
            resource = FileUtils.readFileToString((File)resourceFile, (String)"UTF-8");
            tri = new TemplatedResourceIterator(resource, "src/test/resources/APIM2/valuesplain");
            while (tri.hasNext()) {
                byte[] foxml = tri.next().getBytes("UTF-8");
                this.apim.ingest(foxml, TestAPIM2.FOXML1_1.uri, "ingesting new foxml object");
            }
        }
        TestAPIM2.purgeDemoObjects(s_client);
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestAPIM2.class);
    }

    public static void main(String[] args) {
        JUnitCore.runClasses((Class[])new Class[]{TestAPIM2.class});
    }
}

