/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.server.access.FedoraAPIAMTOM;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.OneEmptyObjectTestSetup;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class TestAuthentication
extends FedoraServerTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAuthentication.class);
    private static final String TEST_PID = "demo:AuthNTestObject";
    private static final int TIMES_PER_TEST = 50;
    private static FedoraClient CLIENT_VALID_USER_VALID_PASS;
    private static FedoraClient CLIENT_VALID_USER_BOGUS_PASS;
    private static FedoraClient CLIENT_BOGUS_USER;

    @Test
    public void testAPIMSOAPAuthNValidUserValidPass() throws Exception {
        int failCount = this.modifyLabel(this.getClient(true, true), 50);
        Assert.assertEquals((String)("Modifying object label using valid user, valid pass failed " + failCount + " times out of " + 50 + " attempts"), (int)0, (int)failCount);
    }

    @Test
    public void testAPIMSOAPAuthNValidUserBogusPass() throws Exception {
        int failCount = this.modifyLabel(this.getClient(true, false), 50);
        int successCount = 50 - failCount;
        Assert.assertEquals((String)("Modifying object label using valid user, bogus pass succeeded " + successCount + " times out of " + 50 + " attempts"), (int)0, (int)successCount);
    }

    @Test
    public void testAPIMSOAPAuthNBogusUser() throws Exception {
        int failCount = this.modifyLabel(this.getClient(false, false), 50);
        int successCount = 50 - failCount;
        Assert.assertEquals((String)("Modifying object label using bogus user, bogus pass succeeded " + successCount + " times out of " + 50 + " attempts"), (int)0, (int)successCount);
    }

    @Test
    public void testAPIMLiteAuthNValidUserValidPass() throws Exception {
        int failCount = this.getNextPID(this.getClient(true, true), 50);
        Assert.assertEquals((String)("Getting next PID using valid user, valid pass failed " + failCount + " times out of " + 50 + " attempts"), (int)0, (int)failCount);
    }

    @Test
    public void testAPIMLiteAuthNValidUserBogusPass() throws Exception {
        int failCount = this.getNextPID(this.getClient(true, false), 50);
        int successCount = 50 - failCount;
        Assert.assertEquals((String)("Getting next PID using valid user, bogus pass succeeded " + successCount + " times out of " + 50 + " attempts"), (int)0, (int)successCount);
    }

    @Test
    public void testAPIMLiteAuthNBogusUser() throws Exception {
        int failCount = this.getNextPID(this.getClient(false, false), 50);
        int successCount = 50 - failCount;
        Assert.assertEquals((String)("Getting next PID using bogus user, bogus pass succeeded " + successCount + " times out of " + 50 + " attempts"), (int)0, (int)successCount);
    }

    @Test
    public void testAPIASOAPAuthNValidUserValidPass() throws Exception {
        int failCount = this.listDatastreams(this.getClient(true, true), 50);
        Assert.assertEquals((String)("Listing object datastreams using valid user, valid pass failed " + failCount + " times out of " + 50 + " attempts"), (int)0, (int)failCount);
    }

    @Test
    public void testAPIASOAPAuthNValidUserBogusPass() throws Exception {
        int failCount = this.listDatastreams(this.getClient(true, false), 50);
        int successCount = 50 - failCount;
        Assert.assertEquals((String)("Listing object datastreams using valid user, bogus pass succeeded " + successCount + " times out of " + 50 + " attempts"), (int)0, (int)successCount);
    }

    @Test
    public void testAPIASOAPAuthNBogusUser() throws Exception {
        int failCount = this.listDatastreams(this.getClient(false, false), 50);
        int successCount = 50 - failCount;
        Assert.assertEquals((String)("Listing object datastreams using bogus user, bogus pass succeeded " + successCount + " times out of " + 50 + " attempts"), (int)0, (int)successCount);
    }

    @Test
    public void testAPIALiteAuthNValidUserValidPass() throws Exception {
        int failCount = this.getDCContent(this.getClient(true, true), 50);
        Assert.assertEquals((String)("Getting DC content using valid user, valid pass failed " + failCount + " times out of " + 50 + " attempts"), (int)0, (int)failCount);
    }

    @Test
    public void testAPIALiteAuthNValidUserBogusPass() throws Exception {
        int failCount = this.getDCContent(this.getClient(true, false), 50);
        int successCount = 50 - failCount;
        Assert.assertEquals((String)("Getting DC content using valid user, bogus pass succeeded " + successCount + " times out of " + 50 + " attempts"), (int)0, (int)successCount);
    }

    @Test
    public void testAPIALiteAuthNBogusUser() throws Exception {
        int failCount = this.getDCContent(this.getClient(false, false), 50);
        int successCount = 50 - failCount;
        Assert.assertEquals((String)("Getting DC content using bogus user, bogus pass succeeded " + successCount + " times out of " + 50 + " attempts"), (int)0, (int)successCount);
    }

    @Before
    public void setUp() throws Exception {
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("management", "http://www.fedora.info/definitions/1/0/management/");
        nsMap.put("oai_dc", "http://www.openarchives.org/OAI/2.0/oai_dc/");
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
    }

    @BeforeClass
    public static void bootstrap() throws Exception {
        CLIENT_VALID_USER_VALID_PASS = TestAuthentication.getFedoraClient();
        OneEmptyObjectTestSetup.ingestOneEmptyObject(CLIENT_VALID_USER_VALID_PASS, TEST_PID);
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
        OneEmptyObjectTestSetup.purgeOneEmptyObject(CLIENT_VALID_USER_VALID_PASS, TEST_PID);
        if (CLIENT_VALID_USER_VALID_PASS != null) {
            CLIENT_VALID_USER_VALID_PASS.shutdown();
        }
        if (CLIENT_VALID_USER_BOGUS_PASS != null) {
            CLIENT_VALID_USER_BOGUS_PASS.shutdown();
        }
        if (CLIENT_BOGUS_USER != null) {
            CLIENT_BOGUS_USER.shutdown();
        }
    }

    private FedoraClient getClient(boolean validUser, boolean validPass) throws Exception {
        if (validUser) {
            if (validPass) {
                LOGGER.info("Using Fedora Client with valid user, valid pass");
                if (CLIENT_VALID_USER_VALID_PASS == null) {
                    CLIENT_VALID_USER_VALID_PASS = TestAuthentication.getFedoraClient();
                }
                return CLIENT_VALID_USER_VALID_PASS;
            }
            LOGGER.info("Using Fedora Client with valid user, bogus pass");
            if (CLIENT_VALID_USER_BOGUS_PASS == null) {
                CLIENT_VALID_USER_BOGUS_PASS = TestAuthentication.getFedoraClient(TestAuthentication.getBaseURL(), TestAuthentication.getUsername(), "bogus");
            }
            return CLIENT_VALID_USER_BOGUS_PASS;
        }
        LOGGER.info("Using Fedora Client with bogus user");
        if (CLIENT_BOGUS_USER == null) {
            CLIENT_BOGUS_USER = TestAuthentication.getFedoraClient(TestAuthentication.getBaseURL(), "bogus", "bogus");
        }
        return CLIENT_BOGUS_USER;
    }

    private int modifyLabel(FedoraClient client, int numTimes) {
        LOGGER.info("Modifying object label via API-M SOAP {} times...", (Object)numTimes);
        int failCount = 0;
        FedoraAPIMMTOM apim = null;
        for (int i = 0; i < numTimes; ++i) {
            try {
                if (apim == null) {
                    apim = client.getAPIMMTOM();
                }
                apim.modifyObject(TEST_PID, null, null, null, "i=" + i);
                continue;
            }
            catch (Exception e) {
                ++failCount;
            }
        }
        LOGGER.info("Failed {} times", (Object)failCount);
        return failCount;
    }

    private int getNextPID(FedoraClient client, int numTimes) {
        LOGGER.info("Getting next PID via API-M Lite {} times...", (Object)numTimes);
        int failCount = 0;
        for (int i = 0; i < numTimes; ++i) {
            try {
                Document result = this.getXMLQueryResult(client, "/management/getNextPID?xml=true");
                XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//management:pid)", (Document)result);
                continue;
            }
            catch (Exception e) {
                ++failCount;
            }
        }
        LOGGER.info("Failed {} times", (Object)failCount);
        return failCount;
    }

    private int listDatastreams(FedoraClient client, int numTimes) {
        LOGGER.info("Listing object datastreams via API-A SOAP {} times...", (Object)numTimes);
        int failCount = 0;
        FedoraAPIAMTOM apia = null;
        for (int i = 0; i < numTimes; ++i) {
            try {
                if (apia == null) {
                    apia = client.getAPIAMTOM();
                }
                apia.listDatastreams(TEST_PID, null);
                continue;
            }
            catch (Exception e) {
                ++failCount;
            }
        }
        LOGGER.info("Failed {} times", (Object)failCount);
        return failCount;
    }

    private int getDCContent(FedoraClient client, int numTimes) {
        LOGGER.debug("Getting DC content via API-A Lite {} times...", (Object)numTimes);
        int failCount = 0;
        for (int i = 0; i < numTimes; ++i) {
            try {
                Document result = this.getXMLQueryResult(client, "/get/demo:AuthNTestObject/DC");
                XMLAssert.assertXpathExists((String)"/oai_dc:dc", (Document)result);
                continue;
            }
            catch (Exception e) {
                LOGGER.info(e.getMessage());
                ++failCount;
            }
        }
        LOGGER.debug("Failed {} times", (Object)failCount);
        return failCount;
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestAuthentication.class);
    }

    public static void main(String[] args) {
        JUnitCore.runClasses((Class[])new Class[]{TestAuthentication.class});
    }
}

