/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.io.InputStream;
import java.io.StringReader;
import java.net.URLEncoder;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.common.Constants;
import org.fcrepo.common.Models;
import org.fcrepo.common.PID;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.ManagedContentTranslator;
import org.fcrepo.test.api.RISearchUtil;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class TestRISearch
extends FedoraServerTestCase {
    private static FedoraClient s_client;
    private static final String[] SMILEYS;

    @BeforeClass
    public static void bootStrap() throws Exception {
        s_client = TestRISearch.getFedoraClient();
        TestRISearch.ingestSimpleImageDemoObjects(s_client);
        TestRISearch.ingestImageCollectionDemoObjects(s_client);
        ManagedContentTranslator.createManagedClone(s_client.getAPIMMTOM(), "demo:SmileyPens", "demo:SmileyPens_M");
        ManagedContentTranslator.createManagedClone(s_client.getAPIMMTOM(), "demo:SmileyBeerGlass", "demo:SmileyBeerGlass_M");
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        TestRISearch.purgeDemoObjects(s_client);
        s_client.shutdown();
    }

    @Test
    public void testRISearchBasicCModel() throws Exception {
        for (String pid : SMILEYS) {
            String query = "<" + PID.toURI((String)pid) + ">" + " <" + Constants.MODEL.HAS_MODEL.uri + ">" + " <" + Models.FEDORA_OBJECT_CURRENT.uri + ">";
            RISearchUtil.checkSPOCount(s_client, query, 1);
        }
    }

    @Test
    public void testRISearchSparqlW3cResult() throws Exception {
        String query = "select $object $modified from <#ri> where  $object <fedora-model:hasModel> <info:fedora/fedora-system:ServiceDefinition-3.0> and $object <fedora-view:lastModifiedDate> $modified";
        String xml = s_client.getResponseAsString("/risearch?lang=itql&format=Sparql_W3C&query=" + URLEncoder.encode(query, "UTF-8"), true, true).trim();
        this.validateXML(xml, this.getClass().getClassLoader().getResourceAsStream("schema/sparql/sparql_result.xsd"));
    }

    private void validateXML(String xml, InputStream schemaIn) throws Exception {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = sf.newSchema(new StreamSource(schemaIn));
        Validator validator = schema.newValidator();
        try {
            validator.validate(new StreamSource(new StringReader(xml)));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error during validation of XML:\n" + e.getLocalizedMessage()));
        }
    }

    @Test
    public void testRISearchRelsExtCollection() throws Exception {
        String collectionPid = "demo:SmileyStuff";
        for (String pid : SMILEYS) {
            String query = "<" + PID.toURI((String)pid) + ">" + " <" + Constants.RELS_EXT.IS_MEMBER_OF.uri + ">" + " <" + PID.toURI((String)collectionPid) + ">";
            RISearchUtil.checkSPOCount(s_client, query, 1);
        }
    }

    @Test
    public void testRISearchRelsInt() throws Exception {
        for (String pid : SMILEYS) {
            String query = "<" + PID.toURI((String)pid) + "/MEDIUM_SIZE" + ">" + " <" + "http://ns.adobe.com/exif/1.0/PixelXDimension" + ">" + " \"320\"";
            RISearchUtil.checkSPOCount(s_client, query, 1);
        }
    }

    @Test
    public void testSpringTripleGenerators() throws Exception {
        String query = "<info:fedora/demo:5> <info:fedora/fedora-system:test/tests#tripleGenerator> \"true\"";
        RISearchUtil.checkSPOCount(s_client, query, 1);
    }

    @Test
    public void testLanguageAttributes() throws Exception {
        String query = "PREFIX skos: <http://www.w3.org/2004/02/skos/core#>\nSELECT ?x FROM <#ri>\nWHERE { ?x skos:prefLabel \"Immagine del Colosseo a Roma\"@it }";
        RISearchUtil.checkSPARQLCount(s_client, query, 1);
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestRISearch.class);
    }

    public static void main(String[] args) {
        JUnitCore.runClasses((Class[])new Class[]{TestRISearch.class});
    }

    static {
        SMILEYS = new String[]{"demo:SmileyPens", "demo:SmileyPens_M", "demo:SmileyGreetingCard"};
    }
}

