/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.fesl.policy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.common.Constants;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.fesl.util.AuthorizationDeniedException;
import org.fcrepo.test.fesl.util.FedoraUtil;
import org.fcrepo.test.fesl.util.HttpUtils;
import org.fcrepo.test.fesl.util.LoadDataset;
import org.fcrepo.test.fesl.util.PolicyUtils;
import org.fcrepo.test.fesl.util.RemoveDataset;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPolicies
extends FedoraServerTestCase
implements Constants {
    private static final Logger logger = LoggerFactory.getLogger(TestPolicies.class);
    private static final String PROPERTIES = "fedora";
    private static FedoraClient s_client;
    private HttpUtils httpUtils = null;
    private PolicyUtils policyUtils = null;

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestPolicies.class);
    }

    @BeforeClass
    public static void bootStrap() throws Exception {
        s_client = TestPolicies.getFedoraClient();
    }

    @AfterClass
    public static void cleanUp() {
        s_client.shutdown();
    }

    @Before
    public void setUp() {
        PropertyResourceBundle prop = (PropertyResourceBundle)ResourceBundle.getBundle(PROPERTIES);
        String username = prop.getString("fedora.admin.username");
        String password = prop.getString("fedora.admin.password");
        String fedoraUrl = FedoraUtil.getBaseURL();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Setting up...");
            }
            this.policyUtils = new PolicyUtils(s_client);
            this.httpUtils = new HttpUtils(fedoraUrl, username, password);
            String policyId = this.policyUtils.addPolicy("test-access-admin.xml");
            LoadDataset.load("fesl", fedoraUrl, username, password);
            this.policyUtils.delPolicy(policyId);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void tearDown() {
        PropertyResourceBundle prop = (PropertyResourceBundle)ResourceBundle.getBundle(PROPERTIES);
        String username = prop.getString("fedora.admin.username");
        String password = prop.getString("fedora.admin.password");
        String fedoraUrl = FedoraUtil.getBaseURL();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Tearing down...");
            }
            this.httpUtils.shutdown();
            String policyId = this.policyUtils.addPolicy("test-access-admin.xml");
            RemoveDataset.remove("fesl", fedoraUrl, username, password);
            this.policyUtils.delPolicy(policyId);
            this.httpUtils.shutdown();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminGetDeny() throws Exception {
        String policyId = this.policyUtils.addPolicy("test-policy-00.xml");
        try {
            String response;
            String url;
            try {
                url = "/fedora/objects/test:1000007?format=xml";
                response = this.httpUtils.get(url);
                logger.debug("http response:\n" + response);
                Assert.fail((String)("Access was permitted when it should have been denied:  " + url));
            }
            catch (AuthorizationDeniedException e) {
                // empty catch block
            }
            try {
                url = "/fedora/objects/test:1000007/datastreams";
                response = this.httpUtils.get(url);
                logger.debug("http response:\n" + response);
                Assert.fail((String)("Access was permitted when it should have been denied:  " + url));
            }
            catch (AuthorizationDeniedException e) {
                // empty catch block
            }
            try {
                url = "/fedora/objects/test:1000007/datastreams/DC";
                response = this.httpUtils.get(url);
                logger.debug("http response:\n" + response);
                Assert.fail((String)("Access was permitted when it should have been denied:  " + url));
            }
            catch (AuthorizationDeniedException e) {
                // empty catch block
            }
            try {
                url = "/fedora/objects/test:1000007/datastreams/DC/content";
                response = this.httpUtils.get(url);
                logger.debug("http response:\n" + response);
                Assert.fail((String)("Access was permitted when it should have been denied:  " + url));
            }
            catch (AuthorizationDeniedException e) {
                // empty catch block
            }
            try {
                url = "/fedora/objects/test:1000007/methods";
                response = this.httpUtils.get(url);
                logger.debug("http response:\n" + response);
                Assert.fail((String)("Access was permitted when it should have been denied:  " + url));
            }
            catch (AuthorizationDeniedException e) {
                // empty catch block
            }
            try {
                url = "/fedora/objects/test:1000007/methods/fedora-system:3/viewDublinCore";
                response = this.httpUtils.get(url);
                logger.debug("http response:\n" + response);
                Assert.fail((String)("Access was permitted when it should have been denied:  " + url));
            }
            catch (AuthorizationDeniedException authorizationDeniedException) {
                // empty catch block
            }
        }
        finally {
            this.policyUtils.delPolicy(policyId);
        }
    }

    @Test
    public void testAdminGetPermit() throws Exception {
        String policyId = this.policyUtils.addPolicy("test-policy-01.xml");
        try {
            String url = "/fedora/objects/test:1000007?format=xml";
            String response = this.httpUtils.get(url);
            if (logger.isDebugEnabled()) {
                logger.debug("http response:\n" + response);
            }
            boolean check = response.contains("<objLabel>Dexter</objLabel>");
            Assert.assertTrue((String)"Expected object data not found", (boolean)check);
        }
        catch (AuthorizationDeniedException e) {
            Assert.fail((String)"Authorization denied.  (Check that system property fedora.fesl.pep_nocache is set to true)");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.policyUtils.delPolicy(policyId);
        }
    }

    @Test
    public void testRIAttributesRels1() throws Exception {
        this.doAttributesTest("test-policy-state-rel1.xml", "test-policy-subject-rel1.xml");
    }

    @Test
    public void testRIAttributesRels2() throws Exception {
        this.doAttributesTest("test-policy-state-rel2.xml", "test-policy-subject-rel2.xml");
    }

    @Test
    public void testRIAttributesTQL() throws Exception {
        this.doAttributesTest("test-policy-state-itql.xml", "test-policy-subject-itql.xml");
    }

    @Test
    public void testRIAttributesSPARQL() throws Exception {
        this.doAttributesTest("test-policy-state-sparql.xml", "test-policy-subject-sparql.xml");
    }

    @Test
    public void testRIAttributesSPO() throws Exception {
        this.doAttributesTest("test-policy-state-spo.xml", "test-policy-subject-spo.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAttributesTest(String statePolicy, String subjectPolicy) throws Exception {
        String[] pids = new String[]{"test:1000000", "test:1000001", "test:1000002", "test:1000003", "test:1000004", "test:1000005", "test:1000006", "test:1000007", "test:1000008", "test:1000009", "test:1000010", "test:1000011", "test:1000012"};
        Perms allPids = new Perms();
        allPids.addAll(Arrays.asList(pids));
        PermissionTest perms = new PermissionTest(1000000, 1000012, "test", "DC");
        Assert.assertEquals((String)"Allowed objects count (no policies)", (int)0, (int)perms.object().allowed().mismatch(pids, true).length);
        Assert.assertEquals((String)"Allowed DC datastreams count (no policies)", (int)0, (int)perms.datastream().allowed().mismatch(pids, true).length);
        String policyId = this.policyUtils.addPolicy(statePolicy);
        try {
            perms = new PermissionTest(1000000, 1000012, "test", "DC");
            String[] denied = new String[]{"test:1000004", "test:1000005", "test:1000006", "test:1000007", "test:1000008", "test:1000009"};
            String[] deniedVideos = new String[]{"test:1000000", "test:1000004", "test:1000005", "test:1000006", "test:1000007", "test:1000008", "test:1000009"};
            String[] allowed = allPids.mismatch(denied, false);
            String[] mismatches = perms.object().denied().mismatch(denied, false);
            Assert.assertEquals((String)TestPolicies.getAccessErrorMessage(subjectPolicy, "objects", "denied", mismatches), (int)0, (int)mismatches.length);
            allowed = allPids.mismatch(deniedVideos, false);
            mismatches = perms.object().listed().mismatch(allowed, true);
            Assert.assertEquals((String)TestPolicies.getAccessErrorMessage(subjectPolicy, "objects", "listed", mismatches), (int)0, (int)mismatches.length);
            denied = new String[]{"test:1000008", "test:1000009", "test:1000010", "test:1000011", "test:1000012"};
            mismatches = perms.datastream().denied().mismatch(denied, true);
            Assert.assertEquals((String)TestPolicies.getAccessErrorMessage(subjectPolicy, "datastreams", "denied", mismatches), (int)0, (int)mismatches.length);
        }
        finally {
            this.policyUtils.delPolicy(policyId);
        }
        perms = new PermissionTest(1000000, 1000012, "test", "DC");
        Assert.assertEquals((String)"Allowed objects count (no policies)", (int)perms.pidCount(), (int)perms.object().allowed().size());
        Assert.assertEquals((String)"Allowed DC datastreams count (no policies)", (int)perms.pidCount(), (int)perms.datastream().allowed().size());
        policyId = this.policyUtils.addPolicy(subjectPolicy);
        try {
            perms = new PermissionTest(1000000, 1000012, "test", "DC");
            String[] allowed = new String[]{"test:1000001", "test:1000003", "test:1000007", "test:1000009"};
            String[] mismatches = perms.object().allowed().mismatch(allowed, true);
            Assert.assertEquals((String)TestPolicies.getAccessErrorMessage(subjectPolicy, "objects", "allowed", mismatches), (int)0, (int)mismatches.length);
            mismatches = perms.object().listed().mismatch(allowed, true);
            Assert.assertEquals((String)TestPolicies.getAccessErrorMessage(subjectPolicy, "objects", "listed", mismatches), (int)0, (int)mismatches.length);
            mismatches = perms.datastream().allowed().mismatch(allowed, true);
            Assert.assertEquals((String)TestPolicies.getAccessErrorMessage(subjectPolicy, "datastreams", "allowed", mismatches), (int)0, (int)mismatches.length);
        }
        finally {
            this.policyUtils.delPolicy(policyId);
        }
    }

    private static String getAccessErrorMessage(String subjectPolicy, String type, String verb, String[] mismatches) {
        StringBuilder sb = new StringBuilder();
        sb.append(subjectPolicy).append(": Access ").append(verb).append(" for ").append(type).append("[");
        for (int i = 0; i < mismatches.length; ++i) {
            sb.append(mismatches[i]);
            if (i >= mismatches.length - 1) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    class Perms
    extends HashSet<String> {
        private static final long serialVersionUID = 3747931619024146008L;

        Perms() {
        }

        public boolean containsAll(String[] items) {
            return this.containsAll(Arrays.asList(items));
        }

        public boolean containsOnly(String[] items) {
            return this.size() == items.length && this.containsAll(items);
        }

        public boolean containsAny(String[] items) {
            boolean result = false;
            for (String item : items) {
                result |= this.contains(item);
            }
            return result;
        }

        public String[] mismatch(String[] items, boolean indicate) {
            ArrayList<String> res = new ArrayList<String>();
            if (this.containsOnly(items)) {
                return res.toArray(new String[0]);
            }
            for (String item : items) {
                if (this.contains(item)) continue;
                if (indicate) {
                    res.add("-" + item);
                    continue;
                }
                res.add(item);
            }
            List<String> asList = Arrays.asList(items);
            for (String item : this) {
                if (asList.contains(item)) continue;
                if (indicate) {
                    res.add("+" + item);
                    continue;
                }
                res.add(item);
            }
            return res.toArray(new String[0]);
        }
    }

    class EntityPerms {
        private final Perms m_allowed;
        private final Perms m_denied;
        private final Perms m_listed;

        EntityPerms() {
            this.m_allowed = new Perms();
            this.m_denied = new Perms();
            this.m_listed = new Perms();
        }

        public Perms allowed() {
            return this.m_allowed;
        }

        public Perms denied() {
            return this.m_denied;
        }

        public Perms listed() {
            return this.m_listed;
        }
    }

    class PermissionTest {
        private final EntityPerms m_object;
        private final EntityPerms m_datastream;
        private final int m_first;
        private final int m_last;
        private final String m_pidns;
        private final String m_dsid;

        PermissionTest(int first, int last, String pidNamespace, String dsid) throws Exception {
            this.m_object = new EntityPerms();
            this.m_datastream = new EntityPerms();
            this.m_first = first;
            this.m_last = last;
            this.m_pidns = pidNamespace;
            this.m_dsid = dsid;
            for (int i = this.m_first; i <= this.m_last; ++i) {
                String pid = this.m_pidns + ":" + i;
                String url = "/fedora/objects/" + pid + "?format=xml";
                try {
                    TestPolicies.this.httpUtils.get(url);
                    this.m_object.allowed().add(pid);
                }
                catch (AuthorizationDeniedException e) {
                    this.m_object.denied().add(pid);
                }
                if (this.m_dsid.equals("")) continue;
                url = "/fedora/objects/" + pid + "/datastreams/" + this.m_dsid + "?format=xml";
                try {
                    TestPolicies.this.httpUtils.get(url);
                    this.m_datastream.allowed().add(pid);
                }
                catch (AuthorizationDeniedException e) {
                    this.m_datastream.denied().add(pid);
                }
                url = "/fedora/objects?resultFormat=xml&query=type%7Evideo";
                String response = TestPolicies.this.httpUtils.get(url);
                Matcher matcher = Pattern.compile("<pid>(.*)<\\/pid>").matcher(response);
                while (matcher.find()) {
                    this.m_object.listed().add(matcher.group(1));
                }
            }
            if (this.m_object.allowed().size() + this.m_object.denied().size() != this.pidCount()) {
                Assert.fail((String)"Error in checking permissions - total of allowed and denied objects does not equal number of objects tested");
                throw new RuntimeException("Should not happen");
            }
            if (!this.m_dsid.equals("") && this.m_datastream.allowed().size() + this.m_datastream.denied().size() != this.pidCount()) {
                Assert.fail((String)"Error in checking permissions - total of allowed and denied datastreams does not equal number of object datastreams tested");
                throw new RuntimeException("Also should not happen");
            }
        }

        public EntityPerms object() {
            return this.m_object;
        }

        public EntityPerms datastream() {
            return this.m_datastream;
        }

        public int pidCount() {
            return this.m_last - this.m_first + 1;
        }
    }
}

