/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.fesl.policyindex;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import junit.framework.JUnit4TestAdapter;
import org.apache.http.client.ClientProtocolException;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.common.Constants;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.server.security.servletfilters.xmluserfile.FedoraUsers;
import org.fcrepo.server.types.gen.Datastream;
import org.fcrepo.server.utilities.StreamUtility;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.fesl.policyindex.PolicyIndexExerciser;
import org.fcrepo.test.fesl.policyindex.PolicyIndexUtils;
import org.fcrepo.test.fesl.util.AuthorizationDeniedException;
import org.fcrepo.test.fesl.util.HttpUtils;
import org.fcrepo.test.fesl.util.LoadDataset;
import org.fcrepo.test.fesl.util.RemoveDataset;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPolicyIndex
extends FedoraServerTestCase
implements Constants {
    private static final Logger logger = LoggerFactory.getLogger(TestPolicyIndex.class);
    private static final String PROPERTIES = "fedora";
    private static FedoraClient s_client;
    private static HttpUtils httpUtils;
    private FedoraAPIMMTOM apim = null;
    private PolicyIndexUtils policyIndexUtils = null;
    private static String POLICY_DATASTREAM;
    private File fedoraUsersBackup = null;
    private String username = null;
    private String password = null;
    private String fedoraUrl = null;

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestPolicyIndex.class);
    }

    @BeforeClass
    public static void bootStrap() throws Exception {
        s_client = TestPolicyIndex.getFedoraClient();
        httpUtils = new HttpUtils(TestPolicyIndex.getBaseURL(), "testuser", "testuser");
    }

    @AfterClass
    public static void cleanUp() {
        httpUtils.shutdown();
        s_client.shutdown();
    }

    @Before
    public void setUp() {
        PropertyResourceBundle prop = (PropertyResourceBundle)ResourceBundle.getBundle(PROPERTIES);
        this.username = prop.getString("fedora.admin.username");
        this.password = prop.getString("fedora.admin.password");
        this.fedoraUrl = TestPolicyIndex.getProtocol() + "://" + TestPolicyIndex.getHost() + ":" + TestPolicyIndex.getPort() + "/" + TestPolicyIndex.getFedoraAppServerContext();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Setting up...");
            }
            this.createFedoraUsersTestFile();
            junit.framework.Assert.assertNotNull((String)"FedoraTestCase.getFedoraClient() returned NULL", (Object)s_client);
            this.apim = s_client.getAPIMMTOM();
            this.policyIndexUtils = new PolicyIndexUtils(this.apim);
            LoadDataset.load("fesl", this.fedoraUrl, this.username, this.password);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void tearDown() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Tearing down...");
            }
            this.restoreFedoraUsersFile();
            RemoveDataset.remove("fesl", this.fedoraUrl, this.username, this.password);
            TestPolicyIndex.purgeDemoObjects(s_client);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    private void createFedoraUsersTestFile() {
        System.out.println("Creating test Fedora Users file");
        this.backupFedoraUsersFile();
        String sep = System.getProperty("line.seperator");
        if (sep == null) {
            sep = "\n";
        }
        if (!this.fedoraUsersBackup.exists()) {
            throw new RuntimeException("Fedora Users backup file expected, but none present");
        }
        try {
            String inp;
            FileInputStream fis = new FileInputStream(this.fedoraUsersBackup);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            boolean addedUser = false;
            String usersTag = "<users>";
            StringBuilder data = new StringBuilder();
            while ((inp = br.readLine()) != null) {
                if (!addedUser && inp.contains(usersTag)) {
                    data.append(inp + sep);
                    data.append("<user name=\"testuser\" password=\"testuser\">" + sep);
                    data.append("<attribute name=\"fedoraRole\">" + sep);
                    data.append("<value>testing</value>" + sep);
                    data.append("</attribute>" + sep);
                    data.append("</user>" + sep);
                    addedUser = true;
                    continue;
                }
                data.append(inp + sep);
            }
            FileOutputStream fu = new FileOutputStream(FedoraUsers.fedoraUsersXML);
            OutputStreamWriter pw = new OutputStreamWriter(fu);
            pw.write(data.toString());
            pw.close();
        }
        catch (IOException e) {
            System.out.println("Error generating test fedora-users.xml: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void backupFedoraUsersFile() {
        File srcFile = FedoraUsers.fedoraUsersXML;
        this.fedoraUsersBackup = new File(srcFile.getAbsolutePath() + ".backup-fesl");
        if (!this.fedoraUsersBackup.exists()) {
            System.out.println("Backing Up Fedora Users");
            try {
                this.fedoraUsersBackup.createNewFile();
                this.copyFile(srcFile, this.fedoraUsersBackup);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void restoreFedoraUsersFile() {
        File destFile = FedoraUsers.fedoraUsersXML;
        if (!this.fedoraUsersBackup.exists()) {
            System.out.println("Error - Fedora Users backup file does not exist");
        } else {
            System.out.println("Restoring Fedora Users");
            this.copyFile(this.fedoraUsersBackup, destFile);
        }
    }

    private boolean copyFile(File src, File dest) {
        try {
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dest);
            StreamUtility.pipeStream((InputStream)in, (OutputStream)out, (int)1024);
            ((InputStream)in).close();
            ((OutputStream)out).close();
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testObjectMethods() throws Exception {
        String pid = this.policyIndexUtils.addPolicyObject("X", "A", null);
        junit.framework.Assert.assertFalse((String)"authorization \"A\" PERMITTED, expected DENIED", (boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertFalse((String)"authorization \"B\" PERMITTED, expected DENIED", (boolean)this.checkPolicyEnforcement("B"));
        String pidA = this.policyIndexUtils.addPolicyObject("A", "A", "A");
        String pidB = this.policyIndexUtils.addPolicyObject("B", "A", "A");
        junit.framework.Assert.assertTrue((String)"authorization \"A\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((String)"authorization \"B\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("B"));
        this.apim.purgeObject(pid, "", false);
        junit.framework.Assert.assertTrue((String)"authorization \"A\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((String)"authorization \"B\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("B"));
        this.apim.purgeObject(pidA, "", false);
        junit.framework.Assert.assertFalse((String)"authorization \"A\" PERMITTED, expected DENIED", (boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((String)"authorization \"B\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("B"));
        this.apim.purgeObject(pidB, "", false);
        junit.framework.Assert.assertFalse((String)"authorization \"B\" PERMITTED, expected DENIED", (boolean)this.checkPolicyEnforcement("B"));
    }

    @Test
    public void testStateChanges() throws Exception {
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("B"));
        String pidA = this.policyIndexUtils.addPolicyObject("A", "A", "A");
        String pidB = this.policyIndexUtils.addPolicyObject("B", "A", "A");
        junit.framework.Assert.assertTrue((boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((boolean)this.checkPolicyEnforcement("B"));
        this.apim.modifyObject(pidA, null, "updated label", null, "updating label");
        junit.framework.Assert.assertTrue((boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((boolean)this.checkPolicyEnforcement("B"));
        this.apim.modifyObject(pidA, "I", null, null, "set inactive");
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((boolean)this.checkPolicyEnforcement("B"));
        this.apim.modifyObject(pidA, null, "updated label", null, "updating label");
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((boolean)this.checkPolicyEnforcement("B"));
        this.apim.modifyObject(pidA, "D", null, null, "set deleted");
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((boolean)this.checkPolicyEnforcement("B"));
        this.apim.modifyObject(pidA, "A", null, null, "set active");
        junit.framework.Assert.assertTrue((boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((boolean)this.checkPolicyEnforcement("B"));
        this.apim.modifyObject(pidA, "D", null, null, "set deleted");
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((boolean)this.checkPolicyEnforcement("B"));
        this.apim.modifyObject(pidA, "A", null, null, "set active");
        junit.framework.Assert.assertTrue((boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((boolean)this.checkPolicyEnforcement("B"));
        this.apim.purgeObject(pidA, "purging policy A", false);
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((boolean)this.checkPolicyEnforcement("B"));
        pidA = this.policyIndexUtils.addPolicyObject("A", "I", "A");
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((boolean)this.checkPolicyEnforcement("B"));
        this.apim.modifyObject(pidA, null, "updated label", null, "updated label");
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((boolean)this.checkPolicyEnforcement("B"));
        this.apim.modifyObject(pidA, "A", null, null, "set active");
        junit.framework.Assert.assertTrue((String)"authorization \"A\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((String)"authorization \"B\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("B"));
        this.apim.purgeObject(pidA, "purging A", false);
        pidA = this.policyIndexUtils.addPolicyObject("A", "I", "I");
        junit.framework.Assert.assertFalse((String)"authorization \"A\" PERMITTED, expected DENIED", (boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((String)"authorization \"B\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("B"));
        this.apim.modifyObject(pidA, "A", null, null, "set active");
        junit.framework.Assert.assertFalse((String)"authorization \"A\" PERMITTED, expected DENIED", (boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((String)"authorization \"B\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("B"));
        this.apim.setDatastreamState(pidA, POLICY_DATASTREAM, "A", "datastream active");
        junit.framework.Assert.assertTrue((String)"authorization \"A\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((String)"authorization \"B\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("B"));
        this.apim.setDatastreamState(pidA, POLICY_DATASTREAM, "I", "datastream inactive");
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((String)"authorization \"B\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("B"));
        this.apim.setDatastreamState(pidA, POLICY_DATASTREAM, "D", "datastream deleted");
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((String)"authorization \"B\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("B"));
        this.apim.setDatastreamState(pidA, POLICY_DATASTREAM, "A", "datastream active");
        junit.framework.Assert.assertTrue((String)"authorization \"A\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((String)"authorization \"B\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("B"));
        this.apim.setDatastreamState(pidA, POLICY_DATASTREAM, "D", "datastream deleted");
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((String)"authorization \"B\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("B"));
        this.apim.modifyObject(pidA, "D", null, null, "set inactive");
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((String)"authorization \"B\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("B"));
        this.apim.setDatastreamState(pidA, POLICY_DATASTREAM, "A", "datastream active");
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((String)"authorization \"B\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("B"));
        this.apim.modifyObject(pidA, "A", null, null, "set inactive");
        junit.framework.Assert.assertTrue((String)"authorization \"A\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertTrue((String)"authorization \"B\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("B"));
        this.apim.purgeObject(pidA, "", false);
        this.apim.purgeObject(pidB, "", false);
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("B"));
    }

    @Test
    public void testDatastreamMethods() throws Exception {
        String pid = this.policyIndexUtils.addPolicyObject("A", "A", "A");
        junit.framework.Assert.assertTrue((boolean)this.checkPolicyEnforcement("A"));
        try {
            this.apim.modifyDatastreamByValue(pid, POLICY_DATASTREAM, null, "policy datastream", "text/xml", null, TypeUtility.convertBytesToDataHandler((byte[])"<not><valid/></not>".getBytes("UTF-8")), null, null, "modify to policy B", false);
            Assert.fail((String)"FeSL policy datastream validation failure - should have rejected update and thrown an exception");
        }
        catch (Exception e) {
            System.out.println("Expected error occurred from invalid XACML - " + e.getMessage());
        }
        junit.framework.Assert.assertTrue((String)"authorization \"A\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("A"));
        this.apim.modifyDatastreamByValue(pid, POLICY_DATASTREAM, null, "policy datastream", "text/xml", null, TypeUtility.convertBytesToDataHandler((byte[])PolicyIndexUtils.getPolicy("B").getBytes("UTF-8")), null, null, "modify to policy B", false);
        junit.framework.Assert.assertTrue((String)"authorization \"B\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("B"));
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("A"));
        this.apim.modifyDatastreamByValue(pid, POLICY_DATASTREAM, null, "policy datastream", "text/xml", null, TypeUtility.convertBytesToDataHandler((byte[])PolicyIndexUtils.getPolicy("A").getBytes("UTF-8")), null, null, "modify to policy B", false);
        junit.framework.Assert.assertTrue((String)"authorization \"A\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("B"));
        Datastream ds = this.apim.getDatastream(pid, POLICY_DATASTREAM, null);
        this.apim.purgeDatastream(pid, POLICY_DATASTREAM, ds.getCreateDate(), ds.getCreateDate(), "purging latest version", false);
        junit.framework.Assert.assertTrue((String)"authorization \"B\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("B"));
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("A"));
        this.apim.purgeDatastream(pid, POLICY_DATASTREAM, null, null, "purge FESLPOLICY", false);
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("B"));
        String pidTemp = this.policyIndexUtils.addPolicyObject("A", "A", "A");
        this.apim.addDatastream(pid, POLICY_DATASTREAM, null, "FESL policy datastream", true, "text/xml", null, this.fedoraUrl + "/objects/" + pidTemp + "/datastreams/FESLPOLICY/content", "M", "I", null, null, "add policy datastream by reference");
        this.apim.purgeObject(pidTemp, "removing temp object", false);
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("A"));
        this.apim.setDatastreamState(pid, POLICY_DATASTREAM, "A", "FESLPOLICY set to active");
        junit.framework.Assert.assertTrue((String)"authorization \"A\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertFalse((String)"authorization \"B\" PERMITTED, expected DENIED", (boolean)this.checkPolicyEnforcement("B"));
        this.apim.addDatastream(pid, "UNRELATED", null, "some datastream", true, "text/xml", null, this.fedoraUrl + "/objects/test:1000001/datastreams/DC/content", "M", "A", null, null, "adding UNRELATED");
        junit.framework.Assert.assertTrue((String)"authorization \"A\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("A"));
        this.apim.purgeDatastream(pid, "UNRELATED", null, null, "purge UNRELATED", false);
        junit.framework.Assert.assertTrue((String)"authorization \"A\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("A"));
        this.apim.purgeDatastream(pid, POLICY_DATASTREAM, null, null, "purge FESLPOLICY", false);
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("B"));
        pidTemp = this.policyIndexUtils.addPolicyObject("A", "A", "A");
        this.apim.addDatastream(pid, POLICY_DATASTREAM, null, "FESL policy datastream", true, "text/xml", null, this.fedoraUrl + "/objects/" + pidTemp + "/datastreams/FESLPOLICY/content", "M", "A", null, null, "add policy datastream by reference");
        this.apim.purgeObject(pidTemp, "removing temp object", false);
        junit.framework.Assert.assertTrue((String)"authorization \"A\" DENIED, expected PERMITTED", (boolean)this.checkPolicyEnforcement("A"));
        pidTemp = this.policyIndexUtils.addPolicyObject("B", "A", "A");
        this.apim.modifyDatastreamByReference(pid, POLICY_DATASTREAM, null, "FESL policy datastream", "text/xml", null, this.fedoraUrl + "/objects/" + pidTemp + "/datastreams/FESLPOLICY/content", null, null, "modiy FESLPOLICY to policy B", false);
        this.apim.purgeObject(pidTemp, "removing temp object", false);
        junit.framework.Assert.assertTrue((boolean)this.checkPolicyEnforcement("B"));
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("A"));
        this.apim.setDatastreamVersionable(pid, POLICY_DATASTREAM, false, "");
        junit.framework.Assert.assertTrue((boolean)this.checkPolicyEnforcement("B"));
        pidTemp = this.policyIndexUtils.addPolicyObject("A", "A", "A");
        this.apim.modifyDatastreamByReference(pid, POLICY_DATASTREAM, null, "FESL policy datastream", "text/xml", null, this.fedoraUrl + "/objects/" + pidTemp + "/datastreams/FESLPOLICY/content", null, null, "modiy FESLPOLICY to policy B", false);
        this.apim.purgeObject(pidTemp, "removing temp object", false);
        junit.framework.Assert.assertTrue((boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("B"));
        this.apim.setDatastreamVersionable(pid, POLICY_DATASTREAM, true, "");
        pidTemp = this.policyIndexUtils.addPolicyObject("B", "A", "A");
        this.apim.modifyDatastreamByReference(pid, POLICY_DATASTREAM, null, "FESL policy datastream", "text/xml", null, this.fedoraUrl + "/objects/" + pidTemp + "/datastreams/FESLPOLICY/content", null, null, "modiy FESLPOLICY to policy B", false);
        this.apim.purgeObject(pidTemp, "removing temp object", false);
        junit.framework.Assert.assertTrue((boolean)this.checkPolicyEnforcement("B"));
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("A"));
    }

    @Test
    public void testManyModifications() throws Exception {
        int e;
        int updatersCount = 5;
        int updatersPolicyCount = 10;
        int readersCount = 10;
        ArrayList<PolicyIndexExerciser> updaters = new ArrayList<PolicyIndexExerciser>();
        ArrayList<PolicyIndexExerciser> readers = new ArrayList<PolicyIndexExerciser>();
        for (e = 0; e < 5; ++e) {
            String[] pids = this.policyIndexUtils.getNextPids(10);
            PolicyIndexExerciser ex = new PolicyIndexExerciser(TestPolicyIndex.getBaseURL(), "testuser", "testuser", this.fedoraUrl, this.username, this.password, pids);
            updaters.add(ex);
        }
        for (e = 0; e < 10; ++e) {
            PolicyIndexExerciser ex = new PolicyIndexExerciser(TestPolicyIndex.getBaseURL(), "testuser", "testuser");
            readers.add(ex);
        }
        for (PolicyIndexExerciser ex : readers) {
            ex.start();
        }
        for (PolicyIndexExerciser ex : updaters) {
            ex.start();
        }
        int maxSleepSeconds = 20;
        while (PolicyIndexExerciser.updaterRunningCount() == 0) {
            Thread.sleep(1000L);
            if (--maxSleepSeconds != 0) continue;
            Assert.fail((String)"No threads have started");
        }
        maxSleepSeconds = 600;
        while (PolicyIndexExerciser.updaterRunningCount() > 0) {
            Thread.sleep(1000L);
            if (--maxSleepSeconds != 0) continue;
        }
        for (PolicyIndexExerciser ex : readers) {
            ex.stopit();
        }
        maxSleepSeconds = 300;
        while (PolicyIndexExerciser.readerRunningCount() > 0) {
            Thread.sleep(1000L);
            if (--maxSleepSeconds != 0) continue;
        }
        for (PolicyIndexExerciser ex : updaters) {
            if (ex.failed()) {
                System.out.println("PolicyIndexExerciser failed.  Last URL was: " + ex.lastUrl());
                System.out.println("Error was: " + ex.failure().getMessage());
            }
            ex.shutdown();
        }
        for (PolicyIndexExerciser ex : readers) {
            if (ex.failed()) {
                System.out.println("PolicyIndexExerciser failed.  Last URL was: " + ex.lastUrl());
                System.out.println("Error was: " + ex.failure().getMessage());
            }
            ex.shutdown();
        }
        junit.framework.Assert.assertTrue((String)"Some policy index exercisers did not complete", (PolicyIndexExerciser.updaterRunningCount() == 0 ? 1 : 0) != 0);
        junit.framework.Assert.assertTrue((String)"Some policy index exercisers did not complete", (PolicyIndexExerciser.readerRunningCount() == 0 ? 1 : 0) != 0);
        junit.framework.Assert.assertTrue((String)"Some policy index operations reported errors", (PolicyIndexExerciser.updaterPassedCount() == 5 ? 1 : 0) != 0);
        junit.framework.Assert.assertTrue((String)"Some policy index operations reported errors", (PolicyIndexExerciser.readerPassedCount() == 10 ? 1 : 0) != 0);
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("A"));
        junit.framework.Assert.assertFalse((boolean)this.checkPolicyEnforcement("B"));
    }

    private boolean checkPolicyEnforcement(String policy) throws ClientProtocolException, IOException {
        boolean permitted;
        String url;
        if (policy.equals("A")) {
            url = "/fedora/objects/test:1000002?format=xml";
        } else if (policy.equals("B")) {
            url = "/fedora/objects/test:1000007?format=xml";
        } else {
            throw new RuntimeException("Invalid policy, specify A or B");
        }
        try {
            httpUtils.get(url);
            permitted = true;
        }
        catch (AuthorizationDeniedException e) {
            permitted = false;
        }
        return permitted;
    }

    static {
        httpUtils = null;
        POLICY_DATASTREAM = "FESLPOLICY";
    }
}

