/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.integration;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.OutputStream;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.common.Constants;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.utilities.ExecUtility;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class TestCommandLineUtilities
extends FedoraServerTestCase
implements Constants {
    static ByteArrayOutputStream sbOut = null;
    static ByteArrayOutputStream sbErr = null;
    static TestCommandLineUtilities curTest = null;
    private static FedoraClient s_client;
    private static final String RESOURCEBASE;
    private static final String LOGDIR;
    private static final String BUILDDIR;
    private static File logDir;
    private static File buildDir;

    @BeforeClass
    public static void bootStrap() throws Exception {
        String baseURL = TestCommandLineUtilities.getProtocol() + "://" + TestCommandLineUtilities.getHost() + ":" + TestCommandLineUtilities.getPort() + "/" + TestCommandLineUtilities.getFedoraAppServerContext();
        s_client = new FedoraClient(baseURL, TestCommandLineUtilities.getUsername(), TestCommandLineUtilities.getPassword());
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        TestCommandLineUtilities.purgeDemoObjects(s_client);
        s_client.shutdown();
    }

    @Test
    public void testFedoraIngestAndPurge() {
        System.out.println("Ingesting object test:1001");
        this.ingestFoxmlFile(new File(RESOURCEBASE + "/test1001.xml"));
        String out = sbOut.toString();
        String err = sbErr.toString();
        if (out.indexOf("Ingested pid: test:1001") == -1) {
            System.err.println("Command-line ingest failed: STDOUT='" + out + "', STDERR='" + err + "'");
        }
        Assert.assertEquals((boolean)true, (out.indexOf("Ingested pid: test:1001") != -1 ? 1 : 0) != 0);
        System.out.println("Purging object test:1001");
        System.out.println("FEDORA-HOME = " + FEDORA_HOME);
        TestCommandLineUtilities.purgeUsingScript("test:1001");
        Assert.assertEquals((String)("Expected empty STDERR output, got '" + sbErr.toString() + "'"), (int)0, (int)sbErr.size());
        System.out.println("Ingest and purge test succeeded");
    }

    @Test
    public void testBatchBuildAndBatchIngestAndPurge() throws Exception {
        System.out.println("Building batch objects");
        this.batchBuild(new File(RESOURCEBASE + "/templates/foxml-template.xml"), new File(RESOURCEBASE + "/batch-objs"), buildDir, new File(LOGDIR + "/build.log"));
        String err = sbErr.toString();
        Assert.assertEquals((String)err, (boolean)true, (err.indexOf("10 Fedora FOXML XML documents successfully created") != -1 ? 1 : 0) != 0);
        System.out.println("Ingesting batch objects");
        this.batchIngest(buildDir, new File(LOGDIR + "/junit_ingest.log"));
        err = sbErr.toString();
        Assert.assertTrue((String)("Response did not contain expected string re: objects successfully ingested: <reponse>" + err + "</reponse>"), (boolean)err.contains("10 objects successfully ingested into Fedora"));
        String[] batchObjs = new String[]{"test:0001", "test:0002", "test:0003", "test:0004", "test:0005", "test:0006", "test:0007", "test:0008", "test:0009", "test:0010"};
        System.out.println("Purging batch objects");
        TestCommandLineUtilities.purgeFast(batchObjs);
        System.out.println("Build and ingest test succeeded");
    }

    @Test
    public void testBatchBuildIngestAndPurge() throws Exception {
        System.out.println("Building and Ingesting batch objects");
        this.batchBuildIngest(new File(RESOURCEBASE + "/templates/foxml-template.xml"), new File(RESOURCEBASE + "/batch-objs"), buildDir, new File(LOGDIR + "/junit_buildingest.log"));
        String err = sbErr.toString();
        Assert.assertTrue((String)("Response did not contain expected string re: FOXML XML documents: <reponse>" + err + "</response>"), (boolean)err.contains("10 Fedora FOXML XML documents successfully created"));
        Assert.assertTrue((String)("Response did not contain expected string re: objects successfully ingested: <reponse>" + err + "</reponse"), (boolean)err.contains("10 objects successfully ingested into Fedora"));
        String[] batchObjs = new String[]{"test:0001", "test:0002", "test:0003", "test:0004", "test:0005", "test:0006", "test:0007", "test:0008", "test:0009", "test:0010"};
        System.out.println("Purging batch objects");
        TestCommandLineUtilities.purgeFast(batchObjs);
        System.out.println("Build/ingest test succeeded");
    }

    @Test
    public void testBatchModify() throws Exception {
        System.out.println("Running batch modify of objects");
        this.batchModify(new File(RESOURCEBASE + "/modify-batch-directives.xml"), new File(LOGDIR + "/junit_modify.log"));
        String out = sbOut.toString();
        String err = sbErr.toString();
        if (out.indexOf("25 modify directives successfully processed.") == -1) {
            System.out.println(" out = " + out);
            System.out.println(" err = " + err);
        }
        if (out.indexOf("25 modify directives successfully processed.") == -1) {
            System.err.println(out);
        }
        Assert.assertEquals((String)String.format("%s; %s", out, err), (boolean)false, (out.indexOf("25 modify directives successfully processed.") == -1 ? 1 : 0) != 0);
        Assert.assertEquals((String)String.format("%s; %s", out, err), (boolean)false, (out.indexOf("0 modify directives failed.") == -1 ? 1 : 0) != 0);
        System.out.println("Purging batch modify object");
        TestCommandLineUtilities.purgeFast("test:1002");
        System.out.println("Batch modify test succeeded");
    }

    @Test
    public void testBatchPurge() throws Exception {
        System.out.println("Batch purging objects from file containing PIDs");
        String base = System.getProperty("fcrepo-integrationtest-core.classes") != null ? System.getProperty("fcrepo-integrationtest-core.classes") : "src/test/resources/";
        this.batchBuildIngest(new File(RESOURCEBASE + "/templates/foxml-template.xml"), new File(RESOURCEBASE + "/batch-objs"), buildDir, new File(LOGDIR + "/junit_buildingest.log"));
        this.batchPurge(new File("/bogus/file"));
        String out = sbOut.toString();
        String err = sbErr.toString();
        Assert.assertTrue((String)("Response did not contain expected string re: java.io.FileNotFoundException: <response>" + err + "</response>"), (boolean)err.contains("java.io.FileNotFoundException"));
        this.batchPurge(new File(base + "/test-objects/test-batch-purge-file.txt"));
        out = sbOut.toString();
        err = sbErr.toString();
        Assert.assertTrue((String)("Response did not contain expected string re: objects successfully purged: <response>" + out + "</response>"), (boolean)out.contains("10 objects successfully purged."));
        this.batchPurge(new File(base + "/test-objects/test-batch-purge-file.txt"));
        out = sbOut.toString();
        err = sbErr.toString();
        Assert.assertTrue((String)("Response did not contain expected string re: Object not found in low-level storage: <response>" + err + "</response>"), (boolean)err.contains("Object not found in low-level storage"));
        Assert.assertTrue((String)("Response did not contain expected string re: objects successfully purged: <response>" + out + "</response>"), (boolean)out.contains("0 objects successfully purged."));
        System.out.println("Batch purge test succeeded");
    }

    @Test
    public void testExport() throws Exception {
        System.out.println("Testing fedora-export");
        System.out.println("Ingesting object test:1001");
        this.ingestFoxmlFile(new File(RESOURCEBASE + "/test1001.xml"));
        String out = sbOut.toString();
        String err = sbErr.toString();
        if (out.indexOf("Ingested pid: test:1001") == -1) {
            System.err.println("Command-line ingest failed: STDOUT='" + out + "', STDERR='" + err + "'");
        }
        Assert.assertEquals((boolean)true, (out.indexOf("Ingested pid: test:1001") != -1 ? 1 : 0) != 0);
        File outFile = new File(RESOURCEBASE + "/test_1001.xml");
        if (outFile.exists()) {
            outFile.delete();
        }
        System.out.println("Exporting object test:1001");
        this.exportObj("test:1001", new File(RESOURCEBASE));
        out = sbOut.toString();
        err = sbErr.toString();
        Assert.assertEquals((out.indexOf("Exported test:1001") != -1 ? 1 : 0) != 0, (boolean)true);
        File outFile2 = new File(RESOURCEBASE + "/test_1001.xml");
        Assert.assertEquals((boolean)outFile2.exists(), (boolean)true);
        System.out.println("Deleting exported file");
        if (outFile2.exists()) {
            outFile2.delete();
        }
        TestCommandLineUtilities.purgeFast("test:1001");
        System.out.println("Export test succeeded");
    }

    @Test
    public void testValidatePolicy() {
        System.out.println("Testing Validate Policies");
        String base = System.getProperty("fcrepo-integrationtest-core.classes") != null ? System.getProperty("fcrepo-integrationtest-core.classes") : "src/test/resources/";
        File validDir = new File(base + "XACMLTestPolicies/valid-policies");
        this.traverseAndValidate(validDir, true);
        File invalidDir = new File(base + "XACMLTestPolicies/invalid-policies");
        this.traverseAndValidate(invalidDir, false);
        System.out.println("Validate Policies test succeeded");
    }

    @Test
    public void testFindObjects() {
        System.out.println("Testing Find Objects");
        TestCommandLineUtilities.execute(FEDORA_HOME + "/client/bin/fedora-find", TestCommandLineUtilities.getHost(), TestCommandLineUtilities.getPort(), TestCommandLineUtilities.getUsername(), TestCommandLineUtilities.getPassword(), "pid", "model", "http", TestCommandLineUtilities.getFedoraAppServerContext());
        Assert.assertEquals((String)("Expected empty STDERR output, got '" + sbErr.toString() + "'"), (int)0, (int)sbErr.size());
        String out = sbOut.toString();
        Assert.assertNotNull((Object)out);
        Assert.assertTrue((boolean)out.contains("#1"));
    }

    private void traverseAndValidate(File testDir, boolean expectValid) {
        File[] testFiles;
        for (File element : testFiles = testDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (name.toLowerCase().startsWith("permit") || name.toLowerCase().startsWith("deny")) && name.endsWith(".xml");
            }
        })) {
            System.out.println("Checking " + (expectValid ? "valid" : "invalid") + " policy: " + element.getName());
            TestCommandLineUtilities.execute(FEDORA_HOME + "/server/bin/validate-policy", element.getAbsolutePath());
            String out = sbOut.toString();
            if (expectValid) {
                Assert.assertTrue((String)("Expected \"Validation successful\", but received \"" + out + "\""), (out.indexOf("Validation successful") != -1 ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((String)("Expected \"Validation failed\", but received \"" + out + "\""), (out.indexOf("Validation failed") != -1 ? 1 : 0) != 0);
        }
    }

    private void ingestFoxmlFile(File f) {
        TestCommandLineUtilities.execute(FEDORA_HOME + "/client/bin/fedora-ingest", "f", f.getAbsolutePath(), TestCommandLineUtilities.FOXML1_1.uri, TestCommandLineUtilities.getHost() + ":" + TestCommandLineUtilities.getPort(), TestCommandLineUtilities.getUsername(), TestCommandLineUtilities.getPassword(), TestCommandLineUtilities.getProtocol(), "junit-ingest", TestCommandLineUtilities.getFedoraAppServerContext());
    }

    private static void purgeUsingScript(String pid) {
        TestCommandLineUtilities.execute(FEDORA_HOME + "/client/bin/fedora-purge", TestCommandLineUtilities.getHost() + ":" + TestCommandLineUtilities.getPort(), TestCommandLineUtilities.getUsername(), TestCommandLineUtilities.getPassword(), pid, TestCommandLineUtilities.getProtocol(), "junit-purge", TestCommandLineUtilities.getFedoraAppServerContext());
    }

    private static void purgeFast(String pid) throws Exception {
        TestCommandLineUtilities.getAPIM().purgeObject(pid, "because", false);
    }

    private static void purgeFast(String[] pids) throws Exception {
        FedoraAPIMMTOM apim = TestCommandLineUtilities.getAPIM();
        for (String element : pids) {
            apim.purgeObject(element, "because", false);
        }
    }

    private static FedoraAPIMMTOM getAPIM() throws Exception {
        FedoraAPIMMTOM result = s_client.getAPIMMTOM();
        return result;
    }

    private void batchBuild(File objectTemplateFile, File objectSpecificDir, File objectDir, File logFile) {
        TestCommandLineUtilities.execute(FEDORA_HOME + "/client/bin/fedora-batch-build", objectTemplateFile.getAbsolutePath(), objectSpecificDir.getAbsolutePath(), objectDir.getAbsolutePath(), logFile.getAbsolutePath(), "text");
    }

    private void batchIngest(File objectDir, File logFile) {
        TestCommandLineUtilities.execute(FEDORA_HOME + "/client/bin/fedora-batch-ingest", objectDir.getAbsolutePath(), logFile.getAbsolutePath(), "text", TestCommandLineUtilities.FOXML1_1.uri, TestCommandLineUtilities.getHost() + ":" + TestCommandLineUtilities.getPort(), TestCommandLineUtilities.getUsername(), TestCommandLineUtilities.getPassword(), TestCommandLineUtilities.getProtocol(), TestCommandLineUtilities.getFedoraAppServerContext());
    }

    private void batchBuildIngest(File objectTemplateFile, File objectSpecificDir, File objectDir, File logFile) {
        TestCommandLineUtilities.execute(FEDORA_HOME + "/client/bin/fedora-batch-buildingest", objectTemplateFile.getAbsolutePath(), objectSpecificDir.getAbsolutePath(), objectDir.getAbsolutePath(), logFile.getAbsolutePath(), "text", TestCommandLineUtilities.getHost() + ":" + TestCommandLineUtilities.getPort(), TestCommandLineUtilities.getUsername(), TestCommandLineUtilities.getPassword(), TestCommandLineUtilities.getProtocol(), TestCommandLineUtilities.getFedoraAppServerContext());
    }

    private void batchPurge(File objectPurgeFile) {
        TestCommandLineUtilities.execute(FEDORA_HOME + "/client/bin/fedora-purge", TestCommandLineUtilities.getHost() + ":" + TestCommandLineUtilities.getPort(), TestCommandLineUtilities.getUsername(), TestCommandLineUtilities.getPassword(), objectPurgeFile.getAbsoluteFile().toURI().toString(), TestCommandLineUtilities.getProtocol(), "because", TestCommandLineUtilities.getFedoraAppServerContext());
    }

    private void batchModify(File batchDirectives, File logFile) {
        TestCommandLineUtilities.execute(FEDORA_HOME + "/client/bin/fedora-modify", TestCommandLineUtilities.getHost() + ":" + TestCommandLineUtilities.getPort(), TestCommandLineUtilities.getUsername(), TestCommandLineUtilities.getPassword(), batchDirectives.getAbsolutePath(), logFile.getAbsolutePath(), TestCommandLineUtilities.getProtocol(), "validate-only-option", TestCommandLineUtilities.getFedoraAppServerContext());
    }

    private void exportObj(String pid, File dir) {
        TestCommandLineUtilities.execute(FEDORA_HOME + "/client/bin/fedora-export", TestCommandLineUtilities.getHost() + ":" + TestCommandLineUtilities.getPort(), TestCommandLineUtilities.getUsername(), TestCommandLineUtilities.getPassword(), pid, TestCommandLineUtilities.FOXML1_1.uri, "public", dir.getAbsolutePath(), TestCommandLineUtilities.getProtocol(), TestCommandLineUtilities.getFedoraAppServerContext());
    }

    public static void execute(String ... cmd) {
        String osName = System.getProperty("os.name");
        if (!osName.startsWith("Windows")) {
            cmd[0] = cmd[0] + ".sh";
        }
        if (sbOut != null && sbErr != null) {
            sbOut.reset();
            sbErr.reset();
            ExecUtility.execCommandLineUtility((String[])cmd, (OutputStream)sbOut, (OutputStream)sbErr);
        } else {
            ExecUtility.execCommandLineUtility((String[])cmd);
        }
    }

    @Before
    public void setUp() throws Exception {
        sbOut = new ByteArrayOutputStream();
        sbErr = new ByteArrayOutputStream();
        System.out.println("Creating temporary build and log directories");
        buildDir = new File(BUILDDIR);
        if (!buildDir.exists()) {
            buildDir.mkdir();
        }
        if (!(logDir = new File(LOGDIR)).exists()) {
            logDir.mkdir();
        }
    }

    @After
    public void tearDown() throws Exception {
        File entry;
        int i;
        String[] list;
        System.out.println("Deleting temporary build and log directories");
        if (buildDir.exists() && buildDir.isDirectory()) {
            list = buildDir.list();
            if (list != null) {
                for (i = 0; i < list.length; ++i) {
                    entry = new File(buildDir, list[i]);
                    entry.delete();
                }
            }
            buildDir.delete();
        }
        if (logDir.exists() && logDir.isDirectory()) {
            list = logDir.list();
            if (list != null) {
                for (i = 0; i < list.length; ++i) {
                    entry = new File(logDir, list[i]);
                    entry.delete();
                }
            }
            logDir.delete();
        }
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestCommandLineUtilities.class);
    }

    public static void main(String[] args) {
        JUnitCore.runClasses((Class[])new Class[]{TestCommandLineUtilities.class});
    }

    static {
        RESOURCEBASE = System.getProperty("fcrepo-integrationtest-core.classes") != null ? System.getProperty("fcrepo-integrationtest-core.classes") + "test-objects/foxml/cli-utils" : "src/test/resources/test-objects/foxml/cli-utils";
        LOGDIR = RESOURCEBASE + "/logs";
        BUILDDIR = RESOURCEBASE + "/temp";
        logDir = null;
        buildDir = null;
    }
}

