/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.transform.TransformerFactory;
import junit.framework.Assert;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.common.FedoraTestConstants;
import org.fcrepo.server.config.ServerConfiguration;
import org.fcrepo.server.config.ServerConfigurationParser;

public abstract class FedoraTestCase
implements FedoraTestConstants {
    public static String ssl = "http";

    public FedoraTestCase() {
        TransformerFactory factory = XMLUnit.getTransformerFactory();
        if (factory.getClass().getName().equals("net.sf.saxon.TransformerFactoryImpl")) {
            factory.setAttribute("http://saxon.sf.net/feature/version-warning", Boolean.FALSE);
        }
    }

    public FedoraTestCase(String name) {
        TransformerFactory factory = XMLUnit.getTransformerFactory();
        if (factory.getClass().getName().equals("net.sf.saxon.TransformerFactoryImpl")) {
            factory.setAttribute("http://saxon.sf.net/feature/version-warning", Boolean.FALSE);
        }
    }

    public static ServerConfiguration getServerConfiguration() {
        try {
            return new ServerConfigurationParser((InputStream)new FileInputStream(FCFG)).parse();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    public static String getDemoBaseURL() {
        if (System.getProperty("fedora.baseURLDemo") != null) {
            return System.getProperty("fedora.baseURLDemo");
        }
        return FedoraTestCase.getProtocol() + "://" + FedoraTestCase.getHost() + ":" + FedoraTestCase.getPort() + "/" + FedoraTestCase.getDemoAppServerContext();
    }

    public static String getBaseURL() {
        if (System.getProperty("fedora.baseURL") != null) {
            return System.getProperty("fedora.baseURL");
        }
        return FedoraTestCase.getProtocol() + "://" + FedoraTestCase.getHost() + ":" + FedoraTestCase.getPort() + "/" + FedoraTestCase.getFedoraAppServerContext();
    }

    public static String getHost() {
        return FedoraTestCase.getServerConfiguration().getParameter("fedoraServerHost");
    }

    public static String getPort() {
        String port = null;
        port = FedoraTestCase.getProtocol().equals("http") ? FedoraTestCase.getServerConfiguration().getParameter("fedoraServerPort") : FedoraTestCase.getServerConfiguration().getParameter("fedoraRedirectPort");
        return port;
    }

    public static String getFedoraAppServerContext() {
        if (System.getProperty("fedoraAppServerContext") != null) {
            return System.getProperty("fedoraAppServerContext");
        }
        return FedoraTestCase.getServerConfiguration().getParameter("fedoraAppServerContext");
    }

    public static String getDemoAppServerContext() {
        return FedoraTestCase.getServerConfiguration().getParameter("fedoraDemoAppServerContext") != null ? FedoraTestCase.getServerConfiguration().getParameter("fedoraDemoAppServerContext") : "fedora-demo";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProtocol() {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(BESECURITY)));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.indexOf("role=\"fedoraInternalCall-1\"") <= 0 || line.indexOf("callSSL=\"true\"") <= 0) continue;
                ssl = "https";
                break;
            }
        }
        catch (Exception e) {
            System.out.println("fedora.home: " + FEDORA_HOME);
            Assert.fail((String)("beSecurity file Not found: " + BESECURITY.getAbsolutePath()));
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                    br = null;
                }
            }
            catch (Exception e) {
                System.out.println("Unable to close BufferdReader");
            }
        }
        return ssl;
    }

    public static String getUsername() {
        return FEDORA_USERNAME;
    }

    public static String getPassword() {
        return FEDORA_PASSWORD;
    }

    public static FedoraClient getFedoraClient() throws Exception {
        return FedoraTestCase.getFedoraClient(FedoraTestCase.getBaseURL(), FedoraTestCase.getUsername(), FedoraTestCase.getPassword());
    }

    public static FedoraClient getFedoraClient(String baseURL, String username, String password) throws Exception {
        return new FedoraClient(baseURL, username, password);
    }
}

