/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.xml.ws.soap.SOAPFaultException;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import org.apache.cxf.binding.soap.SoapFault;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.server.access.FedoraAPIAMTOM;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.server.security.servletfilters.xmluserfile.FedoraUsers;
import org.fcrepo.server.types.gen.ArrayOfString;
import org.fcrepo.server.types.mtom.gen.GetDissemination;
import org.fcrepo.server.utilities.ServerUtility;
import org.fcrepo.server.utilities.StreamUtility;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.test.FedoraServerTestCase;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class TestXACMLPolicies
extends FedoraServerTestCase {
    private static FedoraClient s_client;
    private FedoraClient admin;
    private FedoraClient testuser1;
    private FedoraClient testuserroleA;
    private FedoraClient testuser2;
    private FedoraClient testuser3;
    private FedoraClient testuserroleB;
    private FedoraClient testuserroleC;
    private FedoraClient testuserroleC2;
    private FedoraClient testuser4;
    private File fedoraUsersBackup = null;

    @BeforeClass
    public static void bootstrap() throws Exception {
        s_client = TestXACMLPolicies.getFedoraClient();
        TestXACMLPolicies.ingestImageManipulationDemoObjects(s_client);
        TestXACMLPolicies.ingestSimpleDocumentDemoObjects(s_client);
        TestXACMLPolicies.ingestSimpleImageDemoObjects(s_client);
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        TestXACMLPolicies.purgeDemoObjects(s_client);
        s_client.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXACMLMultiOwnerAccess() throws Exception {
        String pid = "test:MultiOwnerObject";
        String owners = "fedoraAdmin,testuser1";
        String[] nullModels = null;
        this.addTestObject("test:MultiOwnerObject", "fedoraAdmin,testuser1", nullModels);
        try {
            Assert.assertTrue((boolean)this.canWrite(this.admin, "test:MultiOwnerObject", "testXACMLMultiOwnerAccess"));
            Assert.assertTrue((boolean)this.canWrite(this.testuser1, "test:MultiOwnerObject", "testXACMLMultiOwnerAccess"));
            Assert.assertFalse((boolean)this.canWrite(this.testuserroleA, "test:MultiOwnerObject", "testXACMLMultiOwnerAccess"));
        }
        finally {
            this.removeTestObject("test:MultiOwnerObject");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXACMLUnmodifiableContentModel() throws Exception {
        String unrestrictedCModel = "test:UnrestrictedCModel";
        String restrictedCModel = "test:RestrictedCModel";
        String hasUnrestricted = "test:HasUnrestrictedCModel";
        this.addTestObject("test:HasUnrestrictedCModel", null, "test:UnrestrictedCModel");
        String hasRestricted = "test:HasRestrictedCModel";
        this.addTestObject("test:HasRestrictedCModel", null, "test:RestrictedCModel");
        String hasUnrestrictedAndRestricted = "test:HasUnrestrictedAndRestrictedCModel";
        this.addTestObject("test:HasUnrestrictedAndRestrictedCModel", null, "test:UnrestrictedCModel", "test:RestrictedCModel");
        String hasRestrictedAndUnrestricted = "test:HasRestrictedAndUnrestrictedCModel";
        this.addTestObject("test:HasRestrictedAndUnrestrictedCModel", null, "test:RestrictedCModel", "test:UnrestrictedCModel");
        try {
            Assert.assertTrue((boolean)this.canWrite(this.admin, "test:HasUnrestrictedCModel", "testXACMLUnmodifiableContentModel"));
            Assert.assertFalse((boolean)this.canWrite(this.admin, "test:HasRestrictedCModel", "testXACMLUnmodifiableContentModel"));
            Assert.assertFalse((boolean)this.canWrite(this.admin, "test:HasUnrestrictedAndRestrictedCModel", "testXACMLUnmodifiableContentModel"));
            Assert.assertFalse((boolean)this.canWrite(this.admin, "test:HasRestrictedAndUnrestrictedCModel", "testXACMLUnmodifiableContentModel"));
        }
        finally {
            this.removeTestObject("test:HasUnrestrictedCModel");
            this.removeTestObject("test:HasRestrictedCModel");
            this.removeTestObject("test:HasUnrestrictedAndRestrictedCModel");
            this.removeTestObject("test:HasRestrictedAndUnrestrictedCModel");
        }
    }

    private boolean canWrite(FedoraClient client, String pid, String logMessage) throws Exception {
        FedoraAPIMMTOM apim = client.getAPIMMTOM();
        try {
            apim.modifyObject(pid, null, null, null, logMessage);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Test
    public void testXACMLAPIMAccess() throws Exception {
        String dateOfFirstSuccess = null;
        String dateOfSecondSuccess = null;
        String dateOfThirdSuccess = null;
        String dateOfFourthSuccess = null;
        String URL1 = TestXACMLPolicies.getDemoBaseURL() + "/simple-image-demo/col1.jpg";
        String URL2 = TestXACMLPolicies.getDemoBaseURL() + "/simple-image-demo/col2.jpg";
        String URL3 = TestXACMLPolicies.getDemoBaseURL() + "/simple-image-demo/col3.jpg";
        Class[] modDSArgs = new Class[]{String.class, String.class, ArrayOfString.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Boolean.TYPE};
        Object[] modDSParms1 = new Object[]{"demo:5", "THUMBRES_IMG", null, null, null, null, null, null, null, null, false};
        Class[] purgeDSArgs = new Class[]{String.class, String.class, String.class, String.class, String.class, Boolean.TYPE};
        Object[] purgeDSParms1 = new Object[]{"demo:5", "THUMBRES_IMG", null, null, null, false};
        Class[] setVersionableArgs = new Class[]{String.class, String.class, Boolean.TYPE, String.class};
        Object[] setVersionableFalse = new Object[]{"demo:5", "THUMBRES_IMG", Boolean.FALSE, null};
        Object[] setVersionableTrue = new Object[]{"demo:5", "THUMBRES_IMG", Boolean.TRUE, null};
        this.invokeAPIMFailure(this.testuserroleA, "testuserroleA", "modifyDatastreamByReference", modDSArgs, modDSParms1);
        modDSParms1[6] = URL1;
        dateOfFirstSuccess = this.invokeAPIMSuccessString(this.testuser1, "testuser1", "modifyDatastreamByReference", modDSArgs, modDSParms1);
        System.out.println("    URL = " + modDSParms1[6]);
        Assert.assertTrue((dateOfFirstSuccess != null ? 1 : 0) != 0);
        System.out.println("  Modify datastream from testuser1 succeeded.");
        System.out.println("Disabling versioning.");
        this.invokeAPIMSuccess(this.admin, "admin", "setDatastreamVersionable", setVersionableArgs, setVersionableFalse);
        modDSParms1[6] = URL2;
        System.out.println("Testing modify datastream from admin with versioning off.");
        dateOfSecondSuccess = this.invokeAPIMSuccessString(this.admin, "admin", "modifyDatastreamByReference", modDSArgs, modDSParms1);
        System.out.println("    URL = " + modDSParms1[6]);
        Assert.assertTrue((dateOfSecondSuccess != null ? 1 : 0) != 0);
        System.out.println("  Modify datastream from admin succeeded.");
        modDSParms1[6] = null;
        modDSParms1[3] = "The Colliseum with Graffiti";
        System.out.println("Testing modify datastream from admin with versioning off just changing label.");
        dateOfThirdSuccess = this.invokeAPIMSuccessString(this.admin, "admin", "modifyDatastreamByReference", modDSArgs, modDSParms1);
        System.out.println("    Label = " + modDSParms1[3]);
        Assert.assertTrue((dateOfThirdSuccess != null ? 1 : 0) != 0);
        System.out.println("  Modify datastream from admin succeeded.");
        System.out.println("Re-enabling versioning.");
        this.invokeAPIMSuccess(this.admin, "admin", "setDatastreamVersionable", setVersionableArgs, setVersionableTrue);
        modDSParms1[6] = URL3;
        modDSParms1[3] = null;
        dateOfFourthSuccess = this.invokeAPIMSuccessString(this.testuser1, "testuser1", "modifyDatastreamByReference", modDSArgs, modDSParms1);
        System.out.println("    URL = " + modDSParms1[6]);
        Assert.assertTrue((dateOfFourthSuccess != null ? 1 : 0) != 0);
        System.out.println("  Modify datastream from testuser1 succeeded.");
        purgeDSParms1[2] = dateOfFirstSuccess;
        purgeDSParms1[3] = dateOfFourthSuccess;
        this.invokeAPIMFailure(this.testuser1, "testuser1", "purgeDatastream", purgeDSArgs, purgeDSParms1);
        this.invokeAPIMFailure(this.testuserroleA, "testuserroleA", "purgeDatastream", purgeDSArgs, purgeDSParms1);
        String[] purged = this.invokeAPIMSuccessStringArray(this.admin, "admin", "purgeDatastream", purgeDSArgs, purgeDSParms1);
        System.out.println("    Checking number of versions purged.");
        Assert.assertEquals((int)purged.length, (int)2);
        System.out.println("    Checking dates of versions purged.");
        Assert.assertEquals((String)purged[0], (String)dateOfThirdSuccess);
        Assert.assertEquals((String)purged[1], (String)dateOfFourthSuccess);
        System.out.println("Purge Datastreams successful.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXACMLAPIAAccess() throws Exception {
        if (this.isAPIAAuthzOn()) {
            Class[] getDDArgs = new Class[]{String.class, String.class, String.class};
            Object[] getDDParms = new Object[]{"demo:5", "THUMBRES_IMG", null};
            Object[] getDDParms2 = new Object[]{"demo:29", "url", null};
            Object[] getDDParms3 = new Object[]{"demo:31", "DS1", null};
            Object[] getDDParms4 = new Object[]{"demo:ObjSpecificTest", "DC", null};
            Class[] getDissArgs = new Class[]{String.class, String.class, String.class, GetDissemination.Parameters.class, String.class};
            Object[] getDissParms = new Object[]{"demo:5", "demo:1", "getHigh", null, null};
            Object[] getDissParms2 = new Object[]{"demo:29", "demo:27", "grayscaleImage", null, null};
            Object[] getDissParms3 = new Object[]{"demo:5", "demo:1", "getVeryHigh", null, null};
            Class[] modObjArgs = new Class[]{String.class, String.class, String.class, String.class, String.class};
            Object[] modObjParms = new Object[]{"demo:31", null, null, null, null};
            this.invokeAPIAFailure(this.testuser2, "testuser2", "getDatastreamDissemination", getDDArgs, getDDParms);
            this.invokeAPIAFailure(this.testuser3, "testuser3", "getDatastreamDissemination", getDDArgs, getDDParms);
            this.invokeAPIAFailure(this.testuserroleB, "testuserroleB", "getDissemination", getDissArgs, getDissParms);
            this.invokeAPIAFailure(this.testuser4, "testuser4", "getDatastreamDissemination", getDDArgs, getDDParms2);
            this.invokeAPIAFailure(this.testuser4, "testuser4", "getDissemination", getDissArgs, getDissParms2);
            this.invokeAPIAFailure(this.testuserroleC, "testuserroleC", "getDissemination", getDissArgs, getDissParms3);
            this.invokeAPIAFailure(this.testuser1, "testuser1", "getDatastreamDissemination", getDDArgs, getDDParms2);
            this.invokeAPIASuccess(this.testuserroleC, "testuserroleC", "getDatastreamDissemination", getDDArgs, getDDParms2);
            this.addObjectSpecificPolicies();
            try {
                this.invokeAPIASuccess(this.testuserroleC, "testuserroleC", "getDatastreamDissemination", getDDArgs, getDDParms4);
                this.invokeAPIAFailure(this.testuserroleC2, "testuserroleC2", "getDatastreamDissemination", getDDArgs, getDDParms4);
            }
            finally {
                this.removeObjectSpecificPolicies();
            }
            this.invokeAPIASuccess(this.testuser1, "testuser1", "getDatastreamDissemination", getDDArgs, getDDParms);
            this.invokeAPIAFailure(this.testuser1, "testuser1", "getDatastreamDissemination", getDDArgs, getDDParms3);
            modObjParms[3] = "testuser1";
            String dateOfSuccess = this.invokeAPIMSuccessString(this.admin, "fedoraAdmin", "modifyObject", modObjArgs, modObjParms);
            Assert.assertTrue((dateOfSuccess != null ? 1 : 0) != 0);
            System.out.println("  Modify Object from admin succeeded.");
            this.invokeAPIASuccess(this.testuser1, "testuser1", "getDatastreamDissemination", getDDArgs, getDDParms3);
            modObjParms[3] = "fedoraAdmin";
            dateOfSuccess = this.invokeAPIMSuccessString(this.admin, "fedoraAdmin", "modifyObject", modObjArgs, modObjParms);
            Assert.assertTrue((dateOfSuccess != null ? 1 : 0) != 0);
            System.out.println("  Modify Object from admin succeeded.");
        } else {
            System.out.println("Authorization is not enabled for APIA");
            System.out.println("Testing Policies for APIA access will not work.");
        }
    }

    public void invokeAPIMFailure(FedoraClient user, String username, String functionToTest, Class<?>[] args, Object[] parms) {
        try {
            System.out.println("Testing " + functionToTest + " from invalid user: " + username);
            FedoraAPIMMTOM apim1 = user.getAPIMMTOM();
            Method func = apim1.getClass().getMethod(functionToTest, args);
            func.invoke((Object)apim1, parms);
            Assert.fail((String)"Illegal access allowed");
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof SOAPFaultException) {
                SOAPFaultException af = (SOAPFaultException)cause;
                System.out.println("    Reason = " + af.getMessage());
                Assert.assertTrue((String)af.getMessage(), (boolean)af.getMessage().contains("Authorization Denied"));
                System.out.println("Access denied correctly");
            } else {
                System.out.println("Got exception: " + cause.getClass().getName());
                Assert.fail((String)("Illegal access dis-allowed for some other reason: " + cause.getClass().getName()));
            }
        }
        catch (IOException ioe) {
            System.out.println("    Reason = " + ioe.getMessage());
            Assert.assertTrue((boolean)ioe.getMessage().contains("[403 Forbidden]"));
            System.out.println("Access denied correctly");
        }
        catch (Exception ae) {
            String message = "Some other exception: " + ae.toString();
            System.out.println(message);
            Assert.fail((String)message);
        }
    }

    public String invokeAPIMSuccessString(FedoraClient user, String username, String functionToTest, Class<?>[] args, Object[] parms) {
        Object result = this.invokeAPIMSuccess(user, username, functionToTest, args, parms);
        return (String)result;
    }

    public String[] invokeAPIMSuccessStringArray(FedoraClient user, String username, String functionToTest, Class<?>[] args, Object[] parms) {
        Object result = this.invokeAPIMSuccess(user, username, functionToTest, args, parms);
        return ((ArrayList)result).toArray(new String[0]);
    }

    public Object invokeAPIMSuccess(FedoraClient user, String username, String functionToTest, Class<?>[] args, Object[] parms) {
        try {
            System.out.println("Testing " + functionToTest + " from valid user: " + username);
            FedoraAPIMMTOM apim1 = user.getAPIMMTOM();
            Method func = apim1.getClass().getMethod(functionToTest, args);
            Object result = func.invoke((Object)apim1, parms);
            Assert.assertTrue((result != null ? 1 : 0) != 0);
            return result;
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof SoapFault) {
                SoapFault af = (SoapFault)cause;
                System.out.println("Got exception: " + af.getClass().getName());
                System.out.println("Reason = " + af.getReason());
                System.out.println("Message = " + af.getMessage());
                Assert.fail((String)"Legal access dis-allowed");
            } else {
                System.out.println("Got exception: " + cause.getClass().getName());
                Assert.fail((String)"Legal access dis-allowed");
            }
        }
        catch (Exception e) {
            System.out.println("Got exception: " + e.getClass().getName());
            Assert.fail((String)"Legal access dis-allowed");
        }
        return null;
    }

    public void invokeAPIAFailure(FedoraClient user, String username, String functionToTest, Class<?>[] args, Object[] parms) {
        try {
            System.out.println("Testing " + functionToTest + " from invalid user: " + username);
            FedoraAPIAMTOM apia1 = user.getAPIAMTOM();
            Method func = apia1.getClass().getMethod(functionToTest, args);
            func.invoke((Object)apia1, parms);
            Assert.fail((String)"Illegal access allowed");
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof SOAPFaultException) {
                SOAPFaultException sfe = (SOAPFaultException)cause;
                System.out.println("    Reason = " + sfe.getMessage());
                Assert.assertTrue((String)sfe.getMessage(), (boolean)sfe.getMessage().contains("Authorization Denied"));
                System.out.println("Access denied correctly");
            } else {
                String message = "Got exception: " + cause.getClass().getName();
                System.out.println(message);
                Assert.fail((String)("Illegal access dis-allowed for some other reason: " + message));
            }
        }
        catch (IOException ioe) {
            System.out.println("    Reason = " + ioe.getMessage().substring(ioe.getMessage().lastIndexOf("[")));
            Assert.assertTrue((boolean)ioe.getMessage().contains("[403 Forbidden]"));
            System.out.println("Access denied correctly");
        }
        catch (Exception ae) {
            String message = "Some other exception: " + ae.toString();
            System.out.println(message);
            Assert.fail((String)("Illegal access dis-allowed for some other reason: " + message));
        }
    }

    public Object invokeAPIASuccess(FedoraClient user, String username, String functionToTest, Class<?>[] args, Object[] parms) {
        try {
            System.out.println("Testing " + functionToTest + " from valid user: " + username);
            FedoraAPIAMTOM apia1 = user.getAPIAMTOM();
            Method func = apia1.getClass().getMethod(functionToTest, args);
            Object result = func.invoke((Object)apia1, parms);
            Assert.assertTrue((result != null ? 1 : 0) != 0);
            System.out.println("Access succeeded");
            return result;
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof SoapFault) {
                SoapFault af = (SoapFault)cause;
                System.out.println("Got exception: " + af.getClass().getName());
                System.out.println("Reason = " + af.getReason());
                System.out.println("Message = " + af.getMessage());
                Assert.fail((String)"Legal access dis-allowed");
            } else {
                System.out.println("Got exception: " + cause.getClass().getName());
                Assert.fail((String)"Legal access dis-allowed");
            }
        }
        catch (Exception e) {
            System.out.println("Got exception: " + e.getClass().getName());
            Assert.fail((String)"Legal access dis-allowed");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAPIAAuthzOn() throws IOException {
        File installProperties = new File(FEDORA_HOME, "install/install.properties");
        BufferedReader prop = null;
        try {
            prop = new BufferedReader(new FileReader(installProperties));
            String line = null;
            while ((line = prop.readLine()) != null) {
                if (!line.startsWith("apia.auth.required")) continue;
                if (line.equals("apia.auth.required=true")) {
                    boolean bl = true;
                    return bl;
                }
                if (!line.equals("apia.auth.required=false")) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (prop != null) {
                prop.close();
            }
        }
    }

    public void installJunitPolicies() {
        String base = System.getProperty("fcrepo-integrationtest-core.classes") != null ? System.getProperty("fcrepo-integrationtest-core.classes") : "src/test/resources/";
        File junitDir = new File(base + "XACMLTestPolicies/junit");
        System.out.println("Copying Policies For Testing from " + junitDir.getAbsolutePath());
        File junitsaveDir = new File(FEDORA_HOME, "data/fedora-xacml-policies/repository-policies/junit");
        if (!junitsaveDir.exists()) {
            junitsaveDir.mkdir();
        }
        File[] list = this.getFilesInDir(junitDir);
        this.traverseAndCopy(list, junitsaveDir);
        System.out.println("Copying Policies succeeded");
    }

    private void deleteJunitPolicies() {
        System.out.println("Removing Policies For Testing");
        File junitsaveDir = new File(FEDORA_HOME, "data/fedora-xacml-policies/repository-policies/junit");
        if (junitsaveDir.exists()) {
            File[] list = this.getFilesInDir(junitsaveDir);
            this.traverseAndDelete(list);
            junitsaveDir.delete();
        }
    }

    private File[] getFilesInDir(File dir) {
        File[] srcFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (name.toLowerCase().startsWith("permit") || name.toLowerCase().startsWith("deny")) && name.endsWith(".xml");
            }
        });
        return srcFiles;
    }

    private void traverseAndCopy(File[] srcFiles, File destDir) {
        for (File element : srcFiles) {
            File destFile = new File(destDir, element.getName());
            System.out.println("Copying policy: " + element.getName());
            if (!destFile.exists()) {
                try {
                    destFile.createNewFile();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.copyFile(element, destFile);
        }
    }

    private void traverseAndDelete(File[] newFiles) {
        for (File element : newFiles) {
            System.out.println("Deleting policy: " + element.getName());
            element.delete();
        }
    }

    private boolean copyFile(File src, File dest) {
        try {
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dest);
            StreamUtility.pipeStream((InputStream)in, (OutputStream)out, (int)1024);
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void reloadPolicies() {
        System.out.println("Reloading Policies...");
        try {
            FedoraClient client = new FedoraClient(ServerUtility.getBaseURL((String)TestXACMLPolicies.getProtocol()), TestXACMLPolicies.getUsername(), TestXACMLPolicies.getPassword());
            client.reloadPolicies();
            System.out.println("  Done Reloading Policies");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void backupFedoraUsersFile() {
        File srcFile = FedoraUsers.fedoraUsersXML;
        this.fedoraUsersBackup = new File(srcFile.getAbsolutePath() + ".backup");
        System.out.println("Backing Up Fedora Users");
        if (!this.fedoraUsersBackup.exists()) {
            try {
                this.fedoraUsersBackup.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.copyFile(srcFile, this.fedoraUsersBackup);
    }

    private void restoreFedoraUsersFile() {
        System.out.println("Restoring Fedora Users");
        if (!this.fedoraUsersBackup.exists()) {
            return;
        }
        File destFile = FedoraUsers.fedoraUsersXML;
        this.copyFile(this.fedoraUsersBackup, destFile);
    }

    private void createNewFedoraUsersFileWithTestUsers() {
        String sep = System.getProperty("line.seperator");
        if (sep == null) {
            sep = "\n";
        }
        String data = "<?xml version='1.0' ?>  " + sep + "<fedora-users>" + sep + "    <user name=\"" + TestXACMLPolicies.getUsername() + "\" password=\"" + TestXACMLPolicies.getPassword() + "\">" + sep + "      <attribute name=\"fedoraRole\">" + sep + "        <value>administrator</value>" + sep + "      </attribute>" + sep + "    </user>" + sep + "    <user name=\"fedoraIntCallUser\" password=\"changeme\">" + sep + "      <attribute name=\"fedoraRole\">" + sep + "        <value>fedoraInternalCall-1</value>" + sep + "        <value>fedoraInternalCall-2</value>" + sep + "      </attribute>" + sep + "    </user>" + sep + "    <user name=\"testuser1\" password=\"testuser1\"/>" + sep + "    <user name=\"testuser2\" password=\"testuser2\"/>" + sep + "    <user name=\"testuser3\" password=\"testuser3\"/>" + sep + "    <user name=\"testuser4\" password=\"testuser4\"/>" + sep + "    <user name=\"testuserroleA\" password=\"testuserroleA\">" + sep + "      <attribute name=\"fedoraRole\">" + sep + "        <value>roleA</value>" + sep + "      </attribute>" + sep + "    </user>" + sep + "    <user name=\"testuserroleB\" password=\"testuserroleB\">" + sep + "      <attribute name=\"fedoraRole\">" + sep + "        <value>roleB</value>" + sep + "      </attribute>" + sep + "    </user>" + sep + "    <user name=\"testuserroleC\" password=\"testuserroleC\">" + sep + "      <attribute name=\"fedoraRole\">" + sep + "        <value>roleC</value>" + sep + "      </attribute>" + sep + "    </user>" + sep + "    <user name=\"testuserroleC2\" password=\"testuserroleC2\">" + sep + "      <attribute name=\"fedoraRole\">" + sep + "        <value>roleC</value>" + sep + "        <value>roleUntrusted</value>" + sep + "      </attribute>" + sep + "    </user>" + sep + "  </fedora-users>";
        try {
            FileOutputStream fu = new FileOutputStream(FedoraUsers.fedoraUsersXML);
            OutputStreamWriter pw = new OutputStreamWriter(fu);
            pw.write(data);
            pw.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Before
    public void setUp() throws Exception {
        System.out.println("setting Up XACML test");
        this.admin = TestXACMLPolicies.getFedoraClient();
        this.backupFedoraUsersFile();
        this.createNewFedoraUsersFileWithTestUsers();
        this.installJunitPolicies();
        this.reloadPolicies();
        System.out.println("creating alternate users");
        this.testuser1 = new FedoraClient(TestXACMLPolicies.getBaseURL(), "testuser1", "testuser1");
        this.testuserroleA = new FedoraClient(TestXACMLPolicies.getBaseURL(), "testuserroleA", "testuserroleA");
        this.testuser2 = new FedoraClient(TestXACMLPolicies.getBaseURL(), "testuser2", "testuser2");
        this.testuser3 = new FedoraClient(TestXACMLPolicies.getBaseURL(), "testuser3", "testuser3");
        this.testuserroleB = new FedoraClient(TestXACMLPolicies.getBaseURL(), "testuserroleB", "testuserroleB");
        this.testuserroleC = new FedoraClient(TestXACMLPolicies.getBaseURL(), "testuserroleC", "testuserroleC");
        this.testuserroleC2 = new FedoraClient(TestXACMLPolicies.getBaseURL(), "testuserroleC2", "testuserroleC2");
        this.testuser4 = new FedoraClient(TestXACMLPolicies.getBaseURL(), "testuser4", "testuser4");
        System.out.println("done setting up");
    }

    private void addObjectSpecificPolicies() {
        try {
            StringBuffer xml = new StringBuffer();
            xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            xml.append("<foxml:digitalObject VERSION=\"1.1\" PID=\"demo:ObjSpecificTest\" xmlns:foxml=\"info:fedora/fedora-system:def/foxml#\">");
            xml.append("  <foxml:objectProperties>");
            xml.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#state\" VALUE=\"A\"/>");
            xml.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#label\" VALUE=\"ObjSpecificTest\"/>");
            xml.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#createdDate\" VALUE=\"2004-12-10T00:21:57Z\"/>");
            xml.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/view#lastModifiedDate\" VALUE=\"2004-12-10T00:21:57Z\"/>");
            xml.append("  </foxml:objectProperties>");
            xml.append("  <foxml:datastream ID=\"POLICY\" CONTROL_GROUP=\"X\" STATE=\"A\">");
            xml.append("    <foxml:datastreamVersion FORMAT_URI=\"" + TestXACMLPolicies.XACML_POLICY1_0.uri + "\" ID=\"POLICY1.0\" MIMETYPE=\"text/xml\" LABEL=\"Policy\">");
            xml.append("         <foxml:xmlContent>");
            xml.append("<Policy PolicyId=\"POLICY\" RuleCombiningAlgId=\"urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:first-applicable\"");
            xml.append("  xmlns=\"urn:oasis:names:tc:xacml:1.0:policy\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
            xml.append("  <Description>");
            xml.append("    Denies all to user with id testuserroleC2");
            xml.append("  </Description>");
            xml.append("  <Target>");
            xml.append("    <Subjects>");
            xml.append("      <AnySubject/>");
            xml.append("    </Subjects>");
            xml.append("    <Resources>");
            xml.append("      <AnyResource/>");
            xml.append("    </Resources>");
            xml.append("    <Actions>");
            xml.append("      <AnyAction/>");
            xml.append("    </Actions>");
            xml.append("  </Target>");
            xml.append("  <Rule Effect=\"Deny\" RuleId=\"1\">");
            xml.append("    <Condition FunctionId=\"urn:oasis:names:tc:xacml:1.0:function:string-is-in\">");
            xml.append("      <AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">roleUntrusted</AttributeValue>");
            xml.append("      <SubjectAttributeDesignator AttributeId=\"fedoraRole\"");
            xml.append("        DataType=\"http://www.w3.org/2001/XMLSchema#string\" MustBePresent=\"false\"/>");
            xml.append("    </Condition>");
            xml.append("  </Rule>");
            xml.append("</Policy>");
            xml.append("      </foxml:xmlContent>");
            xml.append("    </foxml:datastreamVersion>");
            xml.append("  </foxml:datastream>");
            xml.append("</foxml:digitalObject>");
            this.admin.getAPIMMTOM().ingest(TypeUtility.convertBytesToDataHandler((byte[])xml.toString().getBytes("UTF-8")), TestXACMLPolicies.FOXML1_1.uri, "");
        }
        catch (Exception e) {
            throw new RuntimeException("Failure adding object-specific policies", e);
        }
    }

    private void removeObjectSpecificPolicies() {
        try {
            this.admin.getAPIMMTOM().purgeObject("demo:ObjSpecificTest", "", false);
        }
        catch (Exception e) {
            throw new RuntimeException("Failure removing object-specific policies", e);
        }
    }

    private void addTestObject(String pid, String ownerId, String ... cModelPIDs) {
        try {
            StringBuffer xml = new StringBuffer();
            xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            xml.append("<foxml:digitalObject VERSION=\"1.1\" PID=\"" + pid + "\" xmlns:foxml=\"info:fedora/fedora-system:def/foxml#\">");
            xml.append("  <foxml:objectProperties>");
            if (ownerId != null && ownerId.trim().length() > 0) {
                xml.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#ownerId\" VALUE=\"");
                xml.append(ownerId.trim());
                xml.append("\"/>");
            }
            xml.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#state\" VALUE=\"A\"/>");
            xml.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#label\" VALUE=\"MultiOwnerObject\"/>");
            xml.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#createdDate\" VALUE=\"2004-12-10T00:21:57Z\"/>");
            xml.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/view#lastModifiedDate\" VALUE=\"2004-12-10T00:21:57Z\"/>");
            xml.append("  </foxml:objectProperties>");
            if (cModelPIDs != null) {
                xml.append("<foxml:datastream CONTROL_GROUP=\"X\" ID=\"RELS-EXT\">");
                xml.append("  <foxml:datastreamVersion CREATED=\"2008-07-02T05:09:43.375Z\" FORMAT_URI=\"info:fedora/fedora-system:FedoraRELSExt-1.0\" ID=\"RELS-EXT1.0\" LABEL=\"RDF Statements about this object\" MIMETYPE=\"application/rdf+xml\">");
                xml.append("    <foxml:xmlContent>");
                xml.append("      <rdf:RDF xmlns:fedora-model=\"info:fedora/fedora-system:def/model#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">");
                xml.append("        <rdf:Description rdf:about=\"info:fedora/" + pid + "\">");
                for (String cModelPID : cModelPIDs) {
                    xml.append("          <fedora-model:hasModel rdf:resource=\"info:fedora/" + cModelPID + "\"/>");
                }
                xml.append("        </rdf:Description>");
                xml.append("      </rdf:RDF>");
                xml.append("    </foxml:xmlContent>");
                xml.append("  </foxml:datastreamVersion>");
                xml.append("</foxml:datastream>");
            }
            xml.append("</foxml:digitalObject>");
            this.admin.getAPIMMTOM().ingest(TypeUtility.convertBytesToDataHandler((byte[])xml.toString().getBytes("UTF-8")), TestXACMLPolicies.FOXML1_1.uri, "");
        }
        catch (Exception e) {
            throw new RuntimeException("Failure adding test object: " + pid, e);
        }
    }

    private void removeTestObject(String pid) {
        try {
            this.admin.getAPIMMTOM().purgeObject(pid, "", false);
        }
        catch (Exception e) {
            throw new RuntimeException("Failure removing test object: " + pid, e);
        }
    }

    @After
    public void tearDown() {
        this.restoreFedoraUsersFile();
        this.deleteJunitPolicies();
        this.reloadPolicies();
        this.admin.shutdown();
        this.testuser1.shutdown();
        this.testuserroleA.shutdown();
        this.testuser2.shutdown();
        this.testuser3.shutdown();
        this.testuserroleB.shutdown();
        this.testuserroleC.shutdown();
        this.testuserroleC2.shutdown();
        this.testuser4.shutdown();
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestXACMLPolicies.class);
    }

    public static void main(String[] args) {
        JUnitCore.runClasses((Class[])new Class[]{TestXACMLPolicies.class});
    }
}

