/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import junit.framework.Assert;
import org.apache.commons.io.IOUtils;
import org.fcrepo.common.Constants;
import org.fcrepo.test.api.ValidatorEntityResolver;
import org.fcrepo.test.api.ValidatorErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ValidatorHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidatorHelper.class);

    public List<File> getSchemaFiles(String xml, List<File> state) throws Exception {
        File schemaDir = new File(Constants.FEDORA_HOME, "server" + File.separator + "xsd");
        ArrayList<File> result = new ArrayList<File>();
        Pattern p = Pattern.compile("schemaLocation=\"(.+?)\"");
        Matcher m = p.matcher(xml);
        while (m.find()) {
            String[] content;
            for (String frag : content = m.group(1).split("\\s+")) {
                if (!frag.contains(".xsd")) continue;
                String[] paths = frag.split("/");
                File newSchema = new File(schemaDir, paths[paths.length - 1]);
                if (state != null && state.contains(newSchema)) continue;
                result.add(newSchema);
            }
        }
        ArrayList<File> included = new ArrayList<File>();
        for (File f : result) {
            xml = IOUtils.toString((InputStream)new FileInputStream(f));
            included.addAll(this.getSchemaFiles(xml, result));
        }
        result.addAll(included);
        return result;
    }

    public void offlineValidate(String url, String xml, List<File> schemas) throws Exception {
        Schema schema;
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        LOGGER.info(sf.getClass().getName());
        ArrayList<StreamSource> schemata = new ArrayList<StreamSource>();
        for (File schemaFile : schemas) {
            schemata.add(new StreamSource(schemaFile));
        }
        try {
            schema = sf.newSchema(schemata.toArray(new Source[0]));
        }
        catch (SAXException e) {
            throw new RuntimeException("Could not parse schema " + schemas.toString(), e);
        }
        Validator v = schema.newValidator();
        StringBuilder errors = new StringBuilder();
        v.setErrorHandler(new ValidatorErrorHandler(errors));
        v.validate(new StreamSource(new StringReader(xml)));
        Assert.assertTrue((String)("Offline validation failed for " + url + ". Errors: " + errors.toString() + "\n xml:\n" + xml), (0 == errors.length() ? 1 : 0) != 0);
    }

    public void onlineValidate(String url, String xml) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        StringBuilder errors = new StringBuilder();
        XMLReader reader = parser.getXMLReader();
        reader.setEntityResolver(new ValidatorEntityResolver());
        reader.setErrorHandler(new ValidatorErrorHandler(errors));
        reader.parse(new InputSource(new StringReader(xml)));
        if (errors.length() > 0) {
            LOGGER.warn(xml);
        }
        Assert.assertTrue((String)("Online Validation failed for " + url + ". Errors: " + errors.toString()), (0 == errors.length() ? 1 : 0) != 0);
    }
}

