/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.fesl.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.fcrepo.common.http.PreemptiveAuth;
import org.fcrepo.test.fesl.util.AuthorizationDeniedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private DefaultHttpClient client = null;
    private HttpHost httpHost = null;

    public HttpUtils(String baseURL, String username, String password) throws Exception {
        try {
            URL url = new URL(baseURL);
            this.httpHost = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
            if (username != null && password != null) {
                this.client = new PreemptiveAuth();
                AuthScope authScope = new AuthScope(AuthScope.ANY_HOST, -1);
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
                this.client.getCredentialsProvider().setCredentials(authScope, (Credentials)credentials);
            } else {
                this.client = new DefaultHttpClient();
            }
            HttpConnectionParams.setConnectionTimeout((HttpParams)this.client.getParams(), (int)30000);
            HttpConnectionParams.setSoTimeout((HttpParams)this.client.getParams(), (int)30000);
        }
        catch (Exception e) {
            logger.error("Failed to instantiate HttpUtils.", (Throwable)e);
            throw e;
        }
    }

    public String get(String url) throws ClientProtocolException, IOException, AuthorizationDeniedException {
        return this.get(url, null);
    }

    public String get(String url, Map<String, String> headers) throws ClientProtocolException, IOException, AuthorizationDeniedException {
        HttpGet request = new HttpGet(url);
        if (logger.isDebugEnabled()) {
            logger.debug("getting url: " + url);
        }
        if (headers != null && headers.size() > 0) {
            for (String header : headers.keySet()) {
                String value = headers.get(header);
                request.addHeader(header, value);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("adding header: " + header + " = " + value);
            }
        }
        return this.process((HttpRequest)request);
    }

    public String post(String url) throws ClientProtocolException, IOException, AuthorizationDeniedException {
        return this.post(url, null, null);
    }

    public String post(String url, Map<String, String> headers) throws ClientProtocolException, IOException, AuthorizationDeniedException {
        return this.post(url, headers, null);
    }

    public String post(String url, Map<String, String> headers, byte[] data) throws ClientProtocolException, IOException, AuthorizationDeniedException {
        HttpPost request = new HttpPost(url);
        if (data != null) {
            ByteArrayEntity entity = new ByteArrayEntity(data);
            entity.setChunked(true);
            entity.setContentType("text/xml");
            request.setEntity((HttpEntity)entity);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getting url: " + url);
        }
        if (headers != null && headers.size() > 0) {
            for (String header : headers.keySet()) {
                String value = headers.get(header);
                request.addHeader(header, value);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("adding header: " + header + " = " + value);
            }
        }
        return this.process((HttpRequest)request);
    }

    public String put(String url) throws ClientProtocolException, IOException, AuthorizationDeniedException {
        return this.put(url, null, null);
    }

    public String put(String url, Map<String, String> headers) throws ClientProtocolException, IOException, AuthorizationDeniedException {
        return this.put(url, headers, null);
    }

    public String put(String url, Map<String, String> headers, byte[] data) throws ClientProtocolException, IOException, AuthorizationDeniedException {
        HttpPut request = new HttpPut(url);
        if (data != null) {
            ByteArrayEntity entity = new ByteArrayEntity(data);
            entity.setChunked(true);
            entity.setContentType("text/xml");
            request.setEntity((HttpEntity)entity);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getting url: " + url);
        }
        if (headers != null && headers.size() > 0) {
            for (String header : headers.keySet()) {
                String value = headers.get(header);
                request.addHeader(header, value);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("adding header: " + header + " = " + value);
            }
        }
        return this.process((HttpRequest)request);
    }

    public String delete(String url, Map<String, String> headers) throws ClientProtocolException, IOException, AuthorizationDeniedException {
        HttpDelete request = new HttpDelete(url);
        if (logger.isDebugEnabled()) {
            logger.debug("getting url: " + url);
        }
        if (headers != null && headers.size() > 0) {
            for (String header : headers.keySet()) {
                String value = headers.get(header);
                request.addHeader(header, value);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("adding header: " + header + " = " + value);
            }
        }
        return this.process((HttpRequest)request);
    }

    private String process(HttpRequest request) throws IOException, AuthorizationDeniedException, ClientProtocolException {
        return this.process(request, this.httpHost);
    }

    private String process(HttpRequest request, HttpHost host) throws IOException, AuthorizationDeniedException, ClientProtocolException {
        if (logger.isDebugEnabled()) {
            logger.debug("request line: " + request.getRequestLine());
        }
        HttpResponse response = this.client.execute(host, request);
        int sc = response.getStatusLine().getStatusCode();
        String phrase = response.getStatusLine().getReasonPhrase();
        String body = "";
        if (response.getEntity() != null) {
            InputStream is = response.getEntity().getContent();
            ByteArrayOutputStream res = new ByteArrayOutputStream();
            int len = 0;
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) >= 0) {
                res.write(buf, 0, len);
            }
            is.close();
            body = new String(res.toByteArray());
            if (body.contains("Fedora: 403")) {
                throw new AuthorizationDeniedException("Authorization Denied");
            }
        }
        if (sc < 200 || sc >= 400) {
            throw new ClientProtocolException("Error [Status Code = " + sc + "]" + ": " + phrase);
        }
        if (sc == 302) {
            URL redir = new URL(response.getHeaders("Location")[0].getValue());
            return this.process(request, new HttpHost(redir.getHost(), redir.getPort(), redir.getProtocol()));
        }
        return body;
    }

    public void shutdown() {
        this.client.getConnectionManager().shutdown();
    }
}

