/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.integration.cma;

import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.cxf.binding.soap.SoapFault;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.server.access.FedoraAPIAMTOM;
import org.fcrepo.server.types.gen.ObjectMethodsDef;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.integration.cma.Util;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;

public class SharedDeploymentTests {
    private static final String SHARED_DEPLOYMENT_BASE = "cma-examples/shared-deployments";
    private static final String OBJECT_1_PID = "demo:shared-deployments.object.1";
    private static final String OBJECT_2_PID = "demo:shared-deployments.object.2";
    private static final String OBJECT_1_2_PID = "demo:shared-deployments.object.1-2";
    private static final String OBJECT_3_PID = "demo:shared-deployments.object.3";
    private static final String OBJECT_4_PID = "demo:shared-deployments.object.4";
    private static final String SDEF_1_PID = "demo:shared-deployments.sdef.1";
    private static final String SDEF_2_PID = "demo:shared-deployments.sdef.2";
    private static final String SDEF_4_PID = "demo:shared-deployments.sdef.4";
    private static final String SDEF_1_METHOD = "content";
    private static final String SDEF_2_METHOD = "content2";
    private static final String SDEF_4_METHOD = "content4";
    private static FedoraClient s_client;

    public static Test suite() {
        return new JUnit4TestAdapter(SharedDeploymentTests.class);
    }

    @BeforeClass
    public static void bootstrap() throws Exception {
        s_client = new FedoraClient(FedoraServerTestCase.getBaseURL(), FedoraServerTestCase.getUsername(), FedoraServerTestCase.getPassword());
        Util.ingestTestObjects(s_client, SHARED_DEPLOYMENT_BASE);
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        s_client.shutdown();
        FedoraServerTestCase.purgeDemoObjects(s_client);
    }

    @org.junit.Test
    public void testListMethods1() throws Exception {
        FedoraAPIAMTOM apia = s_client.getAPIAMTOM();
        ObjectMethodsDef[] methods = Util.filterMethods(apia.listMethods(OBJECT_1_PID, null).toArray(new ObjectMethodsDef[0]));
        Assert.assertEquals((String)"Wrong number of methods", (int)1, (int)methods.length);
        Assert.assertEquals((String)"Wrong method SDep", (String)SDEF_1_PID, (String)methods[0].getServiceDefinitionPID());
        Assert.assertEquals((String)"Wrong method", (String)SDEF_1_METHOD, (String)methods[0].getMethodName());
    }

    @org.junit.Test
    public void testListMethods2() throws Exception {
        FedoraAPIAMTOM apia = s_client.getAPIAMTOM();
        ObjectMethodsDef[] methods = Util.filterMethods(apia.listMethods(OBJECT_2_PID, null).toArray(new ObjectMethodsDef[0]));
        Assert.assertEquals((String)"Wrong number of methods!", (int)1, (int)methods.length);
        Assert.assertEquals((String)"Wrong method SDef!", (String)SDEF_2_PID, (String)methods[0].getServiceDefinitionPID());
        Assert.assertEquals((String)"Wrong method", (String)SDEF_2_METHOD, (String)methods[0].getMethodName());
    }

    @org.junit.Test
    public void testListMethods1_2() throws Exception {
        FedoraAPIAMTOM apia = s_client.getAPIAMTOM();
        ObjectMethodsDef[] methods = Util.filterMethods(apia.listMethods(OBJECT_1_2_PID, null).toArray(new ObjectMethodsDef[0]));
        Assert.assertEquals((String)"Too many methods!", (int)2, (int)methods.length);
        Assert.assertNotSame((String)"SDefs are duplicated", (Object)methods[0].getServiceDefinitionPID(), (Object)methods[1].getServiceDefinitionPID());
        Assert.assertNotSame((String)"methods are duplicated", (Object)methods[0].getMethodName(), (Object)methods[1].getMethodName());
    }

    @org.junit.Test
    public void testListMethods3() throws Exception {
        FedoraAPIAMTOM apia = s_client.getAPIAMTOM();
        ObjectMethodsDef[] methods = Util.filterMethods(apia.listMethods(OBJECT_3_PID, null).toArray(new ObjectMethodsDef[0]));
        Assert.assertEquals((String)"Too many methods!", (int)2, (int)methods.length);
        Assert.assertNotSame((String)"SDefs are duplicated", (Object)methods[0].getServiceDefinitionPID(), (Object)methods[1].getServiceDefinitionPID());
        Assert.assertNotSame((String)"methods are duplicated", (Object)methods[0].getMethodName(), (Object)methods[1].getMethodName());
    }

    @org.junit.Test
    public void testListMethods4() throws Exception {
        FedoraAPIAMTOM apia = s_client.getAPIAMTOM();
        ObjectMethodsDef[] methods = Util.filterMethods(apia.listMethods(OBJECT_4_PID, null).toArray(new ObjectMethodsDef[0]));
        Assert.assertEquals((String)"Too many methods!", (int)3, (int)methods.length);
        Assert.assertNotSame((String)"SDefs are duplicated", (Object)methods[0].getServiceDefinitionPID(), (Object)methods[1].getServiceDefinitionPID());
        Assert.assertNotSame((String)"SDefs are duplicated", (Object)methods[0].getServiceDefinitionPID(), (Object)methods[2].getServiceDefinitionPID());
        Assert.assertNotSame((String)"SDefs are duplicated", (Object)methods[1].getServiceDefinitionPID(), (Object)methods[2].getServiceDefinitionPID());
        Assert.assertNotSame((String)"methods are duplicated", (Object)methods[0].getMethodName(), (Object)methods[1].getMethodName());
        Assert.assertNotSame((String)"methods are duplicated", (Object)methods[0].getMethodName(), (Object)methods[2].getMethodName());
        Assert.assertNotSame((String)"methods are duplicated", (Object)methods[1].getMethodName(), (Object)methods[2].getMethodName());
    }

    @Ignore(value="Depends on fixing bug 201903")
    @org.junit.Test
    public void testDissemination1() throws Exception {
        Assert.assertTrue((String)"Wrong dissemination content", (boolean)this.getDissemination(OBJECT_1_PID, SDEF_1_PID, SDEF_1_METHOD).contains("CONTENT_1"));
        try {
            this.getDissemination(OBJECT_1_PID, SDEF_1_PID, SDEF_2_METHOD);
            Assert.fail((String)"Was able to call wrong method on SDef1");
        }
        catch (SoapFault e) {
            // empty catch block
        }
        try {
            this.getDissemination(OBJECT_1_PID, SDEF_2_PID, SDEF_2_METHOD);
            Assert.fail((String)"Was able use the wrong SDef!");
        }
        catch (SoapFault e) {
            // empty catch block
        }
        try {
            this.getDissemination(OBJECT_1_PID, SDEF_2_PID, SDEF_1_METHOD);
            Assert.fail((String)"Was able use the wrong SDef and method!");
        }
        catch (SoapFault soapFault) {
            // empty catch block
        }
    }

    @Ignore(value="Depends on fixing bug 201903")
    @org.junit.Test
    public void testDissemination2() throws Exception {
        Assert.assertTrue((String)"Wrong dissemination content", (boolean)this.getDissemination(OBJECT_2_PID, SDEF_2_PID, SDEF_2_METHOD).contains("CONTENT_2"));
        try {
            this.getDissemination(OBJECT_2_PID, SDEF_2_PID, SDEF_1_METHOD);
            Assert.fail((String)"Was able to call wrong method on SDef2");
        }
        catch (SoapFault e) {
            // empty catch block
        }
        try {
            this.getDissemination(OBJECT_2_PID, SDEF_1_PID, SDEF_1_METHOD);
            Assert.fail((String)"Was able use the wrong SDef!");
        }
        catch (SoapFault e) {
            // empty catch block
        }
        try {
            this.getDissemination(OBJECT_2_PID, SDEF_1_PID, SDEF_2_METHOD);
            Assert.fail((String)"Was able use the wrong SDef and method!");
        }
        catch (SoapFault soapFault) {
            // empty catch block
        }
    }

    @Ignore(value="Depends on fixing bug 201903")
    @org.junit.Test
    public void testDissemination1_2() throws Exception {
        Assert.assertTrue((String)"Wrong dissemination content", (boolean)this.getDissemination(OBJECT_1_2_PID, SDEF_1_PID, SDEF_1_METHOD).contains("CONTENT_1"));
        Assert.assertTrue((String)"Wrong dissemination content", (boolean)this.getDissemination(OBJECT_1_2_PID, SDEF_2_PID, SDEF_2_METHOD).contains("CONTENT_2"));
        try {
            this.getDissemination(OBJECT_1_2_PID, SDEF_1_PID, SDEF_2_METHOD);
            Assert.fail((String)"Was able to call wrong method on SDef1");
        }
        catch (SoapFault e) {
            // empty catch block
        }
        try {
            this.getDissemination(OBJECT_1_2_PID, SDEF_2_PID, SDEF_1_METHOD);
            Assert.fail((String)"Was able use the wrong method on SDef2!");
        }
        catch (SoapFault soapFault) {
            // empty catch block
        }
    }

    @Ignore(value="Depends on fixing bug 201903")
    @org.junit.Test
    public void testDissemination3() throws Exception {
        Assert.assertTrue((String)"Wrong dissemination content", (boolean)this.getDissemination(OBJECT_3_PID, SDEF_1_PID, SDEF_1_METHOD).contains("CONTENT_1"));
        Assert.assertTrue((String)"Wrong dissemination content", (boolean)this.getDissemination(OBJECT_3_PID, SDEF_2_PID, SDEF_2_METHOD).contains("CONTENT_2"));
        try {
            this.getDissemination(OBJECT_3_PID, SDEF_1_PID, SDEF_2_METHOD);
            Assert.fail((String)"Was able to call wrong method on SDef1");
        }
        catch (SoapFault e) {
            // empty catch block
        }
        try {
            this.getDissemination(OBJECT_3_PID, SDEF_2_PID, SDEF_1_METHOD);
            Assert.fail((String)"Was able use the wrong method on SDef2!");
        }
        catch (SoapFault soapFault) {
            // empty catch block
        }
    }

    @Ignore(value="Depends on fixing bug 201903")
    @org.junit.Test
    public void testDissemination4() throws Exception {
        Assert.assertTrue((String)"Wrong dissemination content", (boolean)this.getDissemination(OBJECT_4_PID, SDEF_1_PID, SDEF_1_METHOD).contains("CONTENT_1"));
        Assert.assertTrue((String)"Wrong dissemination content", (boolean)this.getDissemination(OBJECT_4_PID, SDEF_2_PID, SDEF_2_METHOD).contains("CONTENT_2"));
        Assert.assertTrue((String)"Wrong dissemination content", (boolean)this.getDissemination(OBJECT_4_PID, SDEF_4_PID, SDEF_4_METHOD).contains("CONTENT_4"));
        try {
            this.getDissemination(OBJECT_4_PID, SDEF_1_PID, SDEF_2_METHOD);
            Assert.fail((String)"Was able to call wrong method on SDef1");
        }
        catch (SoapFault e) {
            // empty catch block
        }
        try {
            this.getDissemination(OBJECT_4_PID, SDEF_1_PID, SDEF_4_METHOD);
            Assert.fail((String)"Was able to call wrong method on SDef1");
        }
        catch (SoapFault e) {
            // empty catch block
        }
        try {
            this.getDissemination(OBJECT_4_PID, SDEF_2_PID, SDEF_1_METHOD);
            Assert.fail((String)"Was able use the wrong method on SDef2!");
        }
        catch (SoapFault e) {
            // empty catch block
        }
        try {
            this.getDissemination(OBJECT_4_PID, SDEF_2_PID, SDEF_4_METHOD);
            Assert.fail((String)"Was able use the wrong method on SDef2!");
        }
        catch (SoapFault e) {
            // empty catch block
        }
        try {
            this.getDissemination(OBJECT_4_PID, SDEF_4_PID, SDEF_1_METHOD);
            Assert.fail((String)"Was able use the wrong method on SDef4!");
        }
        catch (SoapFault e) {
            // empty catch block
        }
        try {
            this.getDissemination(OBJECT_4_PID, SDEF_4_PID, SDEF_2_METHOD);
            Assert.fail((String)"Was able use the wrong method on SDef4!");
        }
        catch (SoapFault soapFault) {
            // empty catch block
        }
    }

    private String getDissemination(String pid, String sDef, String method) throws Exception {
        return Util.getDissemination(s_client, pid, sDef, method);
    }
}

