/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.messaging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import org.fcrepo.server.Context;
import org.fcrepo.server.MockContext;
import org.fcrepo.server.errors.MessagingException;
import org.fcrepo.server.management.Management;
import org.fcrepo.server.management.MockManagementDelegate;
import org.fcrepo.server.messaging.AtomAPIMMessage;
import org.fcrepo.server.messaging.JMSManager;
import org.fcrepo.server.messaging.Messaging;
import org.fcrepo.server.messaging.MessagingImpl;
import org.fcrepo.server.messaging.NotificationInvocationHandler;
import org.fcrepo.server.proxy.ProxyFactory;
import org.fcrepo.test.FedoraTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class NotificationInvocationHandlerTest
extends FedoraTestCase {
    private JMSManager jmsMgr;

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(NotificationInvocationHandlerTest.class);
    }

    @Before
    public void setUp() throws Exception {
        Properties props = new Properties();
        props.setProperty("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        props.setProperty("java.naming.provider.url", "vm://localhost?broker.useShutdownHook=false&broker.persistent=false");
        props.setProperty("connection.factory.name", "ConnectionFactory");
        props.setProperty("topic.fedora.apim.update", "fedora.apim.update");
        this.jmsMgr = new JMSManager(props);
    }

    @After
    public void tearDown() throws Exception {
        if (this.jmsMgr != null) {
            this.jmsMgr.close();
        }
    }

    @Test
    public void testAPIMPubAndReceipt() throws Exception {
        CountDownLatch listeningSignal = new CountDownLatch(1);
        CountDownLatch doneSignal = new CountDownLatch(1);
        ListenerThread listener = new ListenerThread(listeningSignal, doneSignal);
        listener.start();
        listeningSignal.await();
        try {
            HashMap mdMap = new HashMap();
            ArrayList<String> destinations = new ArrayList<String>();
            destinations.add("fedora.apim.update");
            mdMap.put(Messaging.MessageType.apimUpdate.toString(), destinations);
            MessagingImpl msg = new MessagingImpl(NotificationInvocationHandlerTest.getBaseURL(), mdMap, this.jmsMgr);
            Object[] invocationHandlers = new Object[]{new NotificationInvocationHandler((Messaging)msg)};
            MockManagementDelegate mgmt = new MockManagementDelegate();
            Management proxy = (Management)ProxyFactory.getProxy((Object)mgmt, (Object[])invocationHandlers);
            proxy.purgeObject((Context)new MockContext(), "demo:test", null);
        }
        catch (Exception e) {
            ((Thread)listener).interrupt();
            throw e;
        }
        doneSignal.await();
    }

    class ListenerThread
    extends Thread
    implements MessageListener {
        private final CountDownLatch listeningSignal;
        private final CountDownLatch doneSignal;

        ListenerThread(CountDownLatch listeningSignal, CountDownLatch doneSignal) {
            this.listeningSignal = listeningSignal;
            this.doneSignal = doneSignal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                NotificationInvocationHandlerTest.this.jmsMgr.listen("fedora.apim.update", (MessageListener)this);
            }
            catch (MessagingException e) {
                Assert.fail((String)e.getMessage());
            }
            finally {
                this.listeningSignal.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void interrupt() {
            try {
                NotificationInvocationHandlerTest.this.jmsMgr.close();
            }
            catch (MessagingException e) {
                Assert.fail((String)e.getMessage());
            }
            finally {
                super.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message msg) {
            try {
                TextMessage message = (TextMessage)msg;
                AtomAPIMMessage apim = new AtomAPIMMessage(message.getText());
                Assert.assertEquals((String)"demo:test", (String)apim.getPID());
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            finally {
                this.doneSignal.countDown();
            }
        }
    }
}

