/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import junit.framework.Assert;
import org.fcrepo.client.FedoraClient;

public class RISearchUtil {
    private static final String RISEARCH_SPO_COUNT = "/risearch?type=triples&lang=spo&format=count&stream=on&flush=true&query=";
    private static final String RISEARCH_SPARQL_COUNT = "/risearch?type=tuples&lang=sparql&format=count&stream=on&flush=true&query=";

    public static void checkSPOCount(FedoraClient client, String query, int expectedCount) {
        int actualCount = RISearchUtil.getSPOCount(client, query);
        Assert.assertEquals((String)("Expected " + expectedCount + " results from SPO query" + " " + query + ", but got " + actualCount), (int)expectedCount, (int)actualCount);
    }

    public static void checkSPARQLCount(FedoraClient client, String query, int expectedCount) {
        int actualCount = RISearchUtil.getSPARQLCount(client, query);
        Assert.assertEquals((String)("Expected " + expectedCount + " results from SPARQL query" + " " + query + ", but got " + actualCount), (int)expectedCount, (int)actualCount);
    }

    private static int getCount(FedoraClient client, String path, String query) {
        String response = null;
        try {
            path = path + URLEncoder.encode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            Assert.fail((String)"Encoding error while querying resource index. See stack trace");
        }
        try {
            response = client.getResponseAsString(path, true, true).trim();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"Error while querying resource index (is it enabled?).  See stack trace");
        }
        int count = 0;
        try {
            count = Integer.parseInt(response);
        }
        catch (NumberFormatException e) {
            Assert.fail((String)("Expected numeric plaintext response body from RI query, but got the following: " + response));
        }
        return count;
    }

    public static int getSPARQLCount(FedoraClient client, String query) {
        return RISearchUtil.getCount(client, RISEARCH_SPARQL_COUNT, query);
    }

    public static int getSPOCount(FedoraClient client, String query) {
        return RISearchUtil.getCount(client, RISEARCH_SPO_COUNT, query);
    }
}

