/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import javax.activation.DataHandler;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.server.access.FedoraAPIAMTOM;
import org.fcrepo.server.types.mtom.gen.GetDissemination;
import org.fcrepo.server.types.mtom.gen.MIMETypedStream;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.test.FedoraServerTestCase;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.JUnitCore;

public class TestAPIAConfigA
extends FedoraServerTestCase {
    private static FedoraClient s_client;
    private FedoraAPIAMTOM apia;

    @org.junit.Test
    public void testGetChainedDissemination() throws Exception {
        GetDissemination.Parameters params = new GetDissemination.Parameters();
        MIMETypedStream diss = this.apia.getDissemination("demo:26", "demo:19", "getPDF", params, null);
        Assert.assertEquals((String)diss.getMIMEType(), (String)"application/pdf");
        Assert.assertTrue((TypeUtility.convertDataHandlerToBytes((DataHandler)diss.getStream()).length > 0 ? 1 : 0) != 0);
    }

    @BeforeClass
    public static void bootstrap() throws Exception {
        s_client = TestAPIAConfigA.getFedoraClient();
        TestAPIAConfigA.ingestFormattingObjectsDemoObjects(s_client);
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        TestAPIAConfigA.purgeDemoObjects(s_client);
        s_client.shutdown();
    }

    @Before
    public void setUp() throws Exception {
        this.apia = s_client.getAPIAMTOM();
    }

    public static Test suite() {
        return new JUnit4TestAdapter(TestAPIAConfigA.class);
    }

    public static void main(String[] args) {
        JUnitCore.runClasses((Class[])new Class[]{TestAPIAConfigA.class});
    }
}

