/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.common.Models;
import org.fcrepo.common.http.HttpInputStream;
import org.fcrepo.test.FedoraServerTestCase;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.JUnitCore;
import org.w3c.dom.Document;

public class TestAPIALite
extends FedoraServerTestCase {
    private static FedoraClient s_client;

    @BeforeClass
    public static void bootStrap() throws Exception {
        s_client = TestAPIALite.getFedoraClient();
        TestAPIALite.ingestSimpleImageDemoObjects(s_client);
        TestAPIALite.ingestSimpleDocumentDemoObjects(s_client);
        TestAPIALite.ingestImageManipulationDemoObjects(s_client);
        TestAPIALite.ingestImageCollectionDemoObjects(s_client);
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        TestAPIALite.purgeDemoObjects(s_client);
        s_client.shutdown();
    }

    @Before
    public void setUp() throws Exception {
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("fedora-types", "http://www.fedora.info/definitions/1/0/types/");
        nsMap.put(TestAPIALite.OAI_DC.prefix, TestAPIALite.OAI_DC.uri);
        nsMap.put(TestAPIALite.DC.prefix, TestAPIALite.DC.uri);
        nsMap.put(TestAPIALite.ACCESS.prefix, TestAPIALite.ACCESS.uri);
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
    }

    @After
    public void tearDown() {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
    }

    @org.junit.Test
    public void testDescribeRepository() throws Exception {
        Document result = this.getXMLQueryResult(s_client, "/describe?xml=true");
        XMLAssert.assertXpathExists((String)String.format("/%s:fedoraRepository/%s:repositoryName", TestAPIALite.ACCESS.prefix, TestAPIALite.ACCESS.prefix), (Document)result);
    }

    @org.junit.Test
    public void testGetDatastreamDissemination() throws Exception {
        Document result = this.getXMLQueryResult(s_client, "/get/demo:5/DC");
        XMLAssert.assertXpathExists((String)"/oai_dc:dc", (Document)result);
        XMLAssert.assertXpathEvaluatesTo((String)"demo:5", (String)"/oai_dc:dc/dc:identifier/text()", (Document)result);
        HttpInputStream in = s_client.get("/get/demo:SmileyBeerGlass/MEDIUM_SIZE", true);
        String actualType = in.getContentType();
        long actualLength = in.getContentLength();
        in.close();
        Assert.assertEquals((String)"image/jpeg", (String)actualType);
        Assert.assertTrue((actualLength > 0L ? 1 : 0) != 0);
        in = s_client.get("/get/demo:31/DS3", false, false);
        int actualCode = in.getStatusCode();
        in.close();
        Assert.assertEquals((int)302, (int)actualCode);
        in = s_client.get("/get/demo:5/THUMBRES_IMG", true);
        actualType = in.getContentType();
        in.close();
        Assert.assertEquals((String)"image/jpeg", (String)actualType);
    }

    @org.junit.Test
    public void testGetDisseminationDefault() throws Exception {
        HttpInputStream his = s_client.get("/get/demo:5/fedora-system:3/viewDublinCore", true);
        String actual = his.getContentType();
        his.close();
        Assert.assertEquals((String)"text/html", (String)actual);
    }

    @org.junit.Test
    public void testGetDisseminationUserInput() throws Exception {
        HttpInputStream his = s_client.get("/get/demo:29/demo:27/convertImage?convertTo=gif", true);
        String actual = his.getContentType();
        his.close();
        Assert.assertEquals((String)"image/gif", (String)actual);
    }

    @org.junit.Test
    public void testObjectHistory() throws Exception {
        Document result = this.getXMLQueryResult(s_client, "/getObjectHistory/demo:5?xml=true");
        XMLAssert.assertXpathExists((String)String.format("/%s:fedoraObjectHistory/%s:objectChangeDate", TestAPIALite.ACCESS.prefix, TestAPIALite.ACCESS.prefix), (Document)result);
    }

    @org.junit.Test
    public void testGetObjectProfile() throws Exception {
        Document result = this.getXMLQueryResult(s_client, "/get/demo:5?xml=true");
        XMLAssert.assertXpathEvaluatesTo((String)"demo:5", (String)String.format("/%s:objectProfile/attribute::pid", TestAPIALite.ACCESS.prefix), (Document)result);
    }

    @org.junit.Test
    public void testGetObjectProfileBasicCModel() throws Exception {
        String testExpression = String.format("count(/%s:objectProfile/%s:objModels/%s:model[normalize-space()='" + Models.FEDORA_OBJECT_CURRENT.uri + "'])", TestAPIALite.ACCESS.prefix, TestAPIALite.ACCESS.prefix, TestAPIALite.ACCESS.prefix);
        for (String pid : new String[]{"demo:SmileyPens", "demo:SmileyGreetingCard"}) {
            Document result = this.getXMLQueryResult(s_client, "/get/" + pid + "?xml=true");
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)testExpression, (Document)result);
        }
    }

    @org.junit.Test
    public void testListDatastreams() throws Exception {
        Document result = this.getXMLQueryResult(s_client, "/listDatastreams/demo:5?xml=true");
        XMLAssert.assertXpathEvaluatesTo((String)"6", (String)String.format("count(/%s:objectDatastreams/%s:datastream)", TestAPIALite.ACCESS.prefix, TestAPIALite.ACCESS.prefix), (Document)result);
    }

    @org.junit.Test
    public void testListMethods() throws Exception {
        Document result = this.getXMLQueryResult(s_client, "/listMethods/demo:5?xml=true");
        XMLAssert.assertXpathEvaluatesTo((String)"8", (String)String.format("count(/%s:objectMethods/%s:sDef/%s:method)", TestAPIALite.ACCESS.prefix, TestAPIALite.ACCESS.prefix, TestAPIALite.ACCESS.prefix), (Document)result);
    }

    @org.junit.Test
    public void testAccessParmResolver() throws Exception {
        String location = "/getAccessParmResolver?PID=fedora-system:ContentModel-3.0&sDefPID=fedora-system:3&methodName=viewObjectProfile";
        HttpInputStream result = s_client.get(TestAPIALite.getBaseURL() + location, false, false);
        Assert.assertEquals((int)302, (int)result.getStatusCode());
        String expected = TestAPIALite.getBaseURL() + "/get/fedora-system:ContentModel-3.0/fedora-system:3/viewObjectProfile/";
        Assert.assertEquals((String)expected, (String)result.getResponseHeader("Location").getValue());
    }

    public static Test suite() {
        return new JUnit4TestAdapter(TestAPIALite.class);
    }

    public static void main(String[] args) {
        JUnitCore.runClasses((Class[])new Class[]{TestAPIALite.class});
    }
}

