/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.util.HashMap;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.test.FedoraServerTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.JUnitCore;
import org.w3c.dom.Document;

public class TestAPIMLite
extends FedoraServerTestCase {
    private FedoraClient client;

    @Before
    public void setUp() throws Exception {
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("management", "http://www.fedora.info/definitions/1/0/management/");
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
        this.client = TestAPIMLite.getFedoraClient();
    }

    @After
    public void tearDown() {
        this.client.shutdown();
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
    }

    @org.junit.Test
    public void testGetNextPID() throws Exception {
        Document result = this.getXMLQueryResult(this.client, "/management/getNextPID?xml=true");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//management:pid)", (Document)result);
        result = this.getXMLQueryResult(this.client, "/management/getNextPID?numpids=10&namespace=demo&xml=true");
        XMLAssert.assertXpathEvaluatesTo((String)"10", (String)"count(//management:pid)", (Document)result);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(TestAPIMLite.class);
    }

    public static void main(String[] args) {
        JUnitCore.runClasses((Class[])new Class[]{TestAPIMLite.class});
    }
}

