/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Set;
import javax.activation.DataHandler;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.util.EntityUtils;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.common.http.PreemptiveAuth;
import org.fcrepo.server.access.FedoraAPIAMTOM;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.server.types.gen.Datastream;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.test.FedoraServerTestCase;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class TestAdminAPI
extends FedoraServerTestCase {
    private static FedoraClient s_client;
    private FedoraAPIAMTOM apia;
    private FedoraAPIMMTOM apim;
    private static String authAccessProperty;
    protected Boolean authorizeAccess = null;
    protected String url;
    private final boolean chunked = false;

    @BeforeClass
    public static void bootstrap() throws Exception {
        s_client = TestAdminAPI.getFedoraClient();
        TestAdminAPI.ingestSimpleImageDemoObjects(s_client);
        TestAdminAPI.ingestSimpleDocumentDemoObjects(s_client);
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        TestAdminAPI.purgeDemoObjects(s_client);
        s_client.shutdown();
    }

    @Before
    public void setUp() throws Exception {
        this.apia = s_client.getAPIAMTOM();
        this.apim = s_client.getAPIMMTOM();
    }

    @After
    public void tearDown() throws Exception {
    }

    private boolean getAuthAccess() {
        if (this.authorizeAccess == null) {
            String property = System.getProperty(authAccessProperty);
            if (property.equals("true")) {
                this.authorizeAccess = true;
            } else if (property.equals("false")) {
                this.authorizeAccess = false;
            } else {
                Assert.assertTrue((String)("Failed to determine whether to perform authorization on Access requests from: " + authAccessProperty), (boolean)false);
                throw new RuntimeException("Failed to determine whether to perform authorization on Access requests from: " + authAccessProperty);
            }
        }
        return this.authorizeAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyControlGroup() throws Exception {
        FileWriter fw;
        this.url = "/objects?pid=true&title=false&query=pid~demo%3A*&maxResults=1000&resultFormat=xml";
        HttpResponse res = this.get(this.getAuthAccess());
        Assert.assertEquals((int)200, (int)res.getStatusLine().getStatusCode());
        File objectsListFile = null;
        try {
            objectsListFile = File.createTempFile("TestAdminAPI", null);
            fw = new FileWriter(objectsListFile);
            String queryResults = EntityUtils.toString((HttpEntity)res.getEntity());
            fw.write(queryResults);
            fw.close();
            this.testFileInput(objectsListFile);
        }
        finally {
            if (objectsListFile != null && !objectsListFile.delete()) {
                objectsListFile.deleteOnExit();
            }
        }
        TestAdminAPI.purgeDemoObjects(s_client);
        TestAdminAPI.ingestSimpleImageDemoObjects(s_client);
        TestAdminAPI.ingestSimpleDocumentDemoObjects(s_client);
        objectsListFile = null;
        try {
            objectsListFile = File.createTempFile("TestAdminAPI", null);
            fw = new FileWriter(objectsListFile);
            Set<String> objects = TestAdminAPI.getDemoObjects(s_client);
            for (String pid : objects) {
                fw.write(pid + "\n");
            }
            fw.close();
            this.testFileInput(objectsListFile);
        }
        finally {
            if (objectsListFile != null && !objectsListFile.delete()) {
                objectsListFile.deleteOnExit();
            }
        }
        TestAdminAPI.purgeDemoObjects(s_client);
        TestAdminAPI.ingestSimpleImageDemoObjects(s_client);
        TestAdminAPI.ingestSimpleDocumentDemoObjects(s_client);
        Set<String> objects = TestAdminAPI.getDemoObjects(s_client);
        String pid = objects.toArray(new String[0])[0];
        this.url = this.modifyDatastreamControlGroupUrl(pid + "doesnotexist", "DC", "M", false, false, false);
        res = this.get(true);
        Assert.assertEquals((int)404, (int)res.getStatusLine().getStatusCode());
        this.url = this.modifyDatastreamControlGroupUrl(pid, "doesnotexist", "M", false, false, false);
        res = this.get(true);
        Assert.assertEquals((int)404, (int)res.getStatusLine().getStatusCode());
        byte[] before = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apia.getDatastreamDissemination(pid, "DC", null).getStream());
        this.url = this.modifyDatastreamControlGroupUrl(pid, "DC", "M", false, false, false);
        res = this.get(true);
        String contents = EntityUtils.toString((HttpEntity)res.getEntity());
        Assert.assertEquals((int)200, (int)res.getStatusLine().getStatusCode());
        Datastream ds = this.apim.getDatastream(pid, "DC", null);
        Assert.assertEquals((String)"ControlGroup", (String)"M", (String)ds.getControlGroup().value());
        byte[] after = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apia.getDatastreamDissemination(pid, "DC", null).getStream());
        String beforeString = new String(before, "UTF-8");
        String afterString = new String(after, "UTF-8");
        Assert.assertEquals((String)"Datastream contents ", (String)beforeString, (String)afterString);
        String pid1 = objects.toArray(new String[0])[1];
        String pid2 = objects.toArray(new String[0])[2];
        this.url = this.modifyDatastreamControlGroupUrl(pid1 + "," + pid2, "DC", "M", false, false, false);
        res = this.get(true);
        Assert.assertEquals((int)200, (int)res.getStatusLine().getStatusCode());
        contents = EntityUtils.toString((HttpEntity)res.getEntity());
        int[] counts = this.getCounts(contents);
        Assert.assertEquals((String)"Object count", (int)2, (int)counts[0]);
        Assert.assertEquals((String)"Datastream count", (int)2, (int)counts[1]);
        ds = this.apim.getDatastream(pid1, "DC", null);
        Assert.assertEquals((String)"ControlGroup", (String)"M", (String)ds.getControlGroup().value());
        ds = this.apim.getDatastream(pid2, "DC", null);
        Assert.assertEquals((String)"ControlGroup", (String)"M", (String)ds.getControlGroup().value());
    }

    private void testFileInput(File objectsListFile) throws Exception {
        Set<String> objects = TestAdminAPI.getDemoObjects(s_client);
        int managedObjects = 0;
        for (String pid : objects) {
            if (!pid.endsWith("_M")) continue;
            ++managedObjects;
        }
        this.url = this.modifyDatastreamControlGroupUrl("file:///" + objectsListFile.getAbsolutePath(), "DC", "M", false, false, false);
        HttpResponse res = this.get(true);
        int status = res.getStatusLine().getStatusCode();
        String modified = EntityUtils.toString((HttpEntity)res.getEntity());
        Assert.assertEquals((int)200, (int)status);
        String logExpected = "Updated " + (objects.size() - managedObjects) + " objects and " + (objects.size() - managedObjects) + " datastreams";
        Assert.assertTrue((String)("Wrong number of objects/datastreams updated.  Expected " + logExpected + "\n" + "Log file shows:" + "\n" + modified), (boolean)modified.contains(logExpected));
        res = this.get(true);
        modified = EntityUtils.toString((HttpEntity)res.getEntity());
        Assert.assertEquals((int)200, (int)res.getStatusLine().getStatusCode());
        logExpected = "Updated 0 objects and 0 datastreams";
        Assert.assertTrue((String)"Wrong number of objects/datastreams updated", (boolean)modified.contains(logExpected));
        this.url = this.modifyDatastreamControlGroupUrl("file:///" + objectsListFile.getAbsolutePath(), "DC,RELS-EXT", "M", false, false, false);
        res = this.get(true);
        modified = EntityUtils.toString((HttpEntity)res.getEntity());
        Assert.assertEquals((int)200, (int)res.getStatusLine().getStatusCode());
        int[] counts = this.getCounts(modified);
        int objectCount = counts[0];
        int datastreamCount = counts[1];
        if (objectCount <= 0 || objectCount > objects.size() - managedObjects - 2 || datastreamCount <= 0 || datastreamCount > objects.size() - managedObjects - 2) {
            Assert.fail((String)("Incorrect number of objects and datastreams modified: objects " + objectCount + " datastreams " + datastreamCount));
        }
    }

    private int[] getCounts(String response) {
        int objectCountPos = response.lastIndexOf("Updated ");
        int datastreamCountPos = response.lastIndexOf(" objects and ");
        int datastreamEndCountPos = response.lastIndexOf(" datastreams");
        int objectCount = Integer.parseInt(response.substring(objectCountPos + "Updated ".length(), datastreamCountPos));
        int datastreamCount = Integer.parseInt(response.substring(datastreamCountPos + " objects and ".length(), datastreamEndCountPos));
        int[] res = new int[]{objectCount, datastreamCount};
        return res;
    }

    private String modifyDatastreamControlGroupUrl(String pid, String dsID, String controlGroup, boolean addXMLHeader, boolean reformat, boolean setMIMETypeCharset) {
        String ret;
        try {
            ret = "/management/control?action=modifyDatastreamControlGroup&pid=" + URLEncoder.encode(pid, "UTF-8") + "&dsID=" + URLEncoder.encode(dsID, "UTF-8") + "&controlGroup=" + controlGroup + "&addXMLHeader=" + addXMLHeader + "&reformat=" + reformat + "&setMIMETypeCharset=" + setMIMETypeCharset;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    private HttpClient getClient(boolean auth) {
        PreemptiveAuth client = new PreemptiveAuth();
        if (auth) {
            client.getCredentialsProvider().setCredentials(new AuthScope(TestAdminAPI.getHost(), Integer.valueOf(TestAdminAPI.getPort()).intValue()), (Credentials)new UsernamePasswordCredentials(TestAdminAPI.getUsername(), TestAdminAPI.getPassword()));
        }
        return client;
    }

    protected HttpResponse get(boolean authenticate) throws Exception {
        return this.getOrDelete("GET", authenticate);
    }

    protected HttpResponse delete(boolean authenticate) throws Exception {
        return this.getOrDelete("DELETE", authenticate);
    }

    protected HttpResponse put(boolean authenticate) throws Exception {
        return this.putOrPost("PUT", null, authenticate);
    }

    protected HttpResponse put(String requestContent, boolean authenticate) throws Exception {
        return this.putOrPost("PUT", requestContent, authenticate);
    }

    protected HttpResponse post(String requestContent, boolean authenticate) throws Exception {
        return this.putOrPost("POST", requestContent, authenticate);
    }

    protected HttpResponse put(File requestContent, boolean authenticate) throws Exception {
        return this.putOrPost("PUT", requestContent, authenticate);
    }

    protected HttpResponse post(File requestContent, boolean authenticate) throws Exception {
        return this.putOrPost("POST", requestContent, authenticate);
    }

    private HttpResponse getOrDelete(String method, boolean authenticate) throws Exception {
        if (this.url == null || this.url.length() == 0) {
            throw new IllegalArgumentException("url must be a non-empty value");
        }
        if (!this.url.startsWith("http://") && !this.url.startsWith("https://")) {
            this.url = TestAdminAPI.getBaseURL() + this.url;
        }
        HttpGet httpMethod = null;
        if (method.equals("GET")) {
            httpMethod = new HttpGet(this.url);
        } else if (method.equals("DELETE")) {
            httpMethod = new HttpDelete(this.url);
        } else {
            throw new IllegalArgumentException("method must be one of GET or DELETE.");
        }
        httpMethod.setHeader("Connection", "Keep-Alive");
        return this.getClient(authenticate).execute((HttpUriRequest)httpMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse putOrPost(String method, Object requestContent, boolean authenticate) throws Exception {
        if (this.url == null || this.url.length() == 0) {
            throw new IllegalArgumentException("url must be a non-empty value");
        }
        if (!this.url.startsWith("http://") && !this.url.startsWith("https://")) {
            this.url = TestAdminAPI.getBaseURL() + this.url;
        }
        HttpPut httpMethod = null;
        try {
            if (method.equals("PUT")) {
                httpMethod = new HttpPut(this.url);
            } else if (method.equals("POST")) {
                httpMethod = new HttpPost(this.url);
            } else {
                throw new IllegalArgumentException("method must be one of PUT or POST.");
            }
            httpMethod.setHeader("Connection", "Keep-Alive");
            if (requestContent != null) {
                MultipartEntity entity;
                if (requestContent instanceof String) {
                    entity = new StringEntity((String)requestContent, Charset.forName("UTF-8"));
                    entity.setChunked(false);
                    httpMethod.setEntity((HttpEntity)entity);
                } else if (requestContent instanceof File) {
                    entity = new MultipartEntity();
                    entity.addPart(((File)requestContent).getName(), (ContentBody)new FileBody((File)requestContent));
                    entity.addPart("param_name", (ContentBody)new StringBody("value"));
                    httpMethod.setEntity((HttpEntity)entity);
                } else {
                    throw new IllegalArgumentException("requestContent must be a String or File");
                }
            }
            HttpResponse httpResponse = this.getClient(authenticate).execute((HttpUriRequest)httpMethod);
            return httpResponse;
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestAdminAPI.class);
    }

    public static void main(String[] args) {
        JUnitCore.runClasses((Class[])new Class[]{TestAdminAPI.class});
    }

    static {
        authAccessProperty = "fedora.authorize.access";
    }

    class HttpResponseInfo {
        private final int statusCode;
        private final byte[] responseBody;
        private final Header[] responseHeaders;

        HttpResponseInfo(int status, byte[] body, Header[] headers) {
            this.statusCode = status;
            this.responseBody = body;
            this.responseHeaders = headers;
        }

        HttpResponseInfo(HttpResponse response) throws IOException {
            this.statusCode = response.getStatusLine().getStatusCode();
            InputStream is = response.getEntity().getContent();
            this.responseBody = IOUtils.toByteArray((InputStream)is);
            IOUtils.closeQuietly((InputStream)is);
            this.responseHeaders = response.getAllHeaders();
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public byte[] getResponseBody() {
            return this.responseBody;
        }

        public String getResponseBodyString() {
            try {
                return new String(this.responseBody, "UTF-8");
            }
            catch (UnsupportedEncodingException wontHappen) {
                throw new Error(wontHappen);
            }
        }

        public Header[] getResponseHeaders() {
            return this.responseHeaders;
        }

        public Header getResponseHeader(String headerName) {
            for (Header header : this.responseHeaders) {
                if (!header.getName().equalsIgnoreCase(headerName)) continue;
                return header;
            }
            return null;
        }
    }
}

