/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.FileUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.common.Constants;
import org.fcrepo.common.Models;
import org.fcrepo.common.PID;
import org.fcrepo.server.access.FedoraAPIAMTOM;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.server.types.gen.Datastream;
import org.fcrepo.server.types.gen.FieldSearchQuery;
import org.fcrepo.server.types.gen.FieldSearchResult;
import org.fcrepo.server.types.gen.ObjectFactory;
import org.fcrepo.server.types.gen.ObjectFields;
import org.fcrepo.server.types.mtom.gen.MIMETypedStream;
import org.fcrepo.server.utilities.MD5Utility;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.api.ValidatorHelper;
import org.jrdf.graph.Triple;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trippi.RDFFormat;
import org.trippi.TripleIterator;
import org.trippi.TrippiException;
import org.trippi.io.TripleIteratorFactory;

public class TestRESTAPI
extends FedoraServerTestCase {
    private static final String TEXT_XML = "text/xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(TestRESTAPI.class);
    private static FedoraClient s_client;
    private FedoraAPIAMTOM apia;
    private FedoraAPIMMTOM apim;
    private static String authAccessProperty;
    protected Boolean authorizeAccess = null;
    private static String DEMO_OWNERID;
    private static String DEMO_REST;
    private static byte[] DEMO_REST_FOXML;
    private static String DEMO_MIN;
    private static String DEMO_MIN_PID;
    private static final PID DEMO_REST_PID;
    private static final String REST_RESOURCE_PATH;
    private static final String DS1RelsFilename = "Datastream 1 filename from rels.extension";
    private static final String DS2LabelFilename = "Datastream 2 filename from label";
    private static final String DS3LabelFilename = "Datastream 3 filename from label";
    private static final String DodgyChars = "\\/*?&lt;&gt;:|";
    private static final String DS4LabelFilenameOriginal = "Datastream 4 filename \\/*?&lt;&gt;:|from label";
    private static final String DS4LabelFilename = "Datastream 4 filename from label";
    private static final String DS5ID = "DS5";
    private static final String DS6ID = "DS6.xml";
    static SimpleDateFormat df;
    private static final ValidatorHelper validator;
    private static final Date now;
    private static final String datetime;
    private static final String earlierDateTime = "2001-01-01T00:00:00.000Z";
    private boolean chunked = false;

    protected static FedoraClient initClient() throws Exception {
        s_client = TestRESTAPI.getFedoraClient();
        return s_client;
    }

    protected static void stopClient() {
        s_client.shutdown();
        s_client = null;
    }

    @BeforeClass
    public static void bootStrap() throws Exception {
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("management", "http://www.fedora.info/definitions/1/0/management/");
        nsMap.put("access", "http://www.fedora.info/definitions/1/0/access/");
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
        TestRESTAPI.initClient();
        TestRESTAPI.ingestImageManipulationDemoObjects(s_client);
        TestRESTAPI.ingestDocumentTransformDemoObjects(s_client);
        if (DEMO_MIN == null) {
            DEMO_MIN = FileUtils.readFileToString((File)new File(REST_RESOURCE_PATH + "/demo_min.xml"), (String)"UTF-8");
        }
        if (DEMO_MIN_PID == null) {
            DEMO_MIN_PID = FileUtils.readFileToString((File)new File(REST_RESOURCE_PATH + "/demo_min_pid.xml"), (String)"UTF-8");
        }
        if (DEMO_REST == null) {
            StringTemplate tpl = new StringTemplate(FileUtils.readFileToString((File)new File(REST_RESOURCE_PATH + "/demo_rest.xml"), (String)"UTF-8"));
            tpl.setAttribute("MODEL_DOWNLOAD_FILENAME", (Object)TestRESTAPI.MODEL.DOWNLOAD_FILENAME.localName);
            tpl.setAttribute("DS1_RELS_FILENAME", (Object)DS1RelsFilename);
            tpl.setAttribute("MODEL_URI", (Object)TestRESTAPI.MODEL.uri);
            tpl.setAttribute("DATETIME", (Object)datetime);
            tpl.setAttribute("FEDORA_BASE_URL", (Object)TestRESTAPI.getBaseURL());
            tpl.setAttribute("DS2_LABEL_FILENAME", (Object)DS2LabelFilename);
            tpl.setAttribute("DS3_LABEL_FILENAME", (Object)DS3LabelFilename);
            tpl.setAttribute("DS4_LABEL_FILENAME_ORIGINAL", (Object)DS4LabelFilenameOriginal);
            DEMO_REST = tpl.toString();
            DEMO_REST_FOXML = DEMO_REST.getBytes("UTF-8");
        }
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        TestRESTAPI.purgeDemoObjects(s_client);
        TestRESTAPI.stopClient();
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
    }

    @Before
    public void setUp() throws Exception {
        this.apia = s_client.getAPIAMTOM();
        this.apim = s_client.getAPIMMTOM();
        this.apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])DEMO_REST_FOXML), TestRESTAPI.FOXML1_1.uri, "TestRESTAPI.setUp: ingesting new foxml object " + DEMO_REST_PID);
    }

    @After
    public void tearDown() throws Exception {
        this.apim.purgeObject(DEMO_REST_PID.toString(), "TestRESTAPI.tearDown: purging " + DEMO_REST_PID, false);
    }

    protected static byte[] readBytes(HttpResponse response) {
        byte[] body = new byte[]{};
        if (response.getEntity() != null) {
            try {
                body = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return body;
    }

    protected static String readString(HttpResponse response) {
        return TestRESTAPI.readString(response, Charset.forName("UTF-8"));
    }

    protected static String readString(HttpResponse response, Charset charset) {
        String body = null;
        if (response.getEntity() != null) {
            try {
                body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)charset);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return body != null ? body : "";
    }

    private boolean getAuthAccess() {
        if (this.authorizeAccess == null) {
            String property = System.getProperty(authAccessProperty);
            if (property.equals("true")) {
                this.authorizeAccess = true;
            } else if (property.equals("false")) {
                this.authorizeAccess = false;
            } else {
                Assert.assertTrue((String)("Failed to determine whether to perform authorization on Access requests from: " + authAccessProperty), (boolean)false);
                throw new RuntimeException("Failed to determine whether to perform authorization on Access requests from: " + authAccessProperty);
            }
        }
        return this.authorizeAccess;
    }

    protected void verifyDELETEStatusOnly(URI url, int expected, boolean authenticate) throws Exception {
        HttpDelete get = new HttpDelete(url);
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, authenticate, false);
        int status = response.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)expected, (int)status);
    }

    protected void verifyGETStatusOnly(URI url, int expected, boolean authenticate, boolean validate) throws Exception {
        HttpGet get = new HttpGet(url);
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, authenticate, validate);
        int status = response.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)expected, (int)status);
    }

    protected void verifyGETStatusOnly(URI url, int expected, boolean validate) throws Exception {
        this.verifyGETStatusOnly(url, expected, this.getAuthAccess(), validate);
    }

    protected void verifyGETStatusOnly(URI url, int expected) throws Exception {
        this.verifyGETStatusOnly(url, expected, false);
    }

    protected String verifyGETStatusString(URI url, int expected, boolean authenticate, boolean validate) throws Exception {
        HttpGet get = new HttpGet(url);
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, authenticate, validate);
        int status = response.getStatusLine().getStatusCode();
        String result = TestRESTAPI.readString(response);
        Assert.assertEquals((int)expected, (int)status);
        return result;
    }

    protected byte[] verifyGETStatusBytes(URI url, int expected, boolean authenticate, boolean validate) throws Exception {
        HttpGet get = new HttpGet(url);
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, authenticate, validate);
        int status = response.getStatusLine().getStatusCode();
        byte[] result = TestRESTAPI.readBytes(response);
        Assert.assertEquals((int)expected, (int)status);
        return result;
    }

    protected static StringEntity getStringEntity(String content, String contentType) {
        if (content == null) {
            return null;
        }
        StringEntity entity = new StringEntity(content, Charset.forName("UTF-8"));
        if (contentType != null) {
            entity.setContentType(contentType);
        }
        return entity;
    }

    protected void verifyPOSTStatusOnly(URI url, int expected, StringEntity content, boolean authenticate) throws Exception {
        String original;
        HttpPost post = new HttpPost(url);
        HttpResponse response = this.putOrPost((HttpEntityEnclosingRequestBase)post, (HttpEntity)content, authenticate);
        int status = response.getStatusLine().getStatusCode();
        if (status == 302 && !(original = url.toString()).equals((url = URI.create(response.getFirstHeader("Location").getValue())).toString())) {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            post = new HttpPost(url);
            response = this.putOrPost((HttpEntityEnclosingRequestBase)post, (HttpEntity)content, true);
            status = response.getStatusLine().getStatusCode();
        }
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)expected, (int)status);
    }

    protected void verifyPOSTStatusOnly(URI url, int expected, StringEntity content, boolean authenticate, boolean validate) throws Exception {
        String original;
        HttpPost post = new HttpPost(url);
        HttpResponse response = this.putOrPost((HttpEntityEnclosingRequestBase)post, (HttpEntity)content, authenticate);
        int status = response.getStatusLine().getStatusCode();
        if (status == 302 && !(original = url.toString()).equals((url = URI.create(response.getFirstHeader("Location").getValue())).toString())) {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            post = new HttpPost(url);
            response = this.putOrPost((HttpEntityEnclosingRequestBase)post, (HttpEntity)content, true);
            status = response.getStatusLine().getStatusCode();
        }
        if (validate) {
            this.validateResponse(url, response);
        } else {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
        Assert.assertEquals((int)expected, (int)status);
    }

    protected void verifyPUTStatusOnly(URI url, int expected, StringEntity content, boolean authenticate) throws Exception {
        String original;
        HttpPut put = new HttpPut(url);
        HttpResponse response = this.putOrPost((HttpEntityEnclosingRequestBase)put, (HttpEntity)content, authenticate);
        int status = response.getStatusLine().getStatusCode();
        if (status == 302 && !(original = url.toString()).equals((url = URI.create(response.getFirstHeader("Location").getValue())).toString())) {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            put = new HttpPut(url);
            response = this.putOrPost((HttpEntityEnclosingRequestBase)put, (HttpEntity)content, true);
            status = response.getStatusLine().getStatusCode();
        }
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)expected, (int)status);
    }

    protected void verifyNoAuthFailOnAPIAAuth(URI url) throws Exception {
        if (this.getAuthAccess()) {
            HttpGet get = new HttpGet(url);
            HttpResponse response = this.getOrDelete((HttpRequestBase)get, false, false);
            int status = response.getStatusLine().getStatusCode();
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            Assert.assertEquals((int)401, (int)status);
        }
    }

    @Test
    public void testGetWADL() throws Exception {
        URI url = TestRESTAPI.getURI("/objects/application.wadl");
        this.verifyNoAuthFailOnAPIAAuth(url);
        this.verifyGETStatusOnly(url, 200);
    }

    @Test
    public void testGetObjectProfile() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects/%s", DEMO_REST_PID.toString()));
        this.verifyNoAuthFailOnAPIAAuth(url);
        HttpGet get = new HttpGet(url);
        int status = 0;
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        status = response.getStatusLine().getStatusCode();
        Assert.assertEquals((int)200, (int)status);
        url = TestRESTAPI.getURI(String.format("/objects/%s?format=xml", DEMO_REST_PID.toString()));
        this.verifyNoAuthFailOnAPIAAuth(url);
        get = new HttpGet(url);
        response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), true);
        status = response.getStatusLine().getStatusCode();
        String responseXML = TestRESTAPI.readString(response);
        Assert.assertEquals((int)200, (int)status);
        Assert.assertTrue((boolean)responseXML.contains("<objLabel>"));
        Assert.assertTrue((boolean)responseXML.contains("<objOwnerId>"));
        Assert.assertTrue((boolean)responseXML.contains("<objCreateDate>"));
        Assert.assertTrue((boolean)responseXML.contains("<objLastModDate>"));
        Assert.assertTrue((boolean)responseXML.contains("<objDissIndexViewURL>"));
        Assert.assertTrue((boolean)responseXML.contains("<objItemIndexViewURL>"));
        Assert.assertTrue((boolean)responseXML.contains("<objState>"));
        url = TestRESTAPI.getURI(String.format("/objects/%s?asOfDateTime=%s", DEMO_REST_PID.toString(), datetime));
        this.verifyNoAuthFailOnAPIAAuth(url);
        this.verifyGETStatusOnly(url, 200);
        url = TestRESTAPI.getURI(String.format("/objects/%s", "demo:BOGUS_PID"));
        this.verifyNoAuthFailOnAPIAAuth(url);
        this.verifyGETStatusOnly(url, 404);
    }

    @Test
    public void testListMethods() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects/%s/methods", DEMO_REST_PID.toString()));
        this.verifyNoAuthFailOnAPIAAuth(url);
        this.verifyGETStatusOnly(url, 200);
        url = TestRESTAPI.getURI(String.format("/objects/%s/methods?format=xml", DEMO_REST_PID.toString()));
        this.verifyNoAuthFailOnAPIAAuth(url);
        this.verifyGETStatusOnly(url, 200);
        url = TestRESTAPI.getURI(String.format("/objects/%s/methods?asOfDateTime=%s", DEMO_REST_PID.toString(), datetime));
        this.verifyNoAuthFailOnAPIAAuth(url);
        this.verifyGETStatusOnly(url, 200);
    }

    @Test
    public void testListMethodsForSDep() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects/%s/methods/fedora-system:3", DEMO_REST_PID.toString()));
        this.verifyNoAuthFailOnAPIAAuth(url);
        HttpGet get = new HttpGet(url);
        int status = 0;
        get = new HttpGet(url);
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        status = response.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)200, (int)status);
        url = TestRESTAPI.getURI(String.format("/objects/%s/methods/fedora-system:3?format=xml", DEMO_REST_PID.toString()));
        this.verifyNoAuthFailOnAPIAAuth(url);
        get = new HttpGet(url);
        response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), true);
        Assert.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
        String responseXML = TestRESTAPI.readString(response);
        Assert.assertTrue((boolean)responseXML.contains("sDef=\"fedora-system:3\""));
        url = TestRESTAPI.getURI(String.format("/objects/%s/methods/fedora-system:3?asOfDateTime=%s", DEMO_REST_PID.toString(), datetime));
        this.verifyNoAuthFailOnAPIAAuth(url);
        get = new HttpGet(url);
        response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        status = response.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)200, (int)status);
    }

    @Test
    public void testGETMethodBuiltInBadMethod() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects/%s/methods/fedora-system:3/noSuchMethod", DEMO_REST_PID.toString()));
        this.verifyNoAuthFailOnAPIAAuth(url);
        HttpGet get = new HttpGet(url);
        int status = 0;
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        status = response.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertFalse((200 == status ? 1 : 0) != 0);
    }

    @Test
    public void testGETMethodBuiltInBadUserArg() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects/%s/methods/fedora-system:3/viewMethodIndex?noSuchArg=foo", DEMO_REST_PID.toString()));
        this.verifyNoAuthFailOnAPIAAuth(url);
        HttpGet get = new HttpGet(url);
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        int status = response.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertFalse((200 == status ? 1 : 0) != 0);
    }

    @Test
    public void testGETMethodBuiltInNoArg() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects/%s/methods/fedora-system:3/viewMethodIndex", DEMO_REST_PID.toString()));
        this.verifyNoAuthFailOnAPIAAuth(url);
        HttpGet get = new HttpGet(url);
        int status = 0;
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        status = response.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)200, (int)status);
    }

    @Test
    public void testGETMethodCustomBadMethod() throws Exception {
        URI url = TestRESTAPI.getURI("/objects/demo:14/methods/demo:12/noSuchMethod");
        this.verifyNoAuthFailOnAPIAAuth(url);
        HttpGet get = new HttpGet(url);
        int status = 0;
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        status = response.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertFalse((200 == status ? 1 : 0) != 0);
    }

    @Test
    public void testGETMethodCustomBadUserArg() throws Exception {
        URI url = TestRESTAPI.getURI("/objects/demo:14/methods/demo:12/getDocumentStyle1?noSuchArg=foo");
        this.verifyNoAuthFailOnAPIAAuth(url);
        HttpGet get = new HttpGet(url);
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        int status = response.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertFalse((200 == status ? 1 : 0) != 0);
    }

    @Test
    public void testGETMethodCustomNoArg() throws Exception {
        URI url = TestRESTAPI.getURI("/objects/demo:14/methods/demo:12/getDocumentStyle1");
        this.verifyNoAuthFailOnAPIAAuth(url);
        HttpGet get = new HttpGet(url);
        int status = 0;
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        status = response.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)200, (int)status);
    }

    @Test
    public void testGETMethodCustomGoodUserArg() throws Exception {
        URI url = TestRESTAPI.getURI("/objects/demo:29/methods/demo:27/resizeImage?width=50");
        this.verifyNoAuthFailOnAPIAAuth(url);
        HttpGet get = new HttpGet(url);
        int status = 0;
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), true);
        status = response.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)200, (int)status);
        Assert.assertEquals((String)"image/jpeg", (String)response.getFirstHeader("Content-Type").getValue());
    }

    @Test
    public void testGETMethodCustomGoodUserArgGoodDate() throws Exception {
        URI url = TestRESTAPI.getURI("/objects/demo:29/methods/demo:27/resizeImage?width=50&asOfDateTime=" + datetime);
        this.verifyNoAuthFailOnAPIAAuth(url);
        HttpGet get = new HttpGet(url);
        int status = 0;
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), true);
        status = response.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)200, (int)status);
        Assert.assertEquals((String)"image/jpeg", (String)response.getFirstHeader("Content-Type").getValue());
    }

    @Test
    public void testGETMethodCustomUserArgBadDate() throws Exception {
        URI url = TestRESTAPI.getURI("/objects/demo:14/methods/demo:12/getDocumentStyle1?width=50&asOfDateTime=badDate");
        this.verifyNoAuthFailOnAPIAAuth(url);
        HttpGet get = new HttpGet(url);
        int status = 0;
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        status = response.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertFalse((200 == status ? 1 : 0) != 0);
    }

    @Test
    public void testGETMethodCustomUserArgEarlyDate() throws Exception {
        URI url = TestRESTAPI.getURI("/objects/demo:14/methods/demo:12/getDocumentStyle1?width=50&asOfDateTime=1999-11-21T16:38:32.200Z");
        this.verifyNoAuthFailOnAPIAAuth(url);
        HttpGet get = new HttpGet(url);
        int status = 0;
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        status = response.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)404, (int)status);
    }

    @Test
    public void testGETMethodCustomGoodDate() throws Exception {
        URI url = TestRESTAPI.getURI("/objects/demo:14/methods/demo:12/getDocumentStyle1?asOfDateTime=" + datetime);
        this.verifyNoAuthFailOnAPIAAuth(url);
        HttpGet get = new HttpGet(url);
        int status = 0;
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), true);
        status = response.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)200, (int)status);
    }

    @Test
    public void testGETMethodCustomBadDate() throws Exception {
        URI url = TestRESTAPI.getURI("/objects/demo:14/methods/demo:12/getDocumentStyle1?asOfDateTime=badDate");
        this.verifyNoAuthFailOnAPIAAuth(url);
        HttpGet get = new HttpGet(url);
        int status = 0;
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        status = response.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertFalse((200 == status ? 1 : 0) != 0);
    }

    @Test
    public void testGETMethodCustomEarlyDate() throws Exception {
        URI url = TestRESTAPI.getURI("/objects/demo:14/methods/demo:12/getDocumentStyle1?asOfDateTime=1999-11-21T16:38:32.200Z");
        this.verifyNoAuthFailOnAPIAAuth(url);
        HttpGet get = new HttpGet(url);
        int status = 0;
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        status = response.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)404, (int)status);
    }

    @Test
    public void testListDatastreams() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams", DEMO_REST_PID.toString()));
        this.verifyNoAuthFailOnAPIAAuth(url);
        this.verifyGETStatusOnly(url, 200, true, true);
        url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams?format=xml", DEMO_REST_PID.toString()));
        this.verifyNoAuthFailOnAPIAAuth(url);
        this.verifyGETStatusOnly(url, 200, true, true);
        url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams?asOfDateTime=%s", DEMO_REST_PID.toString(), datetime));
        this.verifyNoAuthFailOnAPIAAuth(url);
        this.verifyGETStatusOnly(url, 200, true, true);
        url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams?format=xml&profiles=true", DEMO_REST_PID.toString()));
        this.verifyGETStatusOnly(url, 401, false, false);
        String responseString = this.verifyGETStatusString(url, 200, true, true);
        Assert.assertTrue((responseString.indexOf("datastreamProfile") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testDeletedObject() throws Exception {
        if (!this.getAuthAccess()) {
            String modResponse = this.apim.modifyObject(DEMO_REST_PID.toString(), "D", null, null, "Mark object as deleted");
            LOGGER.info(modResponse);
            URI url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams", DEMO_REST_PID.toString()));
            LOGGER.info("Testing object marked deleted at {}", (Object)url);
            this.verifyGETStatusString(url, 401, false, false);
            this.verifyGETStatusString(url, 200, true, true);
        }
    }

    @Test
    public void testGetDatastreamProfile() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams/RELS-EXT", DEMO_REST_PID.toString()));
        this.verifyGETStatusString(url, 401, false, false);
        String responseXML = this.verifyGETStatusString(url, 200, true, true);
        Assert.assertTrue((boolean)responseXML.contains("<html>"));
        url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams/RELS-EXT?format=xml", DEMO_REST_PID.toString()));
        this.verifyGETStatusString(url, 401, false, false);
        responseXML = this.verifyGETStatusString(url, 200, true, true);
        Assert.assertTrue((boolean)responseXML.contains("<dsLabel>"));
        url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams/RELS-EXT?asOfDateTime=%s&format=xml", DEMO_REST_PID.toString(), datetime));
        this.verifyGETStatusString(url, 401, false, false);
        responseXML = this.verifyGETStatusString(url, 200, true, false);
        Assert.assertTrue((boolean)responseXML.contains("<dsLabel>"));
        url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams/BOGUS_DSID", DEMO_REST_PID.toString()));
        this.verifyGETStatusString(url, 401, false, false);
        this.verifyGETStatusString(url, 404, true, true);
    }

    @Test
    public void testGetDatastreamHistory() throws Exception {
        URI url = TestRESTAPI.getURI("/objects/new");
        StringEntity entity = TestRESTAPI.getStringEntity(DEMO_MIN_PID, TEXT_XML);
        this.verifyPOSTStatusOnly(url, 401, entity, false);
        this.verifyPOSTStatusOnly(url, 201, entity, true);
        url = TestRESTAPI.getURI(String.format("/objects/demo:1234/datastreams/DS1/history?format=xml", new Object[0]));
        this.verifyNoAuthFailOnAPIAAuth(url);
        String responseXML = this.verifyGETStatusString(url, 200, true, true);
        String control = FileUtils.readFileToString((File)new File(REST_RESOURCE_PATH + "/datastreamHistory.xml"), (String)"UTF-8");
        StringTemplate tpl = new StringTemplate(control);
        tpl.setAttribute("FEDORA_BASE_URL", (Object)(TestRESTAPI.getProtocol() + "://" + TestRESTAPI.getHost() + ":" + TestRESTAPI.getPort()));
        XMLUnit.setIgnoreWhitespace((boolean)true);
        Diff xmldiff = new Diff(tpl.toString(), responseXML);
        Assert.assertTrue((String)xmldiff.toString(), (boolean)xmldiff.identical());
        url = TestRESTAPI.getURI("/objects/demo:1234/datastreams/BOGUS_DSID");
        this.verifyGETStatusString(url, 401, false, false);
        this.verifyGETStatusOnly(url, 404, true, false);
        url = TestRESTAPI.getURI("/objects/demo:1234");
        this.verifyDELETEStatusOnly(url, 401, false);
        this.verifyDELETEStatusOnly(url, 200, true);
    }

    @Test
    public void testGetDatastreamDissemination() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams/RELS-EXT/content", DEMO_REST_PID.toString()));
        this.verifyNoAuthFailOnAPIAAuth(url);
        HttpGet get = new HttpGet(url);
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        int status = response.getStatusLine().getStatusCode();
        Header length = response.getFirstHeader("Content-Length");
        String responseXML = TestRESTAPI.readString(response);
        Assert.assertEquals((int)200, (int)status);
        Assert.assertNotNull((Object)length);
        Assert.assertNotNull((Object)length.getValue());
        long lengthlong = Long.parseLong(length.getValue());
        Assert.assertTrue((lengthlong > 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)responseXML.contains("rdf:Description"));
        url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams/RELS-EXT/content?asOfDateTime=%s", DEMO_REST_PID.toString(), datetime));
        this.verifyNoAuthFailOnAPIAAuth(url);
        response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        status = response.getStatusLine().getStatusCode();
        length = response.getFirstHeader("Content-Length");
        responseXML = TestRESTAPI.readString(response);
        Assert.assertEquals((int)200, (int)status);
        Assert.assertNotNull((Object)length);
        Assert.assertNotNull((Object)length.getValue());
        lengthlong = Long.parseLong(length.getValue());
        Assert.assertTrue((lengthlong > 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)responseXML.contains("rdf:Description"));
        url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams/BOGUS_DSID/content", DEMO_REST_PID.toString()));
        this.verifyNoAuthFailOnAPIAAuth(url);
        this.verifyGETStatusString(url, 404, this.getAuthAccess(), false);
    }

    @Test
    public void testFindObjects() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects?pid=true&terms=%s&query=&resultFormat=xml", DEMO_REST_PID.toString()));
        this.verifyNoAuthFailOnAPIAAuth(url);
        this.verifyGETStatusOnly(url, 200, false);
    }

    @Test
    public void testFindObjectWithSingleQuote() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects?pid=true&description=true&terms='Coliseum'&query&maxResults=20&resultFormat=xml", DEMO_REST_PID.toString()));
        this.verifyNoAuthFailOnAPIAAuth(url);
        String xmlResult = this.verifyGETStatusString(url, 200, this.getAuthAccess(), false);
        Assert.assertTrue((xmlResult.indexOf("<pid>demo:REST</pid>") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testResumeFindObjects() throws Exception {
        URI url = TestRESTAPI.getURI("/objects?pid=true&query=&resultFormat=xml&maxResults=4");
        this.verifyNoAuthFailOnAPIAAuth(url);
        String responseXML = this.verifyGETStatusString(url, 200, this.getAuthAccess(), false);
        String sessionToken = responseXML.substring(responseXML.indexOf("<token>") + 7, responseXML.indexOf("</token>"));
        url = TestRESTAPI.getURI(String.format("/objects?pid=true&query=&resultFormat=xml&sessionToken=%s", sessionToken));
        this.verifyNoAuthFailOnAPIAAuth(url);
        this.verifyGETStatusOnly(url, 200);
    }

    @Test
    public void testFindObjectsBadSyntax() throws Exception {
        URI url = TestRESTAPI.getURI("/objects?pid=true&query=label%3D%3F&maxResults=20");
        for (int i = 0; i < 101; ++i) {
            this.verifyGETStatusOnly(url, 500, false);
        }
    }

    @Test
    public void testGetObjectHistory() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects/%s/versions", DEMO_REST_PID.toString()));
        this.verifyNoAuthFailOnAPIAAuth(url);
        this.verifyGETStatusOnly(url, 200);
        url = TestRESTAPI.getURI(String.format("/objects/%s/versions?format=xml", DEMO_REST_PID.toString()));
        this.verifyNoAuthFailOnAPIAAuth(url);
        this.verifyGETStatusOnly(url, 200);
    }

    private String extractPid(String source) {
        Matcher m = Pattern.compile("^.*/([^/]+$)").matcher(source);
        String pid = null;
        if (m.find() && m.groupCount() == 1) {
            pid = m.group(1);
        }
        pid = pid.replaceAll("\n", "").replaceAll("\r", "").replaceAll("%3A", ":");
        return pid;
    }

    @Test
    public void testIngest() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects/new", new Object[0]));
        StringEntity entity = TestRESTAPI.getStringEntity("", TEXT_XML);
        this.verifyPOSTStatusOnly(url, 401, entity, false);
        HttpPost post = new HttpPost(url);
        HttpResponse response = this.putOrPost((HttpEntityEnclosingRequestBase)post, (HttpEntity)entity, true);
        String responseBody = TestRESTAPI.readString(response);
        Assert.assertEquals((int)201, (int)response.getStatusLine().getStatusCode());
        String emptyObjectPid = this.extractPid(response.getFirstHeader("Location").getValue());
        Assert.assertNotNull((Object)emptyObjectPid);
        Assert.assertTrue((boolean)responseBody.equals(emptyObjectPid));
        url = TestRESTAPI.getURI(String.format("/objects/%s", emptyObjectPid));
        this.verifyDELETEStatusOnly(url, 401, false);
        this.verifyDELETEStatusOnly(url, 200, true);
        this.verifyGETStatusOnly(url, 404);
        url = TestRESTAPI.getURI(String.format("/objects/new?namespace=test", new Object[0]));
        this.verifyPOSTStatusOnly(url, 401, entity, false);
        post = new HttpPost(url);
        response = this.putOrPost((HttpEntityEnclosingRequestBase)post, (HttpEntity)entity, true);
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)201, (int)response.getStatusLine().getStatusCode());
        emptyObjectPid = this.extractPid(response.getFirstHeader("Location").getValue());
        Assert.assertTrue((boolean)emptyObjectPid.startsWith("test"));
        url = TestRESTAPI.getURI(String.format("/objects/%s", emptyObjectPid));
        this.verifyDELETEStatusOnly(url, 401, false);
        this.verifyDELETEStatusOnly(url, 200, true);
        url = TestRESTAPI.getURI(String.format("/objects/new?state=I", new Object[0]));
        this.verifyPOSTStatusOnly(url, 401, entity, false);
        post = new HttpPost(url);
        response = this.putOrPost((HttpEntityEnclosingRequestBase)post, (HttpEntity)entity, true);
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)201, (int)response.getStatusLine().getStatusCode());
        emptyObjectPid = this.extractPid(response.getFirstHeader("Location").getValue());
        url = TestRESTAPI.getURI(String.format("/objects/%s?format=xml", emptyObjectPid));
        HttpGet get = new HttpGet(url);
        response = this.getOrDelete((HttpRequestBase)get, true, true);
        int status = response.getStatusLine().getStatusCode();
        String responseXML = TestRESTAPI.readString(response);
        Assert.assertEquals((int)200, (int)status);
        Assert.assertTrue((boolean)responseXML.contains("<objState>I</objState>"));
        this.verifyDELETEStatusOnly(url, 401, false);
        this.verifyDELETEStatusOnly(url, 200, true);
        url = TestRESTAPI.getURI(String.format("/objects/%s", DEMO_REST_PID.toString()));
        this.verifyDELETEStatusOnly(url, 401, false);
        this.verifyDELETEStatusOnly(url, 200, true);
        url = TestRESTAPI.getURI(String.format("/objects/%s?ownerId=%s", DEMO_REST_PID.toString(), DEMO_OWNERID));
        this.verifyPOSTStatusOnly(url, 401, null, false);
        post = new HttpPost(url);
        response = this.putOrPost((HttpEntityEnclosingRequestBase)post, (HttpEntity)entity, true);
        responseBody = TestRESTAPI.readString(response);
        Assert.assertEquals((int)201, (int)response.getStatusLine().getStatusCode());
        Header locationHeader = response.getFirstHeader("Location");
        Assert.assertNotNull((Object)locationHeader);
        Assert.assertTrue((boolean)locationHeader.getValue().contains(URLEncoder.encode(DEMO_REST_PID.toString(), "UTF-8")));
        Assert.assertTrue((boolean)responseBody.equals(DEMO_REST_PID.toString()));
        responseBody = this.verifyGETStatusString(url, 200, true, true);
        Assert.assertTrue((responseBody.indexOf(DEMO_OWNERID) > 0 ? 1 : 0) != 0);
        url = TestRESTAPI.getURI(String.format("/objects/%s", DEMO_REST_PID.toString()));
        this.verifyDELETEStatusOnly(url, 401, false);
        this.verifyDELETEStatusOnly(url, 200, true);
        url = TestRESTAPI.getURI(String.format("/objects/%s", DEMO_REST_PID.toString()));
        entity = TestRESTAPI.getStringEntity(DEMO_REST, TEXT_XML);
        this.verifyPOSTStatusOnly(url, 401, entity, false);
        post = new HttpPost(url);
        response = this.putOrPost((HttpEntityEnclosingRequestBase)post, (HttpEntity)entity, true);
        responseBody = TestRESTAPI.readString(response);
        Assert.assertEquals((int)201, (int)response.getStatusLine().getStatusCode());
        locationHeader = response.getFirstHeader("Location");
        Assert.assertNotNull((Object)locationHeader);
        Assert.assertTrue((boolean)locationHeader.getValue().contains(URLEncoder.encode(DEMO_REST_PID.toString(), "UTF-8")));
        Assert.assertTrue((boolean)responseBody.equals(DEMO_REST_PID.toString()));
        url = TestRESTAPI.getURI(String.format("/objects/new", new Object[0]));
        entity = TestRESTAPI.getStringEntity(DEMO_MIN, TEXT_XML);
        this.verifyPOSTStatusOnly(url, 401, entity, false);
        post = new HttpPost(url);
        response = this.putOrPost((HttpEntityEnclosingRequestBase)post, (HttpEntity)entity, true);
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)201, (int)response.getStatusLine().getStatusCode());
        String minimalObjectPid = this.extractPid(response.getFirstHeader("Location").getValue());
        url = TestRESTAPI.getURI(String.format("/objects/%s", minimalObjectPid));
        this.verifyDELETEStatusOnly(url, 401, false);
        this.verifyDELETEStatusOnly(url, 200, true);
    }

    @Test
    public void testIngestWithParameterPid() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects/new", new Object[0]));
        StringEntity entity = TestRESTAPI.getStringEntity(DEMO_MIN_PID, TEXT_XML);
        this.verifyPOSTStatusOnly(url, 401, entity, false);
        this.verifyPOSTStatusOnly(url, 201, entity, true);
        url = TestRESTAPI.getURI(String.format("/objects/%s", "demo:1234"));
        this.verifyDELETEStatusOnly(url, 401, false);
        this.verifyDELETEStatusOnly(url, 200, true);
        url = TestRESTAPI.getURI(String.format("/objects/%s", "demo:234"));
        this.verifyPOSTStatusOnly(url, 401, entity, false);
        this.verifyPOSTStatusOnly(url, 500, entity, true);
        url = TestRESTAPI.getURI(String.format("/objects/%s", "demo:1234"));
        this.verifyPOSTStatusOnly(url, 401, entity, false);
        this.verifyPOSTStatusOnly(url, 201, entity, true);
        url = TestRESTAPI.getURI(String.format("/objects/%s", "demo:1234"));
        this.verifyDELETEStatusOnly(url, 401, false);
        this.verifyDELETEStatusOnly(url, 200, true);
        url = TestRESTAPI.getURI(String.format("/objects/%s", "demo:234"));
        entity = TestRESTAPI.getStringEntity(DEMO_MIN, TEXT_XML);
        this.verifyPOSTStatusOnly(url, 401, entity, false);
        this.verifyPOSTStatusOnly(url, 201, entity, true);
        url = TestRESTAPI.getURI(String.format("/objects/%s", "demo:234"));
        this.verifyDELETEStatusOnly(url, 401, false);
        this.verifyDELETEStatusOnly(url, 200, true);
    }

    @Test
    public void testModifyObject() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects/%s?label=%s", DEMO_REST_PID.toString(), "foo"));
        StringEntity entity = TestRESTAPI.getStringEntity("", TEXT_XML);
        this.verifyPUTStatusOnly(url, 401, entity, false);
        this.verifyPUTStatusOnly(url, 200, entity, true);
        Assert.assertEquals((String)"foo", (String)this.apia.getObjectProfile(DEMO_REST_PID.toString(), null).getObjLabel());
    }

    @Test
    public void testGetObjectXML() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects/%s/objectXML", DEMO_REST_PID.toString()));
        this.verifyGETStatusString(url, 401, false, true);
        this.verifyGETStatusString(url, 200, true, true);
    }

    @Test
    public void testValidate() throws Exception {
        String[] resultFields = new String[]{"pid"};
        BigInteger maxResults = new BigInteger("1000");
        FieldSearchQuery query = new FieldSearchQuery();
        ObjectFactory factory = new ObjectFactory();
        query.setTerms(factory.createFieldSearchQueryTerms("*"));
        FieldSearchResult result = this.apia.findObjects(TypeUtility.convertStringtoAOS((String[])resultFields), maxResults, query);
        List fields = result.getResultList().getObjectFields();
        String pid = "";
        URI url = null;
        for (ObjectFields objectFields : fields) {
            if (objectFields == null) continue;
            pid = objectFields.getPid() != null ? (String)objectFields.getPid().getValue() : "";
            url = TestRESTAPI.getURI(String.format("/objects/%s/validate", pid.toString()));
            this.verifyGETStatusString(url, 401, false, false);
            String responseXML = this.verifyGETStatusString(url, 200, true, true);
            XMLAssert.assertXpathExists((String)"/management:validation[@valid='true']", (String)responseXML);
        }
        url = TestRESTAPI.getURI(String.format("/objects/%s/validate?asOfDateTime=%s", pid.toString(), df.format(new Date())));
        this.verifyGETStatusString(url, 401, false, false);
        String responseXML = this.verifyGETStatusString(url, 200, true, true);
        XMLAssert.assertXpathExists((String)"/management:validation[@valid='true']", (String)responseXML);
        url = TestRESTAPI.getURI(String.format("/objects/%s/validate?asOfDateTime=%s", pid.toString(), earlierDateTime));
        this.verifyGETStatusString(url, 401, false, false);
        responseXML = this.verifyGETStatusString(url, 200, true, true);
        XMLAssert.assertXpathExists((String)"/management:validation[@valid='false']", (String)responseXML);
    }

    @Test
    public void testExportObject() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects/%s/export", DEMO_REST_PID.toString()));
        this.verifyGETStatusString(url, 401, false, false);
        this.verifyGETStatusString(url, 200, true, true);
        url = TestRESTAPI.getURI(String.format("/objects/%s/export?context=public", DEMO_REST_PID.toString()));
        this.verifyGETStatusString(url, 401, false, false);
        this.verifyGETStatusString(url, 200, true, true);
    }

    @Test
    public void testPurgeObject() throws Exception {
        URI url = TestRESTAPI.getURI("/objects/demo:TEST_PURGE");
        StringEntity entity = TestRESTAPI.getStringEntity("", TEXT_XML);
        this.verifyPOSTStatusOnly(url, 401, entity, false);
        this.verifyPOSTStatusOnly(url, 201, entity, true);
        this.verifyDELETEStatusOnly(url, 401, false);
        this.verifyDELETEStatusOnly(url, 200, true);
    }

    @Test
    public void testAddDatastream() throws Exception {
        String xmlData = "<foo>bar</foo>";
        String dsPath = "/objects/" + DEMO_REST_PID + "/datastreams/FOO";
        URI url = TestRESTAPI.getURI(dsPath + "?controlGroup=X&dsLabel=foo");
        StringEntity entity = TestRESTAPI.getStringEntity(xmlData, TEXT_XML);
        this.verifyPOSTStatusOnly(url, 401, entity, false);
        HttpPost post = new HttpPost(url);
        HttpResponse response = this.putOrPost((HttpEntityEnclosingRequestBase)post, (HttpEntity)entity, true);
        String expected = TestRESTAPI.readString(response);
        Assert.assertEquals((int)201, (int)response.getStatusLine().getStatusCode());
        Header locationHeader = response.getFirstHeader("Location");
        Assert.assertNotNull((Object)locationHeader);
        Assert.assertEquals((Object)TestRESTAPI.getURI(dsPath), (Object)URI.create(locationHeader.getValue()));
        Assert.assertEquals((String)TEXT_XML, (String)response.getFirstHeader("Content-Type").getValue());
        url = TestRESTAPI.getURI(dsPath + "?format=xml");
        String actual = this.verifyGETStatusString(url, 200, true, true);
        Assert.assertEquals((String)expected, (String)actual);
        String mimeType = "text/plain";
        Datastream ds = this.apim.getDatastream(DEMO_REST_PID.toString(), "BAR", null);
        Assert.assertNull((Object)ds);
        dsPath = "/objects/" + DEMO_REST_PID + "/datastreams/BAR";
        url = TestRESTAPI.getURI(dsPath + "?controlGroup=M&dsLabel=bar&mimeType=" + mimeType);
        File temp = File.createTempFile("test", null);
        DataOutputStream os = new DataOutputStream(new FileOutputStream(temp));
        os.write(42);
        os.close();
        response = this.post(url, temp, false);
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)401, (int)response.getStatusLine().getStatusCode());
        response = this.post(url, temp, true);
        expected = TestRESTAPI.readString(response);
        Assert.assertEquals((int)201, (int)response.getStatusLine().getStatusCode());
        locationHeader = response.getFirstHeader("Location");
        Assert.assertNotNull((Object)locationHeader);
        Assert.assertEquals((Object)TestRESTAPI.getURI(dsPath), (Object)URI.create(locationHeader.getValue()));
        Assert.assertEquals((String)TEXT_XML, (String)response.getFirstHeader("Content-Type").getValue());
        url = TestRESTAPI.getURI(dsPath + "?format=xml");
        actual = this.verifyGETStatusString(url, 200, true, true);
        Assert.assertEquals((String)expected, (String)actual);
        ds = this.apim.getDatastream(DEMO_REST_PID.toString(), "BAR", null);
        Assert.assertNotNull((Object)ds);
        Assert.assertEquals((String)ds.getMIMEType(), (String)mimeType);
    }

    @Test
    public void testModifyDatastreamByReference() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams/BAR?controlGroup=M&dsLabel=testModifyDatastreamByReference(bar)", DEMO_REST_PID.toString()));
        File temp = File.createTempFile("test", null);
        DataOutputStream os = new DataOutputStream(new FileOutputStream(temp));
        os.write(42);
        os.close();
        HttpResponse response = this.post(url, temp, false);
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)401, (int)response.getStatusLine().getStatusCode());
        response = this.post(url, temp, true);
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)201, (int)response.getStatusLine().getStatusCode());
        url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams/BAR", DEMO_REST_PID.toString()));
        Assert.assertEquals((int)401, (int)this.put(url, temp, false).getStatusLine().getStatusCode());
        response = this.put(url, temp, true);
        String expected = TestRESTAPI.readString(response);
        Assert.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
        Assert.assertEquals((String)TEXT_XML, (String)response.getFirstHeader("Content-Type").getValue());
        url = TestRESTAPI.getURI(url.toString() + "?format=xml");
        String actual = this.verifyGETStatusString(url, 200, true, true);
        Assert.assertEquals((String)expected, (String)actual);
        url = TestRESTAPI.getURI("/objects/" + DEMO_REST_PID + "/datastreams/BOGUS_DS");
        response = this.put(url, temp, true);
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)404, (int)response.getStatusLine().getStatusCode());
        url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams/BAR", DEMO_REST_PID.toString()));
        response = this.post(url, temp, true);
        expected = TestRESTAPI.readString(response);
        Assert.assertEquals((int)201, (int)response.getStatusLine().getStatusCode());
        Header locationHeader = response.getFirstHeader("Location");
        Assert.assertNotNull((Object)locationHeader);
        Assert.assertEquals((String)url.toString(), (String)locationHeader.getValue());
        Assert.assertEquals((String)TEXT_XML, (String)response.getFirstHeader("Content-Type").getValue());
        url = TestRESTAPI.getURI(url.toString() + "?format=xml");
        actual = this.verifyGETStatusString(url, 200, true, true);
        Assert.assertEquals((String)expected, (String)actual);
        String newLabel = "tikibar";
        url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams/BAR?dsLabel=%s", DEMO_REST_PID.toString(), newLabel));
        this.verifyPUTStatusOnly(url, 401, null, false);
        this.verifyPUTStatusOnly(url, 200, null, true);
        Assert.assertEquals((String)newLabel, (String)this.apim.getDatastream(DEMO_REST_PID.toString(), "BAR", null).getLabel());
        String newLocation = "http://" + TestRESTAPI.getHost() + ":" + TestRESTAPI.getPort() + "/" + TestRESTAPI.getFedoraAppServerContext() + "/get/demo:REST/DC";
        url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams/EXTDS?dsLocation=%s", DEMO_REST_PID.toString(), newLocation));
        this.verifyPUTStatusOnly(url, 401, null, false);
        this.verifyPUTStatusOnly(url, 200, null, true);
        Assert.assertEquals((String)newLocation, (String)this.apim.getDatastream(DEMO_REST_PID.toString(), "EXTDS", null).getLocation());
        String dcDS = new String(TypeUtility.convertDataHandlerToBytes((DataHandler)this.apia.getDatastreamDissemination(DEMO_REST_PID.toString(), "DC", null).getStream()));
        String extDS = new String(TypeUtility.convertDataHandlerToBytes((DataHandler)this.apia.getDatastreamDissemination(DEMO_REST_PID.toString(), "EXTDS", null).getStream()));
        Assert.assertEquals((String)dcDS, (String)extDS);
        if (this.getAuthAccess()) {
            url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams/DS1?dsLocation=%s", DEMO_REST_PID.toString(), newLocation));
            this.verifyPUTStatusOnly(url, 401, null, false);
            this.verifyPUTStatusOnly(url, 500, null, true);
        }
        newLocation = TestRESTAPI.getBaseURL() + "/ri/index.xsl";
        url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams/DS1?dsLocation=%s", DEMO_REST_PID.toString(), newLocation));
        this.verifyPUTStatusOnly(url, 401, null, false);
        this.verifyPUTStatusOnly(url, 200, null, true);
    }

    @Test
    public void testModifyDatastreamByValue() throws Exception {
        String xmlData = "<baz>quux</baz>";
        StringEntity entity = TestRESTAPI.getStringEntity(xmlData, TEXT_XML);
        URI url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams/DS1?dsLabel=testModifyDatastreamByValue", DEMO_REST_PID.toString()));
        this.verifyPUTStatusOnly(url, 401, entity, false);
        this.verifyPUTStatusOnly(url, 200, entity, true);
        MIMETypedStream ds1 = this.apia.getDatastreamDissemination(DEMO_REST_PID.toString(), "DS1", null);
        XMLAssert.assertXMLEqual((String)xmlData, (String)new String(TypeUtility.convertDataHandlerToBytes((DataHandler)ds1.getStream()), "UTF-8"));
    }

    @Test
    public void testModifyDatastreamNoContent() throws Exception {
        String label = "testModifyDatastreamNoContent";
        URI url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams/DS1?dsLabel=%s", DEMO_REST_PID.toString(), label));
        StringEntity entity = TestRESTAPI.getStringEntity("", TEXT_XML);
        this.verifyPUTStatusOnly(url, 401, entity, false);
        this.verifyPUTStatusOnly(url, 200, entity, true);
        Datastream ds1 = this.apim.getDatastream(DEMO_REST_PID.toString(), "DS1", null);
        Assert.assertEquals((String)label, (String)ds1.getLabel());
    }

    @Test
    public void testSetDatastreamState() throws Exception {
        String state = "D";
        URI url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams/DS1?dsState=%s", DEMO_REST_PID.toString(), state));
        StringEntity entity = TestRESTAPI.getStringEntity("", TEXT_XML);
        this.verifyPUTStatusOnly(url, 401, entity, false);
        this.verifyPUTStatusOnly(url, 200, entity, true);
        Datastream ds1 = this.apim.getDatastream(DEMO_REST_PID.toString(), "DS1", null);
        Assert.assertEquals((String)state, (String)ds1.getState());
    }

    @Test
    public void testSetDatastreamVersionable() throws Exception {
        boolean versionable = false;
        URI url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams/DS1?versionable=%s", DEMO_REST_PID.toString(), versionable));
        StringEntity entity = TestRESTAPI.getStringEntity("", TEXT_XML);
        this.verifyPUTStatusOnly(url, 401, entity, false);
        this.verifyPUTStatusOnly(url, 200, entity, true);
        Datastream ds1 = this.apim.getDatastream(DEMO_REST_PID.toString(), "DS1", null);
        Assert.assertEquals((boolean)versionable, (boolean)ds1.isVersionable());
    }

    @Test
    public void testPurgeDatastream() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams/RELS-EXT", DEMO_REST_PID.toString()));
        this.verifyDELETEStatusOnly(url, 401, false);
        this.verifyDELETEStatusOnly(url, 200, true);
    }

    @Test
    public void testGetNextPID() throws Exception {
        URI url = TestRESTAPI.getURI("/objects/nextPID");
        this.verifyPOSTStatusOnly(url, 401, null, false);
        this.verifyPOSTStatusOnly(url, 200, null, true, false);
    }

    @Test
    public void testLifecycle() throws Exception {
        HttpResponse response = null;
        URI url = TestRESTAPI.getURI("/objects/nextPID?format=xml");
        this.verifyPOSTStatusOnly(url, 401, null, false);
        HttpPost post = new HttpPost(url);
        response = this.putOrPost((HttpEntityEnclosingRequestBase)post, null, true);
        String responseXML = TestRESTAPI.readString(response);
        Assert.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
        String pid = responseXML.substring(responseXML.indexOf("<pid>") + 5, responseXML.indexOf("</pid>"));
        String label = "Lifecycle-Test-Label";
        url = TestRESTAPI.getURI(String.format("/objects/%s?label=%s", pid, label));
        this.verifyPOSTStatusOnly(url, 401, null, false);
        this.verifyPOSTStatusOnly(url, 201, null, true);
        String datastreamData = "<test>Test Datastream</test>";
        StringEntity entity = TestRESTAPI.getStringEntity(datastreamData, TEXT_XML);
        url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams/TESTDS?controlGroup=X&dsLabel=Test", pid.toString()));
        this.verifyPOSTStatusOnly(url, 401, entity, false);
        this.verifyPOSTStatusOnly(url, 201, entity, true);
        url = TestRESTAPI.getURI(String.format("/objects/%s/objectXML", pid));
        this.verifyGETStatusString(url, 401, false, false);
        responseXML = this.verifyGETStatusString(url, 200, true, true);
        Assert.assertTrue((responseXML.indexOf(label) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((responseXML.indexOf(datastreamData) > 0 ? 1 : 0) != 0);
        label = "Updated-Label";
        url = TestRESTAPI.getURI(String.format("/objects/%s?label=%s", pid.toString(), label));
        this.verifyPUTStatusOnly(url, 401, null, false);
        this.verifyPUTStatusOnly(url, 200, null, true);
        datastreamData = "<test>Update Test</test>";
        entity = TestRESTAPI.getStringEntity(datastreamData, TEXT_XML);
        url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams/TESTDS", pid.toString()));
        this.verifyPUTStatusOnly(url, 401, entity, false);
        this.verifyPUTStatusOnly(url, 200, entity, true);
        url = TestRESTAPI.getURI(String.format("/objects/%s/export", pid.toString()));
        this.verifyGETStatusString(url, 401, false, false);
        responseXML = this.verifyGETStatusString(url, 200, true, true);
        Assert.assertTrue((responseXML.indexOf(label) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((responseXML.indexOf(datastreamData) > 0 ? 1 : 0) != 0);
        url = TestRESTAPI.getURI(String.format("/objects/%s/datastreams/TESTDS", pid));
        this.verifyDELETEStatusOnly(url, 401, false);
        this.verifyDELETEStatusOnly(url, 200, true);
        url = TestRESTAPI.getURI(String.format("/objects/%s", pid));
        this.verifyDELETEStatusOnly(url, 401, false);
        this.verifyDELETEStatusOnly(url, 200, true);
    }

    @Test
    public void testChunked() throws Exception {
        this.chunked = true;
        this.testIngest();
        this.testModifyDatastreamByValue();
        this.testModifyDatastreamNoContent();
        this.testLifecycle();
    }

    @Test
    public void testResponseOverride() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects/%s", "demo:BOGUS_PID"));
        this.verifyPUTStatusOnly(url, 404, null, true);
        url = TestRESTAPI.getURI(String.format("/objects/%s?flash=true", "demo:BOGUS_PID"));
        this.verifyPUTStatusOnly(url, 200, null, true);
    }

    @Test
    public void testDatastreamDisseminationContentDispositionFromRels() throws Exception {
        URI url = TestRESTAPI.getURI("/objects/demo:REST/datastreams/DS1/content");
        HttpGet get = new HttpGet(url);
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
        this.CheckCDHeader(response, "inline", DS1RelsFilename);
        url = TestRESTAPI.getURI(url.toString() + "?download=true");
        get = new HttpGet(url);
        response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
        this.CheckCDHeader(response, "attachment", DS1RelsFilename);
    }

    @Test
    public void testDatastreamDisseminationContentDispositionFromLabel() throws Exception {
        int status = 0;
        URI url = TestRESTAPI.getURI("/objects/demo:REST/datastreams/DS2/content?download=true");
        HttpGet get = new HttpGet(url);
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        status = response.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)200, (int)status);
        this.CheckCDHeader(response, "attachment", "Datastream 2 filename from label.jpg");
        url = TestRESTAPI.getURI("/objects/demo:REST/datastreams/DS3/content?download=true");
        get = new HttpGet(url);
        response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        status = response.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)200, (int)status);
        this.CheckCDHeader(response, "attachment", "Datastream 3 filename from label.bin");
        url = TestRESTAPI.getURI("/objects/demo:REST/datastreams/DS4/content?download=true");
        get = new HttpGet(url);
        response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        status = response.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)200, (int)status);
        this.CheckCDHeader(response, "attachment", "Datastream 4 filename from label.xml");
    }

    @Test
    public void testDatastreamDisseminationContentDispositionFromId() throws Exception {
        URI url = TestRESTAPI.getURI("/objects/demo:REST/datastreams/DS5/content?download=true");
        HttpGet get = new HttpGet(url);
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        Assert.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
        this.CheckCDHeader(response, "attachment", "DS5.xml");
        get.releaseConnection();
        url = TestRESTAPI.getURI("/objects/demo:REST/datastreams/DS6.xml/content?download=true");
        get = new HttpGet(url);
        response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        Assert.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
        this.CheckCDHeader(response, "attachment", DS6ID);
        get.releaseConnection();
    }

    @Test
    public void testDatastreamDisseminationConditionalGet() throws Exception {
        URI url = TestRESTAPI.getURI("/objects/demo:REST/datastreams/DS1/content");
        HttpGet get = new HttpGet(url);
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
        this.checkSingleHeader("Content-Length", response, Long.toString(47L));
        this.checkSingleHeader("Content-Type", response, TEXT_XML);
        this.CheckCDHeader(response, "inline", DS1RelsFilename);
        String etag = response.getFirstHeader("ETag").getValue();
        String lastModified = response.getFirstHeader("Last-Modified").getValue();
        Assert.assertNotNull((Object)etag);
        Assert.assertNotNull((Object)lastModified);
        get = new HttpGet(url);
        get.addHeader("If-None-Match", etag);
        response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)304, (int)response.getStatusLine().getStatusCode());
        get = new HttpGet(url);
        get.addHeader("If-None-Match", etag + "0");
        response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
        get = new HttpGet(url);
        get.addHeader("If-Modified-Since", lastModified);
        response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)304, (int)response.getStatusLine().getStatusCode());
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date checkDate = dateFormat.parse(lastModified);
        checkDate = new Date(checkDate.getTime() - 1000L);
        get = new HttpGet(url);
        get.addHeader("If-Modified-Since", dateFormat.format(checkDate));
        response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
    }

    @Test
    public void testDatastreamDisseminationGetContentRange() throws Exception {
        URI url = TestRESTAPI.getURI("/objects/demo:REST/datastreams/DS1/content");
        HttpGet get = new HttpGet(url);
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        String controlChecksum = MD5Utility.getBase16Hash((String)EntityUtils.toString((HttpEntity)response.getEntity()));
        Assert.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
        this.checkSingleHeader("Content-Length", response, Long.toString(47L));
        this.checkSingleHeader("Content-Type", response, TEXT_XML);
        get = new HttpGet(url);
        get.addHeader("Range", "bytes=0-24");
        response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        String part1 = EntityUtils.toString((HttpEntity)response.getEntity());
        Assert.assertEquals((int)206, (int)response.getStatusLine().getStatusCode());
        this.checkSingleHeader("Content-Length", response, Long.toString(25L));
        this.checkSingleHeader("Content-Range", response, "bytes 0-24/47");
        get = new HttpGet(url);
        get.addHeader("Range", "bytes=25");
        response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        String part2 = EntityUtils.toString((HttpEntity)response.getEntity());
        Assert.assertEquals((int)206, (int)response.getStatusLine().getStatusCode());
        this.checkSingleHeader("Content-Length", response, Long.toString(22L));
        this.checkSingleHeader("Content-Range", response, "bytes 25-46/47");
        String compositeChecksum = MD5Utility.getBase16Hash((String[])new String[]{part1, part2});
        Assert.assertEquals((String)controlChecksum, (String)compositeChecksum);
    }

    @Test
    public void testDatastreamDisseminationHEAD() throws Exception {
        URI url = TestRESTAPI.getURI("/objects/demo:REST/datastreams/DS1/content");
        HttpGet get = new HttpGet(url);
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
        this.checkSingleHeader("Content-Length", response, Long.toString(47L));
        this.checkSingleHeader("Content-Type", response, TEXT_XML);
        this.CheckCDHeader(response, "inline", DS1RelsFilename);
        Header[] expectedHeaders = response.getAllHeaders();
        String etag = response.getFirstHeader("ETag").getValue();
        String lastModified = response.getFirstHeader("Last-Modified").getValue();
        Assert.assertNotNull((Object)etag);
        Assert.assertNotNull((Object)lastModified);
        HttpHead head = new HttpHead(url);
        response = this.getOrDelete((HttpRequestBase)head, this.getAuthAccess(), false);
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
        Header[] actualHeaders = response.getAllHeaders();
        TestRESTAPI.assertHeadersEquals(expectedHeaders, actualHeaders);
        head.addHeader("If-None-Match", etag);
        response = this.getOrDelete((HttpRequestBase)head, this.getAuthAccess(), false);
        Assert.assertEquals((int)304, (int)response.getStatusLine().getStatusCode());
        Assert.assertNull((Object)response.getEntity());
        url = TestRESTAPI.getURI("/objects/demo:REST/datastreams/DS2/content");
        get = new HttpGet(url);
        response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), false);
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
        this.checkSingleHeader("Content-Length", response, Long.toString(47L));
        this.checkSingleHeader("Content-Type", response, "image/jpeg");
        this.CheckCDHeader(response, "inline", "Datastream 2 filename from label.jpg");
        expectedHeaders = response.getAllHeaders();
        head = new HttpHead(url);
        response = this.getOrDelete((HttpRequestBase)head, this.getAuthAccess(), false);
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        Assert.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
        actualHeaders = response.getAllHeaders();
        TestRESTAPI.assertHeadersEquals(expectedHeaders, actualHeaders);
    }

    @Test
    public void testUpload() throws Exception {
        MultipartEntity entity;
        String uploadUrl = "/upload";
        String url = TestRESTAPI.getBaseURL() + uploadUrl;
        HttpPost post = new HttpPost(url);
        HttpResponse response = this.putOrPost((HttpEntityEnclosingRequestBase)post, (HttpEntity)(entity = this._doUploadPost()), true);
        if (response.getStatusLine().getStatusCode() == 302) {
            url = response.getFirstHeader("Location").getValue();
            post = new HttpPost(url);
            entity = this._doUploadPost();
            response = this.putOrPost((HttpEntityEnclosingRequestBase)post, (HttpEntity)entity, true);
        }
        Assert.assertEquals((int)202, (int)response.getStatusLine().getStatusCode());
        Assert.assertTrue((boolean)TestRESTAPI.readString(response).startsWith("uploaded://"));
        entity = this._doUploadPost(new HashMap<String, AbstractContentBody>(0));
        response = this.putOrPost((HttpEntityEnclosingRequestBase)post, (HttpEntity)entity, true);
        Assert.assertEquals((int)400, (int)response.getStatusLine().getStatusCode());
        post.releaseConnection();
    }

    @Test
    public void testGetRelationships() throws Exception {
        String s = "info:fedora/" + DEMO_REST_PID;
        String p = Constants.MODEL.HAS_MODEL.uri;
        String o = Models.FEDORA_OBJECT_CURRENT.uri;
        URI url = TestRESTAPI.getURI("/objects/" + DEMO_REST_PID + "/relationships" + "?subject=" + URLEncoder.encode(s, "UTF-8") + "&predicate=" + URLEncoder.encode(p, "UTF-8"));
        byte[] response = this.verifyGETStatusBytes(url, 200, true, false);
        this.checkRelationship(response, s, p, o, true);
    }

    @Test
    public void testAddRelationship() throws Exception {
        String s = "info:fedora/" + DEMO_REST_PID;
        String p = "http://www.example.org/test#relationship";
        String o = "addRelationship";
        URI url = TestRESTAPI.getURI("/objects/" + DEMO_REST_PID + "/relationships" + "?subject=" + URLEncoder.encode(s, "UTF-8") + "&predicate=" + URLEncoder.encode(p, "UTF-8"));
        byte[] bytes = this.verifyGETStatusBytes(url, 200, true, false);
        this.checkRelationship(bytes, s, p, o, false);
        HttpPost post = new HttpPost();
        url = TestRESTAPI.getURI("/objects/" + DEMO_REST_PID + "/relationships/new" + "?subject=" + URLEncoder.encode(s, "UTF-8") + "&predicate=" + URLEncoder.encode(p, "UTF-8") + "&object=" + URLEncoder.encode(o, "UTF-8") + "&isLiteral=true");
        post.setURI(url);
        HttpResponse response = this.putOrPost((HttpEntityEnclosingRequestBase)post, null, true);
        Assert.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
        post.releaseConnection();
        url = TestRESTAPI.getURI("/objects/" + DEMO_REST_PID + "/relationships");
        bytes = this.verifyGETStatusBytes(url, 200, true, false);
        this.checkRelationship(bytes, s, p, o, true);
        o = "addRelationshipUrlEncoded";
        url = TestRESTAPI.getURI("/objects/" + URLEncoder.encode(DEMO_REST_PID.toString(), "UTF-8") + "/relationships" + "?subject=" + URLEncoder.encode(s, "UTF-8") + "&predicate=" + URLEncoder.encode(p, "UTF-8"));
        bytes = this.verifyGETStatusBytes(url, 200, true, false);
        this.checkRelationship(bytes, s, p, o, false);
        url = TestRESTAPI.getURI("/objects/" + URLEncoder.encode(DEMO_REST_PID.toString(), "UTF-8") + "/relationships/new" + "?subject=" + URLEncoder.encode(s, "UTF-8") + "&predicate=" + URLEncoder.encode(p, "UTF-8") + "&object=" + URLEncoder.encode(o, "UTF-8") + "&isLiteral=true");
        post = new HttpPost(url);
        response = this.putOrPost((HttpEntityEnclosingRequestBase)post, null, true);
        Assert.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
        post.releaseConnection();
        url = TestRESTAPI.getURI("/objects/" + URLEncoder.encode(DEMO_REST_PID.toString(), "UTF-8") + "/relationships");
        bytes = this.verifyGETStatusBytes(url, 200, true, false);
        this.checkRelationship(bytes, s, p, o, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPurgeRelationship() throws Exception {
        String s = "info:fedora/" + DEMO_REST_PID;
        String p = "http://www.example.org/test#relationship";
        String o = "foo";
        HttpPost post = new HttpPost();
        URI url = TestRESTAPI.getURI("/objects/" + DEMO_REST_PID + "/relationships/new" + "?subject=" + URLEncoder.encode(s, "UTF-8") + "&predicate=" + URLEncoder.encode(p, "UTF-8") + "&object=" + URLEncoder.encode(o, "UTF-8") + "&isLiteral=true");
        post.setURI(url);
        HttpResponse response = this.putOrPost((HttpEntityEnclosingRequestBase)post, null, true);
        int status = response.getStatusLine().getStatusCode();
        post.releaseConnection();
        Assert.assertEquals((int)200, (int)status);
        HttpGet get = null;
        HttpDelete delete = null;
        try {
            url = TestRESTAPI.getURI("/objects/" + DEMO_REST_PID + "/relationships" + "?subject=" + URLEncoder.encode(s, "UTF-8") + "&predicate=" + URLEncoder.encode(p, "UTF-8"));
            get = new HttpGet(url);
            response = this.getOrDelete((HttpRequestBase)get, true, false);
            status = response.getStatusLine().getStatusCode();
            byte[] responseBytes = TestRESTAPI.readBytes(response);
            get.releaseConnection();
            Assert.assertEquals((int)200, (int)status);
            this.checkRelationship(responseBytes, s, p, o, true);
            url = TestRESTAPI.getURI("/objects/" + DEMO_REST_PID + "/relationships" + "?subject=" + URLEncoder.encode(s, "UTF-8") + "&predicate=" + URLEncoder.encode(p, "UTF-8") + "&object=" + URLEncoder.encode(o, "UTF-8") + "&isLiteral=true");
            delete = new HttpDelete(url);
            response = this.getOrDelete((HttpRequestBase)delete, true, false);
            status = response.getStatusLine().getStatusCode();
            String responseString = TestRESTAPI.readString(response);
            Assert.assertEquals((int)200, (int)status);
            Assert.assertEquals((String)"Purge relationship", (String)"true", (String)responseString);
            url = TestRESTAPI.getURI("/objects/" + DEMO_REST_PID + "/relationships" + "?subject=" + URLEncoder.encode(s, "UTF-8") + "&predicate=" + URLEncoder.encode(p, "UTF-8"));
            get.setURI(url);
            response = this.getOrDelete((HttpRequestBase)get, true, false);
            status = response.getStatusLine().getStatusCode();
            responseBytes = TestRESTAPI.readBytes(response);
            Assert.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
            this.checkRelationship(responseBytes, s, p, o, false);
            url = TestRESTAPI.getURI("/objects/" + DEMO_REST_PID + "/relationships" + "?subject=" + URLEncoder.encode(s, "UTF-8") + "&predicate=" + URLEncoder.encode(p, "UTF-8") + "&object=" + URLEncoder.encode(o, "UTF-8") + "&isLiteral=true");
            delete.setURI(url);
            response = this.getOrDelete((HttpRequestBase)delete, true, true);
            status = response.getStatusLine().getStatusCode();
            responseString = TestRESTAPI.readString(response);
            Assert.assertEquals((int)200, (int)status);
            Assert.assertEquals((String)"Purge relationship", (String)"false", (String)responseString);
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
            if (delete != null) {
                delete.releaseConnection();
            }
        }
    }

    @Test
    public void testDisseminationContentLengthWhenKnown() throws Exception {
        URI url = TestRESTAPI.getURI("/objects/demo:14/methods/demo:12/getDocument");
        HttpGet get = new HttpGet(url);
        this.verifyNoAuthFailOnAPIAAuth(url);
        HttpResponse response = this.getOrDelete((HttpRequestBase)get, this.getAuthAccess(), true);
        int status = response.getStatusLine().getStatusCode();
        String cLen = response.containsHeader("Content-Length") ? response.getFirstHeader("Content-Length").getValue() : null;
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        get.releaseConnection();
        Assert.assertEquals((int)200, (int)status);
        Assert.assertEquals((String)"19498", (String)cLen);
    }

    private MultipartEntity _doUploadPost() throws Exception {
        File temp = File.createTempFile("test.txt", null);
        FileUtils.writeStringToFile((File)temp, (String)"This is the upload test file");
        FileBody part = new FileBody(temp);
        HashMap<String, AbstractContentBody> parts = new HashMap<String, AbstractContentBody>(1);
        parts.put("file", (AbstractContentBody)part);
        return this._doUploadPost(parts);
    }

    private MultipartEntity _doUploadPost(Map<String, AbstractContentBody> parts) throws Exception {
        MultipartEntity entity = new MultipartEntity();
        for (String name : parts.keySet()) {
            entity.addPart(name, (ContentBody)parts.get(name));
        }
        return entity;
    }

    private void CheckCDHeader(HttpResponse response, String expectedType, String expectedFilename) {
        String headerName = "Content-Disposition";
        String expected = expectedType + "; filename=\"" + expectedFilename + "\"";
        this.checkSingleHeader(headerName, response, expected);
    }

    private void checkSingleHeader(String headerName, HttpResponse response, String expected) {
        String actual = response.containsHeader(headerName) ? response.getFirstHeader(headerName).getValue() : null;
        Assert.assertEquals((String)expected, (String)actual);
    }

    private HttpClient getClient(boolean followRedirects, boolean auth) {
        DefaultHttpClient result = s_client.getHttpClient(followRedirects, auth);
        if (auth) {
            String host = TestRESTAPI.getHost();
            LOGGER.debug("credentials set for scope of {}:[ANY PORT]", (Object)host);
            result.getCredentialsProvider().setCredentials(new AuthScope(host, -1, AuthScope.ANY_REALM), (Credentials)new UsernamePasswordCredentials(TestRESTAPI.getUsername(), TestRESTAPI.getPassword()));
        } else {
            result.getCredentialsProvider().clear();
        }
        return result;
    }

    protected static URI getURI(String url) {
        if (url == null || url.length() == 0) {
            throw new IllegalArgumentException("url must be a non-empty value");
        }
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            url = TestRESTAPI.getBaseURL() + url;
        }
        return URI.create(url);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateResponse(URI url, HttpResponse res) throws Exception {
        Header contentType;
        int sc = res.getStatusLine().getStatusCode();
        if (sc < 200 || sc > 299 || url.toString().contains("flash=true") || (contentType = res.getFirstHeader("Content-Type")) == null || !contentType.getValue().contains(TEXT_XML) && !contentType.getValue().contains("application/xml")) return;
        String xmlResponse = EntityUtils.toString((HttpEntity)res.getEntity());
        res.setEntity((HttpEntity)new StringEntity(xmlResponse, Charset.forName("UTF-8")));
        if (xmlResponse.contains(":schemaLocation=\"")) {
            String offline = System.getProperty("offline");
            String online = System.getProperty("online");
            if (!("false".equals(online) || offline != null && "true".equals(offline))) {
                validator.onlineValidate(url.toString(), xmlResponse);
            }
            if ("false".equals(offline)) return;
        }
        Assert.fail((String)("No schema location specified in response - " + url));
    }

    @Deprecated
    protected HttpResponse put(URI url, File requestContent, boolean authenticate) throws Exception {
        String original;
        HttpPut method = new HttpPut(url);
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("param_name", (ContentBody)new StringBody("value"));
        entity.addPart(requestContent.getName(), (ContentBody)new FileBody(requestContent));
        HttpResponse response = this.putOrPost((HttpEntityEnclosingRequestBase)method, (HttpEntity)entity, authenticate);
        int status = response.getStatusLine().getStatusCode();
        if (status == 302 && !(original = url.toString()).equals((url = URI.create(response.getFirstHeader("Location").getValue())).toString())) {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            method = new HttpPut(url);
            entity = new MultipartEntity();
            entity.addPart("param_name", (ContentBody)new StringBody("value"));
            entity.addPart(requestContent.getName(), (ContentBody)new FileBody(requestContent));
            response = this.putOrPost((HttpEntityEnclosingRequestBase)method, (HttpEntity)entity, true);
        }
        return response;
    }

    @Deprecated
    protected HttpResponse post(URI url, File requestContent, boolean authenticate) throws Exception {
        String original;
        HttpPost method = new HttpPost(url);
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("param_name", (ContentBody)new StringBody("value"));
        entity.addPart(requestContent.getName(), (ContentBody)new FileBody(requestContent));
        HttpResponse response = this.putOrPost((HttpEntityEnclosingRequestBase)method, (HttpEntity)entity, authenticate);
        int status = response.getStatusLine().getStatusCode();
        if (status == 302 && !(original = url.toString()).equals((url = URI.create(response.getFirstHeader("Location").getValue())).toString())) {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            method = new HttpPost(url);
            entity = new MultipartEntity();
            entity.addPart("param_name", (ContentBody)new StringBody("value"));
            entity.addPart(requestContent.getName(), (ContentBody)new FileBody(requestContent));
            response = this.putOrPost((HttpEntityEnclosingRequestBase)method, (HttpEntity)entity, true);
        }
        return response;
    }

    private HttpResponse getOrDelete(HttpRequestBase method, boolean authenticate, boolean validate) throws Exception {
        HttpClient client = this.getClient(true, authenticate);
        HttpResponse response = this.getOrDelete(client, method, authenticate, validate);
        return response;
    }

    private HttpResponse getOrDelete(HttpClient client, HttpRequestBase method, boolean authenticate, boolean validate) throws Exception {
        LOGGER.debug(method.getURI().toString());
        if (!(method instanceof HttpGet || method instanceof HttpDelete || method instanceof HttpHead)) {
            throw new IllegalArgumentException("method must be one of GET, HEAD or DELETE.");
        }
        HttpResponse response = client.execute((HttpUriRequest)method);
        if (response.getStatusLine().getStatusCode() == 302) {
            String redir = response.getFirstHeader("Location").getValue();
            if (!method.getURI().toString().equals(redir)) {
                method.setURI(TestRESTAPI.getURI(redir));
                response = this.getOrDelete(client, method, authenticate, validate);
            }
        }
        if (validate) {
            this.validateResponse(method.getURI(), response);
        }
        return response;
    }

    private HttpResponse putOrPost(HttpEntityEnclosingRequestBase method, HttpEntity requestContent, boolean authenticate) throws Exception {
        HttpClient client = this.getClient(false, authenticate);
        if (method == null) {
            throw new IllegalArgumentException("method must be a non-empty value");
        }
        if (requestContent != null) {
            method.setEntity(requestContent);
        }
        HttpResponse response = client.execute((HttpUriRequest)method);
        return response;
    }

    private void checkRelationship(byte[] rdf, String s, String p, String o, boolean exists) throws TrippiException, UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append("RDF: " + new String(rdf, "UTF-8"));
        TripleIterator it = TripleIteratorFactory.defaultInstance().fromStream((InputStream)new ByteArrayInputStream(rdf), null, RDFFormat.RDF_XML);
        boolean found = false;
        while (it.hasNext()) {
            Triple t = it.next();
            sb.append(t.getSubject().stringValue() + ", ");
            sb.append(t.getPredicate().stringValue() + ", ");
            sb.append(t.getObject().stringValue() + "\n");
            sb.append("matching: " + s + " " + t.getSubject().stringValue() + " " + s.equals(t.getSubject().stringValue()) + "\n");
            sb.append("matching: " + p + " " + t.getPredicate().stringValue() + " " + p.equals(t.getPredicate().stringValue()) + "\n");
            sb.append("matching: " + o + " " + t.getObject().stringValue() + " " + o.equals(t.getObject().stringValue()) + "\n");
            if (!s.equals(t.getSubject().stringValue()) || !p.equals(t.getPredicate().stringValue()) || !o.equals(t.getObject().stringValue())) continue;
            sb.append("Matched\n");
            found = true;
        }
        Assert.assertTrue((String)("Testing if relationship present: " + exists + " [ " + s + ", " + p + ", " + o + " ] \n " + sb.toString()), (exists == found ? 1 : 0) != 0);
    }

    private static void assertHeadersEquals(Header[] expectedHeaders, Header[] actualHeaders) {
        Map<String, String> expected = TestRESTAPI.mapHeaders(expectedHeaders);
        Map<String, String> actual = TestRESTAPI.mapHeaders(actualHeaders);
        expected.remove("Set-Cookie");
        actual.remove("Set-Cookie");
        expected.remove("Date");
        actual.remove("Date");
        Assert.assertEquals((String)"Response header names were different", (String)TestRESTAPI.join(expected.keySet()), (String)TestRESTAPI.join(actual.keySet()));
        for (Map.Entry<String, String> entry : expected.entrySet()) {
            Assert.assertEquals((String)entry.getValue(), (String)actual.get(entry.getKey()));
        }
    }

    private static String join(Set<String> strings) {
        TreeSet<String> sorted = new TreeSet<String>(strings);
        StringBuilder out = new StringBuilder();
        for (String string : sorted) {
            out.append(string).append(", ");
        }
        int len = out.length();
        out.deleteCharAt(len - 1);
        out.deleteCharAt(len - 2);
        return out.toString();
    }

    private static Map<String, String> mapHeaders(Header[] headers) {
        HashMap<String, String> result = new HashMap<String, String>(headers.length);
        for (Header header : headers) {
            String key = header.getName();
            if (result.containsKey(key)) {
                result.put(key, (String)result.get(key) + ", " + header.getValue());
                continue;
            }
            result.put(key, header.getValue());
        }
        return result;
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestRESTAPI.class);
    }

    public static void main(String[] args) {
        JUnitCore.runClasses((Class[])new Class[]{TestRESTAPI.class});
    }

    static {
        authAccessProperty = "fedora.authorize.access";
        DEMO_OWNERID = "nondefaultOwner";
        DEMO_REST_PID = PID.getInstance((String)"demo:REST");
        REST_RESOURCE_PATH = System.getProperty("fcrepo-integrationtest-core.classes") != null ? System.getProperty("fcrepo-integrationtest-core.classes") + "rest" : "src/test/resources/rest";
        df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        validator = new ValidatorHelper();
        now = new Date();
        datetime = df.format(now);
    }
}

