/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.net.URI;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.http.entity.StringEntity;
import org.fcrepo.common.PID;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.api.TestRESTAPI;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.JUnitCore;

public class TestRESTAPIConfigQ
extends FedoraServerTestCase {
    private static FedoraAPIMMTOM apim;
    private static String DEMO_FOXML;
    private static final PID pid;
    private static TestRESTAPI rest;

    @BeforeClass
    public static void bootStrap() throws Exception {
        apim = TestRESTAPI.initClient().getAPIMMTOM();
        rest = new TestRESTAPI();
    }

    @AfterClass
    public static void cleanUp() {
        TestRESTAPI.stopClient();
    }

    @org.junit.Test
    public void testFindObjects() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects?pid=true&terms=&query=&resultFormat=xml", new Object[0]));
        rest.verifyGETStatusOnly(url, 200, false);
    }

    @org.junit.Test
    public void testIngest() throws Exception {
        String label = "Label";
        URI url = TestRESTAPI.getURI(String.format("/objects/%s?label=%s", pid, label));
        StringEntity entity = TestRESTAPI.getStringEntity(DEMO_FOXML, "text/xml");
        rest.verifyPOSTStatusOnly(url, 401, entity, false);
        url = TestRESTAPI.getURI(String.format("/objects/%s", pid));
        rest.verifyGETStatusOnly(url, 404, false);
        url = TestRESTAPI.getURI(String.format("/objects/%s?label=%s", pid, label));
        rest.verifyPOSTStatusOnly(url, 201, entity, true);
        url = TestRESTAPI.getURI(String.format("/objects/%s", pid));
        rest.verifyGETStatusOnly(url, 200, false, false);
        apim.purgeObject(pid.toString(), "", false);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(TestRESTAPIConfigQ.class);
    }

    public static void main(String[] args) {
        JUnitCore.runClasses((Class[])new Class[]{TestRESTAPIConfigQ.class});
    }

    static {
        pid = PID.getInstance((String)"demo:RESTQ");
        StringBuilder sb = new StringBuilder();
        sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<foxml:digitalObject VERSION=\"1.1\" PID=\"" + pid.toString() + "\" ");
        sb.append("  xmlns:foxml=\"info:fedora/fedora-system:def/foxml#\" ");
        sb.append("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
        sb.append("  xsi:schemaLocation=\"info:fedora/fedora-system:def/foxml# ");
        sb.append("  http://www.fedora.info/definitions/1/0/foxml1-1.xsd\">");
        sb.append("  <foxml:objectProperties>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#state\" VALUE=\"A\"/>");
        sb.append("  </foxml:objectProperties>");
        sb.append("</foxml:digitalObject>");
        DEMO_FOXML = sb.toString();
    }
}

