/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.net.URI;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.http.entity.StringEntity;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.api.TestRESTAPI;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.JUnitCore;

public class TestRESTAPIURLDecoding
extends FedoraServerTestCase {
    private static final String pid = "test:SomeObject";
    private static final String pidWithEscapedColon1 = "test%3ASomeObject";
    private static final String pidWithEscapedColon2 = "test%3aSomeObject";
    private static TestRESTAPI rest;

    private static String getFOXML(String pid) {
        StringBuilder sb = new StringBuilder();
        sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<foxml:digitalObject VERSION=\"1.1\" PID=\"" + pid + "\" ");
        sb.append("  xmlns:foxml=\"info:fedora/fedora-system:def/foxml#\" ");
        sb.append("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
        sb.append("  xsi:schemaLocation=\"info:fedora/fedora-system:def/foxml# ");
        sb.append("  http://www.fedora.info/definitions/1/0/foxml1-1.xsd\">");
        sb.append("  <foxml:objectProperties>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#state\" VALUE=\"A\"/>");
        sb.append("  </foxml:objectProperties>");
        sb.append("</foxml:digitalObject>");
        return sb.toString();
    }

    @Before
    public void setUp() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects/%s", pid));
        StringEntity entity = TestRESTAPI.getStringEntity(TestRESTAPIURLDecoding.getFOXML(pid), "text/xml");
        TestRESTAPI.initClient();
        rest = new TestRESTAPI();
        rest.verifyPOSTStatusOnly(url, 201, entity, true);
    }

    @After
    public void tearDown() throws Exception {
        URI url = TestRESTAPI.getURI(String.format("/objects/%s", pid));
        rest.verifyDELETEStatusOnly(url, 200, true);
        TestRESTAPI.stopClient();
    }

    @org.junit.Test
    public void testGetObjectProfile() throws Exception {
        URI url = TestRESTAPI.getURI("/objects/test:SomeObject");
        rest.verifyGETStatusOnly(url, 200, true);
        url = TestRESTAPI.getURI("/objects/test%3ASomeObject");
        rest.verifyGETStatusOnly(url, 200, true);
        url = TestRESTAPI.getURI("/objects/test%3aSomeObject");
        rest.verifyGETStatusOnly(url, 200, true);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(TestRESTAPIURLDecoding.class);
    }

    public static void main(String[] args) {
        JUnitCore.runClasses((Class[])new Class[]{TestRESTAPIURLDecoding.class});
    }
}

