/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.fesl.policyindex;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.rmi.RemoteException;
import org.fcrepo.common.Constants;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.server.utilities.StreamUtility;
import org.fcrepo.server.utilities.TypeUtility;

public class PolicyIndexUtils
implements Constants {
    private FedoraAPIMMTOM m_apim = null;

    public PolicyIndexUtils(FedoraAPIMMTOM apim) {
        this.m_apim = apim;
    }

    public String addPolicyObject(String policy, String objectState, String datastreamState) throws IOException {
        String pid = this.getNextPids(1)[0];
        byte[] object = PolicyIndexUtils.getPolicyObject(policy, objectState, datastreamState, pid);
        this.m_apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])object), PolicyIndexUtils.FOXML1_1.uri, "ingesting new foxml object");
        return pid;
    }

    public String[] getNextPids(int pidCount) throws RemoteException {
        return this.m_apim.getNextPID(new BigInteger(Integer.toString(pidCount)), "demo").toArray(new String[0]);
    }

    public static synchronized String getPolicy(String policy) throws IOException {
        String ln;
        StringBuilder sb = new StringBuilder();
        String base = System.getProperty("fcrepo-integrationtest-core.classes") != null ? System.getProperty("fcrepo-integrationtest-core.classes") : "src/test/resources/";
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(base + "/test-objects/xacml/test-policy-" + policy + ".xml"), "UTF-8"));
        while ((ln = br.readLine()) != null) {
            sb.append(ln).append('\n');
        }
        br.close();
        return sb.toString();
    }

    public static byte[] getPolicyObject(String policy, String objectState, String datastreamState, String pid) throws IOException {
        StringBuilder foxml = new StringBuilder();
        if (datastreamState != null && !"AID".contains(datastreamState)) {
            throw new RuntimeException("Invalid datastreamState parameter " + datastreamState);
        }
        if (!"AID".contains(objectState)) {
            throw new RuntimeException("Invalid datastreamState parameter " + datastreamState);
        }
        foxml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<foxml:digitalObject VERSION=\"1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns:foxml=\"info:fedora/fedora-system:def/foxml#\"\n           xsi:schemaLocation=\"");
        foxml.append(Constants.FOXML.uri);
        foxml.append(' ');
        foxml.append(Constants.FOXML1_1.xsdLocation);
        foxml.append("\"\n           PID=\"");
        StreamUtility.enc((String)pid, (StringBuilder)foxml);
        foxml.append("\">\n  <foxml:objectProperties>\n    <foxml:property NAME=\"info:fedora/fedora-system:def/model#state\" VALUE=\"" + objectState + "\"/>\n" + "    <foxml:property NAME=\"info:fedora/fedora-system:def/model#label\" VALUE=\"");
        StreamUtility.enc((String)"test policy object", (StringBuilder)foxml);
        foxml.append("\"/>\n  </foxml:objectProperties>\n");
        if (datastreamState != null) {
            foxml.append("<foxml:datastream ID=\"FESLPOLICY\" STATE=\"");
            foxml.append(datastreamState);
            foxml.append("\" CONTROL_GROUP=\"X\"><foxml:datastreamVersion ID=\"POLICY.0\" MIMETYPE=\"text/xml\" LABEL=\"XACML policy datastream\">  <foxml:xmlContent>");
            foxml.append(PolicyIndexUtils.getPolicy(policy));
            foxml.append("    </foxml:xmlContent>  </foxml:datastreamVersion></foxml:datastream>");
        }
        foxml.append("</foxml:digitalObject>");
        return foxml.toString().getBytes("UTF-8");
    }
}

