/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.integration;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.activation.DataHandler;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Feed;
import org.apache.abdera.parser.Parser;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.client.utility.export.Export;
import org.fcrepo.client.utility.ingest.Ingest;
import org.fcrepo.common.PID;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.test.FedoraTestCase;
import org.fcrepo.test.api.TestAPIM;
import org.fcrepo.utilities.FileUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestCommandLineFormats
extends FedoraTestCase {
    private static FedoraAPIMMTOM apim;
    private static FedoraClient s_client;

    @BeforeClass
    public static void bootStrap() throws Exception {
        s_client = TestCommandLineFormats.getFedoraClient(TestCommandLineFormats.getBaseURL(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword());
        apim = s_client.getAPIMMTOM();
    }

    @AfterClass
    public static void cleanUp() {
        s_client.shutdown();
    }

    @Before
    public void setUp() throws Exception {
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("foxml", "info:fedora/fedora-system:def/foxml#");
        nsMap.put("METS", "http://www.loc.gov/METS/");
        nsMap.put("", "http://www.w3.org/2005/Atom");
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
    }

    @After
    public void tearDown() {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIngestFOXML10() throws Exception {
        System.out.println("Testing Ingest with FOXML 1.0 format");
        File foxml10 = File.createTempFile("demo_997", ".xml");
        FileOutputStream fileWriter = new FileOutputStream(foxml10);
        fileWriter.write(TestAPIM.demo997FOXML10ObjectXML);
        fileWriter.close();
        String[] parameters = new String[]{"f ", foxml10.getAbsolutePath(), TestCommandLineFormats.FOXML1_0.uri, TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), TestCommandLineFormats.getProtocol(), "\"Ingest\"", TestCommandLineFormats.getFedoraAppServerContext()};
        Ingest.main((String[])parameters);
        foxml10.delete();
        try {
            byte[] objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)apim.getObjectXML("demo:997"));
            Assert.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
            String xmlIn = new String(objectXML, "UTF-8");
            XMLAssert.assertXpathExists((String)"foxml:digitalObject[@PID='demo:997']", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", (String)xmlIn);
            XMLAssert.assertXpathEvaluatesTo((String)"6", (String)"count(//foxml:datastream)", (String)xmlIn);
            XMLAssert.assertXpathNotExists((String)"//foxml:disseminator", (String)xmlIn);
        }
        finally {
            apim.purgeObject("demo:997", "", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIngestFOXML11() throws Exception {
        System.out.println("Testing Ingest with FOXML 1.1 format");
        File foxml11 = File.createTempFile("demo_998", ".xml");
        FileOutputStream fileWriter = new FileOutputStream(foxml11);
        fileWriter.write(TestAPIM.demo998FOXMLObjectXML);
        fileWriter.close();
        String[] parameters = new String[]{"f ", foxml11.getAbsolutePath(), TestCommandLineFormats.FOXML1_1.uri, TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), TestCommandLineFormats.getProtocol(), "\"Ingest\"", TestCommandLineFormats.getFedoraAppServerContext()};
        Ingest.main((String[])parameters);
        foxml11.delete();
        try {
            byte[] objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)apim.getObjectXML("demo:998"));
            Assert.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
            String xmlIn = new String(objectXML, "UTF-8");
            XMLAssert.assertXpathExists((String)"foxml:digitalObject[@PID='demo:998']", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", (String)xmlIn);
            XMLAssert.assertXpathEvaluatesTo((String)"6", (String)"count(//foxml:datastream)", (String)xmlIn);
            XMLAssert.assertXpathNotExists((String)"//foxml:disseminator", (String)xmlIn);
        }
        finally {
            apim.purgeObject("demo:998", "", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIngestMETS11() throws Exception {
        System.out.println("Testing Ingest with METS 1.1 format");
        File mets = File.createTempFile("demo_999", ".xml");
        FileOutputStream fileWriter = new FileOutputStream(mets);
        fileWriter.write(TestAPIM.demo999METSObjectXML);
        fileWriter.close();
        String[] parameters = new String[]{"f ", mets.getAbsolutePath(), TestCommandLineFormats.METS_EXT1_1.uri, TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), TestCommandLineFormats.getProtocol(), "\"Ingest\"", TestCommandLineFormats.getFedoraAppServerContext()};
        Ingest.main((String[])parameters);
        mets.delete();
        try {
            byte[] objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)apim.getObjectXML("demo:999"));
            Assert.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
            String xmlIn = new String(objectXML, "UTF-8");
            XMLAssert.assertXpathExists((String)"foxml:digitalObject[@PID='demo:999']", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", (String)xmlIn);
            XMLAssert.assertXpathEvaluatesTo((String)"6", (String)"count(//foxml:datastream)", (String)xmlIn);
            XMLAssert.assertXpathNotExists((String)"//foxml:disseminator", (String)xmlIn);
        }
        finally {
            apim.purgeObject("demo:999", "", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIngestMETS10() throws Exception {
        System.out.println("Testing Ingest with METS 1.0 format");
        File mets = File.createTempFile("demo_999b", ".xml");
        FileOutputStream fileWriter = new FileOutputStream(mets);
        fileWriter.write(TestAPIM.demo999bMETS10ObjectXML);
        fileWriter.close();
        String[] parameters = new String[]{"f ", mets.getAbsolutePath(), TestCommandLineFormats.METS_EXT1_0.uri, TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), TestCommandLineFormats.getProtocol(), "\"Ingest\"", TestCommandLineFormats.getFedoraAppServerContext()};
        Ingest.main((String[])parameters);
        mets.delete();
        try {
            byte[] objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)apim.getObjectXML("demo:999b"));
            Assert.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
            String xmlIn = new String(objectXML, "UTF-8");
            XMLAssert.assertXpathExists((String)"foxml:digitalObject[@PID='demo:999b']", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", (String)xmlIn);
            XMLAssert.assertXpathEvaluatesTo((String)"6", (String)"count(//foxml:datastream)", (String)xmlIn);
            XMLAssert.assertXpathNotExists((String)"//foxml:disseminator", (String)xmlIn);
        }
        finally {
            apim.purgeObject("demo:999b", "", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIngestATOM() throws Exception {
        System.out.println("Testing Ingest with ATOM format");
        File atom = File.createTempFile("demo_1000", ".xml");
        FileOutputStream fileWriter = new FileOutputStream(atom);
        fileWriter.write(TestAPIM.demo1000ATOMObjectXML);
        fileWriter.close();
        String[] parameters = new String[]{"f ", atom.getAbsolutePath(), TestCommandLineFormats.ATOM1_1.uri, TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), TestCommandLineFormats.getProtocol(), "\"Ingest\"", TestCommandLineFormats.getFedoraAppServerContext()};
        Ingest.main((String[])parameters);
        atom.delete();
        try {
            byte[] objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)apim.getObjectXML("demo:1000"));
            Assert.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
            String xmlIn = new String(objectXML, "UTF-8");
            XMLAssert.assertXpathExists((String)"foxml:digitalObject[@PID='demo:1000']", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", (String)xmlIn);
            XMLAssert.assertXpathEvaluatesTo((String)"7", (String)"count(//foxml:datastream)", (String)xmlIn);
            XMLAssert.assertXpathNotExists((String)"//foxml:disseminator", (String)xmlIn);
        }
        finally {
            apim.purgeObject("demo:1000", "", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIngestATOM_ZIP() throws Exception {
        System.out.println("Testing Ingest with ATOM_ZIP format");
        File atom = File.createTempFile("demo_1001", ".zip");
        FileOutputStream fileWriter = new FileOutputStream(atom);
        fileWriter.write(TestAPIM.demo1001ATOMZip);
        fileWriter.close();
        String[] parameters = new String[]{"f ", atom.getAbsolutePath(), TestCommandLineFormats.ATOM_ZIP1_1.uri, TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), TestCommandLineFormats.getProtocol(), "\"Ingest\"", TestCommandLineFormats.getFedoraAppServerContext()};
        Ingest.main((String[])parameters);
        atom.delete();
        try {
            byte[] objectXML = TypeUtility.convertDataHandlerToBytes((DataHandler)apim.getObjectXML("demo:1001"));
            Assert.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
            String xmlIn = new String(objectXML, "UTF-8");
            XMLAssert.assertXpathExists((String)"foxml:digitalObject[@PID='demo:1001']", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", (String)xmlIn);
            XMLAssert.assertXpathEvaluatesTo((String)"4", (String)"count(//foxml:datastream)", (String)xmlIn);
            XMLAssert.assertXpathNotExists((String)"//foxml:disseminator", (String)xmlIn);
        }
        finally {
            apim.purgeObject("demo:1001", "", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportFOXML10() throws Exception {
        System.out.println("Testing Export in FOXML 1.0 format");
        apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])TestAPIM.demo998FOXMLObjectXML), TestCommandLineFormats.FOXML1_1.uri, "Ingest for test");
        try {
            File temp = File.createTempFile("temp", "");
            String[] parameters = new String[]{TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), "demo:998", TestCommandLineFormats.FOXML1_0.uri, "public", temp.getParent(), "http", TestCommandLineFormats.getFedoraAppServerContext()};
            Export.main((String[])parameters);
            File foxml10 = new File(temp.getParent() + "/demo_998.xml");
            FileInputStream fileReader = new FileInputStream(foxml10);
            byte[] objectXML = new byte[fileReader.available()];
            fileReader.read(objectXML);
            fileReader.close();
            String xmlIn = new String(objectXML, "UTF-8");
            XMLAssert.assertXpathExists((String)"foxml:digitalObject[@PID='demo:998']", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", (String)xmlIn);
            XMLAssert.assertXpathEvaluatesTo((String)"6", (String)"count(//foxml:datastream)", (String)xmlIn);
            XMLAssert.assertXpathNotExists((String)"//foxml:disseminator", (String)xmlIn);
            XMLAssert.assertXpathNotExists((String)"foxml:digitalObject[@VERSION='1.1']", (String)xmlIn);
            temp.delete();
            foxml10.delete();
        }
        finally {
            apim.purgeObject("demo:998", "Purge test object", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportFOXML11() throws Exception {
        System.out.println("Testing Export in FOXML 1.1 format");
        apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])TestAPIM.demo998FOXMLObjectXML), TestCommandLineFormats.FOXML1_1.uri, "Ingest for test");
        try {
            File temp = File.createTempFile("temp", "");
            String[] parameters = new String[]{TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), "demo:998", TestCommandLineFormats.FOXML1_1.uri, "public", temp.getParent(), "http", TestCommandLineFormats.getFedoraAppServerContext()};
            Export.main((String[])parameters);
            File foxml11 = new File(temp.getParent() + "/demo_998.xml");
            String xmlIn = TestCommandLineFormats.fileAsUTFString(foxml11);
            XMLAssert.assertXpathExists((String)"foxml:digitalObject[@PID='demo:998']", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", (String)xmlIn);
            XMLAssert.assertXpathEvaluatesTo((String)"6", (String)"count(//foxml:datastream)", (String)xmlIn);
            XMLAssert.assertXpathNotExists((String)"//foxml:disseminator", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"foxml:digitalObject[@VERSION='1.1']", (String)xmlIn);
            temp.delete();
            foxml11.delete();
        }
        finally {
            apim.purgeObject("demo:998", "Purge test object", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBulkExportFOXML11Syntax() throws Exception {
        System.out.println("Testing Export in FOXML 1.1 format");
        apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])TestAPIM.demo998FOXMLObjectXML), TestCommandLineFormats.FOXML1_1.uri, "Ingest for test");
        try {
            File temp = File.createTempFile("temp", "");
            String[] parameters = new String[]{TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), "FTYPS", "default", "default", temp.getParent(), "http", TestCommandLineFormats.getFedoraAppServerContext()};
            Export.main((String[])parameters);
            File foxml11 = new File(temp.getParent() + "/demo_998.xml");
            Assert.assertTrue((String)("Expected export file " + foxml11.getAbsolutePath() + " does not exist!"), (boolean)foxml11.exists());
            String xmlIn = TestCommandLineFormats.fileAsUTFString(foxml11);
            XMLAssert.assertXpathExists((String)"foxml:digitalObject[@PID='demo:998']", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", (String)xmlIn);
            XMLAssert.assertXpathEvaluatesTo((String)"6", (String)"count(//foxml:datastream)", (String)xmlIn);
            XMLAssert.assertXpathNotExists((String)"//foxml:disseminator", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"foxml:digitalObject[@VERSION='1.1']", (String)xmlIn);
            temp.delete();
            foxml11.delete();
        }
        finally {
            apim.purgeObject("demo:998", "Purge test object", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportMETS11() throws Exception {
        System.out.println("Testing Export in METS 1.1 format");
        apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])TestAPIM.demo998FOXMLObjectXML), TestCommandLineFormats.FOXML1_1.uri, "Ingest for test");
        try {
            File temp = File.createTempFile("temp", "");
            String[] parameters = new String[]{TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), "demo:998", TestCommandLineFormats.METS_EXT1_1.uri, "public", temp.getParent(), "http", TestCommandLineFormats.getFedoraAppServerContext()};
            Export.main((String[])parameters);
            File mets = new File(temp.getParent() + "/demo_998.xml");
            String xmlIn = TestCommandLineFormats.fileAsUTFString(mets);
            XMLAssert.assertXpathExists((String)"METS:mets[@OBJID='demo:998']", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"METS:mets[@LABEL='Data Object (Coliseum) for Local Simple Image Demo']", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"METS:mets[@EXT_VERSION='1.1']", (String)xmlIn);
            XMLAssert.assertXpathEvaluatesTo((String)"4", (String)"count(//METS:fileGrp[@STATUS='A'])", (String)xmlIn);
            temp.delete();
            mets.delete();
        }
        finally {
            apim.purgeObject("demo:998", "Purge test object", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportMETS10() throws Exception {
        System.out.println("Testing Export in METS 1.0 format");
        apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])TestAPIM.demo998FOXMLObjectXML), TestCommandLineFormats.FOXML1_1.uri, "Ingest for test");
        try {
            File temp = File.createTempFile("temp", "");
            String[] parameters = new String[]{TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), "demo:998", TestCommandLineFormats.METS_EXT1_0.uri, "public", temp.getParent(), "http", TestCommandLineFormats.getFedoraAppServerContext()};
            Export.main((String[])parameters);
            File mets = new File(temp.getParent() + "/demo_998.xml");
            String xmlIn = TestCommandLineFormats.fileAsUTFString(mets);
            XMLAssert.assertXpathExists((String)"METS:mets[@OBJID='demo:998']", (String)xmlIn);
            XMLAssert.assertXpathExists((String)"METS:mets[@LABEL='Data Object (Coliseum) for Local Simple Image Demo']", (String)xmlIn);
            XMLAssert.assertXpathNotExists((String)"METS:mets[@EXT_VERSION='1.1']", (String)xmlIn);
            XMLAssert.assertXpathEvaluatesTo((String)"4", (String)"count(//METS:fileGrp[@STATUS='A'])", (String)xmlIn);
            temp.delete();
            mets.delete();
        }
        finally {
            apim.purgeObject("demo:998", "Purge test object", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportATOM() throws Exception {
        System.out.println("Testing Export in ATOM format");
        apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])TestAPIM.demo998FOXMLObjectXML), TestCommandLineFormats.FOXML1_1.uri, "Ingest for test");
        try {
            File temp = File.createTempFile("temp", "");
            String[] parameters = new String[]{TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), "demo:998", TestCommandLineFormats.ATOM1_1.uri, "public", temp.getParent(), "http", TestCommandLineFormats.getFedoraAppServerContext()};
            Export.main((String[])parameters);
            File atom = new File(temp.getParent() + "/demo_998.xml");
            String xmlIn = TestCommandLineFormats.fileAsUTFString(atom);
            Assert.assertTrue((xmlIn.indexOf("<id>info:fedora/demo:998</id>") > -1 ? 1 : 0) != 0);
            Assert.assertTrue((xmlIn.indexOf("<title type=\"text\">Data Object (Coliseum) for Local Simple Image Demo</title>") > -1 ? 1 : 0) != 0);
            temp.delete();
            atom.delete();
        }
        finally {
            apim.purgeObject("demo:998", "Purge test object", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExportATOM_ZIP() throws Exception {
        System.out.println("Testing Export in ATOM_ZIP format");
        apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])TestAPIM.demo998FOXMLObjectXML), TestCommandLineFormats.FOXML1_1.uri, "Ingest for test");
        try {
            ZipEntry entry;
            File temp = File.createTempFile("temp", "");
            String[] parameters = new String[]{TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), "demo:998", TestCommandLineFormats.ATOM_ZIP1_1.uri, "archive", temp.getParent(), "http", TestCommandLineFormats.getFedoraAppServerContext()};
            Export.main((String[])parameters);
            File atom = new File(temp.getParent() + "/demo_998.zip");
            ZipInputStream zip = new ZipInputStream(new FileInputStream(atom));
            int count = 0;
            while ((entry = zip.getNextEntry()) != null) {
                if (!entry.getName().equals("atommanifest.xml")) continue;
                ++count;
                ByteArrayOutputStream manifest = new ByteArrayOutputStream();
                FileUtils.copy((InputStream)zip, (OutputStream)manifest);
                Abdera abdera = Abdera.getInstance();
                Parser parser = abdera.getParser();
                Document feedDoc = parser.parse((Reader)new StringReader(manifest.toString("UTF-8")));
                Feed feed = (Feed)feedDoc.getRoot();
                Assert.assertEquals((String)PID.getInstance((String)"demo:998").toURI(), (String)feed.getId().toString());
            }
            Assert.assertEquals((String)"Expected exactly 1 manifest file", (int)1, (int)count);
            zip.close();
            temp.delete();
            atom.delete();
        }
        finally {
            apim.purgeObject("demo:998", "Purge test object", false);
        }
    }

    private static String fileAsUTFString(File input) throws IOException {
        FileInputStream fileReader = new FileInputStream(input);
        byte[] objectXML = new byte[fileReader.available()];
        fileReader.read(objectXML);
        fileReader.close();
        return new String(objectXML, "UTF-8");
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestCommandLineFormats.class);
    }
}

