/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.integration;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.server.utilities.StreamUtility;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.test.FedoraTestCase;
import org.fcrepo.test.api.RISearchUtil;
import org.junit.After;
import org.junit.Before;

public class TestMisplacedNamespace
extends FedoraTestCase {
    private FedoraClient m_client;
    private static final String OFFENDING_FOXML = "test-objects/foxml/TestMisplacedNamespace/DemoFail.xml";
    private static final String GOOD_FOXML = "test-objects/foxml/TestMisplacedNamespace/DemoSuccess.xml";
    private static final String PID = "demo:failObject";

    public static Test suite() {
        return new JUnit4TestAdapter(TestMisplacedNamespace.class);
    }

    @Before
    public void setUp() throws Exception {
        this.m_client = TestMisplacedNamespace.getFedoraClient();
    }

    @After
    public void tearDown() throws Exception {
        this.m_client.getAPIMMTOM().purgeObject(PID, "Cleanup", false);
        this.m_client.shutdown();
    }

    @org.junit.Test
    public void testIngestAndPurge() throws Exception {
        try {
            this.m_client.getAPIMMTOM().ingest(TypeUtility.convertBytesToDataHandler((byte[])this.getFoxml(OFFENDING_FOXML)), TestMisplacedNamespace.FOXML1_1.uri, "malformed foxml object");
            Assert.fail((String)"Sould have failed initial ingest!");
        }
        catch (Exception e) {
            RISearchUtil.checkSPOCount(this.m_client, "<info:fedora/demo:failObject> * *", 0);
        }
        this.m_client.getAPIMMTOM().ingest(TypeUtility.convertBytesToDataHandler((byte[])this.getFoxml(GOOD_FOXML)), TestMisplacedNamespace.FOXML1_1.uri, "non-malformed foxml object");
    }

    private byte[] getFoxml(String file) throws IOException {
        return StreamUtility.getBytes((InputStream)this.getClass().getClassLoader().getResourceAsStream(file));
    }
}

