/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.integration;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import junit.framework.JUnit4TestAdapter;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.server.utilities.StreamUtility;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.test.FedoraServerTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.w3c.dom.Document;

public class TestOAIService
extends FedoraServerTestCase {
    private FedoraClient client;

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestOAIService.class);
    }

    @Before
    public void setUp() throws Exception {
        this.client = new FedoraClient(TestOAIService.getBaseURL(), TestOAIService.getUsername(), TestOAIService.getPassword());
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("fedora-types", "http://www.fedora.info/definitions/1/0/types/");
        nsMap.put("oai", "http://www.openarchives.org/OAI/2.0/");
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
    }

    @After
    public void tearDown() throws Exception {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
        this.client.shutdown();
    }

    public void testListMetadataFormats() throws Exception {
        String request = "/oai?verb=ListMetadataFormats";
        Document result = this.getXMLQueryResult(this.client, request);
        XMLAssert.assertXpathEvaluatesTo((String)"oai_dc", (String)"/oai:OAI-PMH/oai:ListMetadataFormats/oai:metadataFormat/oai:metadataPrefix", (Document)result);
    }

    @Test
    public void testListRecords() throws Exception {
        FedoraAPIMMTOM apim = this.client.getAPIMMTOM();
        FileInputStream in = new FileInputStream(FEDORA_HOME + "/client/demo/foxml/local-server-demos/simple-document-demo/obj_demo_31.xml");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamUtility.pipeStream((InputStream)in, (OutputStream)out, (int)4096);
        apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])out.toByteArray()), TestOAIService.FOXML1_1.uri, "for testing");
        String request = "/oai?verb=ListRecords&metadataPrefix=oai_dc";
        Document result = this.getXMLQueryResult(this.client, request);
        XMLAssert.assertXpathExists((String)"/oai:OAI-PMH/oai:ListRecords/oai:record", (Document)result);
        request = "/oai?verb=ListRecords&metadataPrefix=oai_dc&from=2000-01-01";
        result = this.getXMLQueryResult(this.client, request);
        XMLAssert.assertXpathExists((String)"/oai:OAI-PMH/oai:ListRecords/oai:record", (Document)result);
        apim.purgeObject("demo:31", "for testing", false);
    }

    public static void main(String[] args) {
        JUnitCore.runClasses((Class[])new Class[]{TestOAIService.class});
    }
}

