/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.client.search.SearchResultParser;
import org.fcrepo.client.utility.AutoPurger;
import org.fcrepo.client.utility.ingest.Ingest;
import org.fcrepo.client.utility.ingest.IngestCounter;
import org.fcrepo.common.Constants;
import org.fcrepo.common.http.HttpInputStream;
import org.fcrepo.server.access.FedoraAPIAMTOM;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.test.FedoraTestCase;
import org.junit.Assert;
import org.junit.runner.JUnitCore;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public abstract class FedoraServerTestCase
extends FedoraTestCase
implements Constants {
    public FedoraServerTestCase() {
    }

    public FedoraServerTestCase(String name) {
        super(name);
    }

    @Deprecated
    public Document getXMLQueryResult(String location) throws Exception {
        return this.getXMLQueryResult(FedoraServerTestCase.getFedoraClient(), location);
    }

    public Document getXMLQueryResult(FedoraClient client, String location) throws Exception {
        HttpInputStream is = client.get(FedoraServerTestCase.getBaseURL() + location, true, true);
        Document result = XMLUnit.buildControlDocument((InputSource)new InputSource((InputStream)is));
        is.close();
        return result;
    }

    public static boolean testingMETS() {
        String format = System.getProperty("demo.format");
        return format != null && format.equalsIgnoreCase("mets");
    }

    public static boolean testingAtom() {
        String format = System.getProperty("demo.format");
        return format != null && format.equalsIgnoreCase("atom");
    }

    public static boolean testingAtomZip() {
        String format = System.getProperty("demo.format");
        return format != null && format.equalsIgnoreCase("atom-zip");
    }

    @Deprecated
    public static void ingestDemoObjects() throws Exception {
        FedoraServerTestCase.ingestDemoObjects("/");
    }

    public static void ingestDemoObjects(FedoraClient client) throws Exception {
        FedoraServerTestCase.ingestDemoObjects(client, "/");
    }

    public static void ingestDemoObjects(FedoraAPIAMTOM apia, FedoraAPIMMTOM apim) throws Exception {
        FedoraServerTestCase.ingestDemoObjects(apia, apim, "/");
    }

    @Deprecated
    public static void ingestDemoObjects(String ... paths) throws Exception {
        FedoraClient client = FedoraTestCase.getFedoraClient();
        FedoraServerTestCase.ingestDemoObjects(client, paths);
        client.shutdown();
    }

    public static void ingestDemoObjects(FedoraClient client, String ... paths) throws Exception {
        FedoraAPIAMTOM apia = client.getAPIAMTOM();
        FedoraAPIMMTOM apim = client.getAPIMMTOM();
        FedoraServerTestCase.ingestDemoObjects(apia, apim, paths);
    }

    public static void ingestDemoObjects(FedoraAPIAMTOM apia, FedoraAPIMMTOM apim, String ... paths) throws Exception {
        File dir = null;
        for (String path : paths) {
            String ingestFormat;
            String specificPath = File.separator + path;
            if (FedoraServerTestCase.testingMETS()) {
                System.out.println("Ingesting demo objects in METS format from " + specificPath);
                dir = new File(FEDORA_HOME, "client/demo/mets" + specificPath);
                ingestFormat = FedoraServerTestCase.METS_EXT1_1.uri;
            } else if (FedoraServerTestCase.testingAtom()) {
                System.out.println("Ingesting demo objects in Atom format from " + specificPath);
                dir = new File(FEDORA_HOME, "client/demo/atom" + specificPath);
                ingestFormat = FedoraServerTestCase.ATOM1_1.uri;
            } else if (FedoraServerTestCase.testingAtomZip()) {
                System.out.println("Ingesting all demo objects in Atom Zip format from " + specificPath);
                dir = new File(FEDORA_HOME, "client/demo/atom-zip" + specificPath);
                ingestFormat = FedoraServerTestCase.ATOM_ZIP1_1.uri;
            } else {
                System.out.println("Ingesting demo objects in FOXML format from " + specificPath);
                dir = new File(FEDORA_HOME, "client/demo/foxml" + specificPath);
                ingestFormat = FedoraServerTestCase.FOXML1_1.uri;
            }
            Ingest.multiFromDirectory((File)dir, (String)ingestFormat, (FedoraAPIAMTOM)apia, (FedoraAPIMMTOM)apim, null, (PrintStream)new PrintStream(File.createTempFile("demo", null)), (IngestCounter)new IngestCounter());
        }
    }

    public static void ingestDocumentTransformDemoObjects(FedoraClient client) throws Exception {
        FedoraServerTestCase.ingestDemoObjects(client, "local-server-demos" + File.separator + "document-transform-demo");
    }

    public static void ingestFormattingObjectsDemoObjects(FedoraClient client) throws Exception {
        FedoraServerTestCase.ingestDemoObjects(client, "local-server-demos" + File.separator + "formatting-objects-demo");
    }

    public static void ingestImageCollectionDemoObjects(FedoraClient client) throws Exception {
        FedoraServerTestCase.ingestDemoObjects(client, "local-server-demos" + File.separator + "image-collection-demo");
    }

    public static void ingestImageManipulationDemoObjects(FedoraClient client) throws Exception {
        FedoraServerTestCase.ingestDemoObjects(client, "local-server-demos" + File.separator + "image-manip-demo");
    }

    public static void ingestSimpleDocumentDemoObjects(FedoraClient client) throws Exception {
        FedoraServerTestCase.ingestDemoObjects(client, "local-server-demos" + File.separator + "simple-document-demo");
    }

    public static void ingestSimpleImageDemoObjects(FedoraClient client) throws Exception {
        FedoraServerTestCase.ingestDemoObjects(client, "local-server-demos" + File.separator + "simple-image-demo");
    }

    @Deprecated
    public static Set<String> getDemoObjects() throws Exception {
        FedoraClient client = FedoraServerTestCase.getFedoraClient();
        Set<String> result = null;
        try {
            result = FedoraServerTestCase.getDemoObjects(client);
        }
        finally {
            client.shutdown();
        }
        return result;
    }

    public static Set<String> getDemoObjects(FedoraClient client) throws Exception {
        HttpInputStream queryResult = client.get(FedoraServerTestCase.getBaseURL() + "/search?query=pid~demo:*" + "&maxResults=1000&pid=true&xml=true", true, true);
        SearchResultParser parser = new SearchResultParser((InputStream)queryResult);
        Set result = parser.getPIDs();
        queryResult.close();
        return result;
    }

    @Deprecated
    public static void purgeDemoObjects() throws Exception {
        FedoraClient client = FedoraServerTestCase.getFedoraClient();
        FedoraServerTestCase.purgeDemoObjects(client);
        client.shutdown();
    }

    public static void purgeDemoObjects(FedoraClient client) throws Exception {
        FedoraAPIMMTOM apim = client.getAPIMMTOM();
        for (String pid : FedoraServerTestCase.getDemoObjects(client)) {
            AutoPurger.purge((FedoraAPIMMTOM)apim, (String)pid, null);
        }
    }

    @Deprecated
    public static void purgeDemoObjects(FedoraAPIMMTOM apim) throws Exception {
        for (String pid : FedoraServerTestCase.getDemoObjects()) {
            AutoPurger.purge((FedoraAPIMMTOM)apim, (String)pid, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runConcurrent(Callable<?>[] callables) throws Exception {
        int numThreads = callables.length;
        ExecutorService threadPool = Executors.newFixedThreadPool(numThreads);
        try {
            final CountDownLatch allExecutorThreadsReady = new CountDownLatch(numThreads);
            final CountDownLatch afterInitBlocker = new CountDownLatch(1);
            final CountDownLatch allDone = new CountDownLatch(numThreads);
            for (final Callable<?> submittedTestCallable : callables) {
                threadPool.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        allExecutorThreadsReady.countDown();
                        try {
                            afterInitBlocker.await();
                            Object v = submittedTestCallable.call();
                            return v;
                        }
                        finally {
                            allDone.countDown();
                        }
                    }
                });
            }
            Assert.assertTrue((String)"Timeout initializing threads! Perform long lasting initializations before passing runnables to assertConcurrent", (boolean)allExecutorThreadsReady.await(callables.length * 10, TimeUnit.MILLISECONDS));
            afterInitBlocker.countDown();
            Assert.assertTrue((String)"Thread timeout! More than 5 seconds", (boolean)allDone.await(5L, TimeUnit.SECONDS));
        }
        finally {
            threadPool.shutdownNow();
        }
    }

    public static void main(String[] args) {
        JUnitCore.runClasses((Class[])new Class[]{FedoraServerTestCase.class});
    }
}

