/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import com.yourmediashelf.fedora.client.FedoraClient;
import com.yourmediashelf.fedora.client.FedoraCredentials;
import com.yourmediashelf.fedora.client.response.GetObjectHistoryResponse;
import java.util.HashMap;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.test.FedoraServerTestCase;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.JUnitCore;
import org.xml.sax.InputSource;

public class TestExampleWithMediashelfClient
extends FedoraServerTestCase {
    private static org.fcrepo.client.FedoraClient s_client;
    private FedoraClient client;

    @BeforeClass
    public static void bootstrap() throws Exception {
        s_client = TestExampleWithMediashelfClient.getFedoraClient();
        TestExampleWithMediashelfClient.ingestSimpleDocumentDemoObjects(s_client);
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        TestExampleWithMediashelfClient.purgeDemoObjects(s_client);
        s_client.shutdown();
    }

    @Before
    public void setUp() throws Exception {
        this.client = new FedoraClient(new FedoraCredentials(TestExampleWithMediashelfClient.getBaseURL(), TestExampleWithMediashelfClient.getUsername(), TestExampleWithMediashelfClient.getPassword()));
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put(TestExampleWithMediashelfClient.ACCESS.prefix, TestExampleWithMediashelfClient.ACCESS.uri);
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
    }

    @org.junit.Test
    public void testObjectHistory() throws Exception {
        GetObjectHistoryResponse response = FedoraClient.getObjectHistory((String)"demo:18").execute(this.client);
        XMLAssert.assertXpathExists((String)"/access:fedoraObjectHistory/access:objectChangeDate", (InputSource)new InputSource(response.getEntityInputStream()));
    }

    @After
    public void tearDown() {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(TestExampleWithMediashelfClient.class);
    }

    public static void main(String[] args) {
        JUnitCore.runClasses((Class[])new Class[]{TestExampleWithMediashelfClient.class});
    }
}

