/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.fesl.util;

import java.io.File;
import java.io.IOException;
import javax.xml.rpc.ServiceException;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.common.Constants;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.server.utilities.StreamUtility;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.test.fesl.util.DataUtils;
import org.w3c.dom.Document;

public class PolicyUtils
implements Constants {
    FedoraAPIMMTOM apim = null;
    private static final String RESOURCEBASE = System.getProperty("fcrepo-integrationtest-core.classes") != null ? System.getProperty("fcrepo-integrationtest-core.classes") + "test-objects" : "src/test/resources/test-objects";

    private PolicyUtils() {
    }

    public PolicyUtils(FedoraClient fedoraClient) throws ServiceException, IOException {
        this.apim = fedoraClient.getAPIMMTOM();
    }

    public String addPolicy(File policyFile) throws Exception {
        byte[] policy = DataUtils.loadFile(policyFile.getAbsolutePath());
        String policyId = PolicyUtils.getPolicyId(policy);
        String policyFileName = "file:///" + policyFile.getAbsolutePath();
        if (policyId.contains(":")) {
            policyId = policyId.replace(":", "%3A");
        }
        String pid = "demo:" + policyId;
        StringBuilder foxml = new StringBuilder();
        foxml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<foxml:digitalObject VERSION=\"1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns:foxml=\"info:fedora/fedora-system:def/foxml#\"\n           xsi:schemaLocation=\"");
        foxml.append(Constants.FOXML.uri);
        foxml.append(' ');
        foxml.append(Constants.FOXML1_1.xsdLocation);
        foxml.append("\"\n           PID=\"");
        StreamUtility.enc((String)pid, (StringBuilder)foxml);
        foxml.append("\">\n  <foxml:objectProperties>\n    <foxml:property NAME=\"info:fedora/fedora-system:def/model#state\" VALUE=\"A\"/>\n    <foxml:property NAME=\"info:fedora/fedora-system:def/model#label\" VALUE=\"");
        StreamUtility.enc((String)"test policy object", (StringBuilder)foxml);
        foxml.append("\"/>\n  </foxml:objectProperties>\n<foxml:datastream ID=\"FESLPOLICY\" CONTROL_GROUP=\"M\"><foxml:datastreamVersion ID=\"POLICY.0\" MIMETYPE=\"text/xml\" LABEL=\"XACML policy datastream\">  <foxml:contentLocation REF=\"");
        foxml.append(policyFileName);
        foxml.append("\" TYPE=\"URL\"/>  </foxml:datastreamVersion></foxml:datastream></foxml:digitalObject>");
        this.apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])foxml.toString().getBytes("UTF-8")), PolicyUtils.FOXML1_1.uri, "ingesting new foxml object");
        return policyId;
    }

    public String addPolicy(String policyName) throws Exception {
        return this.addPolicy(new File(RESOURCEBASE + "/xacml/" + policyName));
    }

    public void delPolicy(String policyId) throws Exception {
        String pid = "demo:" + policyId;
        this.apim.purgeObject(pid, "removing test policy object", false);
    }

    private static String getPolicyId(byte[] data) throws Exception {
        Document doc = DataUtils.getDocumentFromBytes(data);
        String pid = doc.getDocumentElement().getAttribute("PolicyId");
        return pid;
    }
}

