/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.integration;

import java.io.FileInputStream;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.commons.io.IOUtils;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.server.access.FedoraAPIAMTOM;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.server.types.gen.Datastream;
import org.fcrepo.server.types.gen.DatastreamDef;
import org.fcrepo.server.types.gen.ObjectProfile;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.test.FedoraServerTestCase;
import org.junit.Assert;
import org.junit.Before;

public class TestObjectLastModDate
extends FedoraServerTestCase {
    private FedoraAPIAMTOM apia;
    private FedoraAPIMMTOM apim;
    private static final String FOXMLPATH = "fcrepo238.xml";
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final String RESOURCEBASE = System.getProperty("fcrepo-integrationtest-core.classes") != null ? System.getProperty("fcrepo-integrationtest-core.classes") + "test-objects/foxml/cli-utils" : "src/test/resources/test-objects/foxml/cli-utils";

    public static Test suite() {
        return new JUnit4TestAdapter(TestObjectLastModDate.class);
    }

    @Before
    public void setUp() throws Exception {
        FedoraClient client = TestObjectLastModDate.getFedoraClient();
        this.apia = client.getAPIAMTOM();
        this.apim = client.getAPIMMTOM();
        client.shutdown();
    }

    @org.junit.Test
    public void testFCREPO238() throws Exception {
        String pid = this.apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])IOUtils.toByteArray((InputStream)new FileInputStream(RESOURCEBASE + "/" + FOXMLPATH))), TestObjectLastModDate.FOXML1_1.uri, "testing fcrepo 238");
        ObjectProfile profile = this.apia.getObjectProfile(pid, null);
        Date objDate = this.dateFormat.parse(profile.getObjLastModDate());
        for (DatastreamDef dd : this.apia.listDatastreams(pid, null)) {
            Datastream ds = this.apim.getDatastream(pid, dd.getID(), null);
            Date dsDate = this.dateFormat.parse(ds.getCreateDate());
            System.out.print("object:" + this.dateFormat.format(objDate) + ", ");
            System.out.println("datastream: " + this.dateFormat.format(dsDate));
            Assert.assertTrue((String)"object last modificaton date is before datastream's create date. check FCREPO-238", (objDate.compareTo(dsDate) > -1 ? 1 : 0) != 0);
        }
        this.apim.purgeObject(pid, "removing testobject", true);
    }
}

