/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.integration.cma;

import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.client.utility.AutoPurger;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.integration.cma.Util;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public class ConflictingDeploymentTests {
    private static final String DEMO_OBJECT_BASE = "cma-examples/conflicting-deployments";
    private static final String PUBLIC_OBJECT_BASE = "cma-examples/conflicting-deployments/public-objects";
    private static final String DEPLOYMENT_1_BASE = "cma-examples/conflicting-deployments/sdeps/1";
    private static final String DEPLOYMENT_2_BASE = "cma-examples/conflicting-deployments/sdeps/2";
    private final String SDEF_PID = "demo:conflicting-deployment.sdef";
    private final String OBJECT_PID = "demo:conflicting-deployment.object";
    private final String SDEP_1_PID = "demo:conflicting-deployment.sdep1";
    private final String SDEP_2_PID = "demo:conflicting-deployment.sdep2";
    private final String METHOD_NAME = "content";
    private static FedoraClient s_client;

    public static Test suite() {
        return new JUnit4TestAdapter(ConflictingDeploymentTests.class);
    }

    @BeforeClass
    public static void bootStrap() throws Exception {
        s_client = new FedoraClient(FedoraServerTestCase.getBaseURL(), FedoraServerTestCase.getUsername(), FedoraServerTestCase.getPassword());
        Util.ingestTestObjects(s_client, PUBLIC_OBJECT_BASE);
    }

    @AfterClass
    public static void cleanUp() {
        s_client.shutdown();
    }

    @Before
    public void setUp() throws Exception {
        int ingested = 0;
        ingested = Util.ingestTestObjects(s_client, DEPLOYMENT_1_BASE);
        Assert.assertTrue((String)("No objects were ingested from " + Util.resourcePath(DEPLOYMENT_1_BASE)), (ingested > 0 ? 1 : 0) != 0);
        ingested = Util.ingestTestObjects(s_client, DEPLOYMENT_2_BASE);
        Assert.assertTrue((String)("No objects were ingested from " + Util.resourcePath(DEPLOYMENT_2_BASE)), (ingested > 0 ? 1 : 0) != 0);
    }

    @After
    public void tearDown() throws Exception {
        FedoraAPIMMTOM apim = s_client.getAPIMMTOM();
        AutoPurger.purge((FedoraAPIMMTOM)apim, (String)"demo:conflicting-deployment.sdep1", null);
        AutoPurger.purge((FedoraAPIMMTOM)apim, (String)"demo:conflicting-deployment.sdep2", null);
    }

    @org.junit.Test
    public void testDeployFirstIngested12() throws Exception {
        String content = this.getDisseminatedContent();
        junit.framework.Assert.assertFalse((String)("Wrong deployment used!" + content), (boolean)content.contains("CONTENT_2"));
        junit.framework.Assert.assertTrue((String)"Did not disseminate expected content", (boolean)content.contains("CONTENT_1"));
    }

    @org.junit.Test
    public void testDeployFirstIngested21() throws Exception {
        String content = this.getDisseminatedContent();
        junit.framework.Assert.assertFalse((String)"Wrong deployment used!", (boolean)content.contains("CONTENT_2"));
        junit.framework.Assert.assertTrue((String)"Did not disseminate expected content", (boolean)content.contains("CONTENT_1"));
    }

    @org.junit.Test
    public void testModifyOldestSdep() throws Exception {
        this.modify("demo:conflicting-deployment.sdep1");
        String content = this.getDisseminatedContent();
        junit.framework.Assert.assertFalse((String)"Wrong deployment used!", (boolean)content.contains("CONTENT_1"));
        junit.framework.Assert.assertTrue((String)"Did not disseminate expected content", (boolean)content.contains("CONTENT_2"));
    }

    @org.junit.Test
    public void testModifyNewestSdep() throws Exception {
        this.modify("demo:conflicting-deployment.sdep2");
        String content = this.getDisseminatedContent();
        junit.framework.Assert.assertFalse((String)"Wrong deployment used!", (boolean)content.contains("CONTENT_2"));
        junit.framework.Assert.assertTrue((String)"Did not disseminate expected content", (boolean)content.contains("CONTENT_1"));
    }

    @org.junit.Test
    public void testPurgeReplace() throws Exception {
        s_client.getAPIMMTOM().purgeObject("demo:conflicting-deployment.sdep1", "removing first sDep", false);
        try {
            junit.framework.Assert.assertTrue((String)"Did not disseminate expected content: ", (boolean)this.getDisseminatedContent().contains("CONTENT_2"));
        }
        finally {
            Util.ingestTestObjects(s_client, DEPLOYMENT_1_BASE);
        }
    }

    private void modify(String pid) throws Exception {
        s_client.getAPIMMTOM().addRelationship(pid, "http://example.org/isModified", "true", true, null);
    }

    private String getDisseminatedContent() throws Exception {
        return Util.getDissemination(s_client, "demo:conflicting-deployment.object", "demo:conflicting-deployment.sdef", "content");
    }
}

