/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.integration.cma;

import javax.xml.ws.soap.SOAPFaultException;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.client.utility.AutoPurger;
import org.fcrepo.server.access.FedoraAPIAMTOM;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.server.types.gen.ObjectMethodsDef;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.integration.cma.Util;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public class SimpleDeploymentTests {
    private static FedoraClient s_client;
    private static int s_items_ingested;
    private static final String OBJECT_1_PID = "demo:simple-deployment.object.1";
    private static final String SDEF_1_PID = "demo:simple-deployment.sdef.1";
    private static final String SDEF_2_PID = "demo:simple-deployment.sdef.2";
    private static final String SDEF_1_METHOD = "content";
    private static final String SDEF_2_METHOD = "content2";
    private static final String SDEP_1_PID = "demo:simple-deployment.sdep.1";
    private static final String SDEP_2_PID = "demo:simple-deployment.sdep.2";
    private static final String SIMPLE_DEPLOYMENT_BASE = "cma-examples/simple-deployment";
    private static final String SIMPLE_DEPLOYMENT_PUBLIC_OBJECTS = "cma-examples/simple-deployment/public-objects";
    private static final String SIMPLE_DEPLOYMENT_DEPLOYMENTS = "cma-examples/simple-deployment/deployments";

    public static Test suite() {
        return new JUnit4TestAdapter(SimpleDeploymentTests.class);
    }

    @BeforeClass
    public static void bootstrap() throws Exception {
        s_client = new FedoraClient(FedoraServerTestCase.getBaseURL(), FedoraServerTestCase.getUsername(), FedoraServerTestCase.getPassword());
        s_items_ingested = Util.ingestTestObjects(s_client, SIMPLE_DEPLOYMENT_DEPLOYMENTS);
        s_items_ingested += Util.ingestTestObjects(s_client, SIMPLE_DEPLOYMENT_PUBLIC_OBJECTS);
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        FedoraServerTestCase.purgeDemoObjects(s_client);
        s_client.shutdown();
    }

    @Before
    public void setUp() {
        Assert.assertTrue((String)("Nothing was ingested from " + Util.resourcePath(SIMPLE_DEPLOYMENT_BASE)), (s_items_ingested > 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testListMethods() throws Exception {
        FedoraAPIAMTOM apia = s_client.getAPIAMTOM();
        ObjectMethodsDef[] methods = Util.filterMethods(apia.listMethods(OBJECT_1_PID, null).toArray(new ObjectMethodsDef[0]));
        Assert.assertEquals((String)"Wrong number of methods", (int)2, (int)methods.length);
        Assert.assertNotSame((String)"SDeps are not distinct", (Object)methods[0].getServiceDefinitionPID(), (Object)methods[1].getServiceDefinitionPID());
        Assert.assertNotSame((String)"Methods are not distinct", (Object)methods[0].getMethodName(), (Object)methods[1].getMethodName());
        if (methods[0].getServiceDefinitionPID().equals(SDEF_1_PID)) {
            Assert.assertEquals((String)methods[1].getServiceDefinitionPID(), (String)SDEF_2_PID);
            Assert.assertEquals((String)methods[0].getMethodName(), (String)SDEF_1_METHOD);
            Assert.assertEquals((String)methods[1].getMethodName(), (String)SDEF_2_METHOD);
        } else if (methods[0].getServiceDefinitionPID().equals(SDEF_2_PID)) {
            Assert.assertEquals((String)methods[1].getServiceDefinitionPID(), (String)SDEF_1_PID);
            Assert.assertEquals((String)methods[0].getMethodName(), (String)SDEF_2_METHOD);
            Assert.assertEquals((String)methods[1].getMethodName(), (String)SDEF_1_METHOD);
        }
    }

    @org.junit.Test
    public void testListMethodsWithoutSDeps() throws Exception {
        FedoraAPIMMTOM apim = s_client.getAPIMMTOM();
        AutoPurger.purge((FedoraAPIMMTOM)apim, (String)SDEP_1_PID, null);
        AutoPurger.purge((FedoraAPIMMTOM)apim, (String)SDEP_2_PID, null);
        try {
            this.testListMethods();
        }
        finally {
            Util.ingestTestObjects(s_client, SIMPLE_DEPLOYMENT_DEPLOYMENTS);
        }
    }

    @org.junit.Test
    public void testDissemination1() throws Exception {
        Assert.assertTrue((String)"Wrong dissemination content", (boolean)this.getDissemination(OBJECT_1_PID, SDEF_1_PID, SDEF_1_METHOD).contains("CONTENT_1"));
        try {
            this.getDissemination(OBJECT_1_PID, SDEF_1_PID, SDEF_2_METHOD);
            Assert.fail((String)"Should not have been able to disseminate");
        }
        catch (SOAPFaultException sOAPFaultException) {
            // empty catch block
        }
        try {
            this.getDissemination(OBJECT_1_PID, SDEF_2_PID, SDEF_1_METHOD);
            Assert.fail((String)"Should not have been able to disseminate");
        }
        catch (SOAPFaultException sOAPFaultException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testDissemination2() throws Exception {
        Assert.assertTrue((String)"Wrong dissemination content", (boolean)this.getDissemination(OBJECT_1_PID, SDEF_2_PID, SDEF_2_METHOD).contains("CONTENT_2"));
    }

    private String getDissemination(String pid, String sDef, String method) throws Exception {
        return Util.getDissemination(s_client, pid, sDef, method);
    }

    static {
        s_items_ingested = 0;
    }
}

