/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.indexer;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.fcrepo.indexer.Indexer;

public class FileSerializer
implements Indexer {
    private static SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddHHmmss");
    private File path;

    public void setPath(String pathName) {
        this.path = new File(pathName);
        if (!this.path.exists()) {
            this.path.mkdirs();
        }
    }

    public String getPath() {
        return this.path.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(String pid, String content) throws IOException {
        String fn = pid + "." + fmt.format(new Date());
        if (fn.indexOf(47) != -1) {
            fn = StringUtils.substringAfterLast((String)fn, (String)"/");
        }
        try (OutputStreamWriter fw = null;){
            fw = new FileWriter(new File(this.path, fn));
            IOUtils.write((String)content, (Writer)fw);
        }
    }

    @Override
    public void remove(String pid) throws IOException {
        this.update(pid, "");
    }
}

