/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.indexer;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Category;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.parser.Parser;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.fcrepo.indexer.Indexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexerGroup
implements MessageListener {
    private final Logger logger = LoggerFactory.getLogger(IndexerGroup.class);
    private Parser atomParser = new Abdera().getParser();
    private String repositoryURL;
    private Set<Indexer> indexers;
    private HttpClient httpclient;

    public IndexerGroup() {
        PoolingClientConnectionManager p = new PoolingClientConnectionManager();
        p.setDefaultMaxPerRoute(5);
        p.closeIdleConnections(3L, TimeUnit.SECONDS);
        this.httpclient = new DefaultHttpClient((ClientConnectionManager)p);
    }

    public void setRepositoryURL(String repositoryURL) {
        this.repositoryURL = repositoryURL;
    }

    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    public void setIndexers(Set indexers) {
        for (Object o : indexers) {
            if (!(o instanceof Indexer)) continue;
            if (this.indexers == null) {
                this.indexers = new HashSet<Indexer>();
            }
            this.indexers.add((Indexer)o);
        }
    }

    public Set<Indexer> getIndexers() {
        return this.indexers;
    }

    private String getPath(List<Category> categories) {
        for (Category c : categories) {
            if (!c.getLabel().equals("path")) continue;
            return this.repositoryURL + c.getTerm();
        }
        return this.repositoryURL;
    }

    public void onMessage(Message message) {
        try {
            if (message instanceof TextMessage) {
                String xml = ((TextMessage)message).getText();
                Document doc = this.atomParser.parse((Reader)new StringReader(xml));
                Entry entry = (Entry)doc.getRoot();
                String content = null;
                if (!"purgeObject".equals(entry.getTitle())) {
                    HttpGet get = new HttpGet(this.getPath(entry.getCategories("xsd:string")));
                    HttpResponse response = this.httpclient.execute((HttpUriRequest)get);
                    content = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)Charset.forName("UTF-8"));
                }
                String pid = this.getPath(entry.getCategories("xsd:string"));
                for (Indexer indexer : this.indexers) {
                    try {
                        if ("purgeObject".equals(entry.getTitle())) {
                            indexer.remove(pid);
                            continue;
                        }
                        indexer.update(pid, content);
                    }
                    catch (Exception innerex) {
                        this.logger.warn("Error indexing {}, {}", (Object)pid, (Object)innerex);
                    }
                }
            }
        }
        catch (JMSException e) {
            this.logger.warn("Error processing JMS event", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.warn("Error retrieving object from repository", (Throwable)e);
        }
    }
}

