/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.indexer;

import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import com.hp.hpl.jena.sparql.modify.UpdateProcessRemote;
import com.hp.hpl.jena.sparql.modify.request.QuadDataAcc;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataInsert;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateExecutionFactory;
import com.hp.hpl.jena.update.UpdateProcessor;
import com.hp.hpl.jena.update.UpdateRequest;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Iterator;
import org.fcrepo.indexer.Indexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlIndexer
implements Indexer {
    private String prefix;
    private String queryBase;
    private String updateBase;
    private boolean formUpdates = false;
    private final Logger logger = LoggerFactory.getLogger(SparqlIndexer.class);

    public void setPrefix(String s) {
        this.prefix = s;
    }

    public void setFormUpdates(boolean b) {
        this.formUpdates = b;
    }

    public void setQueryBase(String url) {
        this.queryBase = url;
    }

    public void setUpdateBase(String url) {
        this.updateBase = url;
    }

    @Override
    public void update(String pid, String content) {
        this.remove(pid);
        Model model = ModelFactory.createDefaultModel();
        model.read((Reader)new StringReader(content), null, "N3");
        StmtIterator triples = model.listStatements();
        QuadDataAcc add = new QuadDataAcc();
        while (triples.hasNext()) {
            add.addTriple(triples.nextStatement().asTriple());
        }
        this.logger.debug("Sending update request for pid: {}", (Object)pid);
        this.exec(new UpdateRequest((Update)new UpdateDataInsert(add)));
    }

    @Override
    public void remove(String subject) {
        String describeQuery = "DESCRIBE <" + subject + ">";
        QueryEngineHTTP qexec = new QueryEngineHTTP(this.queryBase, describeQuery);
        Iterator results = qexec.execDescribeTriples();
        HashSet<String> uris = new HashSet<String>();
        while (results.hasNext()) {
            String uri;
            Triple triple = (Triple)results.next();
            if (triple.getSubject().isURI() && this.matches(subject, uri = ((Node_URI)triple.getSubject()).getURI())) {
                uris.add(uri);
            }
            if (!triple.getObject().isURI() || !this.matches(subject, uri = ((Node_URI)triple.getObject()).getURI())) continue;
            uris.add(uri);
        }
        qexec.close();
        UpdateRequest del = new UpdateRequest();
        for (String uri : uris) {
            String cmd = "delete where { <" + uri + "> ?p ?o }";
            this.logger.debug(cmd);
            del.add(cmd);
        }
        this.exec(del);
    }

    private boolean matches(String uri1, String uri2) {
        return uri1.equals(uri2) || uri1.startsWith(uri2 + "/") || uri1.startsWith(uri2 + "#");
    }

    private void exec(UpdateRequest update) {
        if (this.formUpdates) {
            UpdateProcessor proc = UpdateExecutionFactory.createRemoteForm((UpdateRequest)update, (String)this.updateBase);
            proc.execute();
        } else {
            UpdateProcessRemote proc = new UpdateProcessRemote(update, this.updateBase, Context.emptyContext);
            proc.execute();
        }
    }

    public int countTriples(String pid) {
        String describeQuery = "DESCRIBE <" + pid + ">";
        QueryEngineHTTP qexec = new QueryEngineHTTP(this.queryBase, describeQuery);
        Iterator results = qexec.execDescribeTriples();
        int triples = 0;
        while (results.hasNext()) {
            results.next();
            ++triples;
        }
        qexec.close();
        return triples;
    }
}

