/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.indexer;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.Reader;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.fcrepo.indexer.AbsentTransformPropertyException;
import org.fcrepo.indexer.Indexer;
import org.fcrepo.indexer.NamedFieldsRetriever;
import org.fcrepo.indexer.RdfRetriever;
import org.fcrepo.kernel.utils.EventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexerGroup
implements MessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexerGroup.class);
    private String repositoryURL;
    private Set<Indexer<Object>> indexers;
    private HttpClient httpClient;
    static final String IDENTIFIER_HEADER_NAME = "http://fedora.info/definitions/v4/repository#identifier";
    static final String EVENT_TYPE_HEADER_NAME = "http://fedora.info/definitions/v4/repository#eventType";
    static final String REMOVAL_EVENT_TYPE = "http://fedora.info/definitions/v4/repository#" + EventType.valueOf((Integer)2).toString();
    public static final String INDEXER_NAMESPACE = "http://fedora.info/definitions/v4/indexing#";
    public static final Property INDEXING_TRANSFORM_PREDICATE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/indexing#hasIndexingTransformation");
    public static final Resource INDEXABLE_MIXIN = ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/indexing#indexable");
    private static final Reader EMPTY_CONTENT = null;

    public IndexerGroup() {
        LOGGER.debug("Creating IndexerGroup: {}", (Object)this);
        PoolingClientConnectionManager connMann = new PoolingClientConnectionManager();
        connMann.setMaxTotal(Integer.MAX_VALUE);
        connMann.setDefaultMaxPerRoute(Integer.MAX_VALUE);
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)connMann);
    }

    public void setRepositoryURL(String repositoryURL) {
        this.repositoryURL = repositoryURL;
    }

    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    public void setIndexers(Set<Indexer<Object>> indexers) {
        this.indexers = indexers;
        LOGGER.debug("Using indexer complement: {} ", indexers);
    }

    public Set<Indexer<Object>> getIndexers() {
        return this.indexers;
    }

    public void setHttpClient(HttpClient client) {
        this.httpClient = client;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void onMessage(Message message) {
        try {
            LOGGER.debug("Received message: {}", (Object)message.getJMSMessageID());
        }
        catch (JMSException e) {
            LOGGER.error("Received unintelligible message: {}", (Throwable)e);
            Throwables.propagate((Throwable)e);
        }
        try {
            String pid;
            String eventType = message.getStringProperty(EVENT_TYPE_HEADER_NAME);
            if (eventType.contains("PROPERTY")) {
                String id = message.getStringProperty(IDENTIFIER_HEADER_NAME);
                pid = id.substring(0, id.lastIndexOf(47));
            } else {
                pid = message.getStringProperty(IDENTIFIER_HEADER_NAME);
            }
            LOGGER.debug("Discovered pid: {} in message.", (Object)pid);
            LOGGER.debug("Discovered event type: {} in message.", (Object)eventType);
            Boolean removal = REMOVAL_EVENT_TYPE.equals(eventType);
            LOGGER.debug("It is {} that this is a removal operation.", (Object)removal);
            String uri = this.getRepositoryURL() + pid;
            Supplier rdfr = Suppliers.memoize((Supplier)new RdfRetriever(uri, this.httpClient));
            Supplier nfr = Suppliers.memoize((Supplier)new NamedFieldsRetriever(uri, this.httpClient, (Supplier<Model>)rdfr));
            Boolean indexable = false;
            if (!removal.booleanValue()) {
                Model rdf = (Model)rdfr.get();
                if (rdf.contains(ResourceFactory.createResource((String)uri), RDF.type, (RDFNode)INDEXABLE_MIXIN)) {
                    LOGGER.debug("Resource: {} retrieved with indexable type.", (Object)pid);
                    indexable = true;
                } else {
                    LOGGER.debug("Resource: {} retrieved without indexable type.", (Object)pid);
                }
            }
            for (Indexer<Object> indexer : this.getIndexers()) {
                LOGGER.debug("Operating for indexer: {}", indexer);
                Boolean hasContent = false;
                Object content = EMPTY_CONTENT;
                if (!removal.booleanValue() && indexable.booleanValue()) {
                    switch (indexer.getIndexerType()) {
                        case NAMEDFIELDS: {
                            LOGGER.debug("Retrieving named fields for: {}, (may be cached) to index to {}...", (Object)pid, indexer);
                            try {
                                content = nfr.get();
                                hasContent = true;
                            }
                            catch (AbsentTransformPropertyException e) {
                                LOGGER.error("Failed to retrieve indexable content:could not find transform property!");
                                hasContent = false;
                            }
                            break;
                        }
                        case RDF: {
                            LOGGER.debug("Retrieving RDF for: {}, (may be cached) to index to {}...", (Object)pid, indexer);
                            content = rdfr.get();
                            hasContent = true;
                            break;
                        }
                        default: {
                            hasContent = true;
                        }
                    }
                }
                try {
                    if (removal.booleanValue()) {
                        LOGGER.debug("Executing removal of: {} to indexer: {}...", (Object)pid, indexer);
                        indexer.remove(uri);
                        continue;
                    }
                    if (hasContent.booleanValue()) {
                        LOGGER.debug("Executing update of: {} to indexer: {}...", (Object)pid, indexer);
                        indexer.update(uri, content);
                        continue;
                    }
                    if (!indexable.booleanValue()) continue;
                    LOGGER.error("Received update for: {} but was unable to retrieve content for update to indexer: {}!", (Object)pid, indexer);
                }
                catch (Exception e) {
                    LOGGER.error("Error indexing {}: {}!", (Object)pid, (Object)e);
                }
            }
        }
        catch (JMSException e) {
            LOGGER.error("Error processing JMS event!", (Throwable)e);
        }
    }
}

