/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.indexer;

import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.fcrepo.indexer.AbsentTransformPropertyException;
import org.fcrepo.indexer.IndexerGroup;
import org.fcrepo.indexer.NamedFields;
import org.fcrepo.indexer.NamedFieldsDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedFieldsRetriever
implements Supplier<NamedFields> {
    private final String uri;
    private final HttpClient httpClient;
    private final Supplier<Model> rdfr;
    private Gson gson;
    private static final Type typeToken = new TypeToken<NamedFields>(){}.getType();
    private static final Logger LOGGER = LoggerFactory.getLogger(NamedFieldsRetriever.class);

    public NamedFieldsRetriever(String uri, HttpClient client, Supplier<Model> rdfr) {
        this.uri = uri;
        this.httpClient = client;
        this.rdfr = rdfr;
        NamedFieldsDeserializer deserializer = new NamedFieldsDeserializer();
        this.gson = new GsonBuilder().registerTypeAdapter(typeToken, (Object)deserializer).create();
        deserializer.setGson(this.gson);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NamedFields get() {
        LOGGER.debug("Retrieving RDF representation for: {}", (Object)this.uri);
        try {
            Model rdf = (Model)this.rdfr.get();
            if (!rdf.contains(ResourceFactory.createResource((String)this.uri), IndexerGroup.INDEXING_TRANSFORM_PREDICATE)) {
                LOGGER.info("Found no property locating LDPath transform for: {}, will not retrieve transformed content.", (Object)this.uri);
                throw new AbsentTransformPropertyException(this.uri);
            }
            RDFNode indexingTransform = rdf.listObjectsOfProperty(ResourceFactory.createResource((String)this.uri), IndexerGroup.INDEXING_TRANSFORM_PREDICATE).next();
            String transformKey = indexingTransform.asLiteral().getString();
            LOGGER.debug("Discovered transform key: {}", (Object)transformKey);
            HttpGet transformedResourceRequest = new HttpGet(this.uri + "/fcr:transform/" + transformKey);
            LOGGER.debug("Retrieving transformed resource from: {}", (Object)transformedResourceRequest.getURI());
            HttpResponse response = this.httpClient.execute((HttpUriRequest)transformedResourceRequest);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new HttpException(response.getStatusLine().toString());
            }
            try (InputStreamReader r = new InputStreamReader(response.getEntity().getContent(), "UTF8");){
                NamedFields namedFields = (NamedFields)this.gson.fromJson((Reader)r, typeToken);
                return namedFields;
            }
        }
        catch (IOException | HttpException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

