/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.indexer.sparql;

import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import com.hp.hpl.jena.sparql.modify.UpdateProcessRemote;
import com.hp.hpl.jena.sparql.modify.request.QuadDataAcc;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataInsert;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateExecutionFactory;
import com.hp.hpl.jena.update.UpdateProcessor;
import com.hp.hpl.jena.update.UpdateRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.jena.atlas.io.IndentedWriter;
import org.fcrepo.indexer.AsynchIndexer;
import org.fcrepo.indexer.Indexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlIndexer
extends AsynchIndexer<Model, Void> {
    private String queryBase;
    private String updateBase;
    private boolean formUpdates = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(SparqlIndexer.class);
    private static final Integer THREAD_POOL_SIZE = 5;
    private ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(THREAD_POOL_SIZE));

    @Override
    public Callable<Void> updateSynch(String pid, Model model) {
        LOGGER.debug("Received update for: {}", (Object)pid);
        this.removeSynch(pid);
        StmtIterator triples = model.listStatements();
        QuadDataAcc add = new QuadDataAcc();
        while (triples.hasNext()) {
            add.addTriple(triples.nextStatement().asTriple());
        }
        LOGGER.debug("Sending update request for pid: {}", (Object)pid);
        return this.exec(new UpdateRequest((Update)new UpdateDataInsert(add)));
    }

    @Override
    public Callable<Void> removeSynch(String subject) {
        LOGGER.debug("Received remove for: {}", (Object)subject);
        String describeQuery = "DESCRIBE <" + subject + ">";
        QueryEngineHTTP qexec = new QueryEngineHTTP(this.queryBase, describeQuery);
        Iterator results = qexec.execDescribeTriples();
        HashSet<String> uris = new HashSet<String>();
        while (results.hasNext()) {
            String uri;
            Triple triple = (Triple)results.next();
            if (triple.getSubject().isURI() && this.matches(subject, uri = ((Node_URI)triple.getSubject()).getURI())) {
                uris.add(uri);
            }
            if (!triple.getObject().isURI() || !this.matches(subject, uri = ((Node_URI)triple.getObject()).getURI())) continue;
            uris.add(uri);
        }
        qexec.close();
        UpdateRequest del = new UpdateRequest();
        for (String uri : uris) {
            String cmd = "DELETE WHERE { <" + uri + "> ?p ?o }";
            LOGGER.debug("Executing: {}", (Object)cmd);
            del.add(cmd);
        }
        return this.exec(del);
    }

    private boolean matches(String uri1, String uri2) {
        return uri1.equals(uri2) || uri1.startsWith(uri2 + "/") || uri1.startsWith(uri2 + "#");
    }

    private Callable<Void> exec(final UpdateRequest update) {
        if (update.getOperations().isEmpty()) {
            LOGGER.debug("Received empty update/remove operation.");
            return new Callable<Void>(){

                @Override
                public Void call() {
                    return null;
                }
            };
        }
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() {
                if (SparqlIndexer.this.formUpdates) {
                    UpdateProcessor proc = UpdateExecutionFactory.createRemoteForm((UpdateRequest)update, (String)SparqlIndexer.this.updateBase);
                    proc.execute();
                } else {
                    UpdateProcessRemote proc = new UpdateProcessRemote(update, SparqlIndexer.this.updateBase, Context.emptyContext);
                    try {
                        proc.execute();
                    }
                    catch (Exception e) {
                        LOGGER.error("Error executing Sparql update/remove!", (Throwable)e);
                    }
                }
                return null;
            }
        };
        ListenableFutureTask task = ListenableFutureTask.create((Callable)callable);
        task.addListener(new Runnable(){

            @Override
            public void run() {
                LOGGER.debug("Completed Sparql update/removal.");
                if (LOGGER.isTraceEnabled()) {
                    try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                        IndentedWriter out = new IndentedWriter((OutputStream)buffer);
                        update.output(out);
                        LOGGER.trace("Executed update/remove operation:\n{}", (Object)((Object)buffer).toString());
                        out.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Couldn't retrieve execution of update/remove operation!", (Throwable)e);
                    }
                }
            }
        }, (Executor)this.executorService);
        this.executorService.submit((Runnable)task);
        return callable;
    }

    public int countTriples(String uri) {
        String describeQuery = "DESCRIBE <" + uri + ">";
        QueryEngineHTTP qexec = new QueryEngineHTTP(this.queryBase, describeQuery);
        Iterator results = qexec.execDescribeTriples();
        int triples = 0;
        while (results.hasNext()) {
            results.next();
            ++triples;
        }
        qexec.close();
        return triples;
    }

    @Override
    public Indexer.IndexerType getIndexerType() {
        return Indexer.IndexerType.RDF;
    }

    public void setFormUpdates(boolean b) {
        this.formUpdates = b;
    }

    public void setQueryBase(String url) {
        this.queryBase = url;
    }

    public void setUpdateBase(String url) {
        this.updateBase = url;
    }

    @Override
    public ListeningExecutorService executorService() {
        return this.executorService;
    }
}

